/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.sub;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.UnSubmit;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.license.GrayFeatureUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.kem.core.event.KemEventFactory;

public class KemSubscribeListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(KemSubscribeListPlugin.class);
    private static final String FORM_KEM_SUBSCRIBE_INH = "kem_subscribe_inh";
    private static final String FORM_KEM_LOG = "kem_log";
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";
    private static final String FEATURE_NUMBER = "KEM";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            GrayFeatureUtil.checkLicenseState((String)FEATURE_NUMBER);
        }
        catch (IscBizException e1) {
            this.getView().showTipNotification(e1.getLocalizedMessage());
            GrayFeatureUtil.showApplyFormWhenNoLicense((AbstractFormPlugin)this, (String)FEATURE_NUMBER, (String)ResManager.loadKDString((String)"\u4e8b\u4ef6\u7f51\u683c", (String)"KemEventListPlugin_10", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4e8b\u4ef6\u7f51\u683c\u7070\u5ea6\u7279\u6027\u7533\u8bf7", (String)"KemEventListPlugin_11", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Object subid = this.getView().getFormShowParameter().getCustomParam("subid");
        if (null != subid) {
            for (FilterColumn col : args.getFastFilterColumns()) {
                if (!col.getFieldName().equals("founderid")) continue;
                col.setDefaultValue(subid.toString());
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object subid = this.getView().getFormShowParameter().getCustomParam("subid");
        if (null != subid) {
            e.getQFilters().add(new QFilter("founderid", "=", subid));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        if (null != e.getParameter().getPkId() && e.getParameter().getBillStatusValue() == 4) {
            e.getParameter().setFormId(FORM_KEM_SUBSCRIBE_INH);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (evt.getItemKey().equals(FORM_KEM_LOG) || evt.getItemKey().equals("hisversion")) {
            Object[] pks = this.getSelectedRows().getPrimaryKeyValues();
            if (pks.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"KemEventListPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (pks.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5355\u6761\u8bb0\u5f55\u3002", (String)"KemSubscribeListPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        Object[] pks = this.getSelectedRows().getPrimaryKeyValues();
        if (evt.getItemKey().equals(FORM_KEM_LOG)) {
            if (pks.length == 1) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId(FORM_KEM_LOG);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setPageId(this.getView().getPageId() + pks[0]);
                showParameter.setCustomParam("subid", (Object)this.getSelectedRows().get(0).getNumber());
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if (evt.getItemKey().equals("hisversion") && pks.length == 1) {
            DynamicObject sub = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getSelectedRows().get(0).getPrimaryKeyValue(), (String)"kem_subscribe");
            if (sub.get("founderid") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u6570\u636e\u3002", (String)"KemSubscribeListPlugin_4", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("kem_subscribe_his");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPageId(this.getView().getPageId() + pks[0]);
            showParameter.setCustomParam("subid", sub.get("founderid"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Submit || args.getSource() instanceof UnSubmit) {
            if (args.getListSelectedData().size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5355\u6761\u8bb0\u5f55\u3002", (String)"KemSubscribeListPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            } else if (args.getListSelectedData().size() == 1) {
                DynamicObject event;
                Object pk = args.getListSelectedData().get(0).getPrimaryKeyValue();
                DynamicObject sub = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"kem_subscribe");
                if (null != sub.getString("srcsubtype") && !sub.getString("srcsubtype").equals("0")) {
                    if (args.getSource() instanceof Submit) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u624b\u5de5\u521b\u5efa\u7684\u8ba2\u9605\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"KemSubscribeListPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u624b\u5de5\u521b\u5efa\u7684\u8ba2\u9605\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"KemSubscribeListPlugin_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                    return;
                }
                if (sub.getDynamicObjectCollection("target_entry").size() <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u4e2a\u4e8b\u4ef6\u76ee\u6807\u3002", (String)"KemSubscribeBasePlugin_9", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (sub.get("triggertype").equals("1") && null != sub.get("eventid") && (event = sub.getDynamicObject("eventid")).getString("enable").equals("0")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba2\u9605\u7684\u4e8b\u4ef6\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5148\u542f\u7528\u4e8b\u4ef6\u518d\u53d1\u5e03\u8ba2\u9605\u3002", (String)"KemEventBasePlugin_12", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (args.getSource() instanceof Submit && sub.getString("status").equals("B")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u5fc5\u987b\u662f\u8349\u7a3f\u624d\u80fd\u53d1\u5e03\u3002", (String)"KemSubscribeListPlugin_5", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                } else if (args.getSource() instanceof UnSubmit && sub.getString("status").equals("A")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u53d1\u5e03\u624d\u80fd\u64a4\u9500\u3002", (String)"KemSubscribeListPlugin_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        } else if (args.getSource() instanceof Delete) {
            Object[] pks = args.getListSelectedData().getPrimaryKeyValues();
            Map subs = BusinessDataServiceHelper.loadFromCache((Object[])pks, (String)"kem_subscribe");
            for (DynamicObject sub : subs.values()) {
                if (null == sub.getString("srcsubtype") || sub.getString("srcsubtype").equals("0")) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u624b\u5de5\u521b\u5efa\u7684\u8ba2\u9605\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"KemSubscribeListPlugin_3", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (key.equals("delete") || key.equals("submit") || key.equals("unsubmit")) {
            if (args.getOperationResult().isSuccess()) {
                KemEventFactory.getEventService().clearCache();
            } else {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f:\r\n %s", (String)"KemSubscribeBasePlugin_12", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), args.getOperationResult().getMessage()));
                return;
            }
        }
    }
}

