/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.sub.target;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.CodeEditListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.connector.webapi.WebApiConnectionFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.kem.common.util.ObjectUtil;
import kd.isc.kem.common.util.StringUtil;
import kd.isc.kem.form.util.FormOpener;
import kd.isc.kem.form.util.KemParamsBuildUtil;

public class KemSubTargetApiFormPlugin
extends AbstractFormPlugin
implements CellClickListener,
CodeEditListener,
TreeNodeClickListener,
BeforeF7SelectListener {
    private static final String ID = "Id";
    private static final String BTN_OPEN = "open";
    private static final String BTN_CLOSE = "close";
    private static final String BTN_WRITE_BACK = "write_back";
    private static final String BTN_BTN_SCRIPT_P = "btn_script_p";
    private static final String BTN_BTN_SCRIPT_D = "btn_script_d";
    private static final String KEY_API_SCRIPT = "api_script";
    private static final String KEY_TARGETAPI = "targetapi";
    private static final String KEY_TARGET_DATASOURCE = "target_datasource";
    private static final String KEY_WEB_REQ_HEADER = "web_req_header";
    private static final String KEY_WEB_URL_PARAMS = "web_url_params";
    private static final String KEY_URL_PARAM_VALUE = "url_param_value";
    private static final String KEY_URL_PARAM_NAME = "url_param_name";
    private static final String KEY_REQ_B_PARAM_VALUE = "req_b_param_value";
    private static final String KEY_REQ_B_PARAM_NAME = "req_b_param_name";
    private static final String KEY_REQ_H_PARAM_VALUE = "req_h_param_value";
    private static final String KEY_REQ_H_PARAM_NAME = "req_h_param_name";
    private static final String KEY_WEB_REQ_BODY = "web_req_body";
    private static final String KEY_PARAMTYPE = "paramtype";
    private static final String KEY_TYPE = "type";
    private static final String KEY_EVENTID = "eventid";
    private static final String KEY_CODEEDITAP = "codeeditap";
    private static final String KEY_SCRIPT = "script";
    private static final String KEY_SCRIPT_TREE = "script_tree";
    private static final String KEY_ACTIONID = "actionid";
    private static final String KEY_SCRIPT_T = "script_t";
    private static final String KEY_SCRIPT_T_TAG = "script_t_tag";
    private static final String KEY_SUCCESS_D = "success_d";
    private static final String KEY_SUCCESS_D_TAG = "success_d_tag";
    private static final String KEY_URL_PREFIX = "url_prefix";
    private static final String KEY_REMARK = "remark";
    private static final String KEY_ACTIONDATASOURCEID = "actiondatasourceid";
    private static final String KEY_BODY = "body_form";
    private static final String KEY_HEADER = "header_form";
    private static final String KEY_QUERYSTRING = "queryString_form";
    private static final String KEY_ACTIONCONFIG_TAG = "actionconfig_tag";
    private static final String KEY_TARGET_ENTRY = "target_entry";
    private static final String KEY_PARAVALUE = "paravalue";
    private static final String FORM_KEM_PARAMS_VALUE = "kem_params_value";
    private static final String FORM_KEM_SCRIPT_TAN = "kem_script_tan";
    private static final String FORM_ISC_APIC_WEBAPI = "isc_apic_webapi";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OPEN, BTN_CLOSE, BTN_BTN_SCRIPT_P, BTN_BTN_SCRIPT_D});
        EntryGrid body = (EntryGrid)this.getView().getControl(KEY_WEB_REQ_BODY);
        body.addCellClickListener((CellClickListener)this);
        EntryGrid url = (EntryGrid)this.getView().getControl(KEY_WEB_URL_PARAMS);
        url.addCellClickListener((CellClickListener)this);
        EntryGrid header = (EntryGrid)this.getView().getControl(KEY_WEB_REQ_HEADER);
        header.addCellClickListener((CellClickListener)this);
        CodeEdit edit = (CodeEdit)this.getControl(KEY_CODEEDITAP);
        edit.addCustomHintsListerner((CodeEditListener)this);
        this.addClickListeners(new String[]{BTN_WRITE_BACK});
        TreeView treeView = (TreeView)this.getControl(KEY_SCRIPT_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BasedataEdit edit2 = (BasedataEdit)this.getControl(KEY_TARGET_DATASOURCE);
        edit2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(BTN_OPEN)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE, KEY_API_SCRIPT});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OPEN});
        } else if (control.getKey().equals(BTN_CLOSE)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CLOSE, KEY_API_SCRIPT});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_OPEN});
        } else if (!control.getKey().equals(BTN_WRITE_BACK) && (control.getKey().equals(BTN_BTN_SCRIPT_P) || control.getKey().equals(BTN_BTN_SCRIPT_D))) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FORM_KEM_SCRIPT_TAN);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, control.getKey()));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(KEY_EVENTID, this.getEventId());
            showParameter.setCustomParam(KEY_TYPE, (Object)control.getKey());
            showParameter.setCustomParam(KEY_REMARK, control.getKey().equals(BTN_BTN_SCRIPT_P) ? this.getModel().getValue(KEY_SCRIPT_T) : this.getModel().getValue(KEY_SUCCESS_D));
            showParameter.setCustomParam(KEY_SCRIPT, control.getKey().equals(BTN_BTN_SCRIPT_P) ? this.getModel().getValue(KEY_SCRIPT_T_TAG) : this.getModel().getValue(KEY_SUCCESS_D_TAG));
            this.getView().showForm(showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(KEY_TARGETAPI)) {
            this.baseDataBuildByApi();
            if (null == this.getModel().getValue(KEY_TARGETAPI)) {
                KemParamsBuildUtil.clearData(this.getView());
            }
        } else if (e.getProperty().getName().equals(KEY_TARGET_DATASOURCE)) {
            this.getModel().setValue(KEY_URL_PREFIX, (Object)this.getUrlPrefix((DynamicObject)this.getModel().getValue(KEY_TARGET_DATASOURCE)));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map actionData = showParameter.getCustomParams();
        if (null != actionData && actionData.size() > 0) {
            this.getModel().setValue(KEY_TARGETAPI, actionData.get(KEY_ACTIONID));
            this.getModel().setValue(KEY_TARGET_DATASOURCE, actionData.get(KEY_ACTIONDATASOURCEID));
            this.baseDataBuildByApi();
            this.updateParamsByParent(actionData.get(KEY_ACTIONCONFIG_TAG));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (null != this.getView().getParentView() && (this.getView().getParentView().getEntityId().equals("kem_subscribe_inh") || this.getView().getParentView().getEntityId().equals("kem_subscribe") || this.getView().getParentView().getEntityId().equals("kem_log_detail"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap7", "flexpanelap4", "flexpanelap9", "fieldsetpanelap", "flexpanelap33", "flexpanelap32", "flexpanelap1"});
        }
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("tabpageap");
    }

    public void cellClick(CellClickEvent evt) {
        IFormView view;
        String field = evt.getFieldKey();
        if (!(null == this.getView().getParentView() || null != (view = this.getView().getParentView()) && view.getEntityId().equals("kem_target_table"))) {
            if (field.equals(KEY_REQ_B_PARAM_VALUE) || field.equals(KEY_URL_PARAM_VALUE) || field.equals(KEY_REQ_H_PARAM_VALUE)) {
                this.showTargetParamForm(field, evt.getRow(), 1);
            }
            return;
        }
        if (field.equals(KEY_REQ_B_PARAM_VALUE) || field.equals(KEY_URL_PARAM_VALUE) || field.equals(KEY_REQ_H_PARAM_VALUE)) {
            this.showTargetParamForm(field, evt.getRow(), 0);
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (null != closedCallBackEvent.getReturnData()) {
            String datas = closedCallBackEvent.getReturnData().toString();
            int index = 0;
            if (KEY_REQ_B_PARAM_VALUE.equals(actionId)) {
                index = this.getModel().getEntryCurrentRowIndex(KEY_WEB_REQ_BODY);
                this.getModel().setValue(actionId, (Object)datas, index);
            } else if (KEY_URL_PARAM_VALUE.equals(actionId)) {
                index = this.getModel().getEntryCurrentRowIndex(KEY_WEB_URL_PARAMS);
                this.getModel().setValue(actionId, (Object)datas, index);
            } else if (KEY_REQ_H_PARAM_VALUE.equals(actionId)) {
                index = this.getModel().getEntryCurrentRowIndex(KEY_WEB_REQ_HEADER);
                this.getModel().setValue(actionId, (Object)datas, index);
            }
            if (closedCallBackEvent.getReturnData() instanceof Map) {
                Map map = (Map)closedCallBackEvent.getReturnData();
                if (BTN_BTN_SCRIPT_D.equals(actionId)) {
                    this.getModel().setValue(KEY_SUCCESS_D, map.get(KEY_REMARK));
                    this.getModel().setValue(KEY_SUCCESS_D_TAG, map.get("script_tag"));
                } else if (BTN_BTN_SCRIPT_P.equals(actionId)) {
                    this.getModel().setValue(KEY_SCRIPT_T, map.get(KEY_REMARK));
                    this.getModel().setValue(KEY_SCRIPT_T_TAG, map.get("script_tag"));
                }
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String name = arg0.getProperty().getName();
        if (KEY_TARGET_DATASOURCE.equals(name)) {
            List<Long> webApiLinkIds = this.getWebApiLinks();
            List<Long> webApiDataSourceIds = this.getWebApiDataSources(webApiLinkIds);
            QFilter qFilter = new QFilter("id", "in", webApiDataSourceIds);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void baseDataBuildByApi() {
        if (null != this.getModel().getValue(KEY_TARGETAPI)) {
            DynamicObject webapi = (DynamicObject)this.getModel().getValue(KEY_TARGETAPI);
            DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)webapi.get(ID), (String)FORM_ISC_APIC_WEBAPI);
            KemParamsBuildUtil.webapiDataPadding(this.getView(), api);
        }
    }

    private void updateParamsByParent(Object config) {
        if (!ObjectUtil.isEmpty((Object)config)) {
            int i;
            JSONObject data = JSONObject.parseObject((String)config.toString());
            if (data.get((Object)KEY_BODY) instanceof JSONObject) {
                DynamicObjectCollection bodys = this.getModel().getEntryEntity(KEY_WEB_REQ_BODY);
                JSONObject body = (JSONObject)data.get((Object)KEY_BODY);
                for (i = 0; i < bodys.size(); ++i) {
                    this.getModel().setValue(KEY_REQ_B_PARAM_VALUE, body.get(((DynamicObject)bodys.get(i)).get(KEY_REQ_B_PARAM_NAME)), i);
                }
            }
            if (data.get((Object)KEY_HEADER) instanceof JSONObject) {
                JSONObject header = (JSONObject)data.get((Object)KEY_HEADER);
                DynamicObjectCollection headers = this.getModel().getEntryEntity(KEY_WEB_REQ_HEADER);
                for (i = 0; i < headers.size(); ++i) {
                    this.getModel().setValue(KEY_REQ_H_PARAM_VALUE, header.get(((DynamicObject)headers.get(i)).get(KEY_REQ_H_PARAM_NAME)), i);
                }
            }
            if (data.get((Object)KEY_QUERYSTRING) instanceof JSONObject) {
                JSONObject url = (JSONObject)data.get((Object)KEY_QUERYSTRING);
                DynamicObjectCollection urls = this.getModel().getEntryEntity(KEY_WEB_URL_PARAMS);
                for (i = 0; i < urls.size(); ++i) {
                    this.getModel().setValue(KEY_URL_PARAM_VALUE, url.get(((DynamicObject)urls.get(i)).get(KEY_URL_PARAM_NAME)), i);
                }
            }
            this.getModel().setValue(KEY_SUCCESS_D_TAG, data.get((Object)"assertion"));
            this.getModel().setValue(KEY_SUCCESS_D, data.get((Object)"assertion_remark"));
            this.getModel().setValue(KEY_SCRIPT_T_TAG, data.get((Object)KEY_SCRIPT));
            this.getModel().setValue(KEY_SCRIPT_T, data.get((Object)"script_remark"));
            this.getModel().setValue(KEY_URL_PREFIX, data.get((Object)KEY_URL_PREFIX));
        }
    }

    public void customHints(Map<String, Object> word) {
    }

    public void setTargetData() {
        IFormView view = this.getView().getParentView();
        if (view.getFormShowParameter().getFormId().contains("kem_subscribe")) {
            IDataModel model = view.getModel();
            int n = model.getEntryCurrentRowIndex(KEY_TARGET_ENTRY);
        }
    }

    private void showTargetParamForm(String field, int row, int type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_PARAMTYPE, 0);
        params.put("lab", 0);
        params.put(KEY_EVENTID, this.getEventId());
        params.put(KEY_TYPE, type);
        String value = String.valueOf(this.getModel().getValue(field, row));
        if (StringUtil.isNotEmpty((CharSequence)value)) {
            params.put(KEY_PARAVALUE, value);
        }
        FormOpener.showForm(this, FORM_KEM_PARAMS_VALUE, "", params, field);
    }

    private String getUrlPrefix(DynamicObject cn) {
        String http_protocal;
        DataSource dataSource = DataSource.get((long)cn.getLong(ID));
        try {
            cn = ConnectionConfig.getConfig((long)dataSource.getDbLink());
        }
        catch (IscBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
        ConnectionFactory factory = DatabaseType.find((String)cn.getString("database_type"));
        if (!(factory instanceof WebApiConnectionFactory)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u8fde\u63a5\u7c7b\u578b\u4e3aWebApi\u7c7b\u7684\u6570\u636e\u6e90", (String)"KemSubTargetApiFormPlugin_0", (String)"isc-kem-formplugin", (Object[])new Object[0]));
        }
        if ((http_protocal = D.s((Object)cn.get("http_protocal"))) == null) {
            http_protocal = "http";
        }
        return http_protocal + "://" + cn.getString("server_ip") + ":" + this.getPort(cn, http_protocal);
    }

    private int getPort(DynamicObject cn, String http_protocal) {
        int port = D.i((Object)cn.get("server_port"));
        if (port <= 0) {
            port = "https".equals(http_protocal) ? 443 : 80;
        }
        return port;
    }

    private List<Long> getWebApiDataSources(List linkIds) {
        QFilter dblinkFilter = new QFilter("dblink", "in", (Object)linkIds);
        DynamicObjectCollection dataSources = QueryServiceHelper.query((String)"isc_data_source", (String)"id", (QFilter[])new QFilter[]{dblinkFilter});
        ArrayList<Long> dataSourceIds = new ArrayList<Long>();
        for (DynamicObject dataSource : dataSources) {
            dataSourceIds.add(D.l((Object)dataSource.get("id")));
        }
        return dataSourceIds;
    }

    private List<Long> getWebApiLinks() {
        DynamicObjectCollection links = QueryServiceHelper.query((String)"isc_database_link", (String)"id,database_type", (QFilter[])null);
        ArrayList<Long> linkIds = new ArrayList<Long>();
        for (DynamicObject link : links) {
            String databaseType = link.getString("database_type");
            ConnectionFactory factory = DatabaseType.find((String)databaseType);
            if (!(factory instanceof WebApiConnectionFactory)) continue;
            linkIds.add(D.l((Object)link.get("id")));
        }
        return linkIds;
    }

    private Object getEventId() {
        IFormView view = this.getView().getParentView();
        if (null == view) {
            return null;
        }
        if (view.getEntityId().equals("kem_log_detail")) {
            if (null != view && null != view.getModel().getValue("event_name")) {
                return ((DynamicObject)view.getModel().getValue("event_name")).get(ID);
            }
            return null;
        }
        if (view.getEntityId().equals("kem_target_table")) {
            view = view.getParentView();
        }
        if (null != view && null != view.getModel().getValue(KEY_EVENTID)) {
            return ((DynamicObject)view.getModel().getValue(KEY_EVENTID)).get(ID);
        }
        return null;
    }
}

