/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.sub.target;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.kem.common.util.StringUtil;
import kd.isc.kem.form.util.FormOpener;
import kd.isc.kem.form.util.ServiceFlowParam;
import kd.isc.kem.form.util.ServiceFlowUtil;

public class KemSubTargetSfFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String ID = "Id";
    private static final String BTN_SCRIPT = "btn_script";
    private static final String KEY_PARAM_ENTRY = "param_entry";
    private static final String KEY_PARAMENTRY = "paramEntry";
    private static final String KEY_PARAMNAME = "paramName";
    private static final String KEY_PARAMTYPE = "paramType";
    private static final String KEY_PARAMVALUE = "paramValue";
    private static final String KEY_VAR_CATEGORY = "var_category";
    private static final String KEY_VAR_TYPE = "var_type";
    private static final String KEY_VAR_DESC = "var_desc";
    private static final String KEY_IS_ARRAY = "is_array";
    private static final String KEY_VAR_VALUE = "var_value";
    private static final String KEY_VAR_NAME = "var_name";
    private static final String KEY_SERVICE_FLOW = "service_flow";
    private static final String KEY_ACTIONCONFIG_TAG = "actionconfig_tag";
    private static final String KEY_NO_PROC_INST = "no_proc_inst";
    private static final String KEY_ASYN = "asyn";
    private static final String KEY_DISABLE_TRACE = "disable_trace";
    private static final String KEY_EVENTID = "eventid";
    private static final String KEY_SCRIPT = "script";
    private static final String KEY_TYPE = "type";
    private static final String KEY_SCRIPT_TAG = "script_tag";
    private static final String FORM_KEM_SCRIPT_TAN = "kem_script_tan";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SCRIPT});
        EntryGrid url = (EntryGrid)this.getView().getControl(KEY_PARAM_ENTRY);
        url.addCellClickListener((CellClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (null != this.getView().getParentView() && (this.getView().getParentView().getEntityId().equals("kem_subscribe_inh") || this.getView().getParentView().getEntityId().equals("kem_subscribe") || this.getView().getParentView().getEntityId().equals("kem_log_detail"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fieldsetpanelap", "flexpanelap1", "flexpanelap3"});
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_SCRIPT});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildFormData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(KEY_SERVICE_FLOW)) {
            this.getModel().deleteEntryData(KEY_PARAM_ENTRY);
            if (null != this.getModel().getValue(KEY_SERVICE_FLOW)) {
                this.buildParamEntry();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_KEM_SCRIPT_TAN);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORM_KEM_SCRIPT_TAN));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(KEY_TYPE, (Object)"btn_script_sf");
        showParameter.setCustomParam(KEY_EVENTID, this.getEventId());
        showParameter.setCustomParam(KEY_SCRIPT, this.getModel().getValue(KEY_SCRIPT_TAG));
        showParameter.setCustomParam("remark", this.getModel().getValue(KEY_SCRIPT));
        this.getView().showForm(showParameter);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    private void buildFormData() {
        Object config;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map actionData = showParameter.getCustomParams();
        if (null != actionData && !ObjectUtils.isEmpty(config = actionData.get(KEY_ACTIONCONFIG_TAG))) {
            JSONObject data = JSONObject.parseObject((String)config.toString());
            this.getModel().setValue(KEY_SERVICE_FLOW, data.get((Object)KEY_SERVICE_FLOW));
            this.getModel().setValue(KEY_NO_PROC_INST, data.get((Object)KEY_NO_PROC_INST));
            this.getModel().setValue(KEY_ASYN, data.get((Object)KEY_ASYN));
            this.getModel().setValue(KEY_DISABLE_TRACE, data.get((Object)KEY_DISABLE_TRACE));
            this.getModel().setValue(KEY_SCRIPT, data.get((Object)"script_remark"));
            this.getModel().setValue(KEY_SCRIPT_TAG, data.get((Object)KEY_SCRIPT));
            if (null != data.get((Object)KEY_PARAMENTRY)) {
                JSONArray paramEntry = data.getJSONArray(KEY_PARAMENTRY);
                ArrayList<JSONObject> childs = new ArrayList<JSONObject>();
                for (Object object : paramEntry) {
                    JSONObject row = (JSONObject)object;
                    int index = -1;
                    if (row.getLong("parentId") == 0L) {
                        index = this.getModel().createNewEntryRow(KEY_PARAM_ENTRY);
                    } else {
                        childs.add(row);
                    }
                    this.buildEntryData(index, null, row);
                }
                this.buildChildRowJson(childs);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() != null) {
            if (evt.getActionId().equals(FORM_KEM_SCRIPT_TAN)) {
                if (evt.getReturnData() instanceof Map) {
                    Map map = (Map)evt.getReturnData();
                    this.getModel().setValue(KEY_SCRIPT, map.get("remark"));
                    this.getModel().setValue(KEY_SCRIPT_TAG, map.get(KEY_SCRIPT_TAG));
                }
            } else if (evt.getActionId().equals(KEY_VAR_VALUE)) {
                int index = this.getModel().getEntryCurrentRowIndex(KEY_PARAM_ENTRY);
                this.getModel().setValue(KEY_VAR_VALUE, evt.getReturnData(), index);
            }
        }
    }

    public String setTargetData() {
        System.out.println();
        return null;
    }

    public void cellClick(CellClickEvent evt) {
        IFormView view;
        String field = evt.getFieldKey();
        if (!(null == this.getView().getParentView() || null != (view = this.getView().getParentView()) && view.getEntityId().equals("kem_target_table"))) {
            this.showTargetParamForm(field, evt.getRow(), 1);
            return;
        }
        if (field.equals(KEY_VAR_VALUE)) {
            this.showTargetParamForm(field, evt.getRow(), 0);
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    private void buildParamEntry() {
        if (null != this.getModel().getValue(KEY_SERVICE_FLOW)) {
            Long pk = ((DynamicObject)this.getModel().getValue(KEY_SERVICE_FLOW)).getLong(ID);
            List<ServiceFlowParam> variables = ServiceFlowUtil.getInputs(pk);
            ArrayList<ServiceFlowParam> childs = new ArrayList<ServiceFlowParam>();
            for (ServiceFlowParam variable : variables) {
                int index = -1;
                if (variable.getPid() != 0L) {
                    childs.add(variable);
                    continue;
                }
                index = this.getModel().createNewEntryRow(KEY_PARAM_ENTRY);
                this.buildEntryData(index, variable, null);
            }
            this.buildChildRow(childs);
        }
    }

    private void buildChildRow(List<ServiceFlowParam> childs) {
        ArrayList<ServiceFlowParam> childs1 = new ArrayList<ServiceFlowParam>();
        for (ServiceFlowParam variable : childs) {
            int parentIndex = this.getEntryRowIndex(variable.getPid());
            if (parentIndex == -1) {
                childs1.add(variable);
                continue;
            }
            int index = this.getModel().insertEntryRow(KEY_PARAM_ENTRY, parentIndex);
            this.buildEntryData(index, variable, null);
        }
        if (childs1.size() == 0) {
            return;
        }
        this.buildChildRow(childs1);
    }

    private void buildChildRowJson(List<JSONObject> childs) {
        ArrayList<JSONObject> childs1 = new ArrayList<JSONObject>();
        for (JSONObject variable : childs) {
            int parentIndex = this.getEntryRowIndex(variable.getLong("parentId"));
            if (parentIndex == -1) {
                childs1.add(variable);
                continue;
            }
            int index = this.getModel().insertEntryRow(KEY_PARAM_ENTRY, parentIndex);
            this.buildEntryData(index, null, variable);
        }
        if (childs1.size() == 0) {
            return;
        }
        this.buildChildRowJson(childs1);
    }

    private int getEntryRowIndex(long pid) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_PARAM_ENTRY);
        for (DynamicObject row : rows) {
            if (row.getLong("flowid") != pid) continue;
            return row.getInt("seq") - 1;
        }
        return -1;
    }

    private void buildEntryData(int index, ServiceFlowParam variable, JSONObject row) {
        if (index >= 0) {
            this.getModel().setValue("flowid", row == null ? Long.valueOf(variable.getId()) : row.get((Object)ID), index);
            this.getModel().setValue(KEY_VAR_NAME, (Object)(row == null ? variable.getField() : row.getString(KEY_PARAMNAME)), index);
            this.getModel().setValue(KEY_VAR_CATEGORY, (Object)(row == null ? variable.getCategory() : row.getString(KEY_VAR_CATEGORY)), index);
            this.getModel().setValue(KEY_VAR_TYPE, (Object)(row == null ? variable.getType() : row.getString(KEY_PARAMTYPE)), index);
            this.getModel().setValue(KEY_VAR_DESC, (Object)(row == null ? variable.getRemark() : row.getString(KEY_VAR_DESC)), index);
            this.getModel().setValue(KEY_IS_ARRAY, row == null ? Boolean.valueOf(variable.isMul()) : row.getString(KEY_IS_ARRAY), index);
            if (row != null) {
                this.getModel().setValue(KEY_VAR_VALUE, (Object)row.getString(KEY_PARAMVALUE), index);
            }
        }
    }

    private void showTargetParamForm(String field, int row, int type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("paramtype", 0);
        params.put("lab", 4);
        params.put(KEY_TYPE, type);
        params.put(KEY_EVENTID, this.getEventId());
        String value = String.valueOf(this.getModel().getValue(field, row));
        if (StringUtil.isNotEmpty((CharSequence)value)) {
            params.put("paravalue", value);
        }
        FormOpener.showForm(this, "kem_params_value", "", params, field);
    }

    private Object getEventId() {
        IFormView view = this.getView().getParentView();
        if (null == view) {
            return null;
        }
        if (view.getEntityId().equals("kem_log_detail")) {
            return null;
        }
        if (view.getEntityId().equals("kem_target_table")) {
            view = view.getParentView();
        }
        if (null != view && null != view.getModel().getValue(KEY_EVENTID)) {
            return ((DynamicObject)view.getModel().getValue(KEY_EVENTID)).get(ID);
        }
        return null;
    }
}

