/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.sub.target.msg;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.common.util.ObjectUtil;

public class KemSubTarMsgUserFormPlugin
extends AbstractFormPlugin {
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";
    private static final String CHINA_MOBILE_PATTERN = "^(13|14|15|17|18)\\d{9}$";
    private static final String EMAIL_PATTERN = "^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}$";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object data = this.getView().getFormShowParameter().getCustomParam("data");
        if (!ObjectUtil.isEmpty((Object)data)) {
            List list = (List)JacksonUtil.readValue((String)data.toString(), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            for (Map map : list) {
                DynamicObject row = entryentity.addNew();
                row.set("username", map.get("username"));
                row.set("userphone", map.get("userphone"));
                row.set("useremail", map.get("useremail"));
            }
            this.getModel().updateEntryCache(entryentity);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btnok")) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject row : entryentity) {
                String index = row.getString("seq");
                boolean phone = row.getString("userphone").isEmpty();
                boolean email = row.getString("useremail").isEmpty();
                if (phone && email) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u8f93\u5165\u7535\u8bdd\u53f7\u7801\u6216\u90ae\u7bb1\u3002", (String)"KemSubTargetMsgFormPlugin_7", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), index));
                    evt.setCancel(true);
                    break;
                }
                if (!phone && !KemSubTarMsgUserFormPlugin.isValidChineseMobile(row.getString("userphone"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7535\u8bdd\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"KemSubTargetMsgFormPlugin_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), index));
                    evt.setCancel(true);
                    break;
                }
                if (email || KemSubTarMsgUserFormPlugin.isValidEmail(row.getString("useremail"))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"KemSubTargetMsgFormPlugin_5", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), index));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btnok")) {
            ArrayList data = new ArrayList();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject row : entryentity) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("username", row.getString("username"));
                map.put("userphone", row.getString("userphone"));
                map.put("useremail", row.getString("useremail"));
                data.add(map);
            }
            this.getView().returnDataToParent((Object)JacksonUtil.writeValueAsString(data));
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("userphone")) {
            if (!KemSubTarMsgUserFormPlugin.isValidChineseMobile(e.getChangeSet()[0].getNewValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u8bdd\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"KemSubTargetMsgFormPlugin_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if (name.equals("useremail") && !KemSubTarMsgUserFormPlugin.isValidEmail(e.getChangeSet()[0].getNewValue().toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"KemSubTargetMsgFormPlugin_3", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    public static boolean isValidChineseMobile(String phoneNumber) {
        Pattern pattern = Pattern.compile(CHINA_MOBILE_PATTERN);
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }

    public static boolean isValidEmail(String email) {
        Pattern pattern = Pattern.compile(EMAIL_PATTERN);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }
}

