/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.util;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.Util;

public class DataHandler
implements Const {
    public static DynamicObjectCollection initDataBody(String dataText, DynamicObject obj) {
        Map dataMap = Util.getDataMap((String)dataText);
        return DataHandler.initDataBody(dataMap, obj);
    }

    public static DynamicObjectCollection initDataBody(Map<String, Object> dataMap, DynamicObject obj) {
        DynamicObjectCollection reqBody = obj.getDynamicObjectCollection("data_entry");
        reqBody.clear();
        if (dataMap != null) {
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                DataHandler.newReqBodyParamEntry(reqBody, entry.getKey(), entry.getValue(), 0L, 1);
            }
        }
        return reqBody;
    }

    private static void newReqBodyParamEntry(DynamicObjectCollection reqBody, String name, Object value, long pid, int level) {
        DynamicObject bodyParam = DataHandler.addNewReq(reqBody, name, pid, level);
        if (value instanceof List) {
            DataHandler.handleListValueReq((List)value, reqBody, bodyParam);
        } else if (value instanceof Map) {
            DataHandler.handleMapValueReq((Map)value, reqBody, bodyParam);
        } else {
            DataHandler.handleBaseValueReq(value, bodyParam);
        }
    }

    private static void handleBaseValueReq(Object value, DynamicObject bodyParam) {
        bodyParam.set("data_example", value);
        bodyParam.set("paratype", (Object)Util.getIscFieldTypeFromValue((Object)value).getTypeName());
    }

    private static void handleMapValueReq(Map<String, Object> value, DynamicObjectCollection reqBody, DynamicObject bodyParam) {
        bodyParam.set("paratype", (Object)IscFieldType.STRUCT.getTypeName());
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            DataHandler.newReqBodyParamEntry(reqBody, entry.getKey(), entry.getValue(), bodyParam.getLong("id"), bodyParam.getInt("paralevel") + 1);
        }
    }

    private static void handleListValueReq(List value, DynamicObjectCollection reqBody, DynamicObject bodyParam) {
        bodyParam.set("ismultivalue", (Object)"1");
        if (!value.isEmpty()) {
            Object o = value.get(0);
            if (o instanceof Map) {
                DataHandler.handleMapValueReq((Map)o, reqBody, bodyParam);
            } else {
                bodyParam.set("paratype", (Object)Util.getIscFieldTypeFromValue(o).getTypeName());
            }
        } else {
            bodyParam.set("paratype", (Object)IscFieldType.UNKNOWN.getTypeName());
        }
    }

    private static DynamicObject addNewReq(DynamicObjectCollection reqBody, String name, long pid, int level) {
        DynamicObject bodyParam = reqBody.addNew();
        bodyParam.set("id", (Object)IDService.get().genLongId());
        bodyParam.set("pid", (Object)pid);
        bodyParam.set("paraname", (Object)name);
        bodyParam.set("paranumber", (Object)name);
        bodyParam.set("paradesc", (Object)name);
        bodyParam.set("isrequired", (Object)"0");
        bodyParam.set("paralevel", (Object)(level + ""));
        bodyParam.set("ismultivalue", (Object)"0");
        return bodyParam;
    }
}

