/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.isc.kem.common.util.StringUtil;

public class JsonUtil {
    private static String mDateFormat;

    private JsonUtil() {
    }

    public static String format(Object obj) {
        return JsonUtil.toJsonString(obj, SerializerFeature.PrettyFormat);
    }

    public static String toJsonString(Object obj, SerializerFeature ... features) {
        EnumSet<SerializerFeature> featureSet = features == null || features.length == 0 ? EnumSet.noneOf(SerializerFeature.class) : EnumSet.copyOf(Arrays.asList(features));
        featureSet.add(SerializerFeature.WriteMapNullValue);
        featureSet.add(SerializerFeature.WriteDateUseDateFormat);
        featureSet.add(SerializerFeature.DisableCircularReferenceDetect);
        featureSet.add(SerializerFeature.WriteBigDecimalAsPlain);
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Long.TYPE, (ObjectSerializer)ToStringSerializer.instance);
        if (StringUtil.isEmpty((CharSequence)mDateFormat)) {
            mDateFormat = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_datesdf", "api.datesdf", "yyyy-MM-dd HH:mm:ss");
        }
        serializeConfig.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer(mDateFormat));
        serializeConfig.put(Timestamp.class, (ObjectSerializer)new SimpleDateFormatSerializer(mDateFormat));
        return JSON.toJSONString((Object)obj, (SerializeConfig)serializeConfig, (SerializerFeature[])featureSet.toArray(new SerializerFeature[0]));
    }

    public static String toStringBySortField(Object obj) {
        return JsonUtil.toJsonString(obj, SerializerFeature.SortField, SerializerFeature.MapSortField);
    }

    public static Object parseJson(String jsonStr) {
        return JSON.parse((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static Object toJSON(Object obj) {
        return JSON.toJSON((Object)obj);
    }

    public static <T> T parseObject(Object obj, Type type, Feature ... features) {
        if (obj == null) {
            return null;
        }
        String json = JSON.toJSONString((Object)obj);
        return (T)JSON.parseObject((String)json, (Type)type, (Feature[])features);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJsonString(String str, boolean supportMultiValue) {
        if (str == null) {
            return true;
        }
        try (JSONValidator validator = JSONValidator.fromUtf8((byte[])str.getBytes(StandardCharsets.UTF_8));){
            boolean bl = validator.validate();
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

