/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.IBasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.ParentBasedataField;
import kd.bos.metadata.filter.CustomBaseDataFilterColumnAp;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.isc.kem.form.util.DataTypeUtil;

public class KemBusinessEventConfigPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener,
SearchEnterListener {
    public static final String PROPERTYNAME = "propertyname";
    public static final String PROPERTYNUMBER = "propertynumber";
    public static final String PROPERTYTYPE = "propertytype";
    public static final String PROPERTYDESCRIPTION = "description";
    private static final String KEY_PARANAME = "paraname";
    private static final String KEY_PARADESC = "paradesc";
    private static final String KEY_PARATYPE = "paratype";
    private static final String KEY_PARALEVEL = "paralevel";
    private static final String KEY_ISREQUIRED = "isrequired";
    private static final String KEY_ISMULTIVALUE = "ismultivalue";
    private static final String KEY_PARANUMBER = "paranumber";
    private static final String KEY_TRUENUMBER = "trueNumber";
    private static final String KEY_TRUENAME = "trueName";
    public static final String ISMULTI = "ismulti";
    public static final String VALUE = "value";
    public static final String CAPTION = "caption";
    public static final String TYPE = "type";
    public static final String DYNAMICOBJECT = "DynamicObject";
    public static final String ATTRIBUTE = "attribute";
    public static final String ENTRYENTITY = "entryentity";
    public static final String ENTITYNUMBER = "entitynumber";
    public static final String ENTITYID = "entityid";
    private static final String BTNOK = "btnok";
    private static final String BTNREMOVE = "btnremove";
    private static final String FTARGETPROPS = "ftargetprops";
    private static final String FTNAME = "ftname";
    private static final String TREEROOTNODE = "treerootnode";
    private static final String STRING = "String";
    private static final String FIELDTREE = "fieldtree";
    private static final String FTID = "ftid";
    private static final String CONFIGNUMBER = "confignumber";
    private static final String F_TARGET_PROPS = "ftargetprops";
    private static final String FIELD_TREE = "FieldTree";
    private static final String CHECK_NODES = "checkNodes";
    private static final String SEARCH_AP = "searchap";
    private static final String VERIFY_REF_QUANTITY = "verifyRefQuantity";
    private static final String REF_MAX_QUANTITY = "refMaxQuantity";
    public static final String BASEREFSET = "baserefset";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK, BTNREMOVE});
        EntryGrid grid = (EntryGrid)this.getControl("ftargetprops");
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl(FIELDTREE);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search searchEdit = (Search)this.getControl(SEARCH_AP);
        searchEdit.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String number = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
        this.getPageCache().put("rootId", fid);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        TreeView tree = (TreeView)this.getView().getControl(FIELDTREE);
        TreeNode root = new TreeNode();
        root.setId(entityMetadata.getId());
        root.setLongNumber(entityMetadata.getKey());
        root.setText(entityMetadata.getName().toString());
        root.setIsOpened(true);
        this.setTreeNode(number, root);
        this.rebuildRoot(root);
        tree.addNode(root);
        this.getPageCache().put(TREEROOTNODE, SerializationUtils.toJsonString((Object)root));
        Object configFields = this.getView().getFormShowParameter().getCustomParams().get("configfields");
        if (configFields != null && !StringUtils.isBlank(configFields)) {
            List fields = (List)configFields;
            ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(fields.size());
            this.getModel().deleteEntryData("ftargetprops");
            for (Map field : fields) {
                String fieldId = (String)field.get(CONFIGNUMBER);
                TreeNode node = root.getTreeNode(fieldId, 16);
                if (node == null) continue;
                checkNodes.add(node);
                int rowindex = this.getModel().createNewEntryRow("ftargetprops");
                this.getModel().setValue(FTNAME, field.get("configname"), rowindex);
                this.getModel().setValue(FTID, (Object)fieldId, rowindex);
            }
            tree.checkNodes(checkNodes);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNREMOVE.equals(key)) {
            this.delete();
        } else if (BTNOK.equals(key)) {
            this.buildTreeData();
            this.affirm();
        }
    }

    public void search(SearchEnterEvent evt) {
        Search source = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)SEARCH_AP, (CharSequence)source.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        String treeNode_cache = this.getPageCache().get(FIELD_TREE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNode_cache, TreeNode.class);
        TreeView treeView = (TreeView)this.getView().getControl(FIELDTREE);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            List<TreeNode> childrenNode = this.getChildrenNode(searchText, root);
            root.setChildren(childrenNode);
        }
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>();
        List checkNodesId = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        for (String str : checkNodesId) {
            TreeNode treeNode = root.getTreeNode(str, 16);
            if (treeNode == null) continue;
            checkNodes.add(treeNode);
        }
        treeView.updateNode(root);
        treeView.checkNodes(checkNodes);
    }

    private List<TreeNode> getChildrenNode(String searchText, TreeNode parentNode) {
        ArrayList<TreeNode> childrenNodes = new ArrayList<TreeNode>();
        if (parentNode != null && parentNode.getChildren() != null) {
            for (TreeNode childrenNode : parentNode.getChildren()) {
                List<TreeNode> subChildrenNodes = this.getChildrenNode(searchText, childrenNode);
                if (!subChildrenNodes.isEmpty()) {
                    childrenNode.setChildren(subChildrenNodes);
                    childrenNode.setIsOpened(true);
                    childrenNodes.add(childrenNode);
                    continue;
                }
                if (!childrenNode.getText().contains(searchText)) continue;
                childrenNodes.add(childrenNode);
            }
        }
        return childrenNodes;
    }

    private void affirm() {
        JSONArray arg13 = new JSONArray();
        this.getView().returnDataToParent((Object)arg13.toJSONString());
        this.getView().close();
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("ftargetprops");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows != null && rows.length != 0) {
            ArrayList<String> nodeIds = new ArrayList<String>();
            int[] tree = rows;
            int arg4 = rows.length;
            for (int arg5 = 0; arg5 < arg4; ++arg5) {
                int row = tree[arg5];
                if (row < 0) continue;
                nodeIds.add((String)this.getModel().getValue(FTID, row));
            }
            this.getModel().deleteEntryRows("ftargetprops", rows);
            TreeView arg7 = (TreeView)this.getView().getControl(FIELDTREE);
            arg7.uncheckNodes(nodeIds);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79fb\u9664\u7684\u884c", (String)"BusinessEventConfigPlugin_0", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        }
    }

    private void setTreeNode(String entityNumber, TreeNode root) {
        HashSet<String> entrySet = new HashSet<String>();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (IDataEntityProperty fieldProp : mainType.getAllFields().values()) {
            if (StringUtils.isNotEmpty((CharSequence)fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName())) {
                TreeNode enNode;
                TreeNode node1;
                EntityType node3;
                if (fieldProp.getParent().getParent() != null && fieldProp.getParent().getParent().getParent() != null) {
                    TreeNode enNode1;
                    if (!(fieldProp.getParent() instanceof EntryType) || !(fieldProp.getParent().getParent() instanceof EntryType)) continue;
                    node3 = (EntityType)fieldProp.getParent();
                    EntityType enNode2 = (EntityType)fieldProp.getParent().getParent();
                    if (!StringUtils.isNotEmpty((CharSequence)node3.getDisplayName().toString()) || !StringUtils.isNotEmpty((CharSequence)enNode2.getDisplayName().toString())) continue;
                    if (entrySet.add(enNode2.getName())) {
                        node1 = new TreeNode();
                        node1.setParentid(root.getId());
                        node1.setId(enNode2.getName());
                        node1.setText(enNode2.getDisplayName().getLocaleValue());
                        root.addChild(node1);
                        nodeMap.put(enNode2.getName(), node1);
                    } else {
                        node1 = (TreeNode)nodeMap.get(enNode2.getName());
                    }
                    if (entrySet.add(node3.getName())) {
                        enNode1 = new TreeNode();
                        enNode1.setParentid(node1.getId());
                        enNode1.setId(node3.getName());
                        enNode1.setText(node3.getDisplayName().getLocaleValue());
                        node1.addChild(enNode1);
                        nodeMap.put(node3.getName(), enNode1);
                    } else {
                        enNode1 = (TreeNode)nodeMap.get(node3.getName());
                    }
                    TreeNode node2 = new TreeNode();
                    node2.setParentid(enNode1.getId());
                    node2.setId(fieldProp.getParent().getParent().getName() + "." + fieldProp.getParent().getName() + "." + fieldProp.getName());
                    node2.setText(((IFieldHandle)fieldProp).getDisplayName().getLocaleValue());
                    enNode1.addChild(node2);
                    continue;
                }
                if (!(fieldProp.getParent() instanceof EntryType) || !StringUtils.isNotEmpty((CharSequence)(node3 = (EntityType)fieldProp.getParent()).getDisplayName().toString())) continue;
                if (entrySet.add(node3.getName())) {
                    enNode = new TreeNode();
                    enNode.setParentid(root.getId());
                    enNode.setId(node3.getName());
                    enNode.setText(node3.getDisplayName().getLocaleValue());
                    root.addChild(enNode);
                    nodeMap.put(node3.getName(), enNode);
                } else {
                    enNode = (TreeNode)nodeMap.get(node3.getName());
                }
                node1 = new TreeNode();
                node1.setParentid(enNode.getId());
                node1.setId(fieldProp.getParent().getName() + "." + fieldProp.getName());
                if (((IFieldHandle)fieldProp).getDisplayName() != null) {
                    node1.setText(((IFieldHandle)fieldProp).getDisplayName().getLocaleValue());
                }
                enNode.addChild(node1);
                continue;
            }
            TreeNode node = new TreeNode();
            node.setParentid(root.getId());
            node.setId(fieldProp.getName());
            node.setText(fieldProp.getDisplayName().getLocaleValue());
            root.addChild(node);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        String fieldId = evt.getNodeId().toString();
        if (evt.getChecked().booleanValue()) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
            TreeNode node = root.getTreeNode(fieldId, 16);
            if (node.getChildren() == null) {
                int childrenNodeIds = this.getModel().createNewEntryRow("ftargetprops");
                this.getModel().setValue(FTID, (Object)node.getId(), childrenNodeIds);
                this.getModel().setValue(FTNAME, (Object)node.getText(), childrenNodeIds);
            } else {
                ArrayList<String> arg12 = new ArrayList<String>();
                ArrayList<TreeNode> deleteFieldIndexs = new ArrayList<TreeNode>();
                this.getChildrenNodeIds(arg12, deleteFieldIndexs, node);
                ArrayList<Integer> fields = new ArrayList<Integer>();
                DynamicObjectCollection delFieldIndexs = this.getModel().getEntryEntity("ftargetprops");
                for (int i = 0; i < delFieldIndexs.size(); ++i) {
                    DynamicObject i1 = (DynamicObject)delFieldIndexs.get(i);
                    if (i1 == null || !arg12.contains(i1.get(FTID))) continue;
                    fields.add(i);
                }
                int[] arg16 = new int[fields.size()];
                for (int arg18 = 0; arg18 < fields.size(); ++arg18) {
                    arg16[arg18] = (Integer)fields.get(arg18);
                }
                this.getModel().deleteEntryRows("ftargetprops", arg16);
                for (TreeNode childNode : deleteFieldIndexs) {
                    int index = this.getModel().createNewEntryRow("ftargetprops");
                    this.getModel().setValue(FTID, (Object)childNode.getId(), index);
                    this.getModel().setValue(FTNAME, (Object)childNode.getText(), index);
                }
            }
        } else {
            ArrayList<TreeNode> deleteFieldIndexs;
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
            TreeNode node = root.getTreeNode(fieldId, 16);
            ArrayList<String> arg12 = new ArrayList<String>();
            if (node.getChildren() == null) {
                arg12.add(fieldId);
            } else {
                deleteFieldIndexs = new ArrayList<TreeNode>();
                this.getChildrenNodeIds(arg12, deleteFieldIndexs, node);
            }
            deleteFieldIndexs = new ArrayList();
            DynamicObjectCollection arg13 = this.getModel().getEntryEntity("ftargetprops");
            for (int arg14 = 0; arg14 < arg13.size(); ++arg14) {
                DynamicObject arg17 = (DynamicObject)arg13.get(arg14);
                if (arg17 == null || !arg12.contains(arg17.get(FTID))) continue;
                deleteFieldIndexs.add((TreeNode)Integer.valueOf(arg14));
            }
            int[] arg15 = new int[arg12.size()];
            for (int i = 0; i < deleteFieldIndexs.size(); ++i) {
                arg15[i] = (Integer)deleteFieldIndexs.get(i);
            }
            this.getModel().deleteEntryRows("ftargetprops", arg15);
        }
    }

    private void getChildrenNodeIds(List<String> childrenNodeIds, List<TreeNode> nodes, TreeNode node) {
        List childrenNodes = node.getChildren();
        if (childrenNodes != null && !childrenNodes.isEmpty()) {
            for (TreeNode childNode : childrenNodes) {
                if (childNode.getChildren() != null && !childNode.getChildren().isEmpty()) {
                    this.getChildrenNodeIds(childrenNodeIds, nodes, childNode);
                    continue;
                }
                childrenNodeIds.add(childNode.getId());
                nodes.add(childNode);
            }
            return;
        }
    }

    private void getEntityPorperty(String entityNumber, Map<String, Map<String, Object>> propertyList) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Iterator iter = mainType.getAllFields().values().iterator();
        while (iter.hasNext()) {
            JSONObject obj = new JSONObject();
            HashMap<String, Object> m = new HashMap<String, Object>();
            IDataEntityProperty fieldProp = (IDataEntityProperty)iter.next();
            if (fieldProp instanceof AttachmentProp || !(fieldProp instanceof IFieldHandle) || ((IFieldHandle)fieldProp).getDisplayName() == null) continue;
            if (StringUtils.isNotEmpty((CharSequence)fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName())) {
                EntityType description;
                if (fieldProp.getParent().getParent() != null && fieldProp.getParent().getParent().getParent() != null) {
                    if (fieldProp.getParent() instanceof EntryType && fieldProp.getParent().getParent() instanceof EntryType) {
                        description = (EntityType)fieldProp.getParent();
                        EntityType valueType = (EntityType)fieldProp.getParent().getParent();
                        if (StringUtils.isNotEmpty((CharSequence)description.getDisplayName().toString()) && StringUtils.isNotEmpty((CharSequence)valueType.getDisplayName().toString())) {
                            m.put(PROPERTYNAME, valueType.getDisplayName().getLocaleValue() + "." + description.getDisplayName().getLocaleValue() + "." + ((IFieldHandle)fieldProp).getDisplayName().getLocaleValue());
                            m.put(KEY_TRUENAME, ((IFieldHandle)fieldProp).getDisplayName().getLocaleValue());
                        }
                    }
                    this.buildEntrymByField(fieldProp, propertyList, m);
                    m.put(PROPERTYNUMBER, fieldProp.getParent().getParent().getName() + "." + fieldProp.getParent().getName() + "." + fieldProp.getName());
                    m.put(KEY_TRUENUMBER, fieldProp.getName());
                    obj.put(TYPE, (Object)fieldProp.getPropertyType());
                } else {
                    if (fieldProp.getParent() instanceof EntryType && StringUtils.isNotEmpty((CharSequence)(description = (EntityType)fieldProp.getParent()).getDisplayName().toString())) {
                        m.put(PROPERTYNAME, description.getDisplayName().getLocaleValue() + "." + ((IFieldHandle)fieldProp).getDisplayName().getLocaleValue());
                        m.put(KEY_TRUENAME, ((IFieldHandle)fieldProp).getDisplayName().getLocaleValue());
                    }
                    this.buildEntrymByField(fieldProp, propertyList, m);
                    m.put(PROPERTYNUMBER, fieldProp.getParent().getName() + "." + fieldProp.getName());
                    m.put(KEY_TRUENUMBER, fieldProp.getName());
                    obj.put(TYPE, (Object)fieldProp.getPropertyType());
                }
            } else {
                m.put(PROPERTYNAME, fieldProp.getDisplayName().getLocaleValue());
                m.put(KEY_TRUENAME, fieldProp.getDisplayName().getLocaleValue());
                m.put(PROPERTYNUMBER, fieldProp.getName());
                m.put(KEY_TRUENUMBER, fieldProp.getName());
            }
            StringBuilder description1 = new StringBuilder(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u7c7b\u578b\u4e3a:", (String)"BusinessEventConfigPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            if (fieldProp instanceof BasedataProp) {
                obj.put(TYPE, (Object)DYNAMICOBJECT);
                obj.put(ENTITYID, (Object)((BasedataProp)fieldProp).getBaseEntityId());
                obj.put(ISMULTI, (Object)Boolean.FALSE);
                description1.append(ResManager.loadKDString((String)"\u5b9e\u4f53", (String)"BusinessEventConfigPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                obj.put(PROPERTYDESCRIPTION, (Object)description1.toString());
            } else if (fieldProp instanceof MulBasedataProp) {
                obj.put(TYPE, (Object)DYNAMICOBJECT);
                obj.put(ENTITYID, (Object)((MulBasedataProp)fieldProp).getBaseEntityId());
                obj.put(ISMULTI, (Object)Boolean.TRUE);
                description1.append(ResManager.loadKDString((String)"\u5b9e\u4f53", (String)"BusinessEventConfigPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                obj.put(PROPERTYDESCRIPTION, (Object)description1.toString());
            } else {
                JSONArray arr;
                String valueType1 = KemBusinessEventConfigPlugin.getReturnType(fieldProp, description1);
                obj.put(TYPE, (Object)valueType1);
                obj.put(ISMULTI, (Object)Boolean.FALSE);
                if (!(fieldProp instanceof ComboProp)) {
                    if (fieldProp instanceof BooleanProp) {
                        arr = new JSONArray();
                        JSONObject obj11 = new JSONObject();
                        obj11.put(VALUE, (Object)"1");
                        obj11.put(CAPTION, (Object)new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"BusinessEventConfigPlugin_3", (String)"bos-bec-formplugin", (Object[])new Object[0])));
                        arr.add((Object)obj11);
                        JSONObject obj01 = new JSONObject();
                        obj01.put(VALUE, (Object)"0");
                        obj01.put(CAPTION, (Object)new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"BusinessEventConfigPlugin_4", (String)"bos-bec-formplugin", (Object[])new Object[0])));
                        arr.add((Object)obj01);
                        obj.put(ATTRIBUTE, (Object)arr.toJSONString());
                    }
                } else {
                    arr = new JSONArray();
                    ComboProp obj1 = (ComboProp)fieldProp;
                    List obj0 = obj1.getComboItems();
                    for (ValueMapItem i : obj0) {
                        JSONObject item = new JSONObject();
                        item.put(VALUE, (Object)i.getValue());
                        item.put(CAPTION, (Object)i.getName());
                        arr.add((Object)item);
                    }
                    obj.put(ATTRIBUTE, (Object)arr.toJSONString());
                }
            }
            obj.put(PROPERTYDESCRIPTION, (Object)description1.toString());
            m.put(PROPERTYTYPE, obj);
            m.put(PROPERTYDESCRIPTION, description1.toString());
            propertyList.put(String.valueOf(m.get(PROPERTYNUMBER)), m);
            if (fieldProp instanceof BasedataProp) {
                this.buildmByField(fieldProp, propertyList, m);
                continue;
            }
            if (!(fieldProp instanceof MulBasedataProp)) continue;
            this.buildmByField(fieldProp, propertyList, m);
        }
        return;
    }

    private void buildEntrymByField(IDataEntityProperty fieldProp, Map<String, Map<String, Object>> propertyList, Map<String, Object> pm) {
        EntryType type;
        if (fieldProp.getParent() instanceof EntryType && !propertyList.containsKey((type = (EntryType)fieldProp.getParent()).getName())) {
            JSONObject obj = new JSONObject();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put(PROPERTYNAME, type.getDisplayName().getLocaleValue());
            m.put(PROPERTYNUMBER, type.getName());
            m.put(KEY_TRUENAME, type.getDisplayName().getLocaleValue());
            m.put(KEY_TRUENUMBER, type.getName());
            obj.put(TYPE, (Object)"STRUCT");
            obj.put(PROPERTYDESCRIPTION, (Object)"");
            obj.put(ISMULTI, (Object)Boolean.TRUE);
            m.put(PROPERTYTYPE, (String)obj);
            m.put(PROPERTYDESCRIPTION, type.getDisplayName().getLocaleValue());
            propertyList.put(String.valueOf(m.get(PROPERTYNUMBER)), m);
        }
    }

    private void buildmByField(IDataEntityProperty fieldProp, Map<String, Map<String, Object>> propertyList, Map<String, Object> pm) {
        DynamicObjectType type = null;
        if (fieldProp instanceof BasedataProp) {
            if (fieldProp instanceof MaterielProp) {
                MaterielProp prop = (MaterielProp)fieldProp;
                type = prop.getDynamicComplexPropertyType();
                this.buildBasedataPropertyList(type, pm, propertyList);
                if (prop.getDynamicComplexPropertyType().getProperty("masterid") instanceof MasterBasedataProp) {
                    MasterBasedataProp prop1 = (MasterBasedataProp)prop.getDynamicComplexPropertyType().getProperty("masterid");
                    type = prop1.getDynamicComplexPropertyType();
                    this.buildBasedataPropertyList(type, pm, propertyList);
                }
            } else {
                BasedataProp prop = (BasedataProp)fieldProp;
                type = prop.getDynamicComplexPropertyType();
                this.buildBasedataPropertyList(type, pm, propertyList);
            }
        } else if (fieldProp instanceof MulBasedataProp) {
            MulBasedataProp prop = (MulBasedataProp)fieldProp;
            type = prop.getDynamicCollectionItemPropertyType();
            BasedataProp prop1 = (BasedataProp)type.getProperty("fbasedataid");
            type = prop1.getDynamicComplexPropertyType();
            this.buildBasedataPropertyList(type, pm, propertyList);
        }
    }

    private void buildBasedataPropertyList(DynamicObjectType type, Map<String, Object> pm, Map<String, Map<String, Object>> propertyList) {
        boolean ismulti = Boolean.FALSE;
        for (IDataEntityProperty prop1 : type.getProperties()) {
            JSONObject obj = new JSONObject();
            StringBuilder description1 = new StringBuilder(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u7c7b\u578b\u4e3a:", (String)"BusinessEventConfigPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put(PROPERTYNUMBER, pm.get(PROPERTYNUMBER) + "." + prop1.getName());
            m.put(KEY_TRUENUMBER, prop1.getName());
            String name = prop1.getName();
            try {
                name = prop1.getDisplayName() == null ? prop1.getName() : ((IFieldHandle)prop1).getDisplayName().getLocaleValue();
            }
            catch (Exception e) {
                name = prop1.getName();
            }
            m.put(PROPERTYNAME, name);
            m.put(KEY_TRUENAME, name);
            String valueType1 = KemBusinessEventConfigPlugin.getReturnType(prop1, description1);
            obj.put(TYPE, (Object)valueType1);
            obj.put(ISMULTI, (Object)ismulti);
            obj.put(PROPERTYDESCRIPTION, (Object)description1.toString());
            m.put(PROPERTYTYPE, obj);
            m.put(PROPERTYDESCRIPTION, description1.toString());
            propertyList.put(String.valueOf(m.get(PROPERTYNUMBER)), m);
            this.buildmByField(prop1, propertyList, m);
        }
    }

    private static String getReturnType(IDataEntityProperty fieldProp, StringBuilder description) {
        if (fieldProp instanceof BooleanProp) {
            description.append(ResManager.loadKDString((String)"\u5e03\u5c14", (String)"BusinessEventConfigPlugin_5", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            return "boolean";
        }
        if (fieldProp instanceof LongProp) {
            description.append(ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"KemBusinessEventConfigPlugin_0", (String)"isc-kem-formplugin", (Object[])new Object[0]));
            return "Long";
        }
        if (fieldProp instanceof BigIntProp) {
            if (fieldProp.getName().equals("masterid")) {
                return "STRUCT";
            }
            return "Long";
        }
        if (!(fieldProp instanceof IntegerProp || fieldProp instanceof BigIntProp || fieldProp instanceof AmountProp || fieldProp instanceof DecimalProp)) {
            if (!(fieldProp instanceof TextProp || fieldProp instanceof MuliLangTextProp || fieldProp instanceof PictureProp)) {
                if (!(fieldProp instanceof ComboProp || fieldProp instanceof BillStatusProp || fieldProp instanceof MulComboProp)) {
                    if (!(fieldProp instanceof CreateDateProp || fieldProp instanceof ModifyDateProp || fieldProp instanceof DateProp || fieldProp instanceof DateTimeProp)) {
                        description.append(ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"BusinessEventConfigPlugin_7", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                        return STRING;
                    }
                    description.append(ResManager.loadKDString((String)"\u65e5\u671f", (String)"BusinessEventConfigPlugin_9", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                    return "date";
                }
                description.append(ResManager.loadKDString((String)"\u679a\u4e3e", (String)"BusinessEventConfigPlugin_8", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                return STRING;
            }
            if (fieldProp instanceof MuliLangTextProp) {
                description.append(ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"BusinessEventConfigPlugin_7", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                return "mulilang";
            }
            description.append(ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"BusinessEventConfigPlugin_7", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            return STRING;
        }
        description.append(ResManager.loadKDString((String)"\u6570\u5b57", (String)"BusinessEventConfigPlugin_6", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        return "number";
    }

    private String getModelType() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        if (StringUtils.isBlank((CharSequence)modelType)) {
            modelType = "DynamicFormModel";
        }
        return modelType;
    }

    private int getRefMaxQuantity() {
        String refMaxQuantity = this.getPageCache().get(REF_MAX_QUANTITY);
        if (StringUtils.isBlank((CharSequence)refMaxQuantity)) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BASEDATA_REFERENCING_PROPERTY ", new DistributeCacheHAPolicy(true, true));
            refMaxQuantity = (String)cache.get(CacheKeyUtil.getAcctId() + ".refMaxQuantity");
        }
        if (StringUtils.isNotBlank((CharSequence)refMaxQuantity)) {
            return Integer.parseInt(refMaxQuantity);
        }
        return 50;
    }

    private void rebuildRoot(TreeNode root1) {
        List item = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (item == null || item.isEmpty()) {
            return;
        }
        Object obj = item.get(0);
        List fldlist = obj instanceof List ? (List)item.get(0) : item;
        String modelType = this.getModelType();
        IFormTemplate template = FormTemplateFactory.createTemplate((String)modelType);
        Object ctrl = template.deserializeFromMap((Map)fldlist.get(0), null);
        String entityId = "";
        if (ctrl instanceof CustomBaseDataFilterColumnAp) {
            entityId = ((CustomBaseDataFilterColumnAp)ctrl).getBaseEntityId();
        } else if (ctrl instanceof MulBasedataField) {
            entityId = ((MulBasedataField)ctrl).getBaseEntityId();
        } else if (ctrl instanceof ParentBasedataField) {
            List listCustData = (List)item.get(1);
            for (Map map : listCustData) {
                String type = (String)map.get("_Type_");
                if (!"BaseEntity".equals(type)) continue;
                entityId = (String)map.get("Id");
                break;
            }
        } else if (ctrl instanceof IBasedataField) {
            entityId = ((IBasedataField)ctrl).getBaseEntityId();
        }
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeAllMasterProps(true);
        option.addInvalidClassTypes(BasedataPropField.class);
        TreeNode fullTree = FormTreeBuilder.buildEntityFieldsTree((EntityMetadata)entityMetadata, (EntityFieldTreeBuildOption)option);
        option.setIncludeBDPropPK(true);
        option.setSpecialTreatmentMulBDProp(true);
        option.setTestIncludeFiledNumber(true);
        String number = MetadataDao.getNumberById((String)MetadataDao.getMasterId((String)entityId));
        this.getPageCache().put(ENTITYNUMBER, number);
        TreeNode root = FormTreeBuilder.buildRefEntityTree((String)number, (PropTreeBuildOption)option);
        ArrayList<TreeNode> childrenId = new ArrayList<TreeNode>(root.getChildren().size());
        for (TreeNode node : root.getChildren()) {
            childrenId.add(node);
        }
        for (TreeNode node : childrenId) {
            node.setParentid(root.getId());
        }
        this.getPageCache().put(TREEROOTNODE, SerializationUtils.toJsonString((Object)root));
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (value == null || StringUtils.isBlank(value)) {
            value = new ArrayList();
        }
        List refProps = (List)value;
        ArrayList checkNodeIds = new ArrayList();
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkNodeIds));
        IDataModel model = this.getModel();
        model.deleteEntryData("ftargetprops");
        for (Map refProp : refProps) {
            String name = (String)refProp.get("Name");
            TreeNode node = root.getTreeNode(name, 16);
            if (node == null) {
                node = fullTree.getTreeNode(name, 16);
            }
            if (node == null) continue;
            int rowindex = model.createNewEntryRow("ftargetprops");
            model.setValue(FTNAME, (Object)node.getId(), rowindex);
            model.setValue("ftdisplayname", (Object)node.getText(), rowindex);
        }
        int refMaxQuantity = this.getRefMaxQuantity();
        if (refProps.size() > refMaxQuantity) {
            this.getPageCache().put(VERIFY_REF_QUANTITY, "false");
        }
        this.getPageCache().put(REF_MAX_QUANTITY, String.valueOf(refMaxQuantity));
        this.rebuildTreeRoot(root1, root);
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root1));
    }

    private void rebuildTreeRoot(TreeNode root1, TreeNode root) {
        this.mergeTreeNodes(root, root1);
        List billheads = null;
        for (TreeNode a1 : root.getChildren()) {
            if (!a1.getId().equals("billhead")) continue;
            billheads = a1.getChildren();
        }
        if (null != billheads && billheads.size() > 0) {
            for (TreeNode billHead : billheads) {
                for (TreeNode ro : root1.getChildren()) {
                    if (!ro.getId().equals(billHead.getId()) || null == billHead.getChildren() || billHead.getChildren().size() <= 0) continue;
                    ro.addChildren(billHead.getChildren());
                    ro.setCheckable(true);
                }
            }
        }
    }

    public void mergeTreeNodes(TreeNode root, TreeNode root1) {
        List<TreeNode> entrys1 = this.collectEntryNodes(root1);
        List<TreeNode> subs = root.getChildren().stream().filter(a -> !"billhead".equals(a.getId())).collect(Collectors.toList());
        for (TreeNode a2 : root.getChildren()) {
            if ("billhead".equals(a2.getId())) continue;
            root1.getChildren().stream().filter(a1 -> Objects.equals(a1.getId(), a2.getId())).findFirst().ifPresent(a1 -> {
                this.mergeChildren(a2, (TreeNode)a1);
                subs.remove(a2);
            });
        }
        subs.forEach(sub -> entrys1.stream().filter(entry1 -> Objects.equals(entry1.getId(), sub.getId())).forEach(entry1 -> this.mergeChildren((TreeNode)sub, (TreeNode)entry1)));
    }

    private List<TreeNode> collectEntryNodes(TreeNode root1) {
        return root1.getChildren().stream().filter(a1_1 -> a1_1.getChildren() != null).flatMap(a1_1 -> a1_1.getChildren().stream()).filter(a1_3 -> a1_3.getChildren() != null).collect(Collectors.toList());
    }

    private void mergeChildren(TreeNode a, TreeNode a1) {
        if (this.hasChildren(a) && this.hasChildren(a1)) {
            a1.getChildren().forEach(treeNode -> a.getChildren().forEach(treeNode1 -> {
                if (this.isMatchingNode(a, (TreeNode)treeNode, (TreeNode)treeNode1)) {
                    if (treeNode1.getChildren() != null) {
                        treeNode1.getChildren().forEach(child -> child.setId(treeNode.getId() + "." + child.getId().replace(child.getParentid() + ".", "")));
                        treeNode.addChildren(this.rebuildChildId((TreeNode)treeNode, treeNode1.getChildren()));
                    }
                    this.mergeChildren((TreeNode)treeNode1, (TreeNode)treeNode);
                }
            }));
        }
    }

    private List<TreeNode> rebuildChildId(TreeNode pNode, List<TreeNode> children) {
        for (TreeNode child : children) {
            if (!child.getId().contains(pNode.getId() + ".")) {
                String[] strs = child.getId().split("\\.");
                child.setId(pNode.getId() + "." + strs[strs.length - 1]);
            }
            if (child.getChildren() == null) continue;
            this.rebuildChildId(child, child.getChildren());
        }
        return children;
    }

    private boolean hasChildren(TreeNode node) {
        return node.getChildren() != null && !node.getChildren().isEmpty();
    }

    private boolean isMatchingNode(TreeNode parent, TreeNode node, TreeNode child) {
        String childIdWithParent = parent.getId() + "." + child.getId();
        return node.getId().equals(childIdWithParent) || (node.getId() + ".").contains(childIdWithParent + ".");
    }

    private void buildTreeData() {
        IDataModel parentModel = this.getView().getParentView().getModel();
        DynamicObjectCollection datas = parentModel.getEntryEntity("data_entry");
        this.addPKRow(datas, parentModel);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
        String number = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        LinkedHashMap<String, Map<String, Object>> propertyList = new LinkedHashMap<String, Map<String, Object>>();
        this.getEntityPorperty(number, propertyList);
        DynamicObjectCollection fields = this.getModel().getEntryEntity("ftargetprops");
        for (DynamicObject field : fields) {
            String fieldId = field.getString(FTID);
            this.addRowByTreeNode(root.getTreeNode(fieldId), propertyList, root, datas, null, 1);
        }
        parentModel.updateEntryCache(datas);
    }

    private void addRowByTreeNode(TreeNode node, Map<String, Map<String, Object>> propertyList, TreeNode root, DynamicObjectCollection datas, DynamicObject child, int level) {
        String rootId = this.getPageCache().get("rootId");
        if (!rootId.equals(node.getId())) {
            TreeNode pNode;
            Map<String, Object> config = propertyList.get(node.getId());
            if (null == config) {
                config = propertyList.get(node.getId().replace("masterid.", ""));
            }
            if (null == config) {
                return;
            }
            Map propertytype = (Map)config.get(PROPERTYTYPE);
            DynamicObject row = this.findExistingRow(datas, config.get(PROPERTYNUMBER).toString(), level);
            Long id = 0L;
            int paraLevel = 0;
            if (row == null) {
                row = datas.addNew();
                row.set(KEY_PARANAME, config.get(KEY_TRUENUMBER));
                row.set(KEY_PARANUMBER, config.get(KEY_TRUENAME));
                id = IDService.get().genLongId();
                row.set("id", (Object)id);
                row.set("pid", (Object)0L);
                row.set(KEY_PARATYPE, (Object)DataTypeUtil.convertType(propertytype.get(TYPE)));
                row.set(KEY_ISMULTIVALUE, (Object)((Boolean)propertytype.get(ISMULTI) != false ? "1" : "0"));
                row.set(KEY_ISREQUIRED, (Object)"1");
                row.set(KEY_PARADESC, (Object)this.buildEnumData(propertytype.get(ATTRIBUTE), config.get(PROPERTYNAME).toString()));
                row.set(CONFIGNUMBER, config.get(PROPERTYNUMBER));
                row.set(KEY_PARALEVEL, (Object)level);
                paraLevel = level;
            } else {
                id = row.getLong("id");
                paraLevel = row.getInt(KEY_PARALEVEL);
            }
            if (child != null) {
                child.set("pid", (Object)id);
                if (row.getLong("id") == id.longValue()) {
                    row.set(KEY_PARATYPE, (Object)"STRUCT");
                }
                child.set(KEY_PARALEVEL, (Object)(paraLevel + 1));
            }
            if (null == (pNode = root.getTreeNode(node.getParentid()))) {
                pNode = root.getTreeNode(StringUtils.substringBefore((String)node.getId(), (String)node.getParentid()) + node.getParentid());
            }
            this.addRowByTreeNode(pNode, propertyList, root, datas, row, level);
        }
    }

    private DynamicObject findExistingRow(DynamicObjectCollection datas, String paranumber, int level) {
        for (DynamicObject row : datas) {
            if (!row.getString(CONFIGNUMBER).equals(paranumber)) continue;
            return row;
        }
        return null;
    }

    private void addPKRow(DynamicObjectCollection datas, IDataModel parentModel) {
        long isHasPK = datas.stream().filter(item -> item.getString(CONFIGNUMBER).equals("PrimaryKey")).count();
        if (isHasPK > 0L) {
            return;
        }
        DynamicObject bizObj = (DynamicObject)parentModel.getValue("bizobjectid");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)bizObj.getString("number"));
        DynamicObject pk = datas.addNew();
        PKFieldProp prop = (PKFieldProp)mainType.getPrimaryKey();
        pk.set(KEY_PARANAME, (Object)prop.getName());
        pk.set(KEY_PARANUMBER, (Object)prop.getName());
        pk.set("id", (Object)IDService.get().genLongId());
        pk.set("pid", (Object)0L);
        pk.set(KEY_PARATYPE, (Object)prop.getPropertyType().getName());
        pk.set(KEY_ISMULTIVALUE, (Object)"0");
        pk.set(KEY_ISREQUIRED, (Object)"1");
        pk.set(KEY_PARADESC, (Object)"pk");
        pk.set(KEY_PARALEVEL, (Object)"1");
        pk.set(CONFIGNUMBER, (Object)"PrimaryKey");
    }

    private String buildEnumData(Object attribute, String propertyname) {
        StringBuilder data = new StringBuilder();
        data.append(propertyname);
        try {
            JSONArray arr = JSONArray.parseArray((String)attribute.toString());
            if (arr.size() > 0) {
                data.append(':');
                JSONArray arr1 = new JSONArray();
                for (Object obj : arr) {
                    JSONObject jsonObj = (JSONObject)obj;
                    StringBuilder kv = new StringBuilder();
                    kv.append(jsonObj.getString(VALUE));
                    kv.append(':');
                    kv.append(jsonObj.getJSONObject(CAPTION).get((Object)RequestContext.get().getLang().name()));
                    arr1.add((Object)kv.toString());
                }
                data.append(arr1.toJSONString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data.toString();
    }
}

