/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.CodeEdit;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.common.util.ObjectUtil;
import kd.isc.kem.core.subscribe.model.TargetInput;

public class KemParamsBuildUtil {
    private static final String ID = "Id";
    private static final String PID = "pid";
    private static final String KEY_WEB_URL_PARAMS = "web_url_params";
    private static final String KEY_WEB_REQ_BODY = "web_req_body";
    private static final String KEY_WEB_REQ_HEADER = "web_req_header";
    private static final String KEY_TARGETAPI = "targetapi";
    private static final String KEY_TARGET_DATASOURCE = "target_datasource";
    private static final String KEY_SCRIPT = "script";
    private static final String KEY_ASSERTION = "assertion";
    private static final String KEY_HEADER = "header";
    private static final String KEY_BODY = "body";
    private static final String KEY_QUERYSTRING = "queryString";
    private static final String KEY_CODEEDITAP = "codeeditap";
    private static final String KEY_CODEEDIT_SCRIPT = "codeedit_script";
    private static final String KEY_CODEEDIT_COM = "codeedit_com";
    private static final String KEY_HTTPMETHOD = "httpmethod";
    private static final String KEY_METHOD = "method";
    private static final String KEY_URL_PREFIX = "url_prefix";
    private static final String KEY_URL_PATH = "url_path";
    private static final String KEY_URL = "url";
    private static final String KEY_ACTIONDATASOURCEID = "actiondatasourceid";
    private static final String KEY_ACTIONID = "actionid";
    private static final String KEY_ACTIONNUMBER = "actionnumber";
    private static final String KEY_ACTIONNAME = "actionname";
    private static final String KEY_ACTIONTYPE = "actiontype";
    private static final String KEY_TARGETTYPE = "targetType";
    private static final String KEY_TARGETID = "targetId";
    private static final String KEY_ISARRAY = "isArray";
    private static final String KEY_REQUIRED = "required";
    private static final String KEY_URL_PARAM_NAME = "url_param_name";
    private static final String KEY_URL_PARAM_VALUE = "url_param_value";
    private static final String KEY_ACTIONCONFIG_TAG = "actionconfig_tag";
    private static final String KEY_ACTION_BASETYPE = "action_basetype";
    private static final String KEY_ACTION_BASEDATA = "action_basedata";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_NAME = "name";
    private static final String KEY_PARENTID = "parentId";
    private static final String KEY_PARAMTYPE = "paramType";
    private static final String KEY_PARAMVALUE = "paramValue";
    private static final String KEY_PARAMNAME = "paramName";
    private static final String KEY_PARAMDESC = "paramDesc";
    private static final String KEY_REQ_B_PARAM_NAME = "req_b_param_name";
    private static final String KEY_REQ_B_PARAM_TYPE = "req_b_param_type";
    private static final String KEY_REQ_B_PARAM_IS_ARRAY = "req_b_param_is_array";
    private static final String KEY_REQ_B_PARAM_REQUIRED = "req_b_param_required";
    private static final String KEY_REQ_H_PARAM_VALUE = "req_h_param_value";
    private static final String KEY_REQ_H_PARAM_NAME = "req_h_param_name";
    private static final String KEY_REQ_B_PARAM_VALUE = "req_b_param_value";
    private static final String KEY_REQ_B_PARAM_DESC = "req_b_param_desc";
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";

    public static void webapiDataPadding(IFormView view, DynamicObject webapi) {
        DynamicObjectCollection headers;
        DynamicObjectCollection bodys;
        IDataModel model = view.getModel();
        KemParamsBuildUtil.clearData(view);
        model.setValue(KEY_HTTPMETHOD, webapi.get(KEY_METHOD));
        model.setValue(KEY_URL_PREFIX, webapi.get(KEY_URL_PREFIX));
        model.setValue(KEY_URL_PATH, webapi.get(KEY_URL_PATH));
        model.setValue(KEY_METHOD, webapi.get(KEY_METHOD));
        DynamicObjectCollection urls = webapi.getDynamicObjectCollection(KEY_WEB_URL_PARAMS);
        if (!CollectionUtils.isEmpty((Collection)urls)) {
            List urlData = urls.stream().filter(a -> ObjectUtils.isEmpty((Object)a.get(KEY_URL_PARAM_VALUE))).collect(Collectors.toList());
            for (DynamicObject url : urlData) {
                model.createNewEntryRow(KEY_WEB_URL_PARAMS, url);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(bodys = webapi.getDynamicObjectCollection(KEY_WEB_REQ_BODY)))) {
            List bodyData = bodys.stream().filter(a -> ObjectUtils.isEmpty((Object)a.get(KEY_REQ_B_PARAM_VALUE))).collect(Collectors.toList());
            DynamicObjectCollection bodys1 = model.getEntryEntity(KEY_WEB_REQ_BODY);
            for (DynamicObject body : bodyData) {
                DynamicObject row = new DynamicObject(bodys1.getDynamicObjectType());
                row.set(PID, body.get(PID));
                row.set(ID, body.get(ID));
                row.set(KEY_REQ_B_PARAM_NAME, body.get(KEY_REQ_B_PARAM_NAME));
                row.set(KEY_REQ_B_PARAM_TYPE, body.get(KEY_REQ_B_PARAM_TYPE));
                row.set(KEY_REQ_B_PARAM_DESC, body.get(KEY_REQ_B_PARAM_DESC));
                row.set(KEY_REQ_B_PARAM_IS_ARRAY, (Object)body.getBoolean(KEY_REQ_B_PARAM_IS_ARRAY));
                row.set(KEY_REQ_B_PARAM_REQUIRED, (Object)body.getBoolean(KEY_REQ_B_PARAM_REQUIRED));
                row.set("req_b_param_example", body.get("req_b_param_example"));
                int i = model.createNewEntryRow(KEY_WEB_REQ_BODY, row);
                model.setValue(KEY_REQ_B_PARAM_IS_ARRAY, (Object)body.getBoolean(KEY_REQ_B_PARAM_IS_ARRAY), i);
                model.setValue(KEY_REQ_B_PARAM_REQUIRED, (Object)body.getBoolean(KEY_REQ_B_PARAM_REQUIRED), i);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(headers = webapi.getDynamicObjectCollection(KEY_WEB_REQ_HEADER)))) {
            List headerData = headers.stream().filter(a -> ObjectUtils.isEmpty((Object)a.get(KEY_REQ_H_PARAM_VALUE))).collect(Collectors.toList());
            for (DynamicObject header : headerData) {
                model.createNewEntryRow(KEY_WEB_REQ_HEADER, header);
            }
        }
        model.updateCache();
    }

    public static String toJSONString(String data) {
        JsonNode jsonNode = JacksonUtil.readTree((String)data);
        return JacksonUtil.writeValueAsPrettyString((Object)jsonNode);
    }

    public static String toInputJSONString(String data) {
        TargetInput targetInput = (TargetInput)JacksonUtil.readValue((String)data, TargetInput.class);
        return JacksonUtil.writeValueAsPrettyString((Object)targetInput.getData().get("originalData"));
    }

    public static void buildParamValue(String value, IFormView view) {
        int paramtype = 1;
        String text = "";
        CodeEdit codeEdit = null;
        if (value.startsWith("<%") && value.endsWith("%>")) {
            paramtype = 3;
            text = value.replace("<%", "");
            text = text.replace("%>", "");
            codeEdit = (CodeEdit)view.getControl(KEY_CODEEDIT_SCRIPT);
            codeEdit.setText(text);
        } else if (value.startsWith("#{") && value.endsWith("}")) {
            paramtype = 2;
        } else if (value.startsWith("\"") && value.endsWith("\"")) {
            paramtype = 1;
            text = value.replace("\"", "");
            codeEdit = (CodeEdit)view.getControl(KEY_CODEEDIT_COM);
            codeEdit.setText(text);
        } else {
            codeEdit = (CodeEdit)view.getControl(KEY_CODEEDIT_COM);
            codeEdit.setText(value);
        }
        view.getModel().setValue(KEY_PARAMTYPE, (Object)paramtype);
    }

    public static void setTargetRow(int index, IFormView subView, JSONObject data1) {
        subView.getModel().setValue(KEY_ACTIONDATASOURCEID, data1.get((Object)KEY_ACTIONDATASOURCEID), index);
        subView.getModel().setValue(KEY_ACTIONID, (Object)data1.getString(KEY_ACTIONID), index);
        subView.getModel().setValue(KEY_ACTIONNUMBER, (Object)data1.getString(KEY_ACTIONNUMBER), index);
        subView.getModel().setValue(KEY_ACTIONNAME, (Object)data1.getString(KEY_ACTIONNAME), index);
        subView.getModel().setValue(KEY_ACTIONCONFIG_TAG, (Object)data1.getJSONObject(KEY_ACTIONCONFIG_TAG).toJSONString(), index);
        subView.getModel().setValue(KEY_ACTION_BASETYPE, data1.get((Object)KEY_ACTION_BASETYPE), index);
        subView.getModel().setValue(KEY_ACTION_BASEDATA, data1.get((Object)KEY_ACTION_BASEDATA), index);
        subView.getModel().updateCache();
    }

    public static void buildApiTargetData(JSONObject data1, IDataModel model) {
        JSONObject data = new JSONObject();
        DynamicObject targetapi = (DynamicObject)model.getValue(KEY_TARGETAPI);
        if (model.getValue(KEY_TARGET_DATASOURCE) == null) {
            return;
        }
        DynamicObject dataSource = (DynamicObject)model.getValue(KEY_TARGET_DATASOURCE);
        data.put(KEY_TARGETID, (Object)targetapi.getString(ID));
        data.put(KEY_ACTIONDATASOURCEID, dataSource.get(KEY_NUMBER));
        DynamicObjectCollection bodyRows = model.getEntryEntity(KEY_WEB_REQ_BODY);
        JSONObject bodyform = new JSONObject();
        ArrayList<JSONObject> bodys = new ArrayList<JSONObject>();
        for (DynamicObject row : bodyRows) {
            bodyform.put(row.getString(KEY_REQ_B_PARAM_NAME), row.get(KEY_REQ_B_PARAM_VALUE));
            JSONObject body = new JSONObject();
            body.put(ID, row.get(ID));
            body.put(KEY_PARENTID, row.get(PID));
            body.put(KEY_PARAMNAME, row.get(KEY_REQ_B_PARAM_NAME));
            body.put(KEY_PARAMTYPE, row.get(KEY_REQ_B_PARAM_TYPE));
            body.put(KEY_ISARRAY, row.get(KEY_REQ_B_PARAM_IS_ARRAY));
            body.put(KEY_REQUIRED, row.get(KEY_REQ_B_PARAM_REQUIRED));
            body.put(KEY_PARAMVALUE, row.get(KEY_REQ_B_PARAM_VALUE));
            body.put(KEY_PARAMDESC, row.get(KEY_REQ_B_PARAM_DESC));
            bodys.add(body);
        }
        data.put("body_form", (Object)bodyform);
        data.put(KEY_BODY, bodys);
        DynamicObjectCollection headerRows = model.getEntryEntity(KEY_WEB_REQ_HEADER);
        JSONObject headerform = new JSONObject();
        ArrayList<JSONObject> headers = new ArrayList<JSONObject>();
        for (DynamicObject row : headerRows) {
            headerform.put(row.getString(KEY_REQ_H_PARAM_NAME), row.get(KEY_REQ_H_PARAM_VALUE));
            JSONObject header = new JSONObject();
            header.put(KEY_PARAMNAME, row.get(KEY_REQ_H_PARAM_NAME));
            header.put(KEY_PARAMVALUE, row.get(KEY_REQ_H_PARAM_VALUE));
            headers.add(header);
        }
        data.put("header_form", (Object)headerform);
        data.put(KEY_HEADER, headers);
        DynamicObjectCollection urlRows = model.getEntryEntity(KEY_WEB_URL_PARAMS);
        JSONObject urlform = new JSONObject();
        ArrayList<JSONObject> urls = new ArrayList<JSONObject>();
        for (DynamicObject row : urlRows) {
            urlform.put(row.getString(KEY_URL_PARAM_NAME), row.get(KEY_URL_PARAM_VALUE));
            JSONObject url = new JSONObject();
            url.put(KEY_PARAMNAME, row.get(KEY_URL_PARAM_NAME));
            url.put(KEY_PARAMVALUE, row.get(KEY_URL_PARAM_VALUE));
            urls.add(url);
        }
        data.put("queryString_form", (Object)urlform);
        data.put(KEY_QUERYSTRING, urls);
        data.put(KEY_URL_PREFIX, model.getValue(KEY_URL_PREFIX));
        data.put(KEY_SCRIPT, model.getValue("script_t_tag"));
        data.put("script_remark", model.getValue("script_t"));
        data.put(KEY_ASSERTION, model.getValue("success_d_tag"));
        data.put("assertion_remark", model.getValue("success_d"));
        data1.put(KEY_ACTIONCONFIG_TAG, (Object)data);
        data1.put(KEY_ACTIONDATASOURCEID, dataSource.get(ID));
        data1.put(KEY_ACTIONID, (Object)targetapi.getString(ID));
        data1.put(KEY_ACTIONNUMBER, (Object)targetapi.getString(KEY_NUMBER));
        data1.put(KEY_ACTIONNAME, (Object)targetapi.getString(KEY_NAME));
        data1.put(KEY_ACTION_BASETYPE, (Object)targetapi.getDynamicObjectType().getName());
        data1.put(KEY_ACTION_BASEDATA, (Object)targetapi);
    }

    public static void buildMsgTargetData(JSONObject data1, IDataModel model) {
        JSONObject data = new JSONObject();
        data.put("msg_channel", model.getValue("msg_channel"));
        data.put("open_msg", model.getValue("open_msg"));
        data.put("msg_user_type", model.getValue("msg_user_type"));
        DynamicObjectCollection collection = (DynamicObjectCollection)model.getValue("msg_user");
        data.put("msg_user", model.getValue("msg_user") == null ? "" : collection.stream().map(i -> i.getDynamicObject("fbasedataid").get("id")).collect(Collectors.toList()));
        data.put("param_user", model.getValue("param_user"));
        data.put("msg_user_ext", model.getValue("msg_user_ext_detail"));
        data.put("param_user_ext", model.getValue("param_user_ext"));
        data.put("msg_title", model.getValue("msg_title"));
        data.put("msg_content", model.getValue("msg_content"));
        data1.put(KEY_ACTIONCONFIG_TAG, (Object)data);
        Map channels = MessageCenterServiceHelper.getEnableChannel();
        data1.put(KEY_ACTIONNAME, (Object)((OrmLocaleValue)channels.get(model.getValue("msg_channel"))).getLocaleValue());
    }

    public static void buildiscSfTargetData(JSONObject data1, IDataModel model) {
        JSONObject data = new JSONObject();
        DynamicObject flow = (DynamicObject)model.getValue("service_flow");
        data.put("service_flow", flow.get(ID));
        data.put(KEY_SCRIPT, model.getValue("script_tag"));
        data.put("script_remark", model.getValue(KEY_SCRIPT));
        data.put("no_proc_inst", model.getValue("no_proc_inst"));
        data.put("asyn", model.getValue("asyn"));
        data.put("disable_trace", model.getValue("disable_trace"));
        ArrayList<JSONObject> paramEntrys = new ArrayList<JSONObject>();
        DynamicObjectCollection paramEntry = model.getEntryEntity("param_entry");
        for (DynamicObject row : paramEntry) {
            JSONObject param = new JSONObject();
            param.put(ID, row.get(ID));
            param.put(KEY_PARENTID, row.get(PID));
            param.put(KEY_PARAMNAME, (Object)row.getString("var_name"));
            param.put("var_category", (Object)row.getString("var_category"));
            param.put(KEY_PARAMTYPE, (Object)row.getString("var_type"));
            param.put("var_desc", (Object)row.getString("var_desc"));
            param.put(KEY_ISARRAY, (Object)row.getString("is_array"));
            param.put(KEY_PARAMVALUE, (Object)row.getString("var_value"));
            paramEntrys.add(param);
        }
        data.put("paramEntry", paramEntrys);
        data1.put(KEY_ACTIONCONFIG_TAG, (Object)data);
        data1.put(KEY_ACTIONNAME, (Object)flow.getString(KEY_NAME));
        data1.put(KEY_ACTION_BASETYPE, (Object)flow.getDynamicObjectType().getName());
        data1.put(KEY_ACTION_BASEDATA, (Object)flow);
    }

    public static void buildScriptTargetData(JSONObject data1, IDataModel model) {
        JSONObject data = new JSONObject();
        Object remark = model.getValue("remark");
        data.put("remark", remark);
        data.put(KEY_SCRIPT, model.getValue("script_tag"));
        data1.put(KEY_ACTIONCONFIG_TAG, (Object)data);
        String actionName = ResManager.loadKDString((String)"\u811a\u672c\u670d\u52a1", (String)"KemParamsBuildUtil_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]);
        if (!ObjectUtil.isEmpty((Object)remark) && (actionName = remark.toString()).length() > 49) {
            actionName = actionName.substring(0, 50);
        }
        data1.put(KEY_ACTIONNAME, (Object)actionName);
    }

    public static JSONObject setWebHookTargetData(int rowIndex, IFormView targetView, IFormView subView) {
        int index = rowIndex;
        if (index >= 0 && targetView != null) {
            JSONObject data = new JSONObject();
            data.put(KEY_URL, targetView.getModel().getValue("webhookurl"));
            data.put("webhookurl", targetView.getModel().getValue("webhookurl"));
            data.put("webhookname", targetView.getModel().getValue("webhookname"));
            data.put(KEY_TARGETTYPE, ((DynamicObject)subView.getModel().getValue(KEY_ACTIONTYPE, index)).get(KEY_NUMBER));
            subView.getModel().setValue(KEY_ACTIONNAME, data.get((Object)KEY_URL), index);
            subView.getModel().setValue(KEY_ACTIONCONFIG_TAG, (Object)data.toJSONString(), index);
            subView.getModel().updateCache();
            return data;
        }
        return null;
    }

    public static Map<String, Object> jsonToMap(String str) {
        JSONObject map = JSON.parseObject((String)str);
        return map;
    }

    public static Map<String, String> mapStringToMap(String str) {
        str = str.substring(1, str.length() - 1);
        String[] strs = str.split(",");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(strs.length);
        for (String string : strs) {
            String key = string.split("=")[0];
            String value = string.split("=")[1];
            String key1 = key.trim();
            String value1 = value.trim();
            map.put(key1, value1);
        }
        return map;
    }

    public static void clearData(IFormView view) {
        IDataModel model = view.getModel();
        model.deleteEntryData(KEY_WEB_URL_PARAMS);
        model.deleteEntryData(KEY_WEB_REQ_BODY);
        model.deleteEntryData(KEY_WEB_REQ_HEADER);
        CodeEdit Edit = (CodeEdit)view.getControl(KEY_CODEEDITAP);
        Edit.setText(null);
    }
}

