/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.TreeView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.isc.kem.form.util.KemEventParmDataModel;

public class KemScriptTreeUtil {
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";
    private static final String[] VALS = new String[]{"0-1", "0-2", "node1"};

    public static void buildScriptTree(TreeView treeView, int type, Long id) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        TreeNode node1 = new TreeNode("0", "0-1", ResManager.loadKDString((String)"\u4e8b\u4ef6\u53c2\u6570", (String)"KemScriptTreeUtil_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        if (id != 0L) {
            KemScriptTreeUtil.getEventNodeMap(id, node1);
        }
        TreeNode node2 = new TreeNode("0", "0-2", ResManager.loadKDString((String)"\u5185\u7f6e\u53d8\u91cf", (String)"KemScriptTreeUtil_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        for (Map.Entry<String, Object> entry : KemScriptTreeUtil.getNodeMap(type).entrySet()) {
            node2.addChild(new TreeNode("0-2", entry.getKey(), String.valueOf(entry.getValue()), (Object)entry.getKey()));
        }
        nodes.add(node1);
        nodes.add(node2);
        node2.setIsOpened(true);
        TreeNode root = new TreeNode("", "node1", ResManager.loadKDString((String)"\u811a\u672c\u6a21\u677f", (String)"KemScriptTreeUtil_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        root.setChildren(nodes);
        root.setIsOpened(true);
        treeView.addNode(root);
        treeView.updateNode(root);
    }

    public static void nodeForCodeEdit(CodeEdit codeEdit, Object nodeId, int type, String cacheData) {
        if (Arrays.asList(VALS).contains(nodeId)) {
            return;
        }
        String code = codeEdit.getText();
        StringBuilder text = new StringBuilder();
        if (code != null) {
            text.append(code);
            if (!code.equals("")) {
                text.append('\n');
            }
        } else if (cacheData != null) {
            text.append(cacheData);
            if (!cacheData.equals("")) {
                text.append('\n');
            }
        }
        text.append(nodeId);
        codeEdit.setText(text.toString());
    }

    private static void getEventNodeMap(Long id, TreeNode node1) {
        DynamicObject evnt = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"kem_event");
        DynamicObjectCollection datas = evnt.getDynamicObjectCollection("data_entry");
        if (!CollectionUtils.isEmpty((Collection)datas)) {
            ArrayList<KemEventParmDataModel> flatData = new ArrayList<KemEventParmDataModel>();
            for (DynamicObject data : datas) {
                flatData.add(new KemEventParmDataModel(data.getLong("id"), data.getLong("pid"), data.getString("paraname")));
            }
            List<KemEventParmDataModel> hierarchy = KemScriptTreeUtil.buildHierarchy(flatData, node1);
            for (KemEventParmDataModel rootNode : hierarchy) {
                System.out.println(rootNode);
            }
        }
    }

    public static List<KemEventParmDataModel> buildHierarchy(List<KemEventParmDataModel> flatData, TreeNode node1) {
        HashMap<Long, KemEventParmDataModel> nodeMap = new HashMap<Long, KemEventParmDataModel>(flatData.size());
        ArrayList<KemEventParmDataModel> rootNodes = new ArrayList<KemEventParmDataModel>();
        for (KemEventParmDataModel node : flatData) {
            nodeMap.put(node.getId(), node);
        }
        for (KemEventParmDataModel node : flatData) {
            if (node.getPid() == 0L) {
                rootNodes.add(node);
                TreeNode treeNode = new TreeNode("0-1", "$data." + node.getName(), node.getName());
                node.setTreeNode(treeNode);
                node1.addChild(treeNode);
                continue;
            }
            KemEventParmDataModel parent = (KemEventParmDataModel)nodeMap.get(node.getPid());
            if (parent == null || parent.getTreeNode() == null) continue;
            TreeNode treeNode = new TreeNode(parent.getId().toString(), parent.getTreeNode().getId() + "." + node.getName(), node.getName());
            node.setTreeNode(treeNode);
            parent.getTreeNode().addChild(treeNode);
            parent.addChild(node);
        }
        return rootNodes;
    }

    private static Map<String, Object> getNodeMap(int type) {
        LinkedHashMap<String, Object> scriptMap = new LinkedHashMap<String, Object>();
        if (type > 1 && type < 4) {
            scriptMap.put("$header", ResManager.loadKDString((String)"API\u8bf7\u6c42\u5934\u53c2\u6570", (String)"KemScriptTreeUtil_3", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            scriptMap.put("$body", ResManager.loadKDString((String)"API\u8bf7\u6c42\u4f53\u53c2\u6570", (String)"KemScriptTreeUtil_4", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            scriptMap.put("$queryString", ResManager.loadKDString((String)"API\u8bf7\u6c42URL\u53c2\u6570", (String)"KemScriptTreeUtil_5", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (type == 4) {
            scriptMap.put("$param", ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u53c2\u6570", (String)"KemScriptTreeUtil_17", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (type == 5 || type == 3) {
            scriptMap.put("$result", ResManager.loadKDString((String)"API\u54cd\u5e94\u7ed3\u679c", (String)"KemScriptTreeUtil_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        }
        scriptMap.put("$event.number", ResManager.loadKDString((String)"\u4e8b\u4ef6\u7f16\u7801", (String)"KemScriptTreeUtil_7", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        scriptMap.put("$event.name", ResManager.loadKDString((String)"\u4e8b\u4ef6\u540d\u79f0", (String)"KemScriptTreeUtil_8", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        scriptMap.put("$event.dataSourceNumber", ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u6e90\u7f16\u7801", (String)"KemScriptTreeUtil_9", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        scriptMap.put("$event.dataSourceName", ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u6e90\u540d\u79f0", (String)"KemScriptTreeUtil_10", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        scriptMap.put("$event.time", ResManager.loadKDString((String)"\u89e6\u53d1\u65f6\u95f4", (String)"KemScriptTreeUtil_11", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        scriptMap.put("$event.msgId", ResManager.loadKDString((String)"\u4e8b\u4ef6\u6d88\u606fID", (String)"KemScriptTreeUtil_12", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        scriptMap.put("$event.req.userId", ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u4e2d\u7684\u7528\u6237ID", (String)"KemScriptTreeUtil_13", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        scriptMap.put("$event.req.accountId", ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u4e2d\u7684\u8d26\u5957ID", (String)"KemScriptTreeUtil_14", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        scriptMap.put("$event.req.orgId", ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u4e2d\u7684\u7ec4\u7ec7ID", (String)"KemScriptTreeUtil_15", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        scriptMap.put("$event.req.tenantId", ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u4e2d\u7684\u79df\u6237ID", (String)"KemScriptTreeUtil_16", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        return scriptMap;
    }
}

