/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.isc.kem.common.constants.ParamType;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.common.util.StringUtil;
import kd.isc.kem.form.util.JsonUtil;

public class ParamDataPreviewUtil {
    public static Object getCustomParams(String entryKey, DynamicObjectCollection entryEntity) {
        if (entryEntity == null || entryEntity.isEmpty()) {
            return Collections.emptyMap();
        }
        String paramName = "paraname";
        String paramType = "paratype";
        String example = "data_example";
        String levelName = "paralevel";
        String mulValue = "ismultivalue";
        LinkedHashMap pidMap = entryEntity.stream().collect(Collectors.groupingBy(it -> it.getLong("pid"), LinkedHashMap::new, Collectors.toList()));
        return ParamDataPreviewUtil.getCustomParams(paramName, paramType, mulValue, example, levelName, pidMap, 0L, 1);
    }

    private static Object getCustomParams(String paramName, String paramType, String mulValue, String example, String levelName, LinkedHashMap<Long, List<DynamicObject>> pidMap, Long pid, int level) {
        List<DynamicObject> current = pidMap.get(pid);
        if (CollectionUtil.isEmpty(current)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>(current.size());
        for (DynamicObject entry : current) {
            String type = entry.getString(paramType);
            if (StringUtil.isEmpty((CharSequence)type)) continue;
            ParamType dataType = ParamType.getParamType((String)type);
            String name = entry.getString(paramName);
            Object value = null;
            boolean isMul = entry.getBoolean(mulValue);
            if (ParamType.Struct == dataType) {
                value = ParamDataPreviewUtil.getCustomParams(paramName, paramType, mulValue, example, levelName, pidMap, entry.getLong("id"), ++level);
                value = isMul ? Collections.singletonList(value) : value;
            } else {
                try {
                    String strValue = entry.getString(example);
                    Object obj = JsonUtil.parseJson(strValue);
                    value = dataType.validator(paramName, obj, isMul);
                    if (null == value) {
                        value = dataType.getExample(isMul);
                    }
                }
                catch (Exception e) {
                    value = dataType.getExample(isMul);
                }
            }
            map.put(name, (List<Object>)value);
        }
        return map;
    }
}

