/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.cache.data.ServiceFlow;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.form.util.ServiceFlowParam;

public class ServiceFlowUtil {
    public static List<ServiceFlowParam> getInputs(long flowId) {
        DynamicObject dynamicObject = ServiceFlow.get((long)flowId);
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("variables");
        if (CollectionUtil.isEmpty((Collection)collection)) {
            return Collections.emptyList();
        }
        ArrayList<ServiceFlowParam> list = new ArrayList<ServiceFlowParam>(collection.size());
        for (DynamicObject meta : collection) {
            if (!meta.getBoolean("is_input_param")) continue;
            ServiceFlowUtil.setParamsEntity(list, meta, "param_field", "param_cata", "param_type", "param_remark", "param_multi");
        }
        return list;
    }

    private static void setParamsEntity(List<ServiceFlowParam> param_entity, DynamicObject meta, String filed, String cata, String type, String remark, String multi) {
        String category;
        ServiceFlowParam aNew = new ServiceFlowParam();
        aNew.setId(ID.genLongId());
        String var_name = meta.getString("var_name");
        if (filed.contains("res")) {
            var_name = "output." + var_name;
        }
        if ("isc_metadata_schema".equalsIgnoreCase(D.s((Object)(category = meta.getString("var_category"))))) {
            DynamicObject var_type = (DynamicObject)meta.get("var_type");
            DynamicObject metaSchema = MetaDataSchema.get((long)D.l((Object)var_type.getPkValue()));
            aNew.setField(var_name);
            aNew.setCategory("isc_metadata_schema");
            aNew.setType(IscFieldType.STRUCT.getTypeName());
            aNew.setRemark(meta.getString("var_desc"));
            aNew.setMul(meta.getBoolean("is_array"));
            ServiceFlowUtil.parseMetaSchema(param_entity, filed, cata, type, remark, multi, var_name, metaSchema, aNew.getId());
        } else if ("isc_type_simple_value".equalsIgnoreCase(D.s((Object)category))) {
            DynamicObject var_type = (DynamicObject)meta.get("var_type");
            aNew.setField(var_name);
            aNew.setCategory("isc_type_simple_value");
            aNew.setType(var_type.getString("number"));
            aNew.setRemark(meta.getString("var_desc"));
            aNew.setMul(meta.getBoolean("is_array"));
        }
        param_entity.add(aNew);
    }

    private static void parseMetaSchema(List<ServiceFlowParam> param_entity, String filed, String cata, String type, String remark, String multi, Object var_name, DynamicObject metaSchema, long pid) {
        DynamicObjectCollection list = metaSchema.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject metaEntry : list) {
            ServiceFlowParam entity = new ServiceFlowParam();
            entity.setId(ID.genLongId());
            entity.setPid(pid);
            String metaName = metaEntry.getString("prop_name");
            String prop_label = metaEntry.getString("prop_label");
            String data_type = metaEntry.getString("data_type");
            entity.setField(metaName);
            entity.setCategory("isc_type_simple_value");
            entity.setType(data_type);
            entity.setRemark(prop_label);
            entity.setMul(false);
            if (ApiToXmlUtil.isEntries((String)metaEntry.getString("data_type"))) {
                entity.setCategory("isc_metadata_schema");
                entity.setMul(true);
                entity.setType(IscFieldType.STRUCT.getTypeName());
                DynamicObject metaEntries = JsonSampleUtil.findMetaByDataSchema((DynamicObject)metaSchema, (String)metaEntry.getString("data_schema"));
                ServiceFlowUtil.parseMetaSchema(param_entity, filed, cata, type, remark, multi, metaName, metaEntries, entity.getId());
            }
            param_entity.add(entity);
        }
    }
}

