/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.constants;

import java.util.Arrays;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemException;

public enum EventType {
    Internal(0, "Internal"),
    SDK(1, "Custom"),
    WebHook(2, "Webhook"),
    Pool(3, "Pooling"),
    MQ(4, "MQ"),
    ENTITY(5, "Entity");

    private final int code;
    private final String title;

    private EventType(int value, String title) {
        this.code = value;
        this.title = title;
    }

    public int getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public static EventType getEventType(int code) {
        return Arrays.stream(EventType.values()).filter(it -> it.getCode() == code).findFirst().orElseThrow(() -> new KemException(KemCommonError.CommonError, "EventType code \u201c" + code + "\u201d is not supported"));
    }
}

