/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.constants;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.isc.kem.common.constants.MultiLangEnumBridge;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.JacksonUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;

public enum ParamType {
    String(new MultiLangEnumBridge("\u5b57\u7b26\u4e32", "ParamType_0", "isc-kem-common").loadKDString(), "string"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return String.class;
        }
    }
    ,
    Integer(new MultiLangEnumBridge("\u6574\u6570", "ParamType_1", "isc-kem-common").loadKDString(), "int"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return Integer.class;
        }
    }
    ,
    Long(new MultiLangEnumBridge("\u957f\u6574\u6570", "ParamType_2", "isc-kem-common").loadKDString(), "long"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return Long.class;
        }
    }
    ,
    Double(new MultiLangEnumBridge("\u6d6e\u70b9\u6570", "ParamType_3", "isc-kem-common").loadKDString(), "double"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return Double.class;
        }
    }
    ,
    Decimal(new MultiLangEnumBridge("\u5c0f\u6570", "ParamType_4", "isc-kem-common").loadKDString(), "decimal"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return BigDecimal.class;
        }
    }
    ,
    Boolean(new MultiLangEnumBridge("\u5e03\u5c14\u503c", "ParamType_5", "isc-kem-common").loadKDString(), "boolean"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return Boolean.class;
        }
    }
    ,
    Date(new MultiLangEnumBridge("\u65e5\u671f", "ParamType_6", "isc-kem-common").loadKDString(), "date"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return LocalDate.class;
        }
    }
    ,
    Time(new MultiLangEnumBridge("\u65f6\u95f4", "ParamType_7", "isc-kem-common").loadKDString(), "time"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return LocalTime.class;
        }
    }
    ,
    DateTime(new MultiLangEnumBridge("\u65e5\u671f\u65f6\u95f4", "ParamType_8", "isc-kem-common").loadKDString(), "datetime"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return LocalDateTime.class;
        }
    }
    ,
    Struct(new MultiLangEnumBridge("\u7ed3\u6784", "ParamType_9", "isc-kem-common").loadKDString(), "STRUCT"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return Map.class;
        }
    }
    ,
    Any(new MultiLangEnumBridge("\u4efb\u610f\u503c", "ParamType_10", "isc-kem-common").loadKDString(), "unknown"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return Object.class;
        }
    }
    ,
    Enum(new MultiLangEnumBridge("\u679a\u4e3e", "ParamType_11", "isc-kem-common").loadKDString(), "ENUM"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return Object.class;
        }
    }
    ,
    Multilingual(new MultiLangEnumBridge("\u591a\u8bed\u8a00", "ParamType_12", "isc-kem-common").loadKDString(), "mulilang"){

        @Override
        public List<String> typeAlias() {
            return Arrays.asList(this.getType(), this.name());
        }

        @Override
        public Class<?> getClazz() {
            return Map.class;
        }
    };

    private final String typeName;
    private final String type;

    private ParamType(String typeName, String type) {
        this.typeName = typeName;
        this.type = type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getType() {
        return this.type;
    }

    public abstract List<String> typeAlias();

    public abstract Class<?> getClazz();

    public String getJsonExample(boolean isMul) {
        return JacksonUtil.writeValueAsString(this.getExample(isMul));
    }

    public Object getExample(boolean isMul) {
        List<Object> example = ParamType.getRandom(this);
        if (example == null) {
            return null;
        }
        return isMul ? Collections.singletonList(example) : example;
    }

    public Object validator(String param, String jsonValue, boolean isMul) {
        return this.validator(param, JacksonUtil.readValue(jsonValue, Object.class), isMul);
    }

    public Object validator(String param, Object value, boolean isMul) {
        List list;
        if (value == null) {
            return null;
        }
        if (!isMul) {
            return this.format(param, value);
        }
        try {
            list = (List)JacksonUtil.convertValue(value, new TypeReference<List<?>>(){});
        }
        catch (Exception e) {
            throw new KemException((Throwable)e, ParamType.class.getSimpleName(), "{0}\uff1a{1}, mul value format error: {3}", param, this.name(), value);
        }
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object object : list) {
            result.add(this.format(param, object));
        }
        return result;
    }

    private Object format(String param, Object value) {
        if (value == null) {
            return null;
        }
        try {
            switch (this) {
                case String: 
                case Integer: 
                case Long: 
                case Boolean: 
                case Double: 
                case Decimal: {
                    return ObjectConverter.convert((Object)value, this.getClazz(), (boolean)true);
                }
                case Date: 
                case Time: 
                case DateTime: {
                    Date date = (Date)ObjectConverter.convert((Object)value, Date.class, (boolean)false);
                    if (date == null) {
                        throw new KemException(ParamType.class.getSimpleName(), "Unsupported {0}\uff1a{1}", param, value);
                    }
                    return date;
                }
                case Multilingual: {
                    return JacksonUtil.convertValue(value, new TypeReference<Map<String, String>>(){});
                }
                case Any: 
                case Enum: {
                    return value;
                }
                case Struct: {
                    return JacksonUtil.convertValue(value, new TypeReference<Map<String, Object>>(){});
                }
            }
            throw new KemException(ParamType.class.getSimpleName(), "Unsupported {0}\uff1atype {1}, value {2}", param, this.getTypeName(), value);
        }
        catch (Exception e) {
            throw new KemException((Throwable)e, ParamType.class.getSimpleName(), "{0}\uff1a{1} value format error: {2}", param, this.getTypeName(), value);
        }
    }

    public static ParamType getParamType(String type) {
        return Arrays.stream(ParamType.values()).filter(it -> it.typeAlias().contains(type)).findFirst().orElseThrow(() -> new KemException(ParamType.class.getSimpleName(), "\u201c" + type + "\u201d not supported"));
    }

    private static Object getRandom(ParamType type) {
        switch (type) {
            case String: {
                return RandomStringUtils.randomAlphanumeric((int)5);
            }
            case Integer: {
                return RandomUtils.nextInt((int)0, (int)100);
            }
            case Long: {
                return RandomUtils.nextLong((long)100L, (long)200L);
            }
            case Boolean: {
                return RandomUtils.nextBoolean();
            }
            case Double: {
                return BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)1000.0)).setScale(2, RoundingMode.DOWN).doubleValue();
            }
            case Decimal: {
                return BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)1000.0)).setScale(2, RoundingMode.DOWN).toString();
            }
            case Date: {
                return LocalDate.now(ZoneId.systemDefault());
            }
            case Time: {
                return LocalTime.now(ZoneId.systemDefault());
            }
            case DateTime: {
                return LocalDateTime.now(ZoneId.systemDefault());
            }
            case Multilingual: 
            case Struct: {
                return Collections.emptyMap();
            }
            case Any: 
            case Enum: {
                return null;
            }
        }
        throw new KemException(ParamType.class.getSimpleName(), "Unsupported ParamTyp\uff1a{0}", new Object[]{type});
    }
}

