/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.constants;

import java.util.Arrays;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.JacksonUtil;

public enum TargetParamFormat {
    CONSTANT("1"){

        @Override
        public String getFormat(String content) {
            if (content == null) {
                return null;
            }
            if (JacksonUtil.isJson(content = content.trim())) {
                return content;
            }
            return JacksonUtil.writeValueAsString(content);
        }
    }
    ,
    PARAMETER_PASS_THROUGH("2"){

        @Override
        public String getFormat(String content) {
            String str;
            if (content == null) {
                return null;
            }
            if (!(content = content.trim()).startsWith("#{")) {
                content = "#{" + content;
            }
            if (!content.endsWith("}")) {
                content = content + "}";
            }
            if (!(str = content.substring(2).trim()).startsWith(TargetParamFormat.VAR_$_DATA_POINT)) {
                content = "#{$data." + str;
            }
            return content;
        }
    }
    ,
    EXPR_FUNCTION("3"){

        @Override
        public String getFormat(String content) {
            if (content == null) {
                return null;
            }
            if (!(content = content.trim()).startsWith("<%")) {
                content = "<%" + content;
            }
            if (!content.endsWith("%>")) {
                content = content + "%>";
            }
            return content;
        }
    };

    private final String code;
    public static final String VAR_$_DATA = "$data";
    public static final String VAR_$_DATA_POINT = "$data.";

    private TargetParamFormat(String code) {
        this.code = code;
    }

    public abstract String getFormat(String var1);

    public static String format(String content, String code) {
        if (content == null) {
            return null;
        }
        return TargetParamFormat.getFilterParamFormat(code).getFormat(content);
    }

    private static TargetParamFormat getFilterParamFormat(String code) {
        return Arrays.stream(TargetParamFormat.values()).filter(it -> it.code.equals(code)).findFirst().orElseThrow(() -> new KemException(KemCommonError.CommonError, "\u201c" + code + "\u201d is not supported"));
    }
}

