/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.encrypt;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.crypto.impl.AbstractEncryptor;
import kd.bos.encrypt.EncryptException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.codec.binary.Base64;

@SdkInternal
public abstract class BaseKemEncryptor
extends AbstractEncryptor {
    private static final Log LOG = LogFactory.getLog(BaseKemEncryptor.class);
    private final Object LOCKER = new Object();
    private final String algorithm;
    private final String transformation;
    private final int ivLength;
    private final Cipher cipher;
    private final boolean isNeedIv;

    public BaseKemEncryptor(String algorithm, String transformation, int ivLength) {
        this.algorithm = algorithm;
        this.transformation = transformation;
        this.ivLength = ivLength;
        this.isNeedIv = ivLength > 0;
        this.cipher = this.createCipher();
    }

    private Cipher createCipher() {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(this.transformation, "BC");
        }
        catch (Exception e) {
            throw new EncryptException("create cipher error: " + e.getMessage(), (Throwable)e);
        }
        return cipher;
    }

    public synchronized Cipher getCipher() {
        return this.createCipher();
    }

    protected String result(byte[] iv, byte[] data) {
        return Base64.encodeBase64String((byte[])data);
    }

    @Deprecated
    public String encrypt(String originalStr, String keyStr, int length) throws EncryptException {
        throw new UnsupportedOperationException();
    }

    public byte[] encrypt(byte[] originalData, byte[] key, byte[] iv) throws EncryptException {
        if (originalData == null) {
            return null;
        }
        try {
            String s = new String(originalData, StandardCharsets.UTF_8);
            return this.encrypt0(s, key, iv);
        }
        catch (Throwable e) {
            LOG.error("encrypt error", e);
            throw new EncryptException("encrypt error " + e.getMessage(), e);
        }
    }

    public String encryptBase64(String originalStr, String keyBase64, String ivBase64) throws EncryptException {
        if (originalStr == null) {
            return null;
        }
        byte[] key = Base64.decodeBase64((String)keyBase64);
        byte[] iv = Base64.decodeBase64((String)ivBase64);
        byte[] data = this.encrypt(originalStr.getBytes(StandardCharsets.UTF_8), key, iv);
        return Base64.encodeBase64String((byte[])data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] encrypt0(String originalStr, byte[] keyBytes, byte[] ivBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException {
        Object object = this.LOCKER;
        synchronized (object) {
            if (this.isNeedIv) {
                this.cipher.init(1, (Key)new SecretKeySpec(keyBytes, this.algorithm), this.getIvSpec(ivBytes));
            } else {
                this.cipher.init(1, new SecretKeySpec(keyBytes, this.algorithm));
            }
            return this.cipher.doFinal(originalStr.getBytes(StandardCharsets.UTF_8));
        }
    }

    protected byte[] encrypt0(Cipher cipher, String originalStr, byte[] keyBytes, byte[] ivBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String decrypt(String encryptStr, String keyStr, int length) throws EncryptException {
        throw new UnsupportedOperationException();
    }

    public byte[] decrypt(byte[] encryptData, byte[] key, byte[] iv) throws EncryptException {
        try {
            return this.decrypt0(encryptData, key, iv).getBytes(StandardCharsets.UTF_8);
        }
        catch (Throwable e) {
            LOG.error("decrypt error", e);
            throw new EncryptException("decrypt error: " + e.getMessage(), e);
        }
    }

    public byte[] deCrpBase64(String encryptBase64, String keyBase64, String ivBase64) throws EncryptException {
        if (encryptBase64 == null) {
            return null;
        }
        byte[] key = Base64.decodeBase64((String)keyBase64);
        byte[] iv = Base64.decodeBase64((String)ivBase64);
        byte[] data = Base64.decodeBase64((String)encryptBase64);
        return this.decrypt(data, key, iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String decrypt0(byte[] data, byte[] keyBytes, byte[] ivBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException {
        Object object = this.LOCKER;
        synchronized (object) {
            if (this.isNeedIv) {
                this.cipher.init(2, (Key)new SecretKeySpec(keyBytes, this.algorithm), this.getIvSpec(ivBytes));
            } else {
                this.cipher.init(2, new SecretKeySpec(keyBytes, this.algorithm));
            }
            return new String(this.cipher.doFinal(data), StandardCharsets.UTF_8);
        }
    }

    protected String decrypt0(Cipher cipher, byte[] data, byte[] keyBytes, byte[] ivBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException {
        throw new UnsupportedOperationException();
    }

    protected byte[] getKeyFromString(String str, int length) throws EncryptException {
        throw new UnsupportedOperationException();
    }

    protected byte[] getIvFromString(String str, int length) throws EncryptException {
        throw new UnsupportedOperationException();
    }

    protected byte[] getRandomIv() throws EncryptException {
        throw new UnsupportedOperationException();
    }

    private IvParameterSpec getIvSpec(byte[] iv) {
        return new IvParameterSpec(iv);
    }

    public String transformation() {
        return this.transformation;
    }

    public List<Integer> supportLength() {
        return Collections.singletonList(128);
    }
}

