/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.encrypt;

import java.util.Arrays;
import kd.isc.kem.common.encrypt.EncryptModel;
import kd.isc.kem.common.encrypt.KemEncryptor;
import kd.isc.kem.common.encrypt.KemSignEncryptHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.codec.binary.Base64;

@SdkInternal
public enum KemEncryptType {
    AES_CBC_PKCS5Padding("1", "AES", "AES/CBC/PKCS5Padding"){

        @Override
        public int[] lens() {
            return new int[]{128, 192, 256};
        }
    }
    ,
    SM4_CBC_PKCS5Padding("2", "SM4", "SM4/CBC/PKCS5Padding"){

        @Override
        public int[] lens() {
            return new int[]{128};
        }
    }
    ,
    UNSUPPORTED("-1", null, null){

        @Override
        public String getKey(int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRandomIv() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncryptModel<byte[], byte[]> encrypt(byte[] originalData, byte[] key, byte[] iv) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncryptModel<String, String> encryptBase64(String originalStr, String keyBase64) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EncryptModel<String, String> encryptBase64(String originalStr, String keyBase64, String ivBase64) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] decrypt(byte[] encrypt, byte[] key, byte[] iv) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] decryptBase64(String encryptBase64, String keyBase64, String ivBase64) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int[] lens() {
            throw new UnsupportedOperationException();
        }

        @Override
        public KemEncryptor getEncryptor() {
            throw new UnsupportedOperationException();
        }
    };

    private final String code;
    private final String algorithm;
    private final String transformation;

    public String getKey(int length) {
        boolean isSupport = false;
        for (int len : this.lens()) {
            if (len != length) continue;
            isSupport = true;
            break;
        }
        if (!isSupport) {
            throw new IllegalArgumentException(this.name() + "\uff1a not support the key length " + length);
        }
        return KemSignEncryptHelper.getBase64EncodeKey(this.algorithm(), length);
    }

    public String getRandomIv() {
        return KemSignEncryptHelper.getBase64EncodeRandomIv(this.ivLen());
    }

    public void validBase64Key(String key, int length) {
        byte[] decodedBytes;
        try {
            decodedBytes = java.util.Base64.getDecoder().decode(key);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.name() + "\uff1a the key must be Base64 encoded", e);
        }
        if (decodedBytes.length == length / 8) {
            return;
        }
        throw new IllegalArgumentException(this.name() + "\uff1a the key length must be " + length + " bits");
    }

    public EncryptModel<byte[], byte[]> encrypt(byte[] originalData, byte[] key, byte[] iv) {
        byte[] encrypt = KemSignEncryptHelper.getEncryptor(this, this.transformation, KemEncryptType.getIvLength(iv)).encrypt(originalData, key, iv);
        return EncryptModel.of(iv, encrypt);
    }

    public EncryptModel<String, String> encryptBase64(String originalStr, String keyBase64) {
        String ivBase64 = this.getRandomIv();
        return this.encryptBase64(originalStr, keyBase64, ivBase64);
    }

    public EncryptModel<String, String> encryptBase64(String originalStr, String keyBase64, String ivBase64) {
        String encrypt = KemSignEncryptHelper.getEncryptor(this, this.transformation, KemEncryptType.getIvLengthBase64(ivBase64)).encryptBase64(originalStr, keyBase64, ivBase64);
        return EncryptModel.of(ivBase64, encrypt);
    }

    public byte[] decrypt(byte[] encrypt, byte[] key, byte[] iv) {
        return KemSignEncryptHelper.getEncryptor(this, this.transformation, KemEncryptType.getIvLength(iv)).decrypt(encrypt, key, iv);
    }

    public byte[] decryptBase64(String encryptBase64, String keyBase64, String ivBase64) {
        return KemSignEncryptHelper.getEncryptor(this, this.transformation, KemEncryptType.getIvLengthBase64(ivBase64)).deCrpBase64(encryptBase64, keyBase64, ivBase64);
    }

    public abstract int[] lens();

    public int ivLen() {
        return 16;
    }

    public KemEncryptor getEncryptor() {
        return new KemEncryptor(this);
    }

    private KemEncryptType(String code, String algorithm, String transformation) {
        this.code = code;
        this.algorithm = algorithm;
        this.transformation = transformation;
    }

    public String getCode() {
        return this.code;
    }

    public String transformation() {
        return this.transformation;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public static KemEncryptType getEncryptType(String codeOrTransformation) {
        return Arrays.stream(KemEncryptType.values()).filter(it -> it.getCode().equals(codeOrTransformation) || it.transformation.equals(codeOrTransformation)).findFirst().orElse(UNSUPPORTED);
    }

    private static int getIvLengthBase64(String ivBase64) {
        byte[] iv = Base64.decodeBase64((String)ivBase64);
        return KemEncryptType.getIvLength(iv);
    }

    private static int getIvLength(byte[] iv) {
        return iv == null ? -1 : iv.length;
    }
}

