/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.encrypt;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.isc.kem.common.encrypt.BaseKemEncryptor;
import kd.isc.kem.common.encrypt.KemEncryptType;
import kd.isc.kem.common.encrypt.KemEncryptor;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@SdkInternal
public class KemSignEncryptHelper {
    private static final Log LOG = LogFactory.getLog(KemSignEncryptHelper.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final Map<KemEncryptType, KemEncryptor> ENCRYPTOR_MAP = Maps.newHashMap();
    private static final Map<String, KemEncryptor> CUSTOM_ENCRYPTOR_MAP = Maps.newHashMap();
    public static final String HmacSHA256 = "HmacSHA256";

    public static synchronized BaseKemEncryptor getEncryptor(KemEncryptType encryptType, String transformation, int ivLength) {
        KemEncryptor encryptor = ENCRYPTOR_MAP.get((Object)encryptType);
        if (encryptor == null) {
            encryptor = CUSTOM_ENCRYPTOR_MAP.computeIfAbsent(transformation, it -> {
                String algorithm = transformation.substring(0, transformation.indexOf(47));
                return new KemEncryptor(algorithm, transformation, ivLength);
            });
        }
        return encryptor;
    }

    public static String getHmacSha256Sign(String signKey, String timestamp, String nonce, String bodyString) {
        String content = KemSignEncryptHelper.getSignContent(signKey, timestamp, nonce, bodyString);
        return KemSignEncryptHelper.getHmacSha256Sign(signKey, content);
    }

    public static String getSha256Sign(String signKey, String timestamp, String nonce, String bodyString) {
        String content = KemSignEncryptHelper.getSignContent(signKey, timestamp, nonce, bodyString);
        return KemSignEncryptHelper.getSha256Sign(content);
    }

    public static String getHmacSha256Sign(String signKey, String content) {
        String HmacSha256Sign = Hashing.hmacSha256((byte[])signKey.getBytes(StandardCharsets.UTF_8)).hashString((CharSequence)content, StandardCharsets.UTF_8).toString();
        return HmacSha256Sign;
    }

    public static String getSha256Sign(String content) {
        String sha256Sign = Hashing.sha256().hashString((CharSequence)content, StandardCharsets.UTF_8).toString();
        return sha256Sign;
    }

    public static String getSignContent(String signKey, String timestamp, String nonce, String bodyString) {
        return signKey + timestamp + nonce + bodyString;
    }

    public static String getBase64EncodeHmacSHA256Key() {
        byte[] hmacSHA256Key = KemSignEncryptHelper.getHmacSHA256Key();
        return Base64.encodeBase64String((byte[])hmacSHA256Key);
    }

    public static String getBase64EncodeSHA256Key() {
        byte[] sha256Key = KemSignEncryptHelper.getSHA256Key();
        return Base64.encodeBase64String((byte[])sha256Key);
    }

    public static String getBase64EncodeSM4Key128() {
        byte[] sm4Key128 = KemSignEncryptHelper.getSM4Key128();
        return Base64.encodeBase64String((byte[])sm4Key128);
    }

    public static String getBase64EncodeAESKey256() {
        byte[] aesKey256 = KemSignEncryptHelper.getAESKey256();
        return Base64.encodeBase64String((byte[])aesKey256);
    }

    public static String getBase64EncodeAESKey128() {
        byte[] aesKey128 = KemSignEncryptHelper.getAESKey128();
        return Base64.encodeBase64String((byte[])aesKey128);
    }

    public static byte[] getBase64DecodeKey(String base64EncodeKey) {
        if (StringUtils.isNotEmpty((String)base64EncodeKey)) {
            return Base64.decodeBase64((String)base64EncodeKey);
        }
        return null;
    }

    private static byte[] getHmacSHA256Key() {
        return KemSignEncryptHelper.getKey(HmacSHA256, 256);
    }

    private static byte[] getSHA256Key() {
        return KemSignEncryptHelper.getKey(HmacSHA256, 256);
    }

    private static byte[] getSM4Key128() {
        return KemSignEncryptHelper.getSM4Key(128);
    }

    private static byte[] getSM4Key(int length) {
        return KemSignEncryptHelper.getKey("SM4", length);
    }

    private static byte[] getAESKey256() {
        return KemSignEncryptHelper.getAESKey(256);
    }

    private static byte[] getAESKey128() {
        return KemSignEncryptHelper.getAESKey(128);
    }

    private static byte[] getAESKey(int length) {
        return KemSignEncryptHelper.getKey("AES", length);
    }

    public static String getBase64EncodeKey(String algorithm, int length) {
        byte[] key = KemSignEncryptHelper.getKey(algorithm, length);
        return Base64.encodeBase64String((byte[])key);
    }

    private static byte[] getKey(String algorithm, int length) {
        return KemSignEncryptHelper.initKey(algorithm, length);
    }

    private static synchronized byte[] initKey(String algorithm, int length) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyGenerator kg = KeyGenerator.getInstance(algorithm, "BC");
            kg.init(length, SECURE_RANDOM);
            SecretKey secretKey = kg.generateKey();
            return secretKey.getEncoded();
        }
        catch (Exception e) {
            throw new EncryptException("create " + algorithm + "\uff08" + length + "\uff09 key error: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String getBase64EncodeRandomIv(int ivLength) {
        byte[] randomIv = KemSignEncryptHelper.getRandomIv(ivLength);
        return Base64.encodeBase64String((byte[])randomIv);
    }

    private static synchronized byte[] getRandomIv(int ivLength) throws EncryptException {
        try {
            byte[] bytesIV = new byte[ivLength];
            SECURE_RANDOM.nextBytes(bytesIV);
            return bytesIV;
        }
        catch (Exception e) {
            throw new EncryptException("An error has occurred when getting random IvKey", (Throwable)e);
        }
    }

    public static String md5(String str) {
        return Hashing.hmacMd5((byte[])str.getBytes(StandardCharsets.UTF_8)).hashString((CharSequence)str, StandardCharsets.UTF_8).toString();
    }

    public static String encode(String originalStr) {
        return Encrypters.encode((String)originalStr);
    }

    public static String decode(String encodeStr) {
        return Encrypters.decode((String)encodeStr);
    }

    public static boolean isEncrypted(String str) {
        return Encrypters.isEncrypted((String)str);
    }

    static {
        LOG.info("--------begin init kem encryptor--------");
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            for (KemEncryptType type : KemEncryptType.values()) {
                if (KemEncryptType.UNSUPPORTED == type) continue;
                ENCRYPTOR_MAP.put(type, type.getEncryptor());
            }
        }
        catch (Exception e) {
            throw new EncryptException((Throwable)e);
        }
        LOG.info("========kem encryptor all loaded=========:" + ENCRYPTOR_MAP.keySet());
    }
}

