/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.encrypt;

import java.util.Arrays;
import kd.isc.kem.common.encrypt.KemSignEncryptHelper;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemException;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public enum KemSignType {
    UNSIGN("0"){

        @Override
        public String getKey() {
            return null;
        }

        @Override
        public String sign(String signKey, String timestamp, String nonce, String bodyString) {
            return bodyString;
        }
    }
    ,
    HMAC_SHA_256("1"){

        @Override
        public String getKey() {
            return KemSignEncryptHelper.getBase64EncodeHmacSHA256Key();
        }

        @Override
        public String sign(String signKey, String timestamp, String nonce, String bodyString) {
            return KemSignEncryptHelper.getHmacSha256Sign(signKey, timestamp, nonce, bodyString);
        }
    }
    ,
    SHA_256("2"){

        @Override
        public String getKey() {
            return KemSignEncryptHelper.getBase64EncodeSHA256Key();
        }

        @Override
        public String sign(String signKey, String timestamp, String nonce, String bodyString) {
            return KemSignEncryptHelper.getSha256Sign(signKey, timestamp, nonce, bodyString);
        }
    };

    private final String code;

    public abstract String getKey();

    public abstract String sign(String var1, String var2, String var3, String var4);

    private KemSignType(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static KemSignType getSignType(String code) {
        return Arrays.stream(KemSignType.values()).filter(it -> it.getCode().equals(code)).findFirst().orElseThrow(() -> new KemException(KemCommonError.CommonError, "SignType code \u201c" + code + "\u201d is not supported"));
    }
}

