/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.exception;

import java.text.MessageFormat;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.util.KemAssert;

public class KemException
extends KDException {
    public static void throwEx(KemErrorTemplate errorCode) {
        throw new KemException(errorCode);
    }

    public static void throwEx(KemErrorTemplate errorCode, Object ... args) {
        throw new KemException(errorCode, args);
    }

    public static void throwEx(Throwable cause, KemErrorTemplate errorCode, Object ... args) {
        throw new KemException(cause, errorCode, args);
    }

    public KemException(KemErrorTemplate errorCode) {
        super(new ErrorCode(errorCode.getCode(), errorCode.getMessageTemplate()), new Object[0]);
    }

    public KemException(KemErrorTemplate errorCode, Object ... args) {
        super(new ErrorCode(errorCode.getCode(), errorCode.getMessageTemplate()), args);
    }

    public KemException(Throwable cause, KemErrorTemplate errorCode, Object ... args) {
        super(cause, new ErrorCode(errorCode.getCode(), errorCode.getMessageTemplate()), args);
    }

    public KemException(String errorCode, String message) {
        this(errorCode, message, new Object[]{null});
    }

    public KemException(String errorCode, String messageTemplate, Object ... args) {
        this(null, errorCode, messageTemplate, args);
    }

    public KemException(Throwable cause, String errorCode, String messageTemplate, Object ... args) {
        super(cause, new ErrorCode(errorCode, messageTemplate), args);
    }

    public String getMessage() {
        KemAssert.notNull((Object)this.errorCode, (String)"errorCode must not be null");
        String message = super.getMessage();
        if (!message.contains("{0}") || this.args == null || this.args.length == 0) {
            return message;
        }
        return MessageFormat.format(message, this.args);
    }
}

