/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.spi;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.spi.IKemSpi;
import kd.isc.kem.common.spi.PbcFlowSpi;
import kd.sdk.spi.SPIConfigurationException;
import kd.sdk.spi.ServiceLoader;

public class KemSpiHelper {
    private static final Log LOG = LogFactory.getLog(KemSpiHelper.class);
    public static final String PBC = "pbc";
    private static final PbcFlowSpi PBC_FLOW_SPI = KemSpiHelper.loadSpi(PbcFlowSpi.class, "pbc");

    public static PbcFlowSpi getPbcFlowSpi() {
        if (PBC_FLOW_SPI == null) {
            throw new KemException(KemSpiHelper.class.getSimpleName(), "An error occurred while getting the PbcFlowSpi.");
        }
        return PBC_FLOW_SPI;
    }

    private static <T extends IKemSpi> T loadSpi(Class<T> clazz, String name) {
        try {
            List list = ServiceLoader.load(clazz);
            for (IKemSpi spi : list) {
                if (spi == null || !name.equals(spi.name())) continue;
                return (T)spi;
            }
            throw new SPIConfigurationException("Not found spi implement: " + clazz.getName() + ", name > " + name);
        }
        catch (Throwable e) {
            LOG.error("An error occurred while creating the KemSpiHelper:", e);
            throw e;
        }
    }
}

