/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.entity.param.AppParam;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.kem.common.util.DataUtil;
import kd.isc.kem.common.util.KemAssert;
import kd.isc.kem.common.util.StringUtil;

public class ConfigHelper {
    private static final String SYS_PARAMS_APPID = "33I4HD2=41UK";
    private static final String SYS_PARAMS_VIEW_TYPE = "15";
    private static final Long SYS_PARAMS_ACT_BOOK_ID = 0L;

    public static String getSysProperty(String key, String defaultValue) {
        String pValue = System.getProperty(key);
        if (StringUtil.isEmpty((CharSequence)pValue)) {
            return defaultValue;
        }
        return pValue;
    }

    public static String getSysPropertyByTenant(String key, String tenantId) {
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty((String)pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }

    public static String getSysPropertyByCurrent(String key) {
        KemAssert.notNull((Object)RequestContext.get(), (String)"RequestContext cannot be null.");
        String tenantId = RequestContext.get().getTenantId();
        return ConfigHelper.getSysPropertyByTenant(key, tenantId);
    }

    public static String getSysPropertyByCurrent(String key, String defaultValue) {
        String value = ConfigHelper.getSysPropertyByCurrent(key);
        if (StringUtil.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public static String getSystemParam(String key, String defaultValue) {
        String value = ConfigHelper.getSystemParam(key);
        if (StringUtil.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    private static String getSystemParam(String key) {
        Object result;
        if (RequestContext.get() == null) {
            return null;
        }
        AppParam appParam = new AppParam(SYS_PARAMS_APPID, SYS_PARAMS_VIEW_TYPE, Long.valueOf(ParameterOrgUtils.getParamRootOrgId()), SYS_PARAMS_ACT_BOOK_ID);
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (paramMap != null && (result = paramMap.getOrDefault(key, null)) != null) {
            return result.toString();
        }
        return null;
    }

    public static String getAppCustomParam(String key, String defaultValue) {
        if (RequestContext.get() == null) {
            return null;
        }
        AppCustomParam param = new AppCustomParam(SYS_PARAMS_APPID);
        Map map = SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)param);
        if (map == null) {
            return null;
        }
        return map.getOrDefault(key, defaultValue);
    }

    public static int getKemMaxBodySize() {
        String maxSizeStr = ConfigHelper.getSystemParam("kem_event_maxbodysize", String.valueOf(10240));
        return DataUtil.i((Object)maxSizeStr);
    }
}

