/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util;

import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemException;

public class DataUtil {
    private static final Date ZERO = DataUtil.t("1899-12-30");

    public static int i(Object value, int defaultValue) {
        try {
            return DataUtil.i(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static long i(Object value, long defaultValue) {
        try {
            return DataUtil.i(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static long l(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        return DataUtil.l(value.toString().trim());
    }

    private static long l(String s) {
        if (s.length() == 0) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static int i(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return DataUtil.i(value.toString().trim());
    }

    private static int i(String s) {
        if (s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public static byte b(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof Boolean) {
            return (byte)((Boolean)value != false ? 1 : 0);
        }
        return DataUtil.b(value.toString().trim());
    }

    private static byte b(String s) {
        if (s.length() == 0) {
            return 0;
        }
        return Byte.parseByte(s);
    }

    public static String s(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static String s2(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        return o.toString();
    }

    public static boolean x(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        String s = o.toString().trim();
        if (s.length() == 0) {
            return false;
        }
        if ("false".equalsIgnoreCase(s) || "0".equalsIgnoreCase(s) || "no".equalsIgnoreCase(s) || "off".equalsIgnoreCase(s) || "n".equalsIgnoreCase(s) || "f".equalsIgnoreCase(s) || "failed".equalsIgnoreCase(s) || ResManager.loadKDString((String)"\u4e0d\u540c\u610f", (String)"DataUtil_0", (String)"bos-open-common", (Object[])new Object[0]).equals(s) || ResManager.loadKDString((String)"\u62d2\u7edd", (String)"DataUtil_1", (String)"bos-open-common", (Object[])new Object[0]).equals(s) || ResManager.loadKDString((String)"\u9a73\u56de", (String)"DataUtil_2", (String)"bos-open-common", (Object[])new Object[0]).equals(s) || ResManager.loadKDString((String)"\u5426", (String)"DataUtil_3", (String)"bos-open-common", (Object[])new Object[0]).equals(s) || "undefined".equals(s) || "disable".equals(s)) {
            return false;
        }
        return "true".equalsIgnoreCase(s) || "1".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s) || "y".equalsIgnoreCase(s) || "t".equalsIgnoreCase(s) || "ok".equalsIgnoreCase(s) || "success".equalsIgnoreCase(s) || ResManager.loadKDString((String)"\u540c\u610f", (String)"DataUtil_4", (String)"bos-open-common", (Object[])new Object[0]).equals(s) || ResManager.loadKDString((String)"\u901a\u8fc7", (String)"DataUtil_5", (String)"bos-open-common", (Object[])new Object[0]).equals(s) || ResManager.loadKDString((String)"\u662f", (String)"DataUtil_6", (String)"bos-open-common", (Object[])new Object[0]).equals(s) || "enable".equals(s);
    }

    public static Timestamp toTimestamp(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(zoneId);
        Date date = Date.from(zonedDateTime.toInstant());
        return new Timestamp(date.getTime());
    }

    public static Timestamp toTimestamp(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Timestamp.valueOf(localDateTime);
    }

    public static LocalDate localDate(String value) {
        if (value == null) {
            return null;
        }
        LocalDateTime localDateTime = DataUtil.localDateTime(value);
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.toLocalDate();
    }

    public static LocalDateTime localDateTime(String value) {
        if (value == null) {
            return null;
        }
        Timestamp timestamp = DataUtil.t(value);
        if (timestamp == null) {
            return null;
        }
        Instant instant = timestamp.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static Timestamp t(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof Double) {
            double t = (Double)value * 8.64E7;
            return new Timestamp((long)t + ZERO.getTime());
        }
        String s0 = value.toString();
        if (s0 == null) {
            return null;
        }
        String s = s0.trim();
        if (s.length() == 0) {
            return null;
        }
        if (DataUtil.isLong(s)) {
            return new Timestamp(Long.parseLong(s));
        }
        String format = DataUtil.getDateFormat(s);
        s = DataUtil.adjustDateString(s, format);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(s, formatter);
            return Timestamp.valueOf(localDateTime);
        }
        catch (Exception e) {
            LocalDate localDate = LocalDate.parse(s, formatter);
            return DataUtil.toTimestamp(localDate);
        }
    }

    private static String adjustDateString(String s, String format) {
        int i;
        if (format.endsWith(".SSS") && (i = s.length() - s.lastIndexOf(46) - 1) < 3) {
            s = s + "000".substring(i);
        }
        return s;
    }

    public static String getDateFormat(String s) {
        String format = null;
        if (s.indexOf(84) > 0) {
            format = s.indexOf(46) > 0 ? "yyyy-MM-dd'T'HH:mm:ss.SSS" : "yyyy-MM-dd'T'HH:mm:ss";
        } else if (s.indexOf(32) > 0) {
            if (s.indexOf(45) > 0) {
                format = s.indexOf(46) > 0 ? "yyyy-MM-dd HH:mm:ss.SSS" : "yyyy-MM-dd HH:mm:ss";
            } else if (s.indexOf(47) > 0) {
                format = s.indexOf(46) > 0 ? "yyyy/MM/dd HH:mm:ss.SSS" : "yyyy/MM/dd HH:mm:ss";
            }
        } else if (s.indexOf(47) > 0) {
            format = "yyyy/MM/dd";
        } else if (s.indexOf(45) > 0) {
            format = "yyyy-MM-dd";
        } else if (s.indexOf(58) > 0) {
            format = s.indexOf(46) > 0 ? "HH:mm:ss.SSS" : "HH:mm:ss";
        }
        if (format != null) {
            return format;
        }
        throw new KemException(KemCommonError.CommonError, "illegal datetime format, s='" + s + "'.");
    }

    public static boolean isLong(String d) {
        int j = d.length();
        for (int i = 0; i < j; ++i) {
            char c = d.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static BigDecimal n(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        String s = value.toString().trim();
        if (s.length() == 0) {
            return BigDecimal.ZERO;
        }
        if (s.indexOf(44) >= 0) {
            s = s.replaceAll(",", "");
        }
        if ("-".equals(s)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(s);
    }

    public static RuntimeException e(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new KemException(KemCommonError.CommonError, e.getMessage());
    }

    public static Exception e2(Throwable e) {
        if (e instanceof Exception) {
            return (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return DataUtil.e(e);
    }

    public static String getMessage(Throwable e) {
        String s = DataUtil.s(e.getMessage());
        if (s == null) {
            s = e.getClass().getName();
        } else if (e instanceof UnknownHostException) {
            s = String.format("Unkown host address:%s.", s);
        }
        return s;
    }

    public static String getCascadeMessage(Throwable e) {
        StringBuilder s = new StringBuilder();
        String message = DataUtil.getMessage(e);
        s.append(message);
        String priorMessage = message;
        HashSet<Throwable> visited = new HashSet<Throwable>();
        while (visited.add(e) && (e = e.getCause()) != null) {
            message = DataUtil.getMessage(e);
            if (priorMessage.contains(message)) continue;
            s.append("\u3000//Reason:").append(message);
            priorMessage = message;
        }
        return s.toString();
    }

    public static String datetimeToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return sdf.format(date);
    }

    public static boolean isBaseType(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> className = object.getClass();
        return className.equals(Integer.class) || className.equals(Byte.class) || className.equals(Long.class) || className.equals(Double.class) || className.equals(Float.class) || className.equals(String.class) || className.equals(Character.class) || className.equals(Short.class) || className.equals(Boolean.class);
    }
}

