/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util;

import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;

public class DistributeCacheUtil {
    private static final int CACHE_TIME_OUT = 600;
    private static final String APPID_KEY = "_kem_";

    private static DistributeSessionlessCache getCache() {
        return DistributeCacheUtil.getCache(RequestContext.get().getAccountId());
    }

    private static DistributeSessionlessCache getCache(String accountId) {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(APPID_KEY.concat(accountId), new DistributeCacheHAPolicy(true, true));
    }

    public static String getCacheByKey(String cacheType, String key) {
        return (String)DistributeCacheUtil.getCache().get(DistributeCacheUtil.getNewCacheKey(cacheType, key));
    }

    public static void setCacheByKey(String cacheType, String key, String value) {
        DistributeCacheUtil.getCache().put(DistributeCacheUtil.getNewCacheKey(cacheType, key), (Object)value, 600, TimeUnit.SECONDS);
    }

    public static void setCacheByKey(String cacheType, String key, String value, int timeout, TimeUnit timeUnit) {
        DistributeCacheUtil.getCache().put(DistributeCacheUtil.getNewCacheKey(cacheType, key), (Object)value, timeout, timeUnit);
    }

    public static void removeCacheByKey(String cacheType, String key) {
        DistributeCacheUtil.getCache().remove(DistributeCacheUtil.getNewCacheKey(cacheType, key));
    }

    public static String getCacheByKey(String cacheType, String key, String accountId) {
        return (String)DistributeCacheUtil.getCache(accountId).get(DistributeCacheUtil.getNewCacheKey(accountId, cacheType, key));
    }

    public static void setCacheByKey(String cacheType, String key, String value, String accountId) {
        DistributeCacheUtil.getCache(accountId).put(DistributeCacheUtil.getNewCacheKey(accountId, cacheType, key), (Object)value, 600, TimeUnit.SECONDS);
    }

    public static void setCacheByKey(String cacheType, String key, String value, String accountId, int timeout) {
        DistributeCacheUtil.getCache(accountId).put(DistributeCacheUtil.getNewCacheKey(accountId, cacheType, key), (Object)value, timeout, TimeUnit.SECONDS);
    }

    public static void removeCacheByKey(String cacheType, String key, String accountId) {
        DistributeCacheUtil.getCache(accountId).remove(DistributeCacheUtil.getNewCacheKey(accountId, cacheType, key));
    }

    public static boolean isEnable(String accountId) {
        return DistributeCacheUtil.getCache(accountId).isAvailable();
    }

    public static long inc(String key, String accountId, int timeSecond) {
        return DistributeCacheUtil.getCache(accountId).inc(DistributeCacheUtil.getNewCacheKey(accountId, "inc", key), timeSecond);
    }

    private static String getNewCacheKey(String cacheType, String key) {
        String accountId = RequestContext.get().getAccountId();
        return DistributeCacheUtil.getNewCacheKey(accountId, cacheType, key);
    }

    private static String getNewCacheKey(String accountId, String cacheType, String key) {
        return accountId + APPID_KEY + cacheType + "_" + key;
    }
}

