/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import kd.bos.isc.util.misc.HttpConnectionDecorator;
import kd.bos.isc.util.misc.NetUtil;
import kd.isc.kem.common.util.ConfigHelper;
import kd.isc.kem.common.util.DataUtil;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.common.util.SerializationUtils;

public class HttpUtil
extends NetUtil {
    private static final String SCHEME_HTTPS = "https";

    public static int getHtpConnTimeout() {
        String str = ConfigHelper.getSysProperty("kem.httpclient.connectionTimeout", String.valueOf(3000));
        return DataUtil.i((Object)str);
    }

    public static String postJson(String url, HashMap<String, Object> body) {
        return HttpUtil.postJson(url, body, null);
    }

    public static String postJson(String url, HashMap<String, Object> body, int timeout) {
        return HttpUtil.postJson(url, body, null, timeout);
    }

    public static String postJson(String url, HashMap<String, Object> body, HashMap<String, Object> header) {
        Reader reader = HttpUtil.postJson(url, body, header, null, HttpUtil.getHtpConnTimeout());
        return HttpUtil.readText((Reader)reader);
    }

    public static String postJson(String url, HashMap<String, Object> body, HashMap<String, Object> header, int timeout) {
        Reader reader = HttpUtil.postJson(url, body, header, null, timeout);
        return HttpUtil.readText((Reader)reader);
    }

    private static Reader postJson(String url, HashMap<String, Object> body, HashMap<String, Object> headers, HashMap<String, Object> cookies, int timeout) {
        if (body == null) {
            body = new HashMap(1);
        }
        return HttpUtil.postData(url, JacksonUtil.writeValueAsString(body), null, cookies, timeout);
    }

    public static String postData(String url, String data) {
        return HttpUtil.postData(url, data, null);
    }

    public static String postData(String url, String data, int timeout) {
        return HttpUtil.postData(url, data, null, timeout);
    }

    public static String postData(String url, String data, HashMap<String, Object> header) {
        Reader reader = HttpUtil.postData(url, data, header, null, HttpUtil.getHtpConnTimeout());
        return HttpUtil.readText((Reader)reader);
    }

    public static String postData(String url, String data, HashMap<String, Object> header, int timeout) {
        Reader reader = HttpUtil.postData(url, data, header, null, timeout);
        return HttpUtil.readText((Reader)reader);
    }

    private static Reader postData(String url, String data, HashMap<String, Object> headers, HashMap<String, Object> cookies, int timeout) {
        if (headers == null) {
            headers = new HashMap(1);
        }
        if (cookies == null) {
            cookies = new HashMap(1);
        }
        HttpConnectionDecorator decorator = new HttpConnectionDecorator((Map)SerializationUtils.clone(cookies), (Map)SerializationUtils.clone(headers));
        return HttpUtil.httpAccess((String)url, (String)data, (String)"UTF-8", (NetUtil.ConnectionDecorator)decorator, (String)"POST", (int)timeout);
    }
}

