/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.isc.kem.common.util.LambdaUtil;
import kd.isc.kem.common.util.jackson.dser.CustomDateDeserializer;

public class JacksonUtil {
    private static final String DATE_TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMATTER = "yyyy-MM-dd";
    private static final String TIME_FORMATTER = "HH:mm:ss";
    private static final JsonMapper JSON_MAPPER;
    private static final JsonMapper NUMBER_JSON_MAPPER;
    private static final String mDateFormat;

    private static SimpleModule getSimpleModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(DATE_FORMATTER);
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(TIME_FORMATTER);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(mDateFormat);
        module.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormatter));
        module.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormatter));
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(dateFormatter));
        module.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormatter));
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(dateTimeFormatter));
        module.addDeserializer(Date.class, (JsonDeserializer)CustomDateDeserializer.instance);
        return module;
    }

    private static SimpleModule getNumberSimpleModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        module.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        return module;
    }

    public static <T> T readValue(String json, Class<T> valueType) {
        return (T)(json == null ? null : LambdaUtil.wrap(() -> JSON_MAPPER.readValue(json, valueType)));
    }

    public static <T> T readValue(String json, TypeReference<T> valueTypeRef) {
        return (T)(json == null ? null : LambdaUtil.wrap(() -> JSON_MAPPER.readValue(json, valueTypeRef)));
    }

    public static String writeValueAsString(Object obj) {
        return obj == null ? null : LambdaUtil.wrap(() -> JSON_MAPPER.writeValueAsString(obj));
    }

    public static String writeValueAsString2(Object obj) {
        return obj == null ? null : LambdaUtil.wrap(() -> NUMBER_JSON_MAPPER.writeValueAsString(obj));
    }

    public static String writeValueAsPrettyString(Object obj) {
        return obj == null ? null : LambdaUtil.wrap(() -> JSON_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj));
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)(fromValue == null ? null : JSON_MAPPER.convertValue(fromValue, toValueTypeRef));
    }

    public static JsonNode readTree(String json) {
        return json == null ? NullNode.getInstance() : LambdaUtil.wrap(() -> JSON_MAPPER.readTree(json));
    }

    public static JsonNode valueToTree(Object fromValue) {
        return JSON_MAPPER.valueToTree(fromValue);
    }

    public static <T> T treeToValue(TreeNode treeNode, Class<T> valueType) {
        return (T)(treeNode == null ? null : LambdaUtil.wrap(() -> JSON_MAPPER.treeToValue(treeNode, valueType)));
    }

    public static boolean isJson(String str) {
        try {
            JSON_MAPPER.readTree(str);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static {
        mDateFormat = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_datesdf", "api.datesdf", DATE_TIME_FORMATTER);
        JSON_MAPPER = new JsonMapper();
        JSON_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat(mDateFormat)).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)JacksonUtil.getSimpleModule()).enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN}).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        JSON_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        JSON_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        NUMBER_JSON_MAPPER = JSON_MAPPER.copy();
        NUMBER_JSON_MAPPER.registerModule((Module)JacksonUtil.getNumberSimpleModule());
    }
}

