/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.JacksonUtil;

public enum KemJsonNodeType {
    ARRAY(JsonNodeType.ARRAY){

        public Object getVal(JsonNode typeNode) {
            ArrayNode node = (ArrayNode)typeNode;
            ArrayList<Object> list = new ArrayList<Object>(node.size());
            for (JsonNode jsonNode : node) {
                list.add(1.getValue(jsonNode));
            }
            return list;
        }
    }
    ,
    BINARY(JsonNodeType.BINARY){

        public Object getVal(JsonNode typeNode) {
            throw new UnsupportedOperationException(this.name());
        }
    }
    ,
    BOOLEAN(JsonNodeType.BOOLEAN){

        public Object getVal(JsonNode typeNode) {
            BooleanNode node = (BooleanNode)typeNode;
            return node.asBoolean();
        }
    }
    ,
    MISSING(JsonNodeType.MISSING){

        public Object getVal(JsonNode typeNode) {
            return null;
        }
    }
    ,
    NULL(JsonNodeType.NULL){

        public Object getVal(JsonNode typeNode) {
            return null;
        }
    }
    ,
    OBJECT(JsonNodeType.OBJECT){

        public Object getVal(JsonNode typeNode) {
            ObjectNode node = (ObjectNode)typeNode;
            return JacksonUtil.convertValue(node, new TypeReference<Map<String, Object>>(){});
        }
    }
    ,
    POJO(JsonNodeType.POJO){

        public Object getVal(JsonNode typeNode) {
            POJONode node = (POJONode)typeNode;
            return JacksonUtil.convertValue(node, new TypeReference<Map<String, Object>>(){});
        }
    }
    ,
    STRING(JsonNodeType.STRING){

        public Object getVal(JsonNode typeNode) {
            TextNode node = (TextNode)typeNode;
            return node.asText();
        }
    }
    ,
    NUMBER(JsonNodeType.NUMBER){

        public Object getVal(JsonNode typeNode) {
            NumericNode node = (NumericNode)typeNode;
            switch (node.numberType()) {
                case DOUBLE: {
                    return node.doubleValue();
                }
                case LONG: {
                    return node.longValue();
                }
                case INT: {
                    return node.intValue();
                }
                case FLOAT: {
                    return Float.valueOf(node.floatValue());
                }
                case BIG_DECIMAL: {
                    return node.decimalValue();
                }
                case BIG_INTEGER: {
                    return node.bigIntegerValue();
                }
            }
            throw new KemException(KemJsonNodeType.class.getSimpleName(), "JsonNode \u201c" + node + "\u201d is not supported");
        }
    };

    private final JsonNodeType jsonNodeType;

    private KemJsonNodeType(JsonNodeType jsonNodeType) {
        this.jsonNodeType = jsonNodeType;
    }

    abstract <T extends JsonNode> Object getVal(T var1);

    public static <T extends JsonNode> Object getValue(T jsonNode) {
        return KemJsonNodeType.getKemJsonNodeType(jsonNode).getVal(jsonNode);
    }

    private static <T extends JsonNode> KemJsonNodeType getKemJsonNodeType(T jsonNode) {
        return Arrays.stream(KemJsonNodeType.values()).filter(it -> it.jsonNodeType == jsonNode.getNodeType()).findFirst().orElseThrow(() -> new KemException(KemJsonNodeType.class.getSimpleName(), "JsonNode \u201c" + jsonNode + "\u201d is not supported"));
    }
}

