/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.isc.iscb.platform.core.license.GrayFeatureUtil;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemException;

public class KemLicenseUtil {
    private static final String FEATURE_OPEN_NUMBER = "KemOpenEvent";
    private static final String FEATURE_KEM_NUMBER = "KEM";

    public static boolean isEnableGrayLicense() {
        return KemLicenseUtil.isEnableOpenEventGrayLicense();
    }

    public static void checkGrayLicense(String srcSubType) {
        if (srcSubType == null) {
            return;
        }
        if ("1".equals(srcSubType = srcSubType.trim())) {
            KemLicenseUtil.checkOpenEventGrayLicense();
        } else if ("0".equals(srcSubType)) {
            KemLicenseUtil.checkKemGrayLicense();
        }
    }

    public static void checkOpenEventGrayLicense() {
        try {
            if (KemLicenseUtil.isEnableOpenEventGrayLicense()) {
                GrayFeatureUtil.checkLicenseState((String)FEATURE_OPEN_NUMBER);
            }
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"\u5f00\u653e\u4e8b\u4ef6\u7070\u5ea6\u8bb8\u53ef\u9a8c\u8bc1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"License_1", (String)"isc-kem-core", (Object[])new Object[]{ex.getMessage()});
            throw new KemException(KemCommonError.NoLicense, msg);
        }
    }

    public static void checkKemGrayLicense() {
        try {
            GrayFeatureUtil.checkLicenseState((String)FEATURE_KEM_NUMBER);
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"\u4e8b\u4ef6\u7f51\u683c\u7070\u5ea6\u8bb8\u53ef\u9a8c\u8bc1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"License_2", (String)"isc-kem-core", (Object[])new Object[]{ex.getMessage()});
            throw new KemException(KemCommonError.NoLicense, msg);
        }
    }

    public static boolean isEnableOpenEventGrayLicense() {
        int modelType = LicenseServiceHelper.getModeType();
        return modelType != 2 && modelType != 4;
    }
}

