/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LocalCacheUtil {
    private static final Log logger = LogFactory.getLog(LocalCacheUtil.class);
    private static final String APPID_KEY = "_kem_";
    private static final int CACHE_TIME_OUT = 600;
    private static final int CACHE_MAX_ITEM_SIZE = 10000;
    private static final int CACHE_MAX_MEM_SIZE = 150;

    public static LocalMemoryCache getLocalMemoryCache(String cacheType, String accountId) {
        return LocalCacheUtil.getLocalMemoryCache(cacheType, 600, accountId);
    }

    private static LocalMemoryCache getLocalMemoryCache(String cacheType) {
        return LocalCacheUtil.getLocalMemoryCache(cacheType, RequestContext.get().getAccountId());
    }

    private static LocalMemoryCache getLocalMemoryCache(String cacheType, int timeOutInSeconds) {
        return LocalCacheUtil.getLocalMemoryCache(cacheType, timeOutInSeconds, RequestContext.get().getAccountId());
    }

    public static LocalMemoryCache getLocalMemoryCache(String cacheType, int timeOutInSeconds, String accountId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(timeOutInSeconds);
        info.setTimeToLive(true);
        info.setMaxItemSize(10000);
        info.setMaxMemSize(150);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("kem".concat(accountId), cacheType, info);
    }

    public static void setCacheByKey(String cacheType, String key, Object value) {
        String newKey = LocalCacheUtil.getNewCacheKey(cacheType, key);
        LocalCacheUtil.getLocalMemoryCache(cacheType).put(newKey, value);
    }

    public static void setCacheByKey(String cacheType, String key, Object value, int timeOutInSeconds) {
        String newKey = LocalCacheUtil.getNewCacheKey(cacheType, key);
        LocalCacheUtil.getLocalMemoryCache(cacheType, timeOutInSeconds).put(newKey, value);
    }

    public static void setCacheByKey(String cacheType, String key, Object value, String accountId) {
        String newKey = LocalCacheUtil.getNewCacheKey(accountId, cacheType, key);
        LocalCacheUtil.getLocalMemoryCache(cacheType, accountId).put(newKey, value);
    }

    public static void setCacheByKey(String cacheType, String key, Object value, int timeOutInSeconds, String accountId) {
        String newKey = LocalCacheUtil.getNewCacheKey(accountId, cacheType, key);
        LocalCacheUtil.getLocalMemoryCache(cacheType, timeOutInSeconds, accountId).put(newKey, value);
    }

    public static Object getCacheByKey(String cacheType, String key, String accountId) {
        String newKey = LocalCacheUtil.getNewCacheKey(accountId, cacheType, key);
        return LocalCacheUtil.getLocalMemoryCache(cacheType, accountId).get(newKey);
    }

    public static void removeCacheByKey(String cacheType, String key, String accountId) {
        String newKey = LocalCacheUtil.getNewCacheKey(accountId, cacheType, key);
        LocalCacheUtil.getLocalMemoryCache(cacheType, accountId).remove(new String[]{newKey});
    }

    public static void removeCacheByKey(String cacheType, String key) {
        String newKey = LocalCacheUtil.getNewCacheKey(cacheType, key);
        LocalCacheUtil.getLocalMemoryCache(cacheType).remove(new String[]{newKey});
    }

    public static void clear(String cacheType, String accountId) {
        LocalCacheUtil.getLocalMemoryCache(cacheType, accountId).clear();
    }

    public static void clear(String cacheType) {
        LocalCacheUtil.getLocalMemoryCache(cacheType).clear();
    }

    public static <T> boolean checkIsInCache(Class<T> dataType, String key, String accountId) {
        String cacheType = dataType.getName();
        String newKey = LocalCacheUtil.getNewCacheKey(accountId, cacheType, key);
        Object object = LocalCacheUtil.getLocalMemoryCache(cacheType, accountId).get(newKey);
        return object != null;
    }

    public static <T> boolean checkIsInCache(Class<T> dataType, String key) {
        String cacheType = dataType.getName();
        String newKey = LocalCacheUtil.getNewCacheKey(cacheType, key);
        Object object = LocalCacheUtil.getLocalMemoryCache(dataType.getName()).get(newKey);
        return object != null;
    }

    public static <T> void setCacheByKey(String key, T object, String accountId) {
        LocalCacheUtil.setCacheByKey(object.getClass().getName(), key, object, accountId);
    }

    public static <T> void setCacheByKey(String key, T object) {
        LocalCacheUtil.setCacheByKey(object.getClass().getName(), key, object);
    }

    public static <T> T getCacheByKey(Class<T> dataType, String key, String accountId) {
        String cacheType = dataType.getName();
        String newKey = LocalCacheUtil.getNewCacheKey(accountId, cacheType, key);
        return (T)LocalCacheUtil.getLocalMemoryCache(cacheType, accountId).get(newKey);
    }

    public static <T> T getCacheByKey(Class<T> dataType, String key) {
        String cacheType = dataType.getName();
        String newKey = LocalCacheUtil.getNewCacheKey(cacheType, key);
        return (T)LocalCacheUtil.getLocalMemoryCache(dataType.getName()).get(newKey);
    }

    public static Object getCacheByKey(String cacheType, String key) {
        String newKey = LocalCacheUtil.getNewCacheKey(cacheType, key);
        return LocalCacheUtil.getLocalMemoryCache(cacheType).get(newKey);
    }

    public static <T> void removeCacheByKey(Class<T> dataType, String key, String accountId) {
        LocalCacheUtil.removeCacheByKey(dataType.getName(), key, accountId);
    }

    public static <T> void removeCacheByKey(Class<T> dataType, String key) {
        LocalCacheUtil.removeCacheByKey(dataType.getName(), key);
    }

    public static <T> void clear(Class<T> dataType, String accountId) {
        LocalCacheUtil.clear(dataType.getName(), accountId);
    }

    public static <T> void clear(Class<T> dataType) {
        LocalCacheUtil.clear(dataType.getName());
    }

    private static String getNewCacheKey(String cacheType, String key) {
        String accountId = RequestContext.get().getAccountId();
        return LocalCacheUtil.getNewCacheKey(accountId, cacheType, key);
    }

    private static String getNewCacheKey(String accountId, String cacheType, String key) {
        return accountId + APPID_KEY + cacheType + "_" + key;
    }
}

