/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.ConfigHelper;
import kd.isc.kem.common.util.DataUtil;
import kd.isc.kem.common.util.KemAssert;

public class TimeLimiterHelper {
    private static final Log LOG = LogFactory.getLog(TimeLimiterHelper.class);
    private static final int TL_TARGET_WEBAPI_TIMEOUT_SECONDS = 10;
    private static final ExecutorService TARGET_EXECUTOR_SERVICE = ThreadPools.newCachedExecutorService((String)"KEM_TARGET_TIME_LIMITER", (int)TimeLimiterHelper.getTargetCoreThread(), (int)TimeLimiterHelper.getTargetMaxThread());
    private static final SimpleTimeLimiter TARGET_SIMPLE_TIME_LIMITER = SimpleTimeLimiter.create((ExecutorService)TARGET_EXECUTOR_SERVICE);

    private TimeLimiterHelper() {
        throw new UnsupportedOperationException();
    }

    public static <T> T callTargetWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) {
        return TimeLimiterHelper.callWithTimeout(TARGET_SIMPLE_TIME_LIMITER, callable, timeoutDuration, timeoutUnit);
    }

    private static <T> T callWithTimeout(SimpleTimeLimiter timeLimiter, Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) {
        try {
            return (T)timeLimiter.callWithTimeout(callable, timeoutDuration, timeoutUnit);
        }
        catch (TimeoutException e) {
            throw new KemException((Throwable)e, "504", "TIMEOUT ({0} {1})", new Object[]{timeoutDuration, timeoutUnit});
        }
        catch (Exception e) {
            throw new KemException((Throwable)e, "callWithTimeout", e.getMessage() == null ? "ERROR" : e.getMessage(), new Object[0]);
        }
    }

    public static int getTargetWebapiTimeoutSeconds() {
        String str = ConfigHelper.getSystemParam("kem_target_webapi_timeout", String.valueOf(10));
        return DataUtil.i((Object)str);
    }

    private static int getTargetCoreThread() {
        return TimeLimiterHelper.getParameter("kem.Target.TimeLimiter.CoreThread", Integer.class, 2);
    }

    private static int getTargetMaxThread() {
        return TimeLimiterHelper.getParameter("kem.Target.TimeLimiter.MaxThread", Integer.class, 16);
    }

    public static <T> T getParameter(String key, Class<T> cls, T defaultValue) {
        KemAssert.hasText((String)key, (String)"key must not be null");
        KemAssert.notNull(cls, (String)"cls must not be null");
        if (defaultValue instanceof String) {
            KemAssert.hasText((String)((String)defaultValue), (String)"defaultValue must not be null");
        } else {
            KemAssert.notNull(defaultValue, (String)"defaultValue must not be null");
        }
        try {
            String value = ConfigHelper.getSysProperty(key, defaultValue.toString());
            return (T)ObjectConverter.convert((Object)value, cls, (boolean)false);
        }
        catch (Exception e) {
            LOG.error("KEM_LOG:" + key, (Throwable)e);
            return defaultValue;
        }
    }
}

