/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.common.util.jackson.dser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import kd.bos.openapi.common.util.DataUtil;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemException;

public final class CustomDateDeserializer
extends JsonDeserializer<Date> {
    public static final CustomDateDeserializer instance = new CustomDateDeserializer();

    private CustomDateDeserializer() {
    }

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String dateString = jsonParser.getText();
        try {
            Timestamp t = DataUtil.t((Object)dateString);
            if (t == null) {
                return null;
            }
            Date date = new Date(t.getTime());
            return date;
        }
        catch (Exception e) {
            throw new KemException((Throwable)e, KemCommonError.CommonError, "Failed to parse date: " + dateString);
        }
    }
}

