/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.alloc;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.aca.algox.alloc.function.AllocFunction;
import kd.macc.aca.algox.alloc.function.MatAllocFunction;
import kd.macc.aca.algox.alloc.input.AllocDataParameter;
import kd.macc.aca.algox.alloc.output.AllocResult;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.cad.common.dto.AllocReport;
import kd.macc.cad.common.helper.AllocReportHelper;

public abstract class AllocProcessor {
    private static final Log logger = LogFactory.getLog(AllocProcessor.class);
    private AllocFunction allocFunction;
    private RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("costcenter", (DataType)DataType.LongType), new Field("checktype", (DataType)DataType.StringType), new Field("msg", (DataType)DataType.StringType)});

    public AllocResult allocate(AllocDataParameter param, AllocReport report) {
        return this.allocateInner(param, report);
    }

    private AllocResult allocateInner(AllocDataParameter param, AllocReport report) {
        Map<Long, Map<Long, Set<String>>> collDataMap = param.getCollDataMap();
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(collDataMap)) {
            return new AllocResult();
        }
        DataSet processingAllocDataSet = this.getAllocDataSet(collDataMap.keySet(), param.getAllocDims());
        JobSession session = AlgoX.createSession((String)"AllocProcessor.allocateInner");
        DataSetInput processingAllocInput = new DataSetInput(processingAllocDataSet);
        DataSetX processingAllocDx = session.fromInput((Input)processingAllocInput);
        this.setFunctionAttr(this.allocFunction, param);
        DataSetX mainDs = processingAllocDx.groupBy(new String[]{"id"}).reduceGroup((GroupReduceFunction)this.allocFunction);
        DataSetOutput dataSetOutput = new DataSetOutput(this.targetRowMeta);
        String resultId = dataSetOutput.getId();
        mainDs.output((Output)dataSetOutput);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        DataSet resultDs = session.readDataSet(resultId);
        if (report != null) {
            AllocReportHelper.addCheckItem((AllocReport)report, (String)"3", (String)ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u65e0\u503c\u3002", (String)"AllocProcessor_0", (String)"macc-aca-algox", (Object[])new Object[0]));
            AllocReportHelper.addCheckItem((AllocReport)report, (String)"4", (String)ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u503c\u5408\u8ba1\u5c0f\u4e8e\u6216\u7b49\u4e8e0\u3002", (String)"AllocProcessor_3", (String)"macc-aca-algox", (Object[])new Object[0]));
            AllocReportHelper.addCheckItem((AllocReport)report, (String)"5", (String)ResManager.loadKDString((String)"\u7269\u6599\u672a\u627e\u5230\u53ef\u5206\u914d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"AllocProcessor_2", (String)"macc-aca-algox", (Object[])new Object[0]));
            for (Row row : resultDs) {
                String checktype = row.getString("checktype");
                String msg = row.getString("msg");
                Long costcenter = row.getLong("checktype");
                AllocReportHelper.addCheckDatail((AllocReport)report, (String)checktype, (long)costcenter, (String)msg);
            }
        }
        return new AllocResult();
    }

    protected void setFunctionAttr(AllocFunction allocFunction, AllocDataParameter param) {
        allocFunction.setPara(param);
        if (allocFunction instanceof MatAllocFunction) {
            allocFunction.setResultRowMeta(this.targetRowMeta);
        }
    }

    protected abstract DataSet getAllocDataSet(Set<Long> var1, Set<String> var2);

    public void setAllocFunction(AllocFunction allocFunction) {
        this.allocFunction = allocFunction;
    }
}

