/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.alloc;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.alloc.AllocProcessor;
import kd.macc.aca.algox.alloc.function.AllocFunction;
import kd.macc.aca.algox.costcalc.common.ActCalcHelper;

public class MatAllocProcessor
extends AllocProcessor {
    private static final Log logger = LogFactory.getLog(MatAllocProcessor.class);

    @Override
    protected DataSet getAllocDataSet(Set<Long> allocDataIds, Set<String> allocDims) {
        QFilter filter = new QFilter("id", "in", allocDataIds);
        DataSet processingAllocDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.aca.algox.alloc.MatAllocProcessor.getAllocDataSet", (String)"aca_matalloc", (String)"id,org,costaccount,costcenter,period,material,useqty,currency.amtprecision,material.baseunit.precision precision,bizdate,matversion,auxpty,useamount,currency.priceprecision priceprecision,allocdim,manuorg,billno,isreturnitem,product,productnum,material.number materialNo,productgroup,matcollect", (QFilter[])new QFilter[]{filter}, null);
        if (!allocDims.isEmpty()) {
            DataSet ds = processingAllocDataSet.copy().select("matcollect");
            Set<Long> matcollect = ActCalcHelper.getLongIdSetFromDs(ds, "matcollect", false);
            StringBuilder selectFields = new StringBuilder("entryentity.id matcollectid");
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"aca_matusecollect");
            for (String dim : allocDims) {
                String fieldName = dim;
                if ("lot".equals(fieldName)) {
                    fieldName = "lotcoderule";
                }
                selectFields.append(MatAllocProcessor.getMatUseFileds(entityType, fieldName, dim));
            }
            QFilter matUseFilter = new QFilter("entryentity.id", "in", matcollect);
            DataSet matUseDs = QueryServiceHelper.queryDataSet((String)"getAllocDataMatUse", (String)"aca_matusecollect", (String)selectFields.toString(), (QFilter[])new QFilter[]{matUseFilter}, null);
            processingAllocDataSet = processingAllocDataSet.leftJoin(matUseDs).on("matcollect", "matcollectid").select(processingAllocDataSet.getRowMeta().getFieldNames(), allocDims.toArray(new String[0])).finish();
        }
        return processingAllocDataSet;
    }

    @Override
    public void setAllocFunction(AllocFunction allocFunction) {
        super.setAllocFunction(allocFunction);
    }

    private static String getMatUseFileds(MainEntityType entityType, String fieldName, String alias) {
        IDataEntityProperty property = entityType.findProperty(fieldName);
        if (property == null) {
            return " ";
        }
        IDataEntityType parentProp = property.getParent();
        boolean isEntryProp = parentProp instanceof EntryType;
        StringBuilder exFileds = new StringBuilder();
        exFileds.append(",");
        if (isEntryProp) {
            exFileds.append(parentProp.getName());
            exFileds.append('.');
        }
        exFileds.append(property.getName());
        exFileds.append(" as ");
        exFileds.append(alias);
        return exFileds.toString();
    }
}

