/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.alloc.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.alloc.AcaMatAllocHelper;
import kd.macc.aca.algox.alloc.function.AllocFunction;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatAllocFunction
extends AllocFunction {
    private static final Log logger = LogFactory.getLog(MatAllocFunction.class);
    private static final long serialVersionUID = -547462364191130911L;
    private static final int MAP_INITIAL_CAPACITY = 16;

    @Override
    public void doAlloc(RowX rowX, Collector collector) {
        this.doMatAlloc(rowX, collector);
    }

    private void colErrorMsg(Long costcenter, String checktype, String msg, Collector collector) {
        RowX row = new RowX(3);
        row.set(0, (Object)costcenter);
        row.set(1, (Object)checktype);
        row.set(2, (Object)msg);
        collector.collect(row);
    }

    /*
     * WARNING - void declaration
     */
    private void doMatAlloc(RowX rowX, Collector collector) {
        void var39_46;
        BigDecimal totalQty = rowX.getBigDecimal(6);
        int precision = rowX.getInteger(7);
        int qtyPrecision = rowX.getInteger(8);
        BigDecimal totalAmt = rowX.getBigDecimal(12);
        String materialIdStr = rowX.getString(this.sourceRowMeta.getFieldIndex("material"));
        String allocDimStr = rowX.getString(this.sourceRowMeta.getFieldIndex("allocdim"));
        if (this.para.getPageParamMap().containsKey("allocdim") && this.para.getPageParamMap().get("allocdim") != null) {
            allocDimStr = this.para.getPageParamMap().get("allocdim").toString();
        }
        HashSet<String> allocDims = new HashSet<String>();
        if (!StringUtils.isEmpty((String)allocDimStr)) {
            String[] allocDimArr;
            for (String dim : allocDimArr = allocDimStr.split(",")) {
                if (StringUtils.isEmpty((String)dim)) continue;
                allocDims.add(dim);
            }
        }
        Long costdriverId = 0L;
        Long costcenterId = rowX.getLong(this.sourceRowMeta.getFieldIndex("costcenter"));
        String billno = rowX.getString(this.sourceRowMeta.getFieldIndex("billno"));
        Long productGroup = rowX.getLong(this.sourceRowMeta.getFieldIndex("productgroup"));
        Set<Object> matScope = new HashSet(16);
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(this.para.getCollDataMap())) {
            this.colErrorMsg(costcenterId, "3", String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%s\u3011\u5206\u914d\u6807\u51c6\u4e0a\u6307\u5b9a\u7684\u5206\u914d\u8303\u56f4\u4e3a\u7a7a\u3002", (String)"MatAllocFunction_13", (String)"macc-aca-algox", (Object[])new Object[0]), billno), collector);
            logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u5206\u914d\u6807\u51c6\u4e0a\u6307\u5b9a\u7684\u5206\u914d\u8303\u56f4\u4e3a\u7a7a\uff1a{}", (Object)billno);
            return;
        }
        Map<Long, Set<String>> allocStdScopeMap = this.para.getCollDataMap().get(rowX.get(0));
        if (allocStdScopeMap == null) {
            return;
        }
        for (Map.Entry<Long, Set<String>> entry : allocStdScopeMap.entrySet()) {
            costdriverId = entry.getKey();
            matScope = entry.getValue();
        }
        HashMap<String, BigDecimal> effectAllocStdValueMap = new HashMap<String, BigDecimal>(16);
        BigDecimal totalValue = BigDecimal.ZERO;
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(this.para.getAllocStdValueColls())) {
            this.colErrorMsg(costcenterId, "3", String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%1$s\u3011%2$s\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\u3002", (String)"MatAllocFunction_14", (String)"macc-aca-algox", (Object[])new Object[0]), billno, this.getCostcenterDriverMsg(costcenterId, costdriverId)), collector);
            logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u8ba1\u7b97\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\uff1a{}", (Object)billno);
            return;
        }
        String costdriverKey = String.format("%s@%s", costcenterId, costdriverId);
        HashMap<String, BigDecimal> filterMaterialMap = new HashMap<String, BigDecimal>(16);
        Map<Long, Set<String>> productGroupMatSet = this.para.getProductGroupMatSet();
        Set<Object> rangeMats = new HashSet(16);
        if (productGroupMatSet.containsKey(productGroup)) {
            rangeMats = productGroupMatSet.get(productGroup);
        }
        if (this.para.getAllocStdValueColls().containsKey(costdriverKey)) {
            Map<String, BigDecimal> allocStdValueMap = this.para.getAllocStdValueColls().get(costdriverKey);
            if (AcaAlgoxEmptyOrZeroUtils.isEmpty(allocStdValueMap)) {
                this.colErrorMsg(costcenterId, "3", String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%1$s\u3011%2$s\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\u3002", (String)"MatAllocFunction_14", (String)"macc-aca-algox", (Object[])new Object[0]), billno, this.getCostcenterDriverMsg(costcenterId, costdriverId)), collector);
                logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u8ba1\u7b97\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\uff1a{}", (Object)billno);
                return;
            }
            Boolean isreturnitem = rowX.getBoolean(this.sourceRowMeta.getFieldIndex("isreturnitem"));
            String productnum = rowX.getString(this.sourceRowMeta.getFieldIndex("productnum"));
            Long product = rowX.getLong(this.sourceRowMeta.getFieldIndex("product"));
            for (Map.Entry<String, BigDecimal> entry : allocStdValueMap.entrySet()) {
                Map<String, String> costobjectFieldMap = this.getCostdriverValueKeyToMap(entry.getKey());
                String matId = costobjectFieldMap.get("material");
                String materialGroup = costobjectFieldMap.get("materialgroup");
                String auxpty = costobjectFieldMap.get("auxpty");
                String biztype = costobjectFieldMap.get("biztype");
                String isrework = costobjectFieldMap.get("isrework");
                String subMaterial = costobjectFieldMap.get("submaterial");
                String key = String.format("%s@%s", matId, auxpty);
                if (!CadEmptyUtils.isEmpty((String)subMaterial) && !subMaterial.equals(materialIdStr) || !CadEmptyUtils.isEmpty(rangeMats) && !rangeMats.contains(key)) continue;
                if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(matScope) && !matScope.contains(matId)) {
                    this.setFilterMaterialMap(filterMaterialMap, materialGroup, entry.getValue());
                    continue;
                }
                if (!CadEmptyUtils.isEmpty(allocDims)) {
                    StringBuilder srcVal = new StringBuilder();
                    StringBuilder tarVal = new StringBuilder();
                    for (String string : allocDims) {
                        tarVal.append(costobjectFieldMap.get(string));
                        if (this.sourceRowMeta.getFieldIndex(string, false) >= 0) {
                            srcVal.append(rowX.getString(this.sourceRowMeta.getFieldIndex(string)));
                            continue;
                        }
                        srcVal.append("null");
                    }
                    if (!srcVal.toString().equals(tarVal.toString())) {
                        this.setFilterMaterialMap(filterMaterialMap, materialGroup, entry.getValue());
                        continue;
                    }
                }
                if ("SO".equals(biztype)) {
                    if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(product) && !product.toString().equals(matId)) {
                        this.setFilterMaterialMap(filterMaterialMap, materialGroup, entry.getValue());
                        continue;
                    }
                    if (!StringUtils.isBlank((String)productnum) && !productnum.equals(costobjectFieldMap.get("producenum"))) {
                        this.setFilterMaterialMap(filterMaterialMap, materialGroup, entry.getValue());
                        continue;
                    }
                }
                if (isreturnitem == null || !isreturnitem.booleanValue()) {
                    if (matId.equals(materialIdStr)) {
                        this.setFilterMaterialMap(filterMaterialMap, materialGroup, entry.getValue());
                        continue;
                    }
                } else if (this.para.isReworkAllocSelf() && !matId.equals(materialIdStr)) {
                    this.setFilterMaterialMap(filterMaterialMap, materialGroup, entry.getValue());
                    continue;
                }
                totalValue = totalValue.add(entry.getValue());
                effectAllocStdValueMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.dealMaterialGroupStdValue(filterMaterialMap, effectAllocStdValueMap);
        BigDecimal allocTotalQty = BigDecimal.ZERO;
        BigDecimal allocTotalAmount = BigDecimal.ZERO;
        BigDecimal maxAllocVlue = null;
        Long maxCostObjectId = 0L;
        HashMap<Object, Object> allocMap = new HashMap(16);
        HashMap<Long, BigDecimal> allocRsMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> allocRsAmountMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> allocValuesMap = new HashMap<Long, BigDecimal>(16);
        if (effectAllocStdValueMap.size() < 1) {
            this.colErrorMsg(costcenterId, "5", String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%1$s\u3011%2$s\u672a\u627e\u5230\u6709\u6548\u7684\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"MatAllocFunction_15", (String)"macc-aca-algox", (Object[])new Object[0]), billno, this.getCostcenterDriverMsg(costcenterId, costdriverId)), collector);
            logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u6709\u6548\u8ba1\u7b97\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\uff1a{}", (Object)billno);
            return;
        }
        if (!CadEmptyUtils.isEmpty(filterMaterialMap)) {
            BigDecimal materialGroupTotalValue = BigDecimal.ZERO;
            for (Map.Entry entry : effectAllocStdValueMap.entrySet()) {
                materialGroupTotalValue = materialGroupTotalValue.add((BigDecimal)entry.getValue());
            }
            totalValue = materialGroupTotalValue;
        }
        String allocStatus = this.para.getAllocStatus();
        if (totalValue.compareTo(BigDecimal.ZERO) == 0) {
            this.colErrorMsg(costcenterId, "4", String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%1$s\u3011%2$s\u5206\u914d\u6807\u51c6\u503c\u603b\u6570\u4e3a0\u3002", (String)"MatAllocFunction_16", (String)"macc-aca-algox", (Object[])new Object[0]), billno, this.getCostcenterDriverMsg(costcenterId, costdriverId)), collector);
            logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u5206\u914d\u6807\u51c6\u503c\u603b\u6570\u4e3a0\uff1a{}", (Object)billno);
            allocStatus = "0";
        }
        if (totalValue.compareTo(BigDecimal.ZERO) < 0) {
            this.colErrorMsg(costcenterId, "4", String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%1$s\u3011%2$s\u5206\u914d\u6807\u51c6\u503c\u603b\u6570\u5c0f\u4e8e0\u3002", (String)"MatAllocFunction_19", (String)"macc-aca-algox", (Object[])new Object[0]), billno, this.getCostcenterDriverMsg(costcenterId, costdriverId)), collector);
            allocStatus = "0";
        }
        this.getAllocMap(effectAllocStdValueMap, maxAllocVlue, maxCostObjectId, totalValue, totalQty, qtyPrecision, allocTotalQty, allocRsMap, allocValuesMap);
        this.getAllocMap(effectAllocStdValueMap, maxAllocVlue, maxCostObjectId, totalValue, totalAmt, precision, allocTotalAmount, allocRsAmountMap, allocValuesMap);
        String qytOrAmount = "qty";
        if (!CadEmptyUtils.isEmpty((BigDecimal)totalQty)) {
            allocMap = allocRsMap;
        } else {
            allocMap = allocRsAmountMap;
            qytOrAmount = "amount";
        }
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-\u8fdb\u884c\u5206\u914d\u5904\u7406\uff1a{}", (Object)billno);
        DynamicObject allocData = BusinessDataServiceHelper.loadSingle((Object)rowX.getLong(0), (String)"aca_matalloc");
        allocData.set("costdriver", (Object)costdriverId);
        if (this.para.getPageParamMap().containsKey("allocdim")) {
            allocData.set("allocdim", this.para.getPageParamMap().get("allocdim"));
        }
        allocData.set("allocstatus", (Object)allocStatus);
        if ("2".equals(allocStatus)) {
            allocData.set("billstatus", (Object)"C");
            allocData.set("auditdate", (Object)TimeServiceHelper.now());
        }
        allocData.set("alloctype", (Object)1);
        allocData.set("usetype", (Object)1);
        allocData.set("allocatedate", (Object)new Date());
        allocData.set("alloctor", (Object)this.para.getAllocor());
        DynamicObjectCollection entrys = allocData.getDynamicObjectCollection("entryentity");
        entrys.clear();
        int seq = 1;
        String elementAndSubElementPair = this.getMatIdToPairMap(rowX);
        String[] split = elementAndSubElementPair.split("@");
        BigDecimal allocTotalValue = BigDecimal.ZERO;
        for (Map.Entry entry : allocMap.entrySet()) {
            BigDecimal qty = (BigDecimal)entry.getValue();
            if (totalValue.compareTo(BigDecimal.ZERO) != 0 && qty.compareTo(BigDecimal.ZERO) == 0) continue;
            DynamicObject entry2 = entrys.addNew();
            Long costObjectId = (Long)entry.getKey();
            entry2.set("seq", (Object)seq++);
            entry2.set("costobejctentry", (Object)costObjectId);
            entry2.set(qytOrAmount, (Object)qty);
            entry2.set("amount", (Object)qty);
            entry2.set("allocvalue", allocValuesMap.get(costObjectId));
            allocTotalValue = allocTotalValue.add((BigDecimal)allocValuesMap.get(costObjectId));
            entry2.set("subelemententry", (Object)split[1]);
            if (entry2.getLong("subelemententry") <= 0L) continue;
            entry2.set("elemententry", (Object)split[0]);
        }
        if (entrys.isEmpty()) {
            this.colErrorMsg(costcenterId, "5", String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%1$s\u3011%2$s\u65e0\u5206\u914d\u660e\u7ec6\u3002", (String)"MatAllocFunction_17", (String)"macc-aca-algox", (Object[])new Object[0]), billno, this.getCostcenterDriverMsg(costcenterId, costdriverId)), collector);
            logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u65e0\u5206\u914d\u660e\u7ec6\uff1a{}", (Object)billno);
            return;
        }
        BigDecimal allocTotalAmt = BigDecimal.ZERO;
        Object var39_45 = null;
        for (DynamicObject entry2 : entrys) {
            BigDecimal allocValue = entry2.getBigDecimal("allocvalue");
            if (var39_46 == null || allocValue.compareTo(var39_46.getBigDecimal("allocvalue")) > 0) {
                DynamicObject dynamicObject = entry2;
            }
            if (allocTotalValue.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal amt = allocValue.divide(allocTotalValue, 10, RoundingMode.HALF_UP).multiply(totalAmt).setScale(precision, RoundingMode.HALF_UP);
                entry2.set("amount", (Object)amt);
                allocTotalAmt = allocTotalAmt.add(amt);
                continue;
            }
            entry2.set("amount", (Object)BigDecimal.ZERO);
        }
        BigDecimal diffAmt = totalAmt.subtract(allocTotalAmt);
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0 && var39_46 != null) {
            var39_46.set("amount", (Object)var39_46.getBigDecimal("amount").add(diffAmt));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocData});
    }

    private void getAllocMap(Map<String, BigDecimal> effectAllocStdValueMap, BigDecimal maxAllocVlue, Long maxCostObjectId, BigDecimal totalValue, BigDecimal totalQty, int qtyPrecision, BigDecimal allocTotalQty, Map<Long, BigDecimal> allocRsMap, Map<Long, BigDecimal> allocValuesMap) {
        for (Map.Entry<String, BigDecimal> entry : effectAllocStdValueMap.entrySet()) {
            Map<String, String> costobjectFieldMap = this.getCostdriverValueKeyToMap(entry.getKey());
            String costobject = costobjectFieldMap.get("costobject");
            if (maxAllocVlue == null || maxAllocVlue.compareTo(entry.getValue()) < 0) {
                maxAllocVlue = entry.getValue();
                maxCostObjectId = Long.valueOf(costobject);
            }
            BigDecimal allocQty = BigDecimal.ZERO;
            if (totalValue.compareTo(BigDecimal.ZERO) != 0) {
                allocQty = totalQty.multiply(entry.getValue()).divide(totalValue, qtyPrecision, 4);
            }
            allocTotalQty = allocTotalQty.add(allocQty);
            allocRsMap.put(Long.valueOf(costobject), allocQty);
            allocValuesMap.put(Long.valueOf(costobject), entry.getValue());
        }
        BigDecimal diffQty = totalQty.subtract(allocTotalQty);
        if (diffQty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal currAllocQty = allocRsMap.get(maxCostObjectId);
            allocRsMap.put(maxCostObjectId, currAllocQty.add(diffQty));
        }
    }

    private String getCostcenterDriverMsg(long costcenter, long costdriver) {
        String infoMsg = ResManager.loadKDString((String)"-\u6210\u672c\u4e2d\u5fc3\u3010%1$s\u3011\uff0c\u6210\u672c\u52a8\u56e0\u3010%2$s\u3011", (String)"MatAllocFunction_7", (String)"macc-aca-algox", (Object[])new Object[0]);
        DynamicObject costcenterDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)costcenter, (String)"bos_costcenter");
        DynamicObject costdriverDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)costdriver, (String)"cad_costdriver");
        return String.format(infoMsg, costcenterDyn == null ? "" : costcenterDyn.getString("name"), costdriverDyn == null ? "" : costdriverDyn.getString("name"));
    }

    private void dealMaterialGroupStdValue(Map<String, BigDecimal> filterMaterialMap, Map<String, BigDecimal> effectAllocStdValueMap) {
        if (filterMaterialMap == null || filterMaterialMap.size() == 0) {
            return;
        }
        HashMap<String, Object> materialGroupMap = new HashMap<String, Object>();
        for (Map.Entry<String, BigDecimal> entry : filterMaterialMap.entrySet()) {
            String materialGroup = entry.getKey();
            for (Map.Entry<String, BigDecimal> allocEntry : effectAllocStdValueMap.entrySet()) {
                Object sumValue = allocEntry.getValue();
                Map<String, String> map = this.getCostdriverValueKeyToMap(allocEntry.getKey());
                String allocMaterialGroup = map.get("materialgroup");
                if (!materialGroup.equals(allocMaterialGroup)) continue;
                if (materialGroupMap.get(allocMaterialGroup) != null) {
                    sumValue = ((BigDecimal)sumValue).add((BigDecimal)materialGroupMap.get(allocMaterialGroup));
                }
                materialGroupMap.put(allocMaterialGroup, sumValue);
            }
        }
        HashMap<String, BigDecimal> materialRatioTotalValue = new HashMap<String, BigDecimal>(16);
        HashMap materialGroupMaxKey = new HashMap(16);
        HashMap<String, BigDecimal> materialGroupMaxValue = new HashMap<String, BigDecimal>(16);
        for (Map.Entry<String, BigDecimal> entry : filterMaterialMap.entrySet()) {
            for (Map.Entry entry2 : effectAllocStdValueMap.entrySet()) {
                Map<String, String> costobjectFieldMap = this.getCostdriverValueKeyToMap((String)entry2.getKey());
                String allocMaterialGroup = costobjectFieldMap.get("materialgroup");
                BigDecimal sumValue = (BigDecimal)materialGroupMap.get(allocMaterialGroup);
                if (sumValue == null || sumValue.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal ratioValue = entry.getValue().multiply((BigDecimal)entry2.getValue()).divide(sumValue, 10, 4);
                if (materialRatioTotalValue.get(allocMaterialGroup) != null) {
                    materialRatioTotalValue.put(allocMaterialGroup, ratioValue.add((BigDecimal)materialRatioTotalValue.get(allocMaterialGroup)));
                } else {
                    materialRatioTotalValue.put(allocMaterialGroup, ratioValue);
                }
                ratioValue = ratioValue.add((BigDecimal)entry2.getValue());
                effectAllocStdValueMap.put((String)entry2.getKey(), ratioValue);
                if (materialGroupMaxValue.get(allocMaterialGroup) != null && ratioValue.compareTo((BigDecimal)materialGroupMaxValue.get(allocMaterialGroup)) <= 0) continue;
                materialGroupMaxValue.put(allocMaterialGroup, ratioValue);
                materialGroupMaxKey.put(allocMaterialGroup, entry2.getKey());
            }
        }
        for (Map.Entry<String, BigDecimal> entry : filterMaterialMap.entrySet()) {
            String maxKey;
            BigDecimal currAllocValue;
            BigDecimal bigDecimal;
            String materialGroup = entry.getKey();
            if (materialRatioTotalValue.get(materialGroup) == null || (bigDecimal = entry.getValue().subtract((BigDecimal)materialRatioTotalValue.get(materialGroup))).compareTo(BigDecimal.ZERO) == 0 || (currAllocValue = effectAllocStdValueMap.get(maxKey = (String)materialGroupMaxKey.get(materialGroup))) == null) continue;
            effectAllocStdValueMap.put(maxKey, currAllocValue.add(bigDecimal));
        }
    }

    private void setFilterMaterialMap(Map<String, BigDecimal> filterMaterialMap, String materialGroup, BigDecimal value) {
        if (StringUtils.isNotEmpty((String)materialGroup) && !materialGroup.equals("0")) {
            if (filterMaterialMap.get(materialGroup) != null) {
                value = value.add(filterMaterialMap.get(materialGroup));
            }
            filterMaterialMap.put(materialGroup, value);
        }
    }

    private Map<String, String> getCostdriverValueKeyToMap(String costdriverValueKey) {
        String[] arr = costdriverValueKey.split("&&");
        HashMap<String, String> map = new HashMap<String, String>(10);
        for (String field : arr) {
            if (StringUtils.isEmpty((String)field)) continue;
            int i = field.indexOf(61);
            String key = field.substring(0, i);
            String val = "";
            if (field.length() > i + 1) {
                val = field.substring(i + 1);
            }
            map.put(key, val);
        }
        return map;
    }

    private String getMatIdToPairMap(RowX rowX) {
        Map<String, String> matIdToPairMap = this.para.getMatIdToPairMap();
        Long org = rowX.getLong(this.sourceRowMeta.getFieldIndex("org"));
        Long material = rowX.getLong(this.sourceRowMeta.getFieldIndex("material"));
        Long matversion = rowX.getLong(this.sourceRowMeta.getFieldIndex("matversion"));
        Long auxpty = rowX.getLong(this.sourceRowMeta.getFieldIndex("auxpty"));
        Long manuorg = rowX.getLong(this.sourceRowMeta.getFieldIndex("manuorg"));
        String strKey = org + "@" + AcaMatAllocHelper.getStrKey(String.valueOf(material), matversion, auxpty, manuorg, null);
        String matIdToPair = matIdToPairMap.get(strKey);
        if (StringUtils.isEmpty((String)matIdToPair)) {
            logger.info("\u83b7\u53d6\u6210\u672c\u5b50\u8981\u7d20\u7684key" + strKey);
            String msg = String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5355\u636e\u201c%1$s\u201d\u4e0b\u7269\u6599\u201c%2$s\u201d\u5bf9\u5e94\u7684\u6210\u672c\u8981\u7d20\u548c\u5b50\u8981\u7d20\u3002", (String)"MatAllocFunction_1", (String)"macc-aca-algox", (Object[])new Object[0]), rowX.get(this.sourceRowMeta.getFieldIndex("billno")), rowX.get(this.sourceRowMeta.getFieldIndex("materialNo")));
            throw new KDBizException(msg);
        }
        return matIdToPair;
    }
}

