/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.util.Tuple2;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.ReadWhere;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.costcalc.ActCostCalcContext;
import kd.macc.aca.algox.costcalc.common.ActCalcReportEntryRow;
import kd.macc.aca.algox.costcalc.common.ActCalcReportHeader;
import kd.macc.aca.algox.costcalc.common.ActTaskRecordEntryRow;
import kd.macc.aca.algox.costcalc.common.ActTaskRecordHeader;
import kd.macc.aca.algox.enums.CalcReportResultEnum;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.AcaAlgoxTimeUtils;
import org.apache.commons.lang3.StringUtils;

public class ActTaskRecorder {
    protected static final Log logger = LogFactory.getLog(ActTaskRecorder.class);
    private IDataEntityType recordHeadType;
    private IDataEntityType recordEntryType;
    private ActTaskRecordHeader taskRecord;
    private ActCalcReportHeader calcReport;

    public IDataEntityType getRecordHeadType() {
        if (this.recordHeadType == null) {
            this.recordHeadType = OrmUtils.getDataEntityType(ActTaskRecordHeader.class);
        }
        return this.recordHeadType;
    }

    public IDataEntityType getRecordEntryType() {
        if (this.recordEntryType == null) {
            this.recordEntryType = OrmUtils.getDataEntityType(ActTaskRecordEntryRow.class);
        }
        return this.recordEntryType;
    }

    public ActTaskRecordHeader getTaskRecord() {
        return this.taskRecord;
    }

    public ActCalcReportHeader getCalcReport() {
        return this.calcReport;
    }

    public void setCalcReport(ActCalcReportHeader calcReport) {
        this.calcReport = calcReport;
    }

    public ActTaskRecordHeader loadOrCreateTaskRecord(ActCostCalcContext context) {
        Long id = context.getInputArgs().getTaskRecordId();
        if (id == null || Long.compare(0L, id) == 0) {
            id = DBServiceHelper.genGlobalLongId();
        } else {
            this.taskRecord = this.loadTaskRecord(id);
            if (this.taskRecord != null) {
                return this.taskRecord;
            }
        }
        this.taskRecord = this.createAndSaveTaskRecord(context, id);
        context.getInputArgs().setTaskRecordId(id);
        return this.taskRecord;
    }

    public void upateTaskRecord(int mProgess, String status) {
        if (this.taskRecord == null) {
            return;
        }
        int totalProgress = this.taskRecord.getProgress() + mProgess;
        logger.info(String.format("\u66f4\u65b0\u8fdb\u5ea6\uff1a %s + %s = %s", this.taskRecord.getProgress(), mProgess, totalProgress));
        if (mProgess >= 100) {
            this.taskRecord.setProgress(100);
        } else if (totalProgress >= 100) {
            this.taskRecord.setProgress(99);
        } else {
            this.taskRecord.setProgress(totalProgress);
        }
        this.taskRecord.setTime(AcaAlgoxTimeUtils.getSecond(this.taskRecord.getStartTime(), new Date()));
        this.taskRecord.setStatus(status);
        this.taskRecord.setDirtyFlag("Progress");
        this.taskRecord.setDirtyFlag("Time");
        this.taskRecord.setDirtyFlag("Status");
        BusinessDataWriter.update((IDataEntityType)this.getRecordHeadType(), (Object[])new Object[]{this.taskRecord});
    }

    public void saveHeader() {
        if (this.taskRecord != null) {
            BusinessDataWriter.update((IDataEntityType)this.getRecordHeadType(), (Object[])new Object[]{this.taskRecord});
        }
    }

    public void updateAndSaveCalcReport() {
        if (this.taskRecord == null) {
            return;
        }
        if (this.calcReport == null) {
            return;
        }
        this.calcReport.setProgress(this.taskRecord.getProgress());
        this.calcReport.setUsetime(this.taskRecord.getTime());
        this.calcReport.setType(this.taskRecord.getStatus());
        this.calcReport.getEntryRows().clear();
        for (Map.Entry<Long, ActTaskRecordEntryRow> entry : this.taskRecord.getEntryRows().entrySet()) {
            ActTaskRecordEntryRow entryRow = entry.getValue();
            ActCalcReportEntryRow rptEntryRow = this.calcReport.addNewEntryRow();
            rptEntryRow.setEntryId(entryRow.getEntryId());
            rptEntryRow.setItem(entryRow.getSubName());
            rptEntryRow.setResult(entryRow.getSubStatus());
            rptEntryRow.setCnsmtime(entryRow.getSubTime() + "");
            rptEntryRow.setCheckdesc(entryRow.getDetail());
        }
        BusinessDataWriter.save((IDataEntityType)ActCalcReportEntryRow.getDataEntityType(), (Object[])this.calcReport.getEntryRows().toArray());
        BusinessDataWriter.update((IDataEntityType)ActCalcReportHeader.getDataEntityType(), (Object[])new Object[]{this.calcReport});
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status, int seq) {
        this.upateTaskRecordDetail(taskConfigDetailId, status, seq, null);
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status, int seq, String detail) {
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getTaskRecord().getId(), (String)"sca_taskrecord");
        if (record != null) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskConfigDetailId.compareTo(entry.getLong("detailconfig")) != 0 || entry.getInt("seq") != seq) continue;
                entry.set("substatus", (Object)status);
                if ("2".equals(status) && entry.getDate("substarttime") == null) {
                    entry.set("substarttime", (Object)new Date());
                }
                if ("4".equals(status) || "7".equals(status) || "8".equals(status)) {
                    long time = AcaAlgoxTimeUtils.getMilliSecond(entry.getDate("substarttime"), new Date());
                    entry.set("subtime", (Object)(time > 0L ? time : 0L));
                }
                if (StringUtils.isEmpty((CharSequence)detail)) continue;
                entry.set("detail", (Object)detail);
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status, int seq, String detail, String subParam, String subNextEntity) {
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getTaskRecord().getId(), (String)"sca_taskrecord");
        if (record != null) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskConfigDetailId.compareTo(entry.getLong("detailconfig")) != 0 || entry.getInt("seq") != seq) continue;
                Long entryId = entry.getLong("id");
                if (this.getTaskRecord().getEntryRows().containsKey(entryId)) {
                    this.getTaskRecord().getEntryRows().get(entryId).setSubStatus(status);
                }
                entry.set("substatus", (Object)status);
                if ("2".equals(status) && entry.getDate("substarttime") == null) {
                    entry.set("substarttime", (Object)new Date());
                }
                if ("4".equals(status) || "7".equals(status)) {
                    long time = AcaAlgoxTimeUtils.getMilliSecond(entry.getDate("substarttime"), new Date());
                    entry.set("subtime", (Object)(time > 0L ? time : 0L));
                }
                entry.set("detail", (Object)detail);
                String infoMsg = entry.getString("subparam_tag");
                infoMsg = infoMsg + subParam;
                entry.set("subparam", (Object)"");
                entry.set("subparam_tag", (Object)infoMsg);
                entry.set("subnextentity", (Object)subNextEntity);
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status) {
        if (this.taskRecord == null || taskConfigDetailId == null) {
            return;
        }
        ActTaskRecordEntryRow recordEntryRow = this.taskRecord.getEntryRows().get(taskConfigDetailId);
        if (recordEntryRow == null) {
            return;
        }
        recordEntryRow.setSubStatus(status);
        recordEntryRow.setDirtyFlag("SubStatus");
        if ("2".equals(status)) {
            recordEntryRow.setSubStartIime(TimeServiceHelper.now());
            recordEntryRow.setDirtyFlag("SubStartIime");
        }
        if ("4".equals(status) || "7".equals(status)) {
            long oldTime = recordEntryRow.getSubTime();
            Long subTime = AcaAlgoxTimeUtils.getMilliSecond(recordEntryRow.getSubStartIime(), TimeServiceHelper.now());
            recordEntryRow.setSubTime(subTime + oldTime);
            recordEntryRow.setDirtyFlag("SubTime");
        }
        BusinessDataWriter.update((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordEntryRow});
    }

    public int saveTaskRecordEntry(String item, Long taskDetailId, String status) {
        return this.saveTaskRecordEntry(item, taskDetailId, status, null);
    }

    public int saveTaskRecordEntry(String item, Long taskDetailId, String status, String bigtext) {
        return (Integer)this.saveTaskRecordEntryRtEntryId((String)item, (Long)taskDetailId, (String)status, (String)bigtext).t1;
    }

    public Tuple2<Integer, Long> saveTaskRecordEntryRtEntryId(String item, Long taskDetailId, String status, String bigtext) {
        if (this.taskRecord == null) {
            return new Tuple2((Object)0, (Object)0L);
        }
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getTaskRecord().getId(), (String)"sca_taskrecord");
        DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
        int seq = entrys.size() + 1;
        long itemId = DBServiceHelper.genGlobalLongId();
        if (record != null) {
            ActTaskRecordEntryRow recordRow = new ActTaskRecordEntryRow();
            recordRow.setEntryId(itemId);
            recordRow.setId(this.getTaskRecord().getId());
            recordRow.setSeq(seq);
            recordRow.setDetailConfig(taskDetailId);
            recordRow.setSubName(item);
            recordRow.setSubStatus(status);
            recordRow.setSubStartIime(new Date());
            recordRow.setSubStatus("1");
            if (StringUtils.isNotEmpty((CharSequence)bigtext)) {
                recordRow.setSubParam("");
                recordRow.setSubParam_Tag(bigtext);
            }
            if (!this.getTaskRecord().getEntryRows().containsKey(recordRow.getDetailConfig())) {
                this.getTaskRecord().getEntryRows().put(recordRow.getDetailConfig(), recordRow);
            } else {
                this.getTaskRecord().getEntryRows().put(recordRow.getEntryId(), recordRow);
            }
            SaveServiceHelper.save((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordRow});
        }
        return new Tuple2((Object)seq, (Object)itemId);
    }

    public void upateTaskRecordDetailPara(Long taskConfigDetailId, String detail, String nextPagePara) {
        if (this.taskRecord == null || taskConfigDetailId == null) {
            return;
        }
        ActTaskRecordEntryRow recordEntryRow = this.taskRecord.getEntryRows().get(taskConfigDetailId);
        if (recordEntryRow == null) {
            return;
        }
        recordEntryRow.setDetail(detail);
        recordEntryRow.setSubParam(nextPagePara);
        recordEntryRow.setDirtyFlag("Detail");
        recordEntryRow.setDirtyFlag("SubParam");
        BusinessDataWriter.update((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordEntryRow});
    }

    private ActTaskRecordHeader createAndSaveTaskRecord(ActCostCalcContext context, Long taskRecordId) {
        DynamicObject taskConfig = context.getTaskConfig();
        ActTaskRecordHeader recordHeader = new ActTaskRecordHeader();
        Date startTime = TimeServiceHelper.now();
        recordHeader.setId(taskRecordId);
        recordHeader.setTaskName(taskConfig.getString("name"));
        recordHeader.setStartTime(startTime);
        recordHeader.setTime(0L);
        recordHeader.setStatus("2");
        recordHeader.setProgress(0);
        recordHeader.setExecutor(RequestContext.get().getCurrUserId());
        recordHeader.setNextPage(taskConfig.getString("nextentity"));
        recordHeader.setTaskConfig(context.getTaskConfigId());
        DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject entry : taskConfigEntrys) {
            ActTaskRecordEntryRow recordRow = new ActTaskRecordEntryRow();
            recordRow.setEntryId(DBServiceHelper.genGlobalLongId());
            recordRow.setId(taskRecordId);
            recordRow.setSeq(seq);
            recordRow.setDetailConfig((Long)entry.getPkValue());
            recordRow.setSubName(entry.getString("subname"));
            recordRow.setSubNextEntity(entry.getString("subnextentity"));
            recordRow.setSubStatus("1");
            if (seq == 1) {
                recordRow.setSubStartIime(startTime);
            }
            recordHeader.getEntryRows().put(recordRow.getDetailConfig(), recordRow);
            ++seq;
        }
        SaveServiceHelper.save((IDataEntityType)this.getRecordHeadType(), (Object[])new Object[]{recordHeader});
        if (!recordHeader.getEntryRows().isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)this.getRecordEntryType(), (Object[])recordHeader.getEntryRows().values().toArray());
        }
        return recordHeader;
    }

    private ActTaskRecordHeader loadTaskRecord(Long taskRecordId) {
        Object[] entryObjs;
        Object[] recordObjs = BusinessDataServiceHelper.load((Object[])new Object[]{taskRecordId}, (IDataEntityType)this.getRecordHeadType());
        if (recordObjs == null || recordObjs.length == 0) {
            return null;
        }
        ActTaskRecordHeader recordHead = (ActTaskRecordHeader)recordObjs[0];
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)this.getRecordEntryType());
        dataManager.setSelectHeadOnly(true);
        ArrayList<SqlParameter> sqlParams = new ArrayList<SqlParameter>(1);
        sqlParams.add(new SqlParameter("fid", -5, (Object)taskRecordId));
        ReadWhere where = new ReadWhere("fid = ?", sqlParams);
        for (Object entryObj : entryObjs = dataManager.read(where)) {
            ActTaskRecordEntryRow entryRow = (ActTaskRecordEntryRow)entryObj;
            recordHead.getEntryRows().put(entryRow.getDetailConfig(), entryRow);
        }
        return recordHead;
    }

    public void upateTaskRecordHander(Long checkResultId, ActCostCalcContext context) {
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(checkResultId)) {
            return;
        }
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingleFromCache((Object)checkResultId, (String)"aca_calcreport");
        if (context.getCheckNoPassCount() > 0) {
            checkResult.set("type", (Object)CalcReportResultEnum.CALCREPORT_FAIL.getValue());
        } else if (context.getCheckRemaindCount() > 0) {
            checkResult.set("type", (Object)"5");
        } else {
            checkResult.set("type", (Object)CalcReportResultEnum.CALCREPORT_SUC.getValue());
        }
        long time = this.taskRecord.getTime();
        if (time <= 0L) {
            time = 1L;
        }
        checkResult.set("usetime", (Object)time);
        checkResult.set("progress", (Object)100);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
    }
}

