/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.costcalc.ActSingleCheckContext;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.action.IActSingleCheckAction;
import kd.macc.aca.algox.costcalc.check.CheckResultInfo;
import kd.macc.aca.algox.enums.CalcReportResultEnum;
import kd.macc.aca.algox.utils.AcaAlgoxTimeUtils;
import kd.macc.aca.algox.utils.LogUtils;

public abstract class AbstractActSingleCheckAction
extends AbstractActCalcAction
implements IActSingleCheckAction {
    public static final String algoKey = "kd.macc.aca.algox.costcalc.check.AbstractActSingleCheckAction";
    private static final Log logger = LogFactory.getLog(AbstractActSingleCheckAction.class);
    private ActSingleCheckContext singCheckContext;
    private Long globalId;
    private Date startRunDate;
    private String itemDesc;

    @Override
    public void setSingCheckContext(ActSingleCheckContext singCheckContext) {
        this.singCheckContext = singCheckContext;
    }

    @Override
    public ActSingleCheckContext getSingCheckContext() {
        return this.singCheckContext;
    }

    @Override
    protected void doExecute() {
        this.globalId = DBServiceHelper.genGlobalLongId();
        this.startRunDate = TimeServiceHelper.now();
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(this.getTaskConfigDetailId(), "2");
        long start = System.currentTimeMillis();
        if (!this.skipCheck()) {
            this.doCheck();
        }
        LogUtils.logInfo(this.getContext().getInputArgs().getCalcReportId(), logger, String.format(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\uff1a%1$s,\u8017\u65f6:%2$s", (String)"AbstractActSingleCheckAction_6", (String)"macc-aca-algox", (Object[])new Object[0]), this.getClass().toString(), System.currentTimeMillis() - start));
        this.getResultManager().getTaskRecorder().upateTaskRecord(this.getSingCheckContext().getUnitProcess(), "2");
        if (this.skipCheck()) {
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail(this.getTaskConfigDetailId(), "1");
        } else {
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail(this.getTaskConfigDetailId(), "4");
        }
    }

    protected abstract void doCheck();

    protected boolean skipCheck() {
        return false;
    }

    public String getItemDesc() {
        return this.itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    protected abstract Long getTaskConfigDetailId();

    protected void dealAuditChecker(DataSet data) {
        DynamicObject checkDetail = this.initCheckDetail();
        DynamicObjectCollection entry = checkDetail.getDynamicObjectCollection("entryentity");
        String tip = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s \u6ca1\u6709\u5ba1\u6838\u3002", (String)"AbstractActSingleCheckAction_1", (String)"macc-aca-algox", (Object[])new Object[0]);
        int unAuditCount = 0;
        for (Row row : data) {
            DynamicObject newEntry = entry.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("checkdetail", (Object)String.format(tip, row.getString("billno")));
            ++unAuditCount;
        }
        CheckResultInfo info = new CheckResultInfo();
        if (unAuditCount == 0) {
            info.setResult(CalcReportResultEnum.CALCREPORT_PASS.getValue());
        } else {
            info.setResult(CalcReportResultEnum.CALCREPORT_NOPASS.getValue());
            info.setCheckdesc(String.format(ResManager.loadKDString((String)"%s\u5f20\u5355\u636e\u6ca1\u6709\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractActSingleCheckAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), unAuditCount));
        }
        this.saveCheckResult(info);
        if (entry.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
    }

    public void dealNoConfirmChecker(DataSet data) {
        DynamicObject checkDetail = this.initCheckDetail();
        DynamicObjectCollection entry = checkDetail.getDynamicObjectCollection("entryentity");
        String tip = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s \u5206\u914d\u72b6\u6001\u2260\u5df2\u786e\u8ba4\u3002", (String)"AbstractActSingleCheckAction_3", (String)"macc-aca-algox", (Object[])new Object[0]);
        int unConfirmCount = 0;
        for (Row row : data) {
            DynamicObject newEntry = entry.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("checkdetail", (Object)String.format(tip, row.getString("billno")));
            ++unConfirmCount;
        }
        CheckResultInfo info = new CheckResultInfo();
        if (unConfirmCount == 0) {
            info.setResult(CalcReportResultEnum.CALCREPORT_PASS.getValue());
        } else {
            info.setResult(CalcReportResultEnum.CALCREPORT_NOPASS.getValue());
            info.setCheckdesc(String.format(ResManager.loadKDString((String)"%s\u5f20\u5355\u636e\u6ca1\u6709\u786e\u8ba4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractActSingleCheckAction_4", (String)"macc-aca-algox", (Object[])new Object[0]), unConfirmCount));
        }
        this.saveCheckResult(info);
        if (entry.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
    }

    protected void saveCheckResult(CheckResultInfo info) {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getContext().getInputArgs().getCheckResultId(), (String)"aca_calcreport");
        DynamicObjectCollection entrys = checkResult.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entrys.addNew();
        entry.set("id", (Object)this.globalId);
        entry.set("seq", (Object)entrys.size());
        entry.set("item", (Object)this.getItemDesc());
        entry.set("cnsmtime", (Object)AcaAlgoxTimeUtils.getMilliSecond(this.startRunDate, TimeServiceHelper.now()));
        entry.set("result", (Object)info.getResult());
        if (CalcReportResultEnum.CALCREPORT_NOPASS.getValue().equals(info.getResult())) {
            checkResult.set("type", (Object)CalcReportResultEnum.CALCREPORT_FAIL.getValue());
        }
        if (info.getCheckdesc() != null) {
            entry.set("checkdesc", (Object)(info.getCheckdesc().length() > 255 ? info.getCheckdesc().substring(0, 252) : info.getCheckdesc()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
    }

    protected DynamicObject initCheckDetail() {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getContext().getInputArgs().getCheckResultId(), (String)"aca_calcreport");
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"aca_calcreportdetail");
        checkDetail.set("id", (Object)this.globalId);
        checkDetail.set("org", (Object)this.getContext().getInputArgs().getOrgId());
        checkDetail.set("costaccount", (Object)this.getContext().getInputArgs().getCostAccountId());
        checkDetail.set("period", (Object)this.getContext().getInputArgs().getPeriodId());
        checkDetail.set("currency", (Object)this.getContext().getInputArgs().getCurrencyId());
        checkDetail.set("calcdate", checkResult.get("calcdate"));
        checkDetail.set("checkitemdesc", (Object)this.getItemDesc());
        return checkDetail;
    }
}

