/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import java.util.Date;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.aca.algox.constants.TerminalCalcCheck;
import kd.macc.aca.algox.costcalc.ActCalcTaskType;
import kd.macc.aca.algox.costcalc.ActTaskRecorder;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.ActTaskRecordEntryRow;
import kd.macc.aca.algox.costcalc.common.ActTaskRecordHeader;
import kd.macc.aca.algox.utils.AcaAlgoxCheckHelper;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.TimeUtils;
import net.sf.json.JSONObject;

public class ActAfterCalcAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(ActAfterCalcAction.class);
    private ActTaskRecorder taskRecorder;

    @Override
    protected void doExecute() {
        String logUniqueKey = this.getContext().getInputArgs().getGetLogUniqueKey();
        LogUtils.logInfo(logUniqueKey, logger, "ActAfterCalcAction.doExecute() begin");
        this.taskRecorder = this.getResultManager().getTaskRecorder();
        this.taskRecorder.upateTaskRecordDetail(TerminalCalcCheck.DEALCALCRESULT, "2");
        if (this.getContext().getTaskType() == ActCalcTaskType.PeriodEndCalcCheck) {
            this.afterCheckOnly();
        } else {
            this.afterCalc();
        }
        this.taskRecorder.upateTaskRecordDetail(TerminalCalcCheck.DEALCALCRESULT, "4");
    }

    private void afterCheckOnly() {
        ActTaskRecordHeader taskRecord = this.getResultManager().getTaskRecorder().getTaskRecord();
        if (taskRecord != null) {
            if ("2".equals(taskRecord.getStatus())) {
                taskRecord.setStatus("4");
                taskRecord.setDirtyFlag("Status");
            }
            JSONObject subPagePara = new JSONObject();
            subPagePara.accumulate("checkResultId", (Object)this.getContext().getInputArgs().getCheckResultId());
            taskRecord.setNextPagePara(subPagePara.toString());
            taskRecord.setDirtyFlag("NextPagePara");
            this.getResultManager().getTaskRecorder().saveHeader();
        }
    }

    private void afterCalc() {
        this.updateTaskRecord();
    }

    private void updateTaskRecord() {
        Long time = TimeUtils.getSecondTime((Date)this.taskRecorder.getTaskRecord().getStartTime(), (Date)new Date());
        if (Long.compare(0L, time) == 0) {
            time = 1L;
        }
        this.taskRecorder.getTaskRecord().setTime(time);
        int failCount = AcaAlgoxCheckHelper.getCheckFailCount(this.getContext().getInputArgs().getCheckResultId());
        ActCostCalcArgs args = this.getContext().getInputArgs();
        JSONObject pagePara = new JSONObject();
        pagePara.accumulate("orgId", (Object)args.getOrgId());
        pagePara.accumulate("costAccountId", (Object)args.getCostAccountId());
        pagePara.accumulate("periodId", (Object)args.getPeriodId());
        pagePara.accumulate("manuorgId", args.getManuOrgId() == null ? 0L : args.getManuOrgId());
        pagePara.accumulate("time", (Object)time);
        pagePara.accumulate("checkFailCount", failCount);
        pagePara.accumulate("checkResultId", (Object)this.getContext().getInputArgs().getCheckResultId());
        pagePara.accumulate("calcReportId", (Object)args.getCalcReportId());
        pagePara.accumulate("calcReduct", (Object)args.getCalcReduct());
        pagePara.accumulate("currencyId", (Object)args.getCurrencyId());
        pagePara.accumulate("srcCalcJsonStr", (Object)args.getSrcCalcJsonStr());
        pagePara.accumulate("currCalcIndex", args.getCurrCalcIndex());
        ActTaskRecordHeader taskRecord = this.taskRecorder.getTaskRecord();
        if (failCount > 0) {
            pagePara.accumulate("failCcCount", args.getResultCostCenterIds().size());
            pagePara.accumulate("successCcCount", 0);
            pagePara.accumulate("successCoCount", 0);
            this.taskRecorder.getTaskRecord().setTime(0L);
            taskRecord.setStatus("3");
        } else {
            pagePara.accumulate("failCcCount", 0);
            pagePara.accumulate("successCcCount", args.isOnlycheckresult() ? 1 : args.getResultCostCenterIds().size());
            pagePara.accumulate("successCoCount", args.getResultCostObjectIds().size());
            Map<Long, ActTaskRecordEntryRow> entryRows = taskRecord.getEntryRows();
            boolean isWarn = false;
            boolean isError = false;
            for (ActTaskRecordEntryRow row : entryRows.values()) {
                if ("3".equals(row.getSubStatus())) {
                    isError = true;
                    continue;
                }
                if (!"7".equals(row.getSubStatus())) continue;
                isWarn = true;
            }
            if (isError) {
                taskRecord.setStatus("3");
                pagePara.put((Object)"successCcCount", (Object)0);
            } else if (isWarn) {
                taskRecord.setStatus("5");
            } else {
                taskRecord.setStatus("4");
            }
        }
        taskRecord.setNextPagePara(pagePara.toString());
        taskRecord.setProgress(100);
        taskRecord.setDirtyFlag("Time");
        taskRecord.setDirtyFlag("NextPagePara");
        taskRecord.setDirtyFlag("Progress");
        taskRecord.setDirtyFlag("Status");
        this.taskRecorder.saveHeader();
    }
}

