/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.common.MatCalcParam;
import kd.macc.aca.algox.common.TaskConfigConstant;
import kd.macc.aca.algox.costcalc.ActTaskRecorder;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCalcHelper;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.report.MatCalcAnalRptAlgoxService;
import kd.macc.aca.algox.report.MfgcoCalcAnalRptAlgoxService;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class ActAnalAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(ActAnalAction.class);
    private ActTaskRecorder taskRecorder;
    private static final int MAX_ERROR_SIZE = 2000;
    private QFilter curBaseFilter = null;
    private QFilter preBaseFilter = null;
    private boolean setError = false;

    @Override
    protected void doExecute() {
        ActCostCalcArgs args = this.getContext().getInputArgs();
        if (!(args.isOnlycheckresult() || args.getCalc() && args.getCalccmpanal().booleanValue())) {
            LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"ActAnalAction \u5b9e\u9645\u6210\u672c\u8ba1\u7b97-\u8ba1\u7b97\u7ed3\u679c\u5355\u5bf9\u8d26\u5904\u7406\uff1a\u9000\u51fa\uff0cisCalc = false", (String)"ActAnalAction_5", (String)"macc-aca-algox", (Object[])new Object[0]));
            return;
        }
        this.taskRecorder = this.getResultManager().getTaskRecorder();
        ActCostCalcArgs dataArgs = this.getContext().getInputArgs();
        QFilter costaccountFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        costaccountFilter.and("costaccount", "=", (Object)dataArgs.getCostAccountId());
        this.curBaseFilter = new QFilter("period", "=", (Object)dataArgs.getPeriodId());
        this.curBaseFilter.and(costaccountFilter);
        this.preBaseFilter = new QFilter("period", "=", (Object)dataArgs.getPrePeriodId());
        this.preBaseFilter.and(costaccountFilter);
        this.setError = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"calcCheckResultStu", (String)"0"));
        logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97-\u8ba1\u7b97\u7ed3\u679c\u5355\u5bf9\u8d26\u5904\u7406\uff1a\u5f00\u59cb!");
        int unitProgess = 3;
        this.matInputCheck(unitProgess);
        this.mfgInputCheck(unitProgess);
        this.calcDataCheck();
        this.calcMainJoinFactAmtCheck();
        this.calcPrePeriodAndCurPeriodCheck();
        this.calcComAmtAndFactAmtCheck();
        this.calcOutsourceTypeCheck();
        this.calcMatAllocAndActAmtCheck();
        if (args.isCalbyCostElement()) {
            this.calcCompAndSubAmtCheck();
            this.calcMatComAndSubAmtCheck();
        }
        logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97-\u8ba1\u7b97\u7ed3\u679c\u5355\u5bf9\u8d26\u5904\u7406\uff1a\u7ed3\u675f!");
    }

    private void calcMatComAndSubAmtCheck() {
        ActCostCalcArgs dataArgs = this.getContext().getInputArgs();
        String sqlSelect = "costcenter,costobject,entryentity.submaterial submaterial,entryentity.pdstartamount startamt,entryentity.startadjamt startadjamt,entryentity.pdcurramount curramt,entryentity.currcomamount comamt,entryentity.pdendamount endamt,0.0 substartamt,0.0 substartadjamt,0.0 subcurramt,0.0 subcomamt,0.0 subendamt";
        QFilter typeFilter = new QFilter("entryentity.submaterial", ">", (Object)0L);
        typeFilter.and("entryentity.type", "=", (Object)"detail");
        DataSet endDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter}, null);
        sqlSelect = "costcenter,costobject,entryentity.submaterial submaterial,0.0 startamt,0.0 startadjamt,0.0 curramt,0.0 comamt,0.0 endamt,entryentity.subdetail.spdstartamt substartamt,entryentity.subdetail.spdstartadjamt substartadjamt,entryentity.subdetail.spdcurramt subcurramt,entryentity.subdetail.spdcomamt subcomamt,entryentity.subdetail.spdendamt subendamt";
        DataSet startDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter}, null);
        DataSet resultDs = endDataSet.union(startDataSet);
        DataSet compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "submaterial"}).sum("startamt").sum("startadjamt").sum("curramt").sum("comamt").sum("endamt").sum("substartamt").sum("substartadjamt").sum("subcurramt").sum("subcomamt").sum("subendamt").finish();
        compareDs = this.dealDataZeroDs(compareDs, new String[]{"startamt", "startadjamt", "curramt", "comamt", "endamt", "substartamt", "substartadjamt", "subcurramt", "subcomamt", "subendamt"});
        DataSet resultCompDs = compareDs.filter("startamt-substartamt<>0 or startadjamt-substartadjamt<>0 or curramt-subcurramt<>0 or comamt-subcomamt<>0 or endamt-subendamt<>0 ");
        if (resultCompDs.isEmpty()) {
            return;
        }
        DataSet copyDs = resultCompDs.copy();
        HashSet<Long> costobjectIds = new HashSet<Long>(10);
        HashSet<Long> submatIds = new HashSet<Long>(10);
        for (Row row : copyDs) {
            costobjectIds.add(row.getLong("costobject"));
            submatIds.add(row.getLong("submaterial"));
        }
        String curItem = ResManager.loadKDString((String)"\u5206\u9879\u4e0e\u7efc\u5408\u5b8c\u5de5\u6210\u672c\u7684\u68c0\u67e5", (String)"ActAnalAction_6", (String)"macc-aca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u542f\u7528\u5206\u9879\u7ed3\u8f6c\u540e\uff0c\u68c0\u67e5\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u6309\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u7ef4\u5ea6\u68c0\u67e5\u5206\u9879\u603b\u6210\u672c\u662f\u5426\u7b49\u4e8e\u7efc\u5408\u603b\u6210\u672c\u3002", (String)"ActAnalAction_7", (String)"macc-aca-algox", (Object[])new Object[0]);
        DynamicObject checkDetail = this.getTaskRecordEntry(dataArgs, curItem, detail);
        resultCompDs = this.relaCostObjectData(resultCompDs, costobjectIds, null);
        resultCompDs = this.relaMatData(resultCompDs, submatIds, new String[]{"costcenter", "costobject", "submaterial"});
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : resultCompDs) {
            DynamicObject newEntry;
            if (seq > 2000) break;
            BigDecimal startamt = BigDecimalUtil.getOrZero(row.getBigDecimal("startamt"));
            BigDecimal substartamt = BigDecimalUtil.getOrZero(row.getBigDecimal("substartamt"));
            BigDecimal startadjamt = BigDecimalUtil.getOrZero(row.getBigDecimal("startadjamt"));
            BigDecimal substartadjamt = BigDecimalUtil.getOrZero(row.getBigDecimal("substartadjamt"));
            BigDecimal curramt = BigDecimalUtil.getOrZero(row.getBigDecimal("curramt"));
            BigDecimal subcurramt = BigDecimalUtil.getOrZero(row.getBigDecimal("subcurramt"));
            BigDecimal comamt = BigDecimalUtil.getOrZero(row.getBigDecimal("comamt"));
            BigDecimal subcomamt = BigDecimalUtil.getOrZero(row.getBigDecimal("subcomamt"));
            BigDecimal endamt = BigDecimalUtil.getOrZero(row.getBigDecimal("endamt"));
            BigDecimal subendamt = BigDecimalUtil.getOrZero(row.getBigDecimal("subendamt"));
            if (startamt.compareTo(substartamt) != 0) {
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
                newEntry.set("status", (Object)"1");
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u5b50\u7269\u6599\u3010%3$s/%4$s\u3011\u4e0d\u6ee1\u8db3\u201c\u7efc\u5408\u671f\u521d\u6210\u672c\u3010%5$s\u3011=\u5206\u9879\u671f\u521d\u6210\u672c\u3010%6$s\u3011\u201d\u3002", (String)"ActAnalAction_27", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), row.getString("matNo"), row.getString("matName"), this.getBigDecimalStr(startamt), this.getBigDecimalStr(substartamt))));
                newEntry.set("seq", (Object)seq++);
            }
            if (startadjamt.compareTo(substartadjamt) != 0) {
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
                newEntry.set("status", (Object)"1");
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u5b50\u7269\u6599\u3010%3$s/%4$s\u3011\u4e0d\u6ee1\u8db3\u201c\u7efc\u5408\u671f\u521d\u8c03\u6574\u6210\u672c\u3010%5$s\u3011=\u5206\u9879\u671f\u521d\u8c03\u6574\u6210\u672c\u3010%6$s\u3011\u201d\u3002", (String)"ActAnalAction_28", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), row.getString("matNo"), row.getString("matName"), this.getBigDecimalStr(startadjamt), this.getBigDecimalStr(substartadjamt))));
                newEntry.set("seq", (Object)seq++);
            }
            if (curramt.compareTo(subcurramt) != 0) {
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
                newEntry.set("status", (Object)"1");
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u5b50\u7269\u6599\u3010%3$s/%4$s\u3011\u4e0d\u6ee1\u8db3\u201c\u7efc\u5408\u6295\u5165\u6210\u672c\u3010%5$s\u3011=\u5206\u9879\u6295\u5165\u6210\u672c\u3010%6$s\u3011\u201d\u3002", (String)"ActAnalAction_29", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), row.getString("matNo"), row.getString("matName"), this.getBigDecimalStr(curramt), this.getBigDecimalStr(subcurramt))));
                newEntry.set("seq", (Object)seq++);
            }
            if (comamt.compareTo(subcomamt) != 0) {
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
                newEntry.set("status", (Object)"1");
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u5b50\u7269\u6599\u3010%3$s/%4$s\u3011\u4e0d\u6ee1\u8db3\u201c\u7efc\u5408\u5b8c\u5de5\u6210\u672c\u3010%5$s\u3011=\u5206\u9879\u5b8c\u5de5\u6210\u672c\u3010%6$s\u3011\u201d\u3002", (String)"ActAnalAction_30", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), row.getString("matNo"), row.getString("matName"), this.getBigDecimalStr(comamt), this.getBigDecimalStr(subcomamt))));
                newEntry.set("seq", (Object)seq++);
            }
            if (endamt.compareTo(subendamt) == 0) continue;
            newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("status", (Object)"1");
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u5b50\u7269\u6599\u3010%3$s/%4$s\u3011\u4e0d\u6ee1\u8db3\u201c\u7efc\u5408\u671f\u672b\u6210\u672c\u3010%5$s\u3011=\u5206\u9879\u671f\u672b\u6210\u672c\u3010%6$s\u3011\u201d\u3002", (String)"ActAnalAction_31", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), row.getString("matNo"), row.getString("matName"), this.getBigDecimalStr(endamt), this.getBigDecimalStr(subendamt))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
    }

    private void calcCompAndSubAmtCheck() {
        ActCostCalcArgs dataArgs = this.getContext().getInputArgs();
        String sqlSelect = "inventoryentryentity.invcostobject.costcenter costcenter,inventoryentryentity.invcostobject costobject,inventoryentryentity.inventoryamount as compamt,0.0 subamt";
        QFilter typeFilter = new QFilter("inventoryentryentity.carrytype", "=", (Object)"A");
        DataSet compDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter}, null);
        sqlSelect = "inventoryentryentity.invcostobject.costcenter costcenter,inventoryentryentity.invcostobject costobject,0.0 as compamt,inventoryentryentity.inventoryamount subamt";
        typeFilter = new QFilter("inventoryentryentity.carrytype", "=", (Object)"B");
        DataSet subDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter}, null);
        DataSet compareDs = compDataSet.union(subDataSet);
        compareDs = compareDs.groupBy(new String[]{"costcenter", "costobject"}).sum("compamt").sum("subamt").finish();
        compareDs = this.dealDataZeroDs(compareDs, new String[]{"compamt", "subamt"});
        if ((compareDs = compareDs.filter("compamt-subamt!=0")).isEmpty()) {
            logger.info("calcCompAndSubAmtCheck-nodiff");
            return;
        }
        logger.info("calcCompAndSubAmtCheck-hasdiff");
        Set<Long> costobjectIds = ActCalcHelper.getLongIdSetFromDs(compareDs, "costobject", true);
        String curItem = ResManager.loadKDString((String)"\u5206\u9879\u4e0e\u7efc\u5408\u5b8c\u5de5\u6210\u672c\u7684\u68c0\u67e5", (String)"ActAnalAction_6", (String)"macc-aca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u542f\u7528\u5206\u9879\u7ed3\u8f6c\u540e\uff0c\u68c0\u67e5\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u6309\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u7ef4\u5ea6\u68c0\u67e5\u5206\u9879\u603b\u6210\u672c\u662f\u5426\u7b49\u4e8e\u7efc\u5408\u603b\u6210\u672c\u3002", (String)"ActAnalAction_7", (String)"macc-aca-algox", (Object[])new Object[0]);
        DynamicObject checkDetail = this.getTaskRecordEntry(dataArgs, curItem, detail);
        compareDs = this.relaCostObjectData(compareDs, costobjectIds, new String[]{"costcenter", "costobjectNo"});
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("status", (Object)"1");
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u7efc\u5408\u5b8c\u5de5\u6210\u672c\u3010%3$s\u3011=\u5206\u9879\u5b8c\u5de5\u6210\u672c\u3010%4$s\u3011\u201d\u3002", (String)"ActAnalAction_8", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), this.getBigDecimalStr(row.getBigDecimal("compamt")), this.getBigDecimalStr(row.getBigDecimal("subamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
    }

    private void calcMatAllocAndActAmtCheck() {
        ActCostCalcArgs dataArgs = this.getContext().getInputArgs();
        QFilter filter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        filter.and("costaccount", "=", (Object)dataArgs.getCostAccountId());
        filter.and("period", "=", (Object)dataArgs.getPeriodId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("srcbilltype", "!=", (Object)"cal_costadjust_subentity");
        DataSet matallocDs = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_matalloc", (String)"billno,costcenter,matcollect,useamount", (QFilter[])filter.toArray(), null);
        filter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        filter.and("bookdate", ">=", (Object)dataArgs.getStartDate());
        filter.and("bookdate", "<=", (Object)dataArgs.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)"aca");
        DataSet matCollectDs = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_matusecollect", (String)"entryentity.id as entryentityid,entryentity.sourcebillentryid AS sourcebillentryid", (QFilter[])filter.toArray(), null);
        filter = new QFilter("calorg", "=", (Object)dataArgs.getOrgId());
        filter.and("costaccount", "=", (Object)dataArgs.getCostAccountId());
        filter.and("bookdate", ">=", (Object)dataArgs.getStartDate());
        filter.and("bookdate", "<=", (Object)dataArgs.getEndDate());
        filter.and("calbilltype", "=", (Object)"OUT");
        filter.and("billstatus", "=", (Object)"C");
        DataSet matCostRecordDs = QueryServiceHelper.queryDataSet((String)"MatAllocCostDiffCheckAction_getCostRecord", (String)"cal_costrecord_subentity", (String)"entry.bizbillentryid entryid,entry.actualcost as actualcost", (QFilter[])filter.toArray(), null);
        DataSet resultDs = matallocDs.leftJoin(matCollectDs).on("matcollect", "entryentityid").select(matallocDs.getRowMeta().getFieldNames(), new String[]{"sourcebillentryid"}).finish();
        resultDs = resultDs.leftJoin(matCostRecordDs).on("sourcebillentryid", "entryid").select(resultDs.getRowMeta().getFieldNames(), new String[]{"actualcost"}).finish();
        resultDs = this.dealDataZeroDs(resultDs, new String[]{"actualcost"});
        resultDs = resultDs.filter("useamount-actualcost!=0");
        if (resultDs.isEmpty()) {
            logger.info("calcMatAllocAndActAmtCheck-nodiff");
            return;
        }
        logger.info("calcMatAllocAndActAmtCheck-hasdiff");
        String curItem = ResManager.loadKDString((String)"\u6750\u6599\u5206\u914d\u7ed3\u679c\u8868\u4e0e\u5bf9\u5e94\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u7684\u68c0\u67e5", (String)"ActAnalAction_9", (String)"macc-aca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u68c0\u67e5\u6210\u672c\u8ba1\u7b97\u4e4b\u540e\uff0c\u6750\u6599\u5206\u914d\u6570\u636e\u662f\u5426\u4e0e\u5bf9\u5e94\u4e1a\u52a1\u5355\u636e\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u7684\u6210\u672c\u4e00\u81f4\u3002", (String)"ActAnalAction_10", (String)"macc-aca-algox", (Object[])new Object[0]);
        DynamicObject checkDetail = this.getTaskRecordEntry(dataArgs, curItem, detail);
        resultDs = resultDs.orderBy(new String[]{"costcenter", "billno"});
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : resultDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("status", (Object)"1");
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u3010%1$s\u3011\u91d1\u989d\u3010%2$s\u3011\u4e0e\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u4e0a\u7684\u5b9e\u9645\u6210\u672c\u3010%3$s\u3011\u4e0d\u4e00\u81f4\u3002", (String)"ActAnalAction_11", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("billno"), this.getBigDecimalStr(row.getBigDecimal("useamount")), this.getBigDecimalStr(row.getBigDecimal("actualcost")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
    }

    private void calcOutsourceTypeCheck() {
        ActCostCalcArgs dataArgs = this.getContext().getInputArgs();
        String sqlSelect = "costcenter,entryentity.relacostobject costobject,entryentity.subelement subelement";
        QFilter typeFilter = new QFilter("entryentity.type", "=", (Object)"detail");
        typeFilter.and("entryentity.relaproducttype", "=", (Object)"C");
        typeFilter.and("entryentity.outsourcetype", "=", (Object)" ");
        typeFilter.and("costobject.isoutsource", "=", (Object)Boolean.TRUE);
        DataSet curDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter}, null);
        DataSet compareDs = curDataSet.groupBy(new String[]{"costcenter", "costobject", "subelement"}).finish();
        if (compareDs.isEmpty()) {
            logger.info("calcOutsourceTypeCheck-nodiff");
            return;
        }
        logger.info("calcOutsourceTypeCheck-hasdiff");
        Set<Long> costobjectIds = ActCalcHelper.getLongIdSetFromDs(compareDs, "costobject", true);
        String curItem = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u5404\u6210\u672c\u5b50\u8981\u7d20\u5404\u884c\u59d4\u5916\u6210\u672c\u7c7b\u578b\u6709\u503c\u7684\u68c0\u67e5", (String)"ActAnalAction_12", (String)"macc-aca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u68c0\u67e5\u59d4\u5916\u5de5\u5355\u7684\u6210\u672c\u7ed3\u6784\u4e2d\uff0c\u59d4\u5916\u6210\u672c\u7c7b\u578b\u6709\u5bf9\u5e94\u6570\u503c\u3002", (String)"ActAnalAction_13", (String)"macc-aca-algox", (Object[])new Object[0]);
        DynamicObject checkDetail = this.getTaskRecordEntry(dataArgs, curItem, detail);
        compareDs = this.relaSubElementAndCostObjectData(compareDs, costobjectIds, new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("status", (Object)"1");
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u6210\u672c\u5b50\u8981\u7d20\u3010%3$s/%4$s\u3011\u5b58\u5728\u59d4\u5916\u6210\u672c\u7c7b\u578b\u4e3a\u7a7a\u7684\u6570\u636e\u201d\u3002", (String)"ActAnalAction_14", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), row.getString("subelementNo"), row.getString("subelementName"))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
    }

    private void calcComAmtAndFactAmtCheck() {
        ActCostCalcArgs dataArgs = this.getContext().getInputArgs();
        String sqlSelect = "inventoryentryentity.sourcebillentry sourcebillentry,inventoryentryentity.inventoryamount as compamt";
        QFilter typeFilter = new QFilter("inventoryentryentity.carrytype", "!=", (Object)"B");
        if (dataArgs.isCalbyCostElement()) {
            typeFilter = new QFilter("inventoryentryentity.carrytype", "=", (Object)"B");
        }
        DataSet compDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter}, null);
        compDataSet = compDataSet.groupBy(new String[]{"sourcebillentry"}).sum("compamt").finish();
        Set<Long> sourcebillentryIds = ActCalcHelper.getLongIdSetFromDs(compDataSet, "sourcebillentry", true);
        String fields = "entry.bizbillentryid bizbillentryid,entry.actualcost actualcost";
        QFilter resultFilter = new QFilter("billstatus", "=", (Object)"C");
        resultFilter.and("costaccount", "=", (Object)dataArgs.getCostAccountId());
        resultFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        resultFilter.and("bookdate", ">=", (Object)dataArgs.getStartDate());
        resultFilter.and("bookdate", "<=", (Object)dataArgs.getEndDate());
        DataSet factDataSet = InFilterHelper.queryDataSetIn((String)"cal_costrecord_subentity", (String)fields, (QFilter)resultFilter, (String)"entry.bizbillentryid", new ArrayList<Long>(sourcebillentryIds));
        DataSet compareDs = compDataSet.leftJoin(factDataSet).on("sourcebillentry", "bizbillentryid").select(new String[]{"sourcebillentry", "compamt"}, new String[]{"actualcost"}).finish();
        compareDs = this.dealDataZeroDs(compareDs, new String[]{"compamt", "actualcost"});
        compareDs = compareDs.filter("compamt-actualcost!=0");
        if (compareDs.isEmpty()) {
            logger.info("calcComAmtAndFactAmtCheck-nodiff");
            return;
        }
        logger.info("calcComAmtAndFactAmtCheck-hasdiff");
        sourcebillentryIds = ActCalcHelper.getLongIdSetFromDs(compareDs, "sourcebillentry", true);
        QFilter filter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)dataArgs.getStartDate());
        filter.and("bookdate", "<=", (Object)dataArgs.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        if (sourcebillentryIds.size() < 2000) {
            filter.and("sourcebillentry", "in", sourcebillentryIds);
        }
        String selectFields = "billno,costcenter,sourcebillentry as srcEntryId";
        DataSet factBillDataSet = QueryServiceHelper.queryDataSet((String)"fact", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        DataSet resultDs = compareDs.leftJoin(factBillDataSet).on("sourcebillentry", "srcEntryId").select(new String[]{"sourcebillentry", "compamt", "actualcost"}, new String[]{"billno", "costcenter"}).finish();
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u5b8c\u5de5\u6210\u672c\u4e0e\u5b8c\u5de5\u5165\u5e93\u6210\u672c\u5b58\u5728\u5dee\u5f02", (String)"ActAnalAction_15", (String)"macc-aca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u68c0\u67e5\u5b8c\u5de5\u6210\u672c\u4e0e\u5173\u8054\u7684\u5b8c\u5de5\u5165\u5e93\u5355\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u662f\u5426\u5b58\u5728\u5dee\u5f02\u3002", (String)"ActAnalAction_16", (String)"macc-aca-algox", (Object[])new Object[0]);
        DynamicObject checkDetail = this.getTaskRecordEntry(dataArgs, curItem, detail);
        resultDs = resultDs.orderBy(new String[]{"costcenter", "billno"});
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : resultDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("status", (Object)"1");
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3010%1$s\u3011\u4e0d\u6ee1\u8db3\u201c\u5b8c\u5de5\u5165\u5e93\u6210\u672c\u3010%2$s\u3011=\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u4e0a\u7684\u5b9e\u9645\u6210\u672c\u3010%3$s\u3011\u201d\u3002", (String)"ActAnalAction_17", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("billno"), this.getBigDecimalStr(row.getBigDecimal("compamt")), this.getBigDecimalStr(row.getBigDecimal("actualcost")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
    }

    private void calcPrePeriodAndCurPeriodCheck() {
        ActCostCalcArgs dataArgs = this.getContext().getInputArgs();
        String sqlSelect = "entryentity.relacostobject costobject,entryentity.pdendamount+entryentity.endadjamt as endamt,0.0 startamt";
        QFilter typeFilter = new QFilter("entryentity.type", "=", (Object)"finalResult");
        DataSet endDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.preBaseFilter}, null);
        sqlSelect = "entryentity.relacostobject costobject,0.0 as endamt,entryentity.pdstartamount startamt";
        DataSet startDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter}, null);
        DataSet resultDs = endDataSet.union(startDataSet);
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("endamt").sum("startamt").finish();
        compareDs = this.dealDataZeroDs(compareDs, new String[]{"endamt", "startamt"});
        if ((compareDs = compareDs.filter("endamt-startamt!=0")).isEmpty()) {
            logger.info("calcPrePeriodAndCurPeriodCheck-nodiff");
            return;
        }
        logger.info("calcPrePeriodAndCurPeriodCheck-hasdiff");
        Set<Long> costobjectIds = ActCalcHelper.getLongIdSetFromDs(compareDs, "costobject", false);
        sqlSelect = "entryentity.relacostobject.costcenter costcenter,entryentity.relacostobject costobject,entryentity.subelement subelement,entryentity.pdendamount endamt,entryentity.endadjamt as endadjamt,0.0 startamt";
        QFilter rangeQFilter = new QFilter("entryentity.relacostobject", "in", costobjectIds);
        typeFilter = new QFilter("entryentity.type", "=", (Object)"detail");
        endDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.preBaseFilter, rangeQFilter}, null);
        sqlSelect = "entryentity.relacostobject.costcenter costcenter,entryentity.relacostobject costobject,entryentity.subelement subelement,0.0 as endamt,0.0 as endadjamt,entryentity.pdstartamount startamt";
        startDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter, rangeQFilter}, null);
        resultDs = endDataSet.union(startDataSet);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("endamt").sum("endadjamt").sum("startamt").finish();
        compareDs = this.dealDataZeroDs(compareDs, new String[]{"endamt", "endadjamt", "startamt"});
        compareDs = compareDs.filter("endamt+endadjamt-startamt!=0");
        if (compareDs.isEmpty()) {
            return;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u671f\u521d\u6210\u672c\u4e0e\u4e0a\u671f\u671f\u672b\u662f\u5426\u4e00\u81f4", (String)"ActAnalAction_18", (String)"macc-aca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u68c0\u67e5\u671f\u521d\u6210\u672c\u4e0e\u4e0a\u671f\u671f\u672b+\u671f\u672b\u8c03\u6574\u6210\u672c\u662f\u5426\u5b58\u5728\u5dee\u5f02\u3002", (String)"ActAnalAction_19", (String)"macc-aca-algox", (Object[])new Object[0]);
        DynamicObject checkDetail = this.getTaskRecordEntry(dataArgs, curItem, detail);
        compareDs = this.relaSubElementAndCostObjectData(compareDs, costobjectIds, new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("status", (Object)"1");
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u6210\u672c\u5b50\u8981\u7d20\u3010%3$s/%4$s\u3011\u4e0d\u6ee1\u8db3\u201c\u4e0a\u671f\u671f\u672b\u6210\u672c\u3010%5$s\u3011+\u671f\u672b\u8c03\u6574\u6210\u672c\u3010%6$s\u3011=\u672c\u671f\u671f\u521d\u6210\u672c\u3010%7$s\u3011\u201d\u3002", (String)"ActAnalAction_20", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("endamt")), this.getBigDecimalStr(row.getBigDecimal("endadjamt")), this.getBigDecimalStr(row.getBigDecimal("startamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
    }

    private void calcMainJoinFactAmtCheck() {
        ActCostCalcArgs dataArgs = this.getContext().getInputArgs();
        String sqlSelect = "entryentity.relacostobject costobject,entryentity.currcomamount as compamt,0.0 factamt";
        QFilter amtFilter = new QFilter("entryentity.currcomamount", "!=", (Object)BigDecimal.ZERO);
        QFilter typeFilter = new QFilter("entryentity.type", "=", (Object)"finalResult");
        DataSet compDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter, amtFilter}, null);
        sqlSelect = "inventoryentryentity.invcostobject costobject,0.0 compamt,inventoryentryentity.inventoryamount as factamt";
        typeFilter = new QFilter("inventoryentryentity.carrytype", "!=", (Object)"B");
        DataSet factDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter}, null);
        DataSet resultDs = compDataSet.union(factDataSet);
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("compamt").sum("factamt").finish();
        compareDs = this.dealDataZeroDs(compareDs, new String[]{"compamt", "factamt"});
        if ((compareDs = compareDs.filter("compamt-factamt!=0")).isEmpty()) {
            logger.info("calcMainJoinFactAmtCheck-nodiff");
            return;
        }
        logger.info("calcMainJoinFactAmtCheck-hasdiff");
        Set<Long> costobjectIds = ActCalcHelper.getLongIdSetFromDs(compareDs, "costobject", false);
        sqlSelect = "entryentity.relacostobject.costcenter costcenter,entryentity.relacostobject costobject,entryentity.subelement subelement,entryentity.currcomamount as compamt,0.0 factamt";
        amtFilter = new QFilter("entryentity.currcomamount", "!=", (Object)BigDecimal.ZERO);
        typeFilter = new QFilter("entryentity.type", "=", (Object)"detail");
        QFilter rangeQFilter = new QFilter("entryentity.relacostobject", "in", costobjectIds);
        compDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter, amtFilter, rangeQFilter}, null);
        sqlSelect = "inventoryentryentity.invcostobject.costcenter costcenter,inventoryentryentity.invcostobject costobject,inventoryentryentity.inventorysubelement subelement,0.0 compamt,inventoryentryentity.inventoryamount as factamt";
        typeFilter = new QFilter("inventoryentryentity.carrytype", "!=", (Object)"B");
        rangeQFilter = new QFilter("inventoryentryentity.invcostobject", "in", costobjectIds);
        factDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter, rangeQFilter}, null);
        resultDs = compDataSet.union(factDataSet);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("compamt").sum("factamt").finish();
        compareDs = this.dealDataZeroDs(compareDs, new String[]{"compamt", "factamt"});
        compareDs = compareDs.filter("compamt-factamt!=0");
        if (compareDs.isEmpty()) {
            return;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u4e3b\u8054\u526f\u5b8c\u5de5\u5165\u5e93\u6210\u672c\u5b58\u5728\u5dee\u5f02", (String)"ActAnalAction_21", (String)"macc-aca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u68c0\u67e5\u4e3b\u8054\u526f\u5de5\u5355\u7684\u5b8c\u5de5\u6210\u672c\u4e0e\u5173\u8054\u7684\u5f53\u671f\u4e3b\u8054\u526f\u5165\u5e93\u6210\u672c\u662f\u5426\u5b58\u5728\u5dee\u5f02\u3002", (String)"ActAnalAction_22", (String)"macc-aca-algox", (Object[])new Object[0]);
        DynamicObject checkDetail = this.getTaskRecordEntry(dataArgs, curItem, detail);
        compareDs = this.relaSubElementAndCostObjectData(compareDs, costobjectIds, new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("status", (Object)"1");
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u6210\u672c\u5b50\u8981\u7d20\u3010%3$s/%4$s\u3011\u4e0d\u6ee1\u8db3\u201c\u672c\u671f\u5b8c\u5de5\u6210\u672c\u3010%5$s\u3011=\u672c\u671f\u5165\u5e93\u6210\u672c\u3010%6$s\u3011\u201d\u3002", (String)"ActAnalAction_23", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("compamt")), this.getBigDecimalStr(row.getBigDecimal("factamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
    }

    private void calcDataCheck() {
        ActCostCalcArgs dataArgs = this.getContext().getInputArgs();
        String sqlSelect = "costobject,entryentity.pdstartamount as startamt,entryentity.startadjamt as startadjamt,entryentity.pdcurramount as curramt,entryentity.currcomamount as compamt,entryentity.pdendamount as endamt";
        QFilter typeFilter = new QFilter("entryentity.type", "=", (Object)"finalResult");
        DataSet currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter}, null);
        DataSet compareDs = currDataSet.groupBy(new String[]{"costobject"}).sum("startamt").sum("startadjamt").sum("curramt").sum("compamt").sum("endamt").finish();
        compareDs = this.dealDataZeroDs(compareDs, new String[]{"startamt", "startadjamt", "curramt", "compamt", "endamt"});
        if ((compareDs = compareDs.filter("startamt+curramt+startadjamt-compamt-endamt!=0")).isEmpty()) {
            logger.info("calcDataCheck-nodiff");
            return;
        }
        logger.info("calcDataCheck-hasdiff");
        Set<Long> costobjectIds = ActCalcHelper.getLongIdSetFromDs(compareDs, "costobject", false);
        sqlSelect = "costcenter,costobject,entryentity.subelement subelement,entryentity.pdstartamount as startamt,entryentity.startadjamt as startadjamt,entryentity.pdcurramount as curramt,entryentity.currcomamount as compamt,entryentity.pdendamount as endamt";
        typeFilter = new QFilter("entryentity.type", "=", (Object)"detail");
        QFilter rangeQFilter = new QFilter("costobject", "in", costobjectIds);
        currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"aca_calcresult", (String)sqlSelect, (QFilter[])new QFilter[]{typeFilter, this.curBaseFilter, rangeQFilter}, null);
        compareDs = currDataSet.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("startamt").sum("startadjamt").sum("curramt").sum("compamt").sum("endamt").finish();
        compareDs = this.dealDataZeroDs(compareDs, new String[]{"startamt", "startadjamt", "curramt", "compamt", "endamt"});
        compareDs = compareDs.filter("startamt+curramt+startadjamt-compamt-endamt!=0");
        if (compareDs.isEmpty()) {
            return;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u6210\u672c\u7b49\u5f0f\u5b58\u5728\u504f\u5dee", (String)"ActAnalAction_24", (String)"macc-aca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u68c0\u67e5\u6bcf\u4e2a\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u662f\u5426\u6ee1\u8db3\uff1a\u671f\u521d\u5728\u4ea7\u54c1\u6210\u672c+\u671f\u521d\u5728\u4ea7\u54c1\u6210\u672c\u8c03\u6574\u5355\u6210\u672c+\u672c\u671f\u6295\u5165\u6210\u672c=\u5b8c\u5de5\u6210\u672c+\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u3002", (String)"ActAnalAction_25", (String)"macc-aca-algox", (Object[])new Object[0]);
        DynamicObject checkDetail = this.getTaskRecordEntry(dataArgs, curItem, detail);
        compareDs = this.relaSubElementAndCostObjectData(compareDs, costobjectIds, new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("status", (Object)"1");
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s/%2$s\u3011\u6210\u672c\u5b50\u8981\u7d20\u3010%3$s/%4$s\u3011\u4e0d\u6ee1\u8db3\u201c\u671f\u521d\u5728\u4ea7\u3010%5$s\u3011+\u671f\u521d\u5728\u4ea7\u8c03\u6574\u3010%6$s\u3011+\u672c\u671f\u6295\u5165\u3010%7$s\u3011=\u672c\u671f\u5b8c\u5de5\u3010%8$s\u3011+\u671f\u672b\u5728\u4ea7\u3010%9$s\u3011\u201d\u3002", (String)"ActAnalAction_26", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("costobjectNo"), row.getString("costobjectName"), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("startamt")), this.getBigDecimalStr(row.getBigDecimal("startadjamt")), this.getBigDecimalStr(row.getBigDecimal("curramt")), this.getBigDecimalStr(row.getBigDecimal("compamt")), this.getBigDecimalStr(row.getBigDecimal("endamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
    }

    private DynamicObject getTaskRecordEntry(ActCostCalcArgs dataArgs, String curItem, String detail) {
        String status = this.setError ? "3" : "7";
        Tuple2<Integer, Long> tuple = this.taskRecorder.saveTaskRecordEntryRtEntryId(curItem, TaskConfigConstant.PENIODEND_COSTCALC, "2", "");
        this.taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, status, (Integer)tuple.t1, detail, null, null);
        return ActAnalAction.createCalcCheckDetail(dataArgs, (Long)tuple.t2, detail);
    }

    private DataSet relaSubElementAndCostObjectData(DataSet ds, Set<Long> costobjectIds, String[] orderBys) {
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"cad_subelement", (String)"id, number subelementNo,name subelementName", null, (String)"");
        DataSet resultDs = ds.leftJoin(subElementDs).on("subelement", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"subelementNo", "subelementName"}).finish();
        if (costobjectIds != null) {
            resultDs = this.relaCostObjectData(resultDs, costobjectIds, null);
        }
        if (orderBys != null) {
            resultDs = resultDs.orderBy(orderBys);
        }
        return resultDs;
    }

    private DataSet relaCostObjectData(DataSet ds, Set<Long> costobjectIds, String[] orderBys) {
        QFilter filter = new QFilter("id", "in", costobjectIds);
        DataSet costobjectDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"cad_costobject", (String)"id, billno costobjectNo,name costobjectName", (QFilter[])filter.toArray(), null);
        ds = ds.leftJoin(costobjectDs).on("costobject", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"costobjectNo", "costobjectName"}).finish();
        if (orderBys != null) {
            ds = ds.orderBy(orderBys);
        }
        return ds;
    }

    private DataSet relaMatData(DataSet ds, Set<Long> matIds, String[] orderBys) {
        QFilter filter = new QFilter("id", "in", matIds);
        DataSet matDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"bd_material", (String)"id, number matNo,name matName", (QFilter[])filter.toArray(), null);
        ds = ds.leftJoin(matDs).on("submaterial", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"matNo", "matName"}).finish();
        if (orderBys != null) {
            ds = ds.orderBy(orderBys);
        }
        return ds;
    }

    private String getBigDecimalStr(BigDecimal val) {
        if (val == null) {
            return "0";
        }
        return val.stripTrailingZeros().toPlainString();
    }

    private DataSet dealDataZeroDs(DataSet ds, String[] fields) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(ds.getRowMeta().getFieldNames()));
        list.removeAll(Arrays.asList(fields));
        for (String field : fields) {
            list.add(String.format("case when %s is null then 0.0 else %s end %s", field, field, field));
        }
        return ds.select(list.toArray(new String[0]));
    }

    private void matInputCheck(int unitProgess) {
        MatCalcParam matCalcParam = this.getMatCalcParam();
        String curItem = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868\uff08\u6750\u6599\u8d39\u7528\uff09", (String)"ActAnalAction_1", (String)"macc-aca-algox", (Object[])new Object[0]);
        int taskSeq = this.taskRecorder.saveTaskRecordEntry(curItem, TaskConfigConstant.PENIODEND_COSTCALC, "2");
        DataSet matDataSet = this.getMatService().getDataSetResult(matCalcParam);
        this.taskRecorder.upateTaskRecord(unitProgess, "2");
        if (!matDataSet.isEmpty()) {
            matDataSet.close();
            String detail = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868\uff08\u6750\u6599\u8d39\u7528\uff09\u5b58\u5728\u5dee\u5f02\u6570\u636e\uff0c\u8bf7\u8054\u67e5\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868\uff08\u6750\u6599\u8d39\u7528\uff09\u3002", (String)"ActAnalAction_2", (String)"macc-aca-algox", (Object[])new Object[0]);
            this.taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, "7", taskSeq, detail, this.getSubParam(), "aca_matcalcanalrpt");
        } else {
            this.taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, "4", taskSeq);
        }
    }

    private void mfgInputCheck(int unitProgess) {
        MatCalcParam matCalcParam = this.getMatCalcParam();
        String curItem = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868\uff08\u5236\u9020\u8d39\u7528\uff09", (String)"ActAnalAction_3", (String)"macc-aca-algox", (Object[])new Object[0]);
        int taskSeq = this.taskRecorder.saveTaskRecordEntry(curItem, TaskConfigConstant.PENIODEND_COSTCALC, "2");
        DataSet mfgcoDataSet = this.getMfgcoService().getDataSetResult(matCalcParam);
        this.taskRecorder.upateTaskRecord(unitProgess, "2");
        if (!mfgcoDataSet.isEmpty()) {
            mfgcoDataSet.close();
            String detail = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868\uff08\u5236\u9020\u8d39\u7528\uff09\u5b58\u5728\u5dee\u5f02\u6570\u636e\uff0c\u8bf7\u8054\u67e5\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868\uff08\u5236\u9020\u8d39\u7528\uff09\u3002", (String)"ActAnalAction_4", (String)"macc-aca-algox", (Object[])new Object[0]);
            this.taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, "7", taskSeq, detail, this.getSubParam(), "aca_mfgcocalcanalrpt");
        } else {
            this.taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, "4", taskSeq);
        }
    }

    private static DynamicObject createCalcCheckDetail(ActCostCalcArgs args, long entryId, String itemName) {
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"aca_calcreportdetail");
        checkDetail.set("id", (Object)entryId);
        checkDetail.set("org", (Object)args.getOrgId());
        checkDetail.set("costaccount", (Object)args.getCostAccountId());
        checkDetail.set("period", (Object)args.getPeriodId());
        checkDetail.set("currency", (Object)args.getCurrencyId());
        checkDetail.set("checkitemdesc", (Object)itemName);
        checkDetail.set("calcdate", (Object)TimeServiceHelper.now());
        return checkDetail;
    }

    private String tipSubStr(String tip) {
        return StringUtils.substring((String)tip, (int)0, (int)250);
    }

    private String getSubParam() {
        ActCostCalcArgs args = this.getContext().getInputArgs();
        JSONObject params = new JSONObject();
        params.accumulate("orgId", (Object)args.getOrgId());
        params.accumulate("costaccountId", (Object)args.getOrgId());
        params.accumulate("periodId", (Object)args.getOrgId());
        return params.toString();
    }

    private MatCalcParam getMatCalcParam() {
        ActCostCalcArgs args = this.getContext().getInputArgs();
        Long orgId = args.getOrgId();
        Long costaccountId = args.getCostAccountId();
        Long period = args.getPeriodId();
        MatCalcParam matCalcParam = new MatCalcParam();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("costaccount", "=", (Object)costaccountId));
        qFilters.add(new QFilter("period", "=", (Object)period));
        matCalcParam.setBaseFilter(qFilters);
        matCalcParam.setShowMatDetail(Boolean.FALSE);
        matCalcParam.setOnlyShowDiff(Boolean.TRUE);
        matCalcParam.setShowSubelement(Boolean.FALSE);
        return matCalcParam;
    }

    private MatCalcAnalRptAlgoxService getMatService() {
        return new MatCalcAnalRptAlgoxService();
    }

    private MfgcoCalcAnalRptAlgoxService getMfgcoService() {
        return new MfgcoCalcAnalRptAlgoxService();
    }
}

