/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algo.util.Tuple2;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.common.TaskConfigConstant;
import kd.macc.aca.algox.costcalc.AcaResultFinalResultVO;
import kd.macc.aca.algox.costcalc.ActCostCalcContext;
import kd.macc.aca.algox.costcalc.ActCostCalcDataInputFactory;
import kd.macc.aca.algox.costcalc.ActTaskRecorder;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.action.ActCalcCallCalOutException;
import kd.macc.aca.algox.costcalc.action.DebugInfoMsgHandler;
import kd.macc.aca.algox.costcalc.common.ActCalcHelper;
import kd.macc.aca.algox.costcalc.common.ActCalcMaterial;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.ProextraPriceVo;
import kd.macc.aca.algox.costcalc.function.ActCalcAdjuctSubDataDealFunction;
import kd.macc.aca.algox.costcalc.function.ActCalcFunctionHelper;
import kd.macc.aca.algox.costcalc.function.ActCalcGradeFunction;
import kd.macc.aca.algox.costcalc.function.ActCalcInvResultSaveFunction;
import kd.macc.aca.algox.costcalc.function.ActCalcJoinSideAllocFunction;
import kd.macc.aca.algox.costcalc.function.ActCalcJoinSideDetailFunction;
import kd.macc.aca.algox.costcalc.function.ActCalcResultSaveFunction;
import kd.macc.aca.algox.costcalc.function.ActCalcSideFunction;
import kd.macc.aca.algox.costcalc.function.ActCalcSubItemElementFunction;
import kd.macc.aca.algox.costcalc.function.ActCalcSubItemReviseDataFunction;
import kd.macc.aca.algox.costcalc.function.ActCalcSubItemToJsonDealFunction;
import kd.macc.aca.algox.costcalc.function.ActCarryForwardCalcFunction;
import kd.macc.aca.algox.costcalc.function.ActCarryNoMainDetailCalcFunction;
import kd.macc.aca.algox.costcalc.function.ActInCalcFunction;
import kd.macc.aca.algox.costcalc.function.ActInCostCalcFunction;
import kd.macc.aca.algox.costcalc.function.ActNegaunitpriceDealFunction;
import kd.macc.aca.algox.costcalc.function.ActNoDetailResultSaveFunction;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.AcaDataSetXLogUtil;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.sdk.macc.aca.extpoint.IActCostCalcLvlPlugin;

public class ActCalcAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(ActCalcAction.class);
    private static final String ALGOKEY_PRE = "ActCalc-";
    private static final int DEFAULT_BATCH_SIZE = 10000;
    private static final int BATCH_MIN_SIZE = 100;
    private static final String DBPARAM_ACA_CALC_COSTOBJSIZE = "aca_calccostobjsize";
    private static final String MATCONDITIONTYPE_A = "A";
    private static final String MATCONDITIONTYPE_B = "B";
    private ActTaskRecorder taskRecorder;
    private static String[] matAllocDataSetGroupByFields = new String[]{"costCenterId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "matUnitPrecision", "subMatId", "subMatVerId", "subMatAuxId", "subMatUnitPrecision", "elementId", "subElementId", "isMfg", "outsourcetype", "calckeycol"};
    private static String[] matMainAllocDataSetGroupByFields = new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "matUnitPrecision", "subMatId", "subMatVerId", "subMatAuxId", "subMatUnitPrecision", "elementId", "subElementId", "isMfg", "outsourcetype", "calckeycol"};

    @Override
    protected void doExecute() {
        if (!this.getContext().getInputArgs().getCalc()) {
            LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"ActCalcAction \u5b9e\u9645\u6210\u672c\u8ba1\u7b97\uff1a\u9000\u51fa\uff0cisCalc = false", (String)"ActCalcAction_78", (String)"macc-aca-algox", (Object[])new Object[0]));
            return;
        }
        String calcInfoMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b\u4e2d\u5b58\u5728\u8b66\u544a\u9879\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u3002", (String)"ActCalcAction_255", (String)"macc-aca-algox", (Object[])new Object[0]);
        this.taskRecorder = this.getResultManager().getTaskRecorder();
        String logUniqueKey = this.getContext().getInputArgs().getGetLogUniqueKey();
        ActCostCalcArgs args = this.getContext().getInputArgs();
        List<Set<ActCalcMaterial>> matList = this.getContext().getMatLvlList();
        if (CollectionUtils.isEmpty(matList)) {
            LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"ActMaterialLvlCalcAction \u5b9e\u9645\u6210\u672c\u8ba1\u7b97\uff1a\u9000\u51fa\uff0c\u7269\u6599\u4f4e\u9636\u7801 mats.size()==0", (String)"ActCalcAction_79", (String)"macc-aca-algox", (Object[])new Object[0]));
            return;
        }
        LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"\u3010\u6309\u7ea7\u6b21\u8ba1\u7b97\u5b9e\u9645\u6210\u672c\u3011\u5f00\u59cb", (String)"ActCalcAction_81", (String)"macc-aca-algox", (Object[])new Object[0]));
        ActCostCalcDataInputFactory datainputFactory = new ActCostCalcDataInputFactory();
        long start = System.currentTimeMillis();
        String inventoryMode = datainputFactory.getInventoryMode(args);
        Map<String, String> proallocstdMap = datainputFactory.buildProallocstdMap(args);
        Map<String, BigDecimal> costcenterStdValMap = null;
        if (this.isHasCustomProdAllocStd(proallocstdMap)) {
            costcenterStdValMap = datainputFactory.buildInProdAllocStdVal(args, null);
        }
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u3011\u8017\u65f6:%s", (String)"ActCalcAction_82", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        int unitProgess = (int)Math.floor(50.0 / (double)(matList.size() * 2));
        HashSet allMatIdSet = Sets.newHashSetWithExpectedSize((int)2048);
        HashSet hasUpdateReworkSubMats = Sets.newHashSetWithExpectedSize((int)10);
        boolean acaCalcOutParallel = datainputFactory.getCalcConcurrencyMode();
        Set<String> secFields = datainputFactory.getSecondDevGradeField(args);
        int costobjBatsize = this.getCostObjectBatSize();
        PluginProxy pluginProxy = PluginProxy.create(null, IActCostCalcLvlPlugin.class, (String)"MACC_ACA_COSTCALC_LVL", null);
        for (int i = 0; i < matList.size(); ++i) {
            Set<String> curCalMatNumbers;
            String curItem = null;
            String curOutItem = null;
            if (i == 0) {
                curItem = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5c42\u6750\u6599,\u51fa\u5e93\u6838\u7b97%2$s", (String)"ActCalcAction_164", (String)"macc-aca-algox", (Object[])new Object[0]), i + 1, acaCalcOutParallel ? ResManager.loadKDString((String)"-\u5e76\u884c\u6a21\u5f0f", (String)"ActCalcAction_274", (String)"macc-aca-algox", (Object[])new Object[0]) : "");
            } else if (i == 1) {
                curItem = ResManager.loadKDString((String)"\u65e0\u9886\u6599\u4ea7\u54c1\u53ca\u526f\u4ea7\u54c1\u5165\u5e93,\u6210\u672c\u8ba1\u7b97", (String)"ActCalcAction_277", (String)"macc-aca-algox", (Object[])new Object[0]);
                curOutItem = ResManager.loadKDString((String)"\u65e0\u9886\u6599\u4ea7\u54c1\u53ca\u526f\u4ea7\u54c1\u5165\u5e93,\u51fa\u5e93\u6838\u7b97", (String)"ActCalcAction_278", (String)"macc-aca-algox", (Object[])new Object[0]);
            } else {
                curItem = String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u7269\u6599,\u6210\u672c\u8ba1\u7b97", (String)"ActCalcAction_8", (String)"macc-aca-algox", (Object[])new Object[0]), i);
                curOutItem = String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u7269\u6599,\u51fa\u5e93\u6838\u7b97", (String)"ActCalcAction_279", (String)"macc-aca-algox", (Object[])new Object[0]), i);
            }
            Set<ActCalcMaterial> curCalcMat = matList.get(i);
            HashSet matIdSet = Sets.newHashSetWithExpectedSize((int)200);
            for (ActCalcMaterial actCalcMaterial : curCalcMat) {
                matIdSet.add(actCalcMaterial.getMaterialId());
            }
            String twoLevelOutMatStr = "";
            if (i == 0 && !CollectionUtils.isEmpty(this.getContext().getTwoLevelOutStMats())) {
                matIdSet.removeAll(this.getContext().getTwoLevelOutStMats());
                curCalMatNumbers = datainputFactory.buildMaterialNumberSetByMaterialIdSet(this.getContext().getTwoLevelOutStMats());
                twoLevelOutMatStr = "\n" + String.format(ResManager.loadKDString((String)"\u79fb\u5165\u201c\u65e0\u9886\u6599\u4ea7\u54c1\u53ca\u526f\u4ea7\u54c1\u5165\u5e93\u6210\u672c\u8ba1\u7b97\u201d\u5c42\u8fdb\u884c\u51fa\u5e93\u6838\u7b97\u7684\u7269\u6599\uff1a%s", (String)"ActCalcAction_239", (String)"macc-aca-algox", (Object[])new Object[0]), curCalMatNumbers);
            }
            LogUtils.logInfoIdColl(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u7269\u6599ID\u96c6\u5408:", (String)"ActCalcAction_165", (String)"macc-aca-algox", (Object[])new Object[0]), i), matIdSet);
            curCalMatNumbers = datainputFactory.buildMaterialNumberSetByMaterialIdSet(matIdSet);
            String infoMsg = String.format(ResManager.loadKDString((String)"\u672c\u5c42\u8ba1\u7b97\u7269\u6599\u7f16\u7801\u8303\u56f4\uff1a%1$s%2$s", (String)"ActCalcAction_276", (String)"macc-aca-algox", (Object[])new Object[0]), curCalMatNumbers.toString(), twoLevelOutMatStr);
            Tuple2<Integer, Long> tuple = this.saveTaskRecordEntryRtEntryId(curItem, TaskConfigConstant.PENIODEND_COSTCALC, "2", infoMsg);
            int taskSeq = (Integer)tuple.t1;
            args.setLevelEntryId((Long)tuple.t2);
            if (i == 0) {
                this.beforeCostCalcLvlExecute(this.getContext(), i + 1, taskSeq, (PluginProxy<IActCostCalcLvlPlugin>)pluginProxy, matIdSet, new HashSet<Long>(10));
                allMatIdSet.addAll(matIdSet);
                if (!CollectionUtils.isEmpty((Collection)matIdSet)) {
                    if (args.isMatlevelonecalout()) {
                        this.calculatOutService(args, datainputFactory, matIdSet, i, MATCONDITIONTYPE_A, acaCalcOutParallel);
                    } else {
                        LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u81ea\u52a8\u6750\u6599\u5206\u914d\u3011\u5f00\u59cb", (String)"ActCalcAction_229", (String)"macc-aca-algox", (Object[])new Object[0]), i));
                        start = System.currentTimeMillis();
                        ActCalcHelper.autoMatAllocPre(args, matIdSet, null);
                        ActCalcHelper.autoMatAllocNew(args, matIdSet, null);
                        LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u81ea\u52a8\u6750\u6599\u5206\u914d\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%2$s", (String)"ActCalcAction_230", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
                    }
                }
                this.taskRecorder.upateTaskRecord(unitProgess, "2");
                this.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, args.isMatlevelonecalout() ? "4" : "8", taskSeq);
                this.afterCostCalcLvlExecute(this.getContext(), i + 1, taskSeq, (PluginProxy<IActCostCalcLvlPlugin>)pluginProxy, matIdSet, new HashSet<Long>(10));
                continue;
            }
            Set<Long> calcCostObjectSet = null;
            if (i == 1) {
                calcCostObjectSet = this.getContext().getInputArgs().getCacheNotMatUseCostObjects();
            } else {
                allMatIdSet.addAll(matIdSet);
                calcCostObjectSet = this.getLevelCostObjectSet(args, matIdSet);
            }
            HashSet<Long> reWorkPoMatSet = new HashSet<Long>(32);
            HashSet<Long> reWorkPoSubMatSet = new HashSet<Long>(32);
            HashSet<Long> reWorkNotPoSubMatSet = new HashSet<Long>(32);
            HashSet<Long> reWorkCostObjectSet = new HashSet<Long>(32);
            datainputFactory.buildMaterialAllocReworkSet(args, calcCostObjectSet, reWorkPoMatSet, reWorkPoSubMatSet, reWorkNotPoSubMatSet, reWorkCostObjectSet);
            if (i == 1) {
                Set<Long> sideProductIds = this.sideProductCostDeal(args, datainputFactory, taskSeq, logUniqueKey, secFields);
                LogUtils.logInfoIdColl(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u8ba1\u7b97\u526f\u4ea7\u54c1\u6210\u672c\u7684\u7269\u6599ID\u96c6\u5408:", (String)"ActCalcAction_167", (String)"macc-aca-algox", (Object[])new Object[0]), i), sideProductIds);
            }
            reWorkNotPoSubMatSet.removeAll(hasUpdateReworkSubMats);
            if (!reWorkNotPoSubMatSet.isEmpty()) {
                LogUtils.logInfoIdColl(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u975e\u5de5\u5355\u6cd5\u8fd4\u5de5\u7269\u6599ID\u96c6\u5408:", (String)"ActCalcAction_169", (String)"macc-aca-algox", (Object[])new Object[0]), i), reWorkNotPoSubMatSet);
                this.updateCostFromCostPriceService(args, reWorkNotPoSubMatSet, i);
                ActCalcHelper.autoMatAllocNew(args, reWorkNotPoSubMatSet, true);
            }
            reWorkPoSubMatSet.removeAll(hasUpdateReworkSubMats);
            int oneProgess = 0;
            if (!reWorkPoSubMatSet.isEmpty()) {
                LogUtils.logInfoIdColl(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u5de5\u5355\u6cd5\u8fd4\u5de5\u7269\u6599ID\u96c6\u5408:", (String)"ActCalcAction_170", (String)"macc-aca-algox", (Object[])new Object[0]), i), reWorkPoSubMatSet);
                LogUtils.logInfoIdColl(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u5de5\u5355\u6cd5\u8fd4\u5de5\u6210\u672c\u6838\u7b97\u5bf9\u8c61ID\u96c6\u5408:", (String)"ActCalcAction_171", (String)"macc-aca-algox", (Object[])new Object[0]), i), reWorkCostObjectSet);
                oneProgess = unitProgess / 2;
                calcCostObjectSet.removeAll(reWorkCostObjectSet);
                this.beforeCostCalcLvlExecute(this.getContext(), i + 1, taskSeq, (PluginProxy<IActCostCalcLvlPlugin>)pluginProxy, matIdSet, calcCostObjectSet);
                this.actLevelBatchCalc(args, i, matIdSet, calcCostObjectSet, proallocstdMap, costcenterStdValMap, taskSeq, inventoryMode, secFields, costobjBatsize);
                this.taskRecorder.upateTaskRecord(oneProgess, "2");
                this.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, "4", taskSeq);
                this.updateCostFromCostPriceService(args, reWorkPoSubMatSet, i);
                ActCalcHelper.autoMatAllocNew(args, reWorkPoSubMatSet, true);
                this.beforeCostCalcLvlExecute(this.getContext(), i + 1, taskSeq, (PluginProxy<IActCostCalcLvlPlugin>)pluginProxy, reWorkPoMatSet, reWorkCostObjectSet);
                this.actLevelBatchCalc(args, i, reWorkPoMatSet, reWorkCostObjectSet, proallocstdMap, costcenterStdValMap, taskSeq, inventoryMode, secFields, costobjBatsize);
            } else {
                this.beforeCostCalcLvlExecute(this.getContext(), i + 1, taskSeq, (PluginProxy<IActCostCalcLvlPlugin>)pluginProxy, matIdSet, calcCostObjectSet);
                this.actLevelBatchCalc(args, i, matIdSet, calcCostObjectSet, proallocstdMap, costcenterStdValMap, taskSeq, inventoryMode, secFields, costobjBatsize);
            }
            boolean isHasCalcCheckDetail = ActCalcHelper.dealLevelCalcError(args, args.getLevelEntryId(), curItem);
            this.taskRecorder.upateTaskRecord(unitProgess - oneProgess, "2");
            if (isHasCalcCheckDetail) {
                this.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, "7", taskSeq, calcInfoMsg);
            } else {
                this.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, "4", taskSeq);
            }
            Tuple2<Integer, Long> outTuple = this.saveTaskRecordEntryRtEntryId(curOutItem, TaskConfigConstant.PENIODEND_COSTCALC, "2", infoMsg);
            if (i == 1) {
                if (!CollectionUtils.isEmpty(this.getContext().getTwoLevelOutStMats())) {
                    allMatIdSet.addAll(this.getContext().getTwoLevelOutStMats());
                    LogUtils.logInfoIdColl(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u8c03\u7528\u51fa\u5e93\u6838\u7b97\u63a5\u53e3\u7684\u7269\u6599ID\u96c6\u5408:", (String)"ActCalcAction_168", (String)"macc-aca-algox", (Object[])new Object[0]), i), this.getContext().getTwoLevelOutStMats());
                    this.calculatOutService(args, datainputFactory, this.getContext().getTwoLevelOutStMats(), i, MATCONDITIONTYPE_A, acaCalcOutParallel);
                }
            } else {
                LogUtils.logInfoIdColl(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u8c03\u7528\u51fa\u5e93\u6838\u7b97\u63a5\u53e3\u7684\u7269\u6599ID\u96c6\u5408:", (String)"ActCalcAction_168", (String)"macc-aca-algox", (Object[])new Object[0]), i), matIdSet);
                this.calculatOutService(args, datainputFactory, matIdSet, i, MATCONDITIONTYPE_A, acaCalcOutParallel);
            }
            this.taskRecorder.upateTaskRecord(unitProgess, "2");
            this.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, "4", (Integer)outTuple.t1);
            hasUpdateReworkSubMats.addAll(reWorkNotPoSubMatSet);
            hasUpdateReworkSubMats.addAll(reWorkPoSubMatSet);
            this.afterCostCalcLvlExecute(this.getContext(), i + 1, taskSeq, (PluginProxy<IActCostCalcLvlPlugin>)pluginProxy, matIdSet, calcCostObjectSet);
        }
        if (args.getAllInvMatCalout().booleanValue()) {
            String curItem = ResManager.loadKDString((String)"\u5168\u90e8\u5e93\u5b58\u7269\u6599\u6267\u884c\u51fa\u5e93\u6838\u7b97", (String)"ActCalcAction_18", (String)"macc-aca-algox", (Object[])new Object[0]);
            int taskSeq = this.taskRecorder.saveTaskRecordEntry(curItem, TaskConfigConstant.PENIODEND_COSTCALC, "2");
            this.calculatOutService(args, datainputFactory, allMatIdSet, 999, MATCONDITIONTYPE_B, acaCalcOutParallel);
            this.taskRecorder.upateTaskRecord(unitProgess, "2");
            this.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_COSTCALC, "4", taskSeq);
        }
    }

    private void beforeCostCalcLvlExecute(ActCostCalcContext context, int index, int taskseq, PluginProxy<IActCostCalcLvlPlugin> pluginProxy, Set<Long> materialIds, Set<Long> costobjectIds) {
        String calcJson = ActCostCalcArgs.toJSONString(context.getInputArgs());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(10);
        paramMap.put("materialIds", materialIds);
        paramMap.put("costobjectIds", costobjectIds);
        paramMap.put("taskRecordId", this.taskRecorder.getTaskRecord().getId());
        paramMap.put("taskSeq", taskseq);
        if (index == 2) {
            paramMap.put("notHasMatUse", "true");
        } else {
            paramMap.put("notHasMatUse", "false");
        }
        pluginProxy.callReplace(p -> {
            long start = System.currentTimeMillis();
            logger.info("\u8ba1\u7b97\u5f00\u59cb\uff1a\u63d2\u4ef6\u7c7b-{}\u5f00\u59cb\u6267\u884c", (Object)p.getClass().getName());
            p.levelCalcBefore(index, calcJson, paramMap);
            logger.info("\u8ba1\u7b97\u5f00\u59cb\uff1a\u63d2\u4ef6\u7c7b-{}\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a{}", (Object)p.getClass().getName(), (Object)(System.currentTimeMillis() - start));
            return null;
        });
    }

    private void afterCostCalcLvlExecute(ActCostCalcContext context, int index, int taskseq, PluginProxy<IActCostCalcLvlPlugin> pluginProxy, Set<Long> materialIds, Set<Long> costobjectIds) {
        String calcJson = ActCostCalcArgs.toJSONString(context.getInputArgs());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(10);
        paramMap.put("materialIds", materialIds);
        paramMap.put("costobjectIds", costobjectIds);
        paramMap.put("taskRecordId", this.taskRecorder.getTaskRecord().getId());
        paramMap.put("taskSeq", taskseq);
        if (index == 2) {
            paramMap.put("notHasMatUse", "true");
        } else {
            paramMap.put("notHasMatUse", "false");
        }
        pluginProxy.callReplace(p -> {
            long start = System.currentTimeMillis();
            logger.info("\u8ba1\u7b97\u7ed3\u675f\uff1a\u63d2\u4ef6\u7c7b-{}\u5f00\u59cb\u6267\u884c", (Object)p.getClass().getName(), (Object)paramMap);
            p.levelCalcAfter(index, calcJson, paramMap);
            logger.info("\u8ba1\u7b97\u7ed3\u675f\uff1a\u63d2\u4ef6\u7c7b-{}\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a{}", (Object)p.getClass().getName(), (Object)(System.currentTimeMillis() - start));
            return null;
        });
    }

    private Set<Long> getLevelCostObjectSet(ActCostCalcArgs args, Set<Long> matIdSet) {
        HashSet calcCostObjectSet = Sets.newHashSetWithExpectedSize((int)200);
        for (Long matid : matIdSet) {
            if (!args.getMatCostobjectListMap().containsKey(matid)) continue;
            calcCostObjectSet.addAll((Collection)args.getMatCostobjectListMap().get(matid));
        }
        return calcCostObjectSet;
    }

    private Set<Long> sideProductCostDeal(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, int taskSeq, String logUniqueKey, Set<String> secFields) {
        DataSet sideFactnedoutDs = datainputFactory.buildSideFactnedoutputDataSet(args, secFields);
        DataSet sideMIdDs = sideFactnedoutDs.copy().select(new String[]{"matId", "gradeprodgroup"}).distinct();
        HashSet sideProductIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet gradeGroupIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : sideMIdDs) {
            sideProductIds.add(row.getLong("matId"));
            Long gradeGroupId = row.getLong("gradeprodgroup");
            if (AcaAlgoxEmptyOrZeroUtils.isEmpty(gradeGroupId)) continue;
            gradeGroupIds.add(gradeGroupId);
        }
        if (sideProductIds.isEmpty()) {
            return sideProductIds;
        }
        Set<String> sideMatNumbers = datainputFactory.buildMaterialNumberSetByMaterialIdSet(sideProductIds);
        DebugInfoMsgHandler msgHander = new DebugInfoMsgHandler(this.taskRecorder.getTaskRecord().getId(), taskSeq);
        msgHander.dealInfoMsg("\n" + String.format(ResManager.loadKDString((String)"\u8fdb\u884c\u8ba1\u7b97\u7684\u526f\u4ea7\u54c1\u7269\u6599\uff1a%s", (String)"ActCalcAction_240", (String)"macc-aca-algox", (Object[])new Object[0]), sideMatNumbers));
        Map<String, List<ProextraPriceVo>> proextraPriceMap = datainputFactory.buildProextraPriceDataSet(args, sideProductIds);
        JobSession session = AlgoX.createSession((String)"ActCalc-sideCostDeal");
        DataSetX sideFactnedoutDataSetX = session.fromInput((Input)new DataSetInput(sideFactnedoutDs));
        sideFactnedoutDataSetX = sideFactnedoutDataSetX.addFields(new Field[]{new Field("elementId", (DataType)DataType.LongType), new Field("subElementId", (DataType)DataType.LongType), new Field("cost", (DataType)DataType.BigDecimalType), new Field("outsourcetype", (DataType)DataType.StringType)}, new Object[]{0L, 0L, BigDecimal.ZERO, ""});
        sideFactnedoutDataSetX = sideFactnedoutDataSetX.groupBy(new String[]{"costCenterId", "costObjectId"}).reduceGroup((GroupReduceFunction)new ActCalcSideFunction(args, proextraPriceMap));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            sideFactnedoutDataSetX = AcaDataSetXLogUtil.logDataSetX(sideFactnedoutDataSetX, args.getDebugColName(), args.getDebugColVal(), logUniqueKey + ":sideProductCostDeal-one\uff1a", msgHander);
        }
        sideFactnedoutDataSetX = sideFactnedoutDataSetX.addFields(new Field[]{new Field("groupfield", (DataType)DataType.StringType), new Field("groupcategoryid", (DataType)DataType.LongType)}, new Object[]{"", 0L});
        if (!CollectionUtils.isEmpty((Collection)gradeGroupIds)) {
            HashMap<Long, String> matGroFieMap = new HashMap<Long, String>(10);
            HashMap<String, BigDecimal> matCateMap = new HashMap<String, BigDecimal>(16);
            HashMap<String, String> srcFieldMap = new HashMap<String, String>(5);
            datainputFactory.buildGradeProductByGroupIds(gradeGroupIds, matGroFieMap, matCateMap, srcFieldMap);
            sideFactnedoutDataSetX = sideFactnedoutDataSetX.groupBy(new String[]{"costObjectId", "matId", "elementId", "subElementId", "outsourcetype"}).reduceGroup((GroupReduceFunction)new ActCalcGradeFunction(args, matGroFieMap, matCateMap, srcFieldMap, msgHander));
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                sideFactnedoutDataSetX = AcaDataSetXLogUtil.logDataSetX(sideFactnedoutDataSetX, args.getDebugColName(), args.getDebugColVal(), logUniqueKey + ":sideProductCostDeal-two\uff1a", msgHander);
            }
        }
        DataSetOutput resultSet = new DataSetOutput(sideFactnedoutDataSetX.getRowMeta());
        sideFactnedoutDataSetX.output((Output)resultSet);
        try {
            LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"\u3010\u671f\u672b\u6210\u672c\u8ba1\u7b97-\u526f\u4ea7\u54c1\u5b9a\u989d\u6210\u672c\u8ba1\u7b97-algox\u3011\u5f00\u59cb", (String)"ActCalcAction_94", (String)"macc-aca-algox", (Object[])new Object[0]));
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u671f\u672b\u6210\u672c\u8ba1\u7b97-\u526f\u4ea7\u54c1\u5b9a\u989d\u6210\u672c\u8ba1\u7b97--algox\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%s", (String)"ActCalcAction_173", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        DataSet calcInDataSet = session.readDataSet(resultSet.getId());
        if (!calcInDataSet.isEmpty()) {
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                AcaDataSetXLogUtil.logDataSet(calcInDataSet, args.getDebugColName(), args.getDebugColVal(), logUniqueKey + ":sideProductCostDeal-three\uff1a", msgHander);
            }
            Map<String, Object> paramResult = datainputFactory.buildCalcInCostParam(args, calcInDataSet);
            List calcParamList = (List)paramResult.get("calcParamList");
            this.calculatCostRecordCostUpdateService(calcParamList, 2);
        }
        return sideProductIds;
    }

    private Map<Long, Map<Long, AcaResultFinalResultVO>> getCalcCompResultMap(DataSet mainJoinSideCostobjectDs, Set<Long> calcCostObjectSet) {
        AcaResultFinalResultVO resultVo;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)calcCostObjectSet.size());
        for (Row row : mainJoinSideCostobjectDs) {
            Long factcostcenter;
            Long mainCostObjectId = row.getLong("mainCostObjectId");
            Long costobjectId = row.getLong("costObjectId");
            Map detailMap = resultMap.computeIfAbsent(mainCostObjectId, t -> Maps.newHashMapWithExpectedSize((int)10));
            BigDecimal proFinQty = BigDecimalUtil.getOrZero(row.getBigDecimal("proFinQty"));
            BigDecimal finAdjustQty = BigDecimalUtil.getOrZero(row.getBigDecimal("finAdjustQty"));
            resultVo = null;
            if (detailMap.containsKey(costobjectId)) {
                resultVo = (AcaResultFinalResultVO)detailMap.get(costobjectId);
                resultVo.setProFinQty(proFinQty.add(resultVo.getProFinQty()));
            } else {
                resultVo = new AcaResultFinalResultVO();
                detailMap.put(costobjectId, resultVo);
                resultVo.setMatUnitPrecision(row.getInteger("matunitprecision"));
                resultVo.setProductType(row.getString("producttype"));
                resultVo.setProductgroupId(row.getLong("productgroup"));
                resultVo.setOutsource(row.getBoolean("isoutsource"));
                resultVo.setMatId(row.getLong("material"));
                resultVo.setMatVerId(row.getLong("matversion"));
                resultVo.setMatAuxId(row.getLong("auxpty"));
                resultVo.setCloseStatus(row.getBoolean("closestatus"));
                resultVo.setProPlanQty(BigDecimalUtil.getOrZero(row.getBigDecimal("proPlanQty")));
                resultVo.setProFinQty(proFinQty);
                resultVo.setFinAdjustQty(finAdjustQty);
                BigDecimal pdEndCheckQty = row.getBigDecimal("pdEndCheckQty");
                if (pdEndCheckQty != null) {
                    resultVo.setPdEndCheckQty(pdEndCheckQty);
                }
                resultVo.setWeight(row.getBigDecimal("weight"));
                resultVo.setPdStartQty(BigDecimalUtil.getOrZero(row.getBigDecimal("pdStartQty")));
                resultVo.setStartAdjQty(BigDecimalUtil.getOrZero(row.getBigDecimal("startadjqty")));
                resultVo.setEndAdjQty(BigDecimalUtil.getOrZero(row.getBigDecimal("endadjqty")));
                resultVo.setPdSumQty(BigDecimalUtil.getOrZero(row.getBigDecimal("pdSumQty")));
                resultVo.setSumComQty(BigDecimalUtil.getOrZero(row.getBigDecimal("sumComQty")));
                resultVo.setYearSumInputQty(BigDecimalUtil.getOrZero(row.getBigDecimal("yearSumInputQty")));
                resultVo.setYearSumFinishQty(BigDecimalUtil.getOrZero(row.getBigDecimal("yearSumFinishQty")));
            }
            if (CadEmptyUtils.isEmpty((Long)(factcostcenter = row.getLong("factedCostCenterId")))) continue;
            if (resultVo.getCostcenterFinQtyMap() == null) {
                resultVo.setCostcenterFinQtyMap(Maps.newHashMapWithExpectedSize((int)2));
            }
            BigDecimal csProFinQty = BigDecimal.ZERO;
            if (resultVo.getCostcenterFinQtyMap().containsKey(factcostcenter)) {
                csProFinQty = resultVo.getCostcenterFinQtyMap().get(factcostcenter);
            }
            resultVo.getCostcenterFinQtyMap().put(factcostcenter, csProFinQty.add(proFinQty));
        }
        for (Map.Entry mainObjIdResultVoMap : resultMap.entrySet()) {
            Long mainObjId;
            Map mainJoinSideResMap = (Map)mainObjIdResultVoMap.getValue();
            AcaResultFinalResultVO mainResultVo = (AcaResultFinalResultVO)mainJoinSideResMap.get(mainObjId = (Long)mainObjIdResultVoMap.getKey());
            if (mainResultVo == null) continue;
            if (mainResultVo.getCloseStatus()) {
                for (Map.Entry objIdResMap : mainJoinSideResMap.entrySet()) {
                    resultVo = (AcaResultFinalResultVO)objIdResMap.getValue();
                    if (resultVo.getPdEndCheckQty() != null) continue;
                    resultVo.setPdEndCheckQty(BigDecimal.ZERO);
                }
            }
            for (Map.Entry entry : mainJoinSideResMap.entrySet()) {
                if (MATCONDITIONTYPE_B.equals(((AcaResultFinalResultVO)entry.getValue()).getProductType()) || ((AcaResultFinalResultVO)entry.getValue()).getProFinQty().compareTo(BigDecimal.ZERO) == 0) continue;
                ((AcaResultFinalResultVO)entry.getValue()).setProFinQty(((AcaResultFinalResultVO)entry.getValue()).getProFinQty().add(((AcaResultFinalResultVO)entry.getValue()).getFinAdjustQty()));
            }
        }
        return resultMap;
    }

    private void actLevelBatchCalc(ActCostCalcArgs args, int i, Set<Long> matIdSet, Set<Long> calcCostObjectSet, Map<String, String> proallocstdMap, Map<String, BigDecimal> costcenterStdValMap, int taskSeq, String inventoryMode, Set<String> secFields, int costobjBatsize) {
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index-%1$s\u5c42\u8ba1\u7b97\u5f00\u59cb\uff0c\u6210\u672c\u5bf9\u8c61\u6570\u91cf\uff1a%2$s", (String)"ActCalcAction_261", (String)"macc-aca-algox", (Object[])new Object[0]), i, calcCostObjectSet.size()));
        if (calcCostObjectSet.size() > costobjBatsize) {
            List splitLists = Lists.partition(new ArrayList<Long>(calcCostObjectSet), (int)costobjBatsize);
            LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index-%1$s\u5c42\u8ba1\u7b97\u5f00\u59cb\uff0c\u5171%2$s\u4e2a\u6210\u672c\u5bf9\u8c61\u6570\u91cf\uff0c\u6bcf\u6279%3$s\u4e2a\uff0c\u5171%4$s\u6279\u3002", (String)"ActCalcAction_275", (String)"macc-aca-algox", (Object[])new Object[0]), i, calcCostObjectSet.size(), costobjBatsize, splitLists.size()));
            for (List list : splitLists) {
                this.actLevelCalc(args, i, matIdSet, new HashSet<Long>(list), proallocstdMap, costcenterStdValMap, taskSeq, inventoryMode, secFields);
            }
        } else {
            this.actLevelCalc(args, i, matIdSet, calcCostObjectSet, proallocstdMap, costcenterStdValMap, taskSeq, inventoryMode, secFields);
        }
    }

    private boolean isHasCustomProdAllocStd(Map<String, String> proallocstdMap) {
        for (String value : proallocstdMap.values()) {
            String[] costdriverVals = value.split("@");
            if (!"6".equals(costdriverVals[0])) continue;
            return true;
        }
        return false;
    }

    private void actLevelCalc(ActCostCalcArgs args, int i, Set<Long> matIdSet, Set<Long> calcCostObjectSet, Map<String, String> proallocstdMap, Map<String, BigDecimal> costcenterStdValMap, int taskSeq, String inventoryMode, Set<String> secFields) {
        DataSet joinSidePreDetailDataSet;
        if (CollectionUtils.isEmpty(calcCostObjectSet)) {
            return;
        }
        String logUniqueKey = this.getContext().getInputArgs().getGetLogUniqueKey();
        DebugInfoMsgHandler msgHander = new DebugInfoMsgHandler(this.taskRecorder.getTaskRecord().getId(), taskSeq);
        ActCostCalcDataInputFactory datainputFactory = new ActCostCalcDataInputFactory();
        DataSet mainJoinSideCostobjectDs = datainputFactory.getMainJoinSideCostobjDsFromMainId(args.getOrgId(), calcCostObjectSet, new String[]{"C", MATCONDITIONTYPE_A, MATCONDITIONTYPE_B});
        Set<Long> calcMainJoinSideCostObjectSet = datainputFactory.getLongIdSetFromDs(mainJoinSideCostobjectDs, "costObjectId", true);
        boolean isContainsJoinSide = false;
        if (calcCostObjectSet.size() < calcMainJoinSideCostObjectSet.size()) {
            isContainsJoinSide = true;
        }
        DataSet mainJoinCostobjectCopyDs = null;
        Set<Long> assemblyCostCenterSet = args.getAssemblyCostCenterSet();
        if (!assemblyCostCenterSet.isEmpty()) {
            if (assemblyCostCenterSet.contains(0L)) {
                mainJoinCostobjectCopyDs = mainJoinSideCostobjectDs.copy().filter("producttype in('C','A')");
            } else {
                StringBuilder sb = new StringBuilder();
                for (Long costcenter : assemblyCostCenterSet) {
                    sb.append(costcenter).append(",");
                }
                mainJoinCostobjectCopyDs = mainJoinSideCostobjectDs.copy().filter("mainCostCenterId in(" + sb.toString().substring(0, sb.length() - 1) + ") and producttype in('C','A')");
            }
        }
        DataSet bomMainJoinCostObjectDs = null;
        Set<Long> bomCostCenterSet = args.getBomCostCenterSet();
        if (!bomCostCenterSet.isEmpty()) {
            if (bomCostCenterSet.contains(0L)) {
                bomMainJoinCostObjectDs = mainJoinSideCostobjectDs.copy().filter("producttype in('C','A')");
            } else {
                StringBuilder sb = new StringBuilder();
                for (Long costcenter : bomCostCenterSet) {
                    sb.append(costcenter).append(",");
                }
                bomMainJoinCostObjectDs = mainJoinSideCostobjectDs.copy().filter("mainCostCenterId in(" + sb.substring(0, sb.length() - 1) + ") and producttype in('C','A')");
            }
        }
        Set<Long> nestCalcResultIds = datainputFactory.buildNestCalcResultIds(args, calcCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011\u5f00\u59cb", (String)"ActCalcAction_174", (String)"macc-aca-algox", (Object[])new Object[0]), i));
        long start = System.currentTimeMillis();
        DataSet plannedDataSet = datainputFactory.buildPlannedoutputDataSet(args, calcMainJoinSideCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011\u7ed3\u675f%2$s", (String)"ActCalcAction_175", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(plannedDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u6570\u636e\uff1a", (String)"ActCalcAction_176", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3011\u5f00\u59cb", (String)"ActCalcAction_177", (String)"macc-aca-algox", (Object[])new Object[0]), i));
        start = System.currentTimeMillis();
        DataSet factnedDataSet = datainputFactory.buildFactnedoutputDataSet(args, calcMainJoinSideCostObjectSet, secFields);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3011\u7ed3\u675f%2$s", (String)"ActCalcAction_178", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(factnedDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u6570\u636e\uff1a", (String)"ActCalcAction_179", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355-\u6700\u7ec8\u7ed3\u679c\u9879\u3011\u5f00\u59cb", (String)"ActCalcAction_186", (String)"macc-aca-algox", (Object[])new Object[0]), i));
        start = System.currentTimeMillis();
        DataSet preFinalDataSet = datainputFactory.buildFinalPreCalcResultDataSet(args, calcCostObjectSet, nestCalcResultIds);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355-\u6700\u7ec8\u7ed3\u679c\u9879\u3011\u7ed3\u675f%2$s", (String)"ActCalcAction_187", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        DataSet adjDataSet = datainputFactory.buildAdjustDataSet(args, calcCostObjectSet);
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(adjDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u671f\u521d\u4ea7\u54c1\u9879\u6570\u636e\uff1a", (String)"ActCalcAction_188", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        DataSet wipCostCheckAdjDs = datainputFactory.buildWipCostCheckDataDs(args, calcMainJoinSideCostObjectSet);
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(wipCostCheckAdjDs, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u671f\u672b\u5728\u4ea7\u54c1\u76d8\u70b9\u6570\u636e\uff1a", (String)"ActCalcAction_242", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(plannedDataSet).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"proPlanQty"}).finish();
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(preFinalDataSet).on("costObjectId", "costobjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"pdStartQty", "pdStartAmt", "pdSumQty", "pdSumAmt", "sumComQty", "sumComAmt", "yearSumInputQty", "yearSumInputAmt", "yearSumFinishQty", "yearSumFinishAmt"}).finish();
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(adjDataSet).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"startadjqty", "endadjqty"}).finish();
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(wipCostCheckAdjDs).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"pdEndCheckQty", "finAdjustQty"}).finish();
        DataSet factnedCostobjectDs = factnedDataSet.copy().groupBy(new String[]{"factedCostCenterId", "costObjectId"}).sum("proFinQty").finish();
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(factnedCostobjectDs).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"factedCostCenterId", "proFinQty"}).finish();
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(mainJoinSideCostobjectDs, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u671f\u672b\u5728\u4ea7\u54c1\u76d8\u70b9\u6570\u636e\uff1a", (String)"ActCalcAction_242", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        DataSet closeStatusDs = datainputFactory.buildCloseStatus(args, calcMainJoinSideCostObjectSet);
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(closeStatusDs).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"closestatus"}).finish();
        Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap = this.getCalcCompResultMap(mainJoinSideCostobjectDs, calcCostObjectSet);
        this.printDebugCostObjectInfo(args, calcCostobjectFinalResultMap, msgHander);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u6750\u6599\u8017\u7528\u5206\u914d\u3011\u5f00\u59cb", (String)"ActCalcAction_180", (String)"macc-aca-algox", (Object[])new Object[0]), i));
        start = System.currentTimeMillis();
        DataSet matAllocDataSet = datainputFactory.buildMaterialAllocDataSet(args, calcCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u6750\u6599\u8017\u7528\u5206\u914d\u3011\u7ed3\u675f%2$s", (String)"ActCalcAction_181", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(matAllocDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u6750\u6599\u8017\u7528\u5f52\u96c6\u6570\u636e\uff1a", (String)"ActCalcAction_182", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u5236\u9020\u8d39\u7528\u5206\u914d\u3011\u5f00\u59cb", (String)"ActCalcAction_183", (String)"macc-aca-algox", (Object[])new Object[0]), i));
        start = System.currentTimeMillis();
        DataSet mfgAllocDataSet = datainputFactory.buildMfgFeeAllocDataSet(args, calcCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u5236\u9020\u8d39\u7528\u5206\u914d\u3011\u7ed3\u675f%2$s", (String)"ActCalcAction_184", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(mfgAllocDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u5236\u9020\u8d39\u7528\u5f52\u96c6\u6570\u636e\uff1a", (String)"ActCalcAction_185", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355-\u660e\u7ec6\u9879\u3011\u5f00\u59cb", (String)"ActCalcAction_189", (String)"macc-aca-algox", (Object[])new Object[0]), i));
        start = System.currentTimeMillis();
        DataSet preDetailDataSet = datainputFactory.buildDetailPreCalcResultDataSet(args, calcCostObjectSet, nestCalcResultIds);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355-\u660e\u7ec6\u9879\u3011\u7ed3\u675f%2$s", (String)"ActCalcAction_190", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u83b7\u53d6\u8c03\u6574\u5355\u6570\u636e-\u660e\u7ec6\u9879\u3011\u5f00\u59cb", (String)"ActCalcAction_191", (String)"macc-aca-algox", (Object[])new Object[0]), i));
        start = System.currentTimeMillis();
        DataSet adjustDataSet = datainputFactory.buildAdjustCalcResultDataSet(args, calcCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u83b7\u53d6\u8c03\u6574\u5355\u6570\u636e-\u660e\u7ec6\u9879\u3011\u7ed3\u675f%2$s", (String)"ActCalcAction_192", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u83b7\u53d6\u5728\u4ea7\u54c1\u6210\u672c\u5f55\u5165-\u660e\u7ec6\u9879\u3011\u5f00\u59cb", (String)"ActCalcAction_269", (String)"macc-aca-algox", (Object[])new Object[0]), i));
        start = System.currentTimeMillis();
        DataSet wipEntryDataSet = datainputFactory.buildWipInDataSet(args, calcCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u83b7\u53d6\u5728\u4ea7\u54c1\u6210\u672c\u5f55\u5165-\u660e\u7ec6\u9879\u3011\u7ed3\u675f%2$s", (String)"ActCalcAction_270", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(preDetailDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u671f\u521d\u660e\u7ec6\u9879\u6570\u636e\uff1a", (String)"ActCalcAction_193", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(wipEntryDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u5728\u4ea7\u54c1\u6210\u672c\u5f55\u5165\u6570\u636e\uff1a", (String)"ActCalcAction_271", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        HashSet sideProductIds = Sets.newHashSetWithExpectedSize((int)20);
        HashSet productGroupIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet gradeGroupIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet factnedMainJoinEntryIds = Sets.newHashSetWithExpectedSize((int)16);
        DataSet tmpFactnedDataSet = factnedDataSet.copy();
        this.getFactProductInfo(args, tmpFactnedDataSet, sideProductIds, productGroupIds, gradeGroupIds, factnedMainJoinEntryIds, i);
        Map<String, BigDecimal> equivalentMap = datainputFactory.getEquivalentMap(args, calcCostObjectSet, i, msgHander);
        HashMap weightMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap allocTypeMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!productGroupIds.isEmpty()) {
            datainputFactory.buildMainJoinGroupMap(args, productGroupIds, weightMap, allocTypeMap);
        }
        Map<Object, Object> proextraPriceMap = null;
        proextraPriceMap = !sideProductIds.isEmpty() ? datainputFactory.buildProextraPriceDataSet(args, sideProductIds) : Maps.newHashMapWithExpectedSize((int)1);
        Map<String, BigDecimal> inProdAllocStdValMap = null;
        if (this.isHasCustomProdAllocStd(proallocstdMap)) {
            inProdAllocStdValMap = datainputFactory.buildInProdAllocStdVal(args, calcCostObjectSet);
            inProdAllocStdValMap.putAll(costcenterStdValMap);
        }
        JobSession session = AlgoX.createSession((String)"ActCalc-levelCalc");
        DataSetX preDetailDataSetX = session.fromInput((Input)new DataSetInput(preDetailDataSet));
        DataSetX matAllocDataSetX = session.fromInput((Input)new DataSetInput(matAllocDataSet));
        DataSetX mfgAllocDataSetX = ActCalcAction.getMfgAllocDataSetX(args, calcCostObjectSet, session, mfgAllocDataSet, calcMainJoinSideCostObjectSet, calcCostobjectFinalResultMap, datainputFactory);
        DataSet sideAllocDs = datainputFactory.buildOnlySideFactAllocDs(calcCostobjectFinalResultMap);
        if (sideAllocDs != null) {
            DataSetX sideAllocDsX = session.fromInput((Input)new DataSetInput(sideAllocDs));
            mfgAllocDataSetX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(mfgAllocDataSetX, sideAllocDsX);
        }
        DataSetX detailDataSetX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(matAllocDataSetX, mfgAllocDataSetX);
        detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("pdStartQty", (DataType)DataType.BigDecimalType), new Field("pdStartAmt", (DataType)DataType.BigDecimalType), new Field("pdSumQty", (DataType)DataType.BigDecimalType), new Field("pdSumAmt", (DataType)DataType.BigDecimalType), new Field("sumComQty", (DataType)DataType.BigDecimalType), new Field("sumComAmt", (DataType)DataType.BigDecimalType), new Field("finQty", (DataType)DataType.BigDecimalType), new Field("finAmt", (DataType)DataType.BigDecimalType), new Field("inQty", (DataType)DataType.BigDecimalType), new Field("inAmt", (DataType)DataType.BigDecimalType), new Field("yearSumInputQty", (DataType)DataType.BigDecimalType), new Field("yearSumInputAmt", (DataType)DataType.BigDecimalType), new Field("yearSumFinishQty", (DataType)DataType.BigDecimalType), new Field("yearSumFinishAmt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        detailDataSetX = DataSetXHelper.unionIfRowDiff(detailDataSetX, preDetailDataSetX);
        detailDataSetX = detailDataSetX.groupBy(matAllocDataSetGroupByFields).sum("qty").sum("amount").sum("finQty").sum("finAmt").sum("inQty").sum("inAmt").sum("pdStartQty").sum("pdStartAmt").sum("pdSumQty").sum("pdSumAmt").sum("sumComQty").sum("sumComAmt").sum("yearSumInputQty").sum("yearSumInputAmt").sum("yearSumFinishQty").sum("yearSumFinishAmt");
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u8d39\u7528\u6570\u636edataSetX\uff1a", (String)"ActCalcAction_203", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        DataSetX adjustDataSetX = session.fromInput((Input)new DataSetInput(adjustDataSet));
        DataSetX wipEntryDataSetX = session.fromInput((Input)new DataSetInput(wipEntryDataSet));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            adjustDataSetX = AcaDataSetXLogUtil.logDataSetX(adjustDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u6210\u672c\u8c03\u6574\u5355dataSetX\uff1a", (String)"ActCalcAction_204", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("startadjqty", (DataType)DataType.BigDecimalType), new Field("startadjamt", (DataType)DataType.BigDecimalType), new Field("endadjqty", (DataType)DataType.BigDecimalType), new Field("endadjamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        detailDataSetX = DataSetXHelper.unionIfRowDiff(detailDataSetX, adjustDataSetX);
        detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("inSubAdjQty", (DataType)DataType.BigDecimalType), new Field("inSubAdjAmt", (DataType)DataType.BigDecimalType)}, new Object[]{null, null});
        detailDataSetX = DataSetXHelper.unionIfRowDiff(detailDataSetX, wipEntryDataSetX);
        detailDataSetX = detailDataSetX.groupBy(matAllocDataSetGroupByFields).sum("qty").sum("amount").sum("finQty").sum("finAmt").sum("inQty").sum("inAmt").sum("pdStartQty").sum("pdStartAmt").sum("pdSumQty").sum("pdSumAmt").sum("sumComQty").sum("sumComAmt").sum("yearSumInputQty").sum("yearSumInputAmt").sum("yearSumFinishQty").sum("yearSumFinishAmt").sum("startadjqty").sum("startadjamt").sum("endadjqty").sum("endadjamt").sum("inSubAdjQty").sum("inSubAdjAmt");
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u8ba1\u7b97\u524d\u5408\u5e76\u6295\u5165\u6570\u636edataSetX\uff1a", (String)"ActCalcAction_272", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        detailDataSetX = this.unionAddAssemblyCostDs(args, datainputFactory, mainJoinCostobjectCopyDs, session, detailDataSetX, i, msgHander);
        detailDataSetX = this.unionAddBomCostDs(args, datainputFactory, bomMainJoinCostObjectDs, session, detailDataSetX, i, msgHander);
        DataSetX costObjectHasDetailDataSetX = null;
        if (i == 1) {
            costObjectHasDetailDataSetX = detailDataSetX.distinct(new String[]{"costObjectId"});
        }
        detailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "costObjectId"}).reduceGroup((GroupReduceFunction)new ActCarryForwardCalcFunction(detailDataSetX.getRowMeta(), args, calcCostobjectFinalResultMap, this.getContext().isCarryNotInAmtCalc()));
        if (!StringUtils.isEmpty((String)inventoryMode)) {
            DataSet inventoryAllocDataSet = datainputFactory.buildInventoryAllocData(args, calcCostObjectSet);
            DataSetX inventoryAllocDataSetX = session.fromInput((Input)new DataSetInput(inventoryAllocDataSet));
            detailDataSetX = detailDataSetX.leftJoin(inventoryAllocDataSetX).on("costCenterId", "costCenterId").on("costObjectId", "costObjectId").on("subMatId", "matId").on("subMatAuxId", "auxpty").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"inventValue"});
        }
        detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("mainCostObjectId", (DataType)DataType.LongType), new Field("calcAmt", (DataType)DataType.BigDecimalType)}, new Object[]{0L, BigDecimal.ZERO});
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u6210\u672c\u5bf9\u8c61\u5165\u5e93\u6210\u672c\u8ba1\u7b97\u524ddataSetX\uff1a", (String)"ActCalcAction_273", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        detailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "costObjectId"}).reduceGroup((GroupReduceFunction)new ActInCostCalcFunction(args, proallocstdMap, inProdAllocStdValMap, equivalentMap, calcCostobjectFinalResultMap, allocTypeMap, weightMap, inventoryMode, msgHander, this.getContext().isWipcostinBindCustom(), this.getContext().getWipcostinAlloc(), this.getContext().isWipcostinExistOrg()));
        if (args.isNegaunitpricedeal()) {
            detailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "costObjectId"}).reduceGroup((GroupReduceFunction)new ActNegaunitpriceDealFunction(args, calcCostobjectFinalResultMap, msgHander, proextraPriceMap));
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u6210\u672c\u5bf9\u8c61\u5165\u5e93\u6210\u672c\u8ba1\u7b97\u540edataSetX\uff1a", (String)"ActCalcAction_244", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("finTempQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        detailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "costObjectId"}).reduceGroup((GroupReduceFunction)new ActCalcJoinSideAllocFunction(detailDataSetX.getRowMeta(), args, proextraPriceMap, calcCostobjectFinalResultMap, allocTypeMap, weightMap, msgHander));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u6210\u672c\u5bf9\u8c61\u4e3b\u8054\u526f\u5206\u644a\u540edataSetX\uff1a", (String)"ActCalcAction_245", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        if (isContainsJoinSide && !(joinSidePreDetailDataSet = datainputFactory.buildJoinSideDetailPreCalcResultDataSet(args, calcCostObjectSet, nestCalcResultIds)).isEmpty()) {
            DataSetX joinSidePreDetailDataSetX = session.fromInput((Input)new DataSetInput(joinSidePreDetailDataSet));
            detailDataSetX = DataSetXHelper.unionIfRowDiff(detailDataSetX, joinSidePreDetailDataSetX);
            detailDataSetX = detailDataSetX.groupBy(matMainAllocDataSetGroupByFields).sum("qty").sum("amount").sum("finQty").sum("finAmt").sum("inQty").sum("inAmt").sum("pdStartQty").sum("pdStartAmt").sum("pdSumQty").sum("pdSumAmt").sum("sumComQty").sum("sumComAmt").sum("yearSumInputQty").sum("yearSumInputAmt").sum("yearSumFinishQty").sum("yearSumFinishAmt").sum("startadjqty").sum("startadjamt").sum("endadjqty").sum("endadjamt").sum("calcAmt");
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u6210\u672c\u5bf9\u8c61\u5408\u5e76\u8054\u526f\u5b8c\u5de5\u7d2f\u8ba1\u7684\u6570\u636edataSetX1\uff1a", (String)"ActCalcAction_246", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
            }
            detailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId"}).reduceGroup((GroupReduceFunction)new ActCarryNoMainDetailCalcFunction(detailDataSetX.getRowMeta(), calcCostobjectFinalResultMap));
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u6210\u672c\u5bf9\u8c61\u5408\u5e76\u8054\u526f\u5b8c\u5de5\u7d2f\u8ba1\u7684\u6570\u636edataSetX2\uff1a", (String)"ActCalcAction_247", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
            }
        }
        if (args.isCalbyCostElement()) {
            detailDataSetX = this.collectCalbyCostElementInfo(args, datainputFactory, session, calcCostObjectSet, nestCalcResultIds, detailDataSetX, i, msgHander);
        }
        DataSetX calcResultDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId"}).reduceGroup((GroupReduceFunction)new ActCalcResultSaveFunction(detailDataSetX.getRowMeta(), args, calcCostobjectFinalResultMap));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcResultDataSetX = AcaDataSetXLogUtil.logDataSetX(calcResultDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\u5355\u540edataSetX\uff1a", (String)"ActCalcAction_207", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        DataSetX calcSubElementCostDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "elementId", "subElementId", "outsourcetype"}).sum("finAmt").sum("calcAmt");
        calcSubElementCostDataSetX = calcSubElementCostDataSetX.addFields(new Field[]{new Field("carrytype", (DataType)DataType.StringType)}, new Object[]{MATCONDITIONTYPE_A});
        if (args.isCalbyCostElement()) {
            DataSetX calcSubItemElementCostDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "outsourcetype"}).reduceGroup((GroupReduceFunction)new ActCalcSubItemElementFunction(args.getAmtScale()));
            calcSubItemElementCostDataSetX = calcSubItemElementCostDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "elementId", "subElementId", "outsourcetype", "carrytype"}).sum("finAmt").sum("calcAmt");
            calcSubElementCostDataSetX = DataSetXHelper.union(calcSubElementCostDataSetX, calcSubItemElementCostDataSetX);
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcSubElementCostDataSetX = AcaDataSetXLogUtil.logDataSetX(calcSubElementCostDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u6c47\u603b\u5b50\u8981\u7d20\u6210\u672cdataSetX\uff1a", (String)"ActCalcAction_249", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        DataSetX factnedDataSetX = session.fromInput((Input)new DataSetInput(factnedDataSet));
        String selectField = "srcBillId,srcEntryId,proFinQty,factedCostCenterId,factwarehouse,auxpty,invtype";
        if (secFields != null && !secFields.isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            for (String secField : secFields) {
                joiner.add(secField);
            }
            String field = joiner.toString();
            selectField = selectField + "," + field;
        }
        JoinDataSetX calcDataSetX = calcSubElementCostDataSetX.join(factnedDataSetX).on("costObjectId", "costObjectId").select(calcSubElementCostDataSetX.getRowMeta().getFieldNames(), selectField.split(","));
        calcDataSetX = calcDataSetX.filter("srcEntryId>0");
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcDataSetX = AcaDataSetXLogUtil.logDataSetX((DataSetX)calcDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u5b50\u8981\u7d20\u6210\u672c\u5173\u8054\u5b8c\u5de5\u5165\u5e93\u5355dataSetX\uff1a", (String)"ActCalcAction_250", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        calcDataSetX = calcDataSetX.addFields(new Field[]{new Field("cost", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        calcDataSetX = calcDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "elementId", "subElementId", "outsourcetype", "carrytype"}).reduceGroup((GroupReduceFunction)new ActInCalcFunction(calcDataSetX.getRowMeta(), args, proextraPriceMap, calcCostobjectFinalResultMap));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcDataSetX = AcaDataSetXLogUtil.logDataSetX((DataSetX)calcDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u8ba1\u7b97\u5b8c\u5de5\u5165\u5e93\u5355\u7684\u5b50\u8981\u7d20\u6210\u672cdataSetX\uff1a", (String)"ActCalcAction_251", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        calcDataSetX = calcDataSetX.addFields(new Field[]{new Field("groupfield", (DataType)DataType.StringType), new Field("groupcategoryid", (DataType)DataType.LongType)}, new Object[]{"", 0L});
        if (!gradeGroupIds.isEmpty()) {
            calcDataSetX = this.gradeProductProcess(args, datainputFactory, gradeGroupIds, (DataSetX)calcDataSetX, factnedDataSetX, msgHander);
        }
        DataSetX convSubDetailDataSetX = null;
        if (args.getConversionsubdetail()) {
            DataSetX calcDetailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "elementId", "subElementId", "subMatId", "subMatVerId", "subMatAuxId", "subMatUnitPrecision", "outsourcetype"}).sum("finQty").sum("finAmt").sum("calcAmt");
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                calcDetailDataSetX = AcaDataSetXLogUtil.logDataSetX(calcDetailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u7f13\u5b58\u7b2c1\u9875\u7b7e\u6570\u636edataSetX\uff1a", (String)"ActCalcAction_248", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
            }
            convSubDetailDataSetX = this.conversionSubDetailProcess(args, datainputFactory, session, (DataSetX)calcDataSetX, calcDetailDataSetX, msgHander);
        }
        DataSetX negPriceDsx = calcDataSetX.groupBy(new String[]{"srcBillId", "srcEntryId", "costCenterId", "costObjectId", "mainCostObjectId", "groupcategoryid"}).max("proFinQty").sum("cost");
        negPriceDsx = negPriceDsx.addFields(new Field[]{new Field("unitPrice", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        negPriceDsx = negPriceDsx.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX rowx) {
                BigDecimal cost = BigDecimalUtil.getOrZero(rowx.get(this.sourceRowMeta.getFieldIndex("cost")));
                BigDecimal proFinQty = BigDecimalUtil.getOrZero(rowx.get(this.sourceRowMeta.getFieldIndex("proFinQty")));
                if (proFinQty.compareTo(BigDecimal.ZERO) != 0) {
                    rowx.set(this.sourceRowMeta.getFieldIndex("unitPrice"), (Object)cost.divide(proFinQty, 10, RoundingMode.HALF_UP));
                } else {
                    rowx.set(this.sourceRowMeta.getFieldIndex("unitPrice"), (Object)BigDecimal.ZERO);
                }
                return rowx;
            }
        });
        negPriceDsx = negPriceDsx.filter("(cost=0 and groupcategoryid=0) or unitPrice<0");
        DataSetOutput costObjectHasDetailOutput = null;
        DataSetOutput resultSet = new DataSetOutput(calcDataSetX.getRowMeta());
        DataSetOutput negPriceRst = new DataSetOutput(negPriceDsx.getRowMeta());
        String resultId = resultSet.getId();
        calcDataSetX.output((Output)resultSet);
        negPriceDsx.output((Output)negPriceRst);
        DataSetOutput convSubDetailResultSet = null;
        if (args.getConversionsubdetail() && convSubDetailDataSetX != null) {
            convSubDetailResultSet = new DataSetOutput(convSubDetailDataSetX.getRowMeta());
            convSubDetailDataSetX.output((Output)convSubDetailResultSet);
        }
        calcResultDataSetX.output((Output)new IgnoreOutput());
        if (i == 1) {
            costObjectHasDetailOutput = new DataSetOutput(costObjectHasDetailDataSetX.getRowMeta());
            costObjectHasDetailDataSetX.output((Output)costObjectHasDetailOutput);
        }
        try {
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u671f\u672b\u6210\u672c\u8ba1\u7b97-algox\u3011\u5f00\u59cb", (String)"ActCalcAction_208", (String)"macc-aca-algox", (Object[])new Object[0]), i));
            start = System.currentTimeMillis();
            session.commit(10, TimeUnit.HOURS);
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u671f\u672b\u6210\u672c\u8ba1\u7b97-algox\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%2$s", (String)"ActCalcAction_209", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        DataSet calcInDataSet = session.readDataSet(resultId);
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(calcInDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u5165\u5e93\u6838\u7b97\u7684\u6570\u636e\uff1a", (String)"ActCalcAction_210", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey, i), msgHander);
        }
        Map<Long, Long> calcResultMap = datainputFactory.buildCalcResultIdMap(args, calcCostObjectSet);
        HashSet hasUpdateFactedEntryIds = Sets.newHashSetWithExpectedSize((int)10);
        if (args.getConversionsubdetail() && convSubDetailResultSet != null) {
            datainputFactory.buildCalcConversionDetail(session.readDataSet(convSubDetailResultSet.getId()), calcResultMap);
        }
        Map<String, Object> paramResult = this.getOutInParamResult(args, datainputFactory, calcInDataSet, calcResultMap, hasUpdateFactedEntryIds);
        ArrayList<Map<String, Object>> calcParamList = (ArrayList<Map<String, Object>>)paramResult.get("calcParamList");
        DataSet negPriceDs = session.readDataSet(negPriceRst.getId());
        boolean isnegUnitPrice = this.negUnitPriceDeal(args, datainputFactory, negPriceDs, msgHander);
        if (isnegUnitPrice) {
            return;
        }
        if (calcParamList == null) {
            calcParamList = new ArrayList<Map<String, Object>>(10);
        }
        ArrayList<Object[]> addResultEntrys = new ArrayList<Object[]>(10);
        this.factedZeroCostRecordUpdateService(args, datainputFactory, i, factnedMainJoinEntryIds, hasUpdateFactedEntryIds, calcParamList, addResultEntrys);
        this.calculatCostRecordCostUpdateService(calcParamList, i);
        calcParamList.clear();
        if (i == 1 && costObjectHasDetailOutput != null) {
            String costObjectResultId = costObjectHasDetailOutput.getId();
            DataSet costObjectResultDataSet = session.readDataSet(costObjectResultId);
            this.actCalcNotDetailDeal(args, datainputFactory, logUniqueKey, i, matIdSet, calcCostObjectSet, costObjectResultDataSet, msgHander);
        }
        if (!addResultEntrys.isEmpty()) {
            this.addFactedZeroCalcResultRow(args, datainputFactory, addResultEntrys);
        }
    }

    private Map<String, Object> getOutInParamResult(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, DataSet calcInDataSet, Map<Long, Long> calcResultMap, Set<Long> hasUpdateFactedEntryIds) {
        boolean calcInCostParamCon = "0".equals(CadBgParamUtils.getCadBgParamForString((String)"calcInCostParamCon", (String)"0"));
        if (calcInCostParamCon) {
            return datainputFactory.buildCalcInCostParam(args, calcInDataSet, calcResultMap, hasUpdateFactedEntryIds);
        }
        JobSession session = AlgoX.createSession((String)"ActCalc-saveCalcResult");
        DataSetX calcInDataSetX = session.fromInput((Input)new DataSetInput(calcInDataSet));
        calcInDataSetX = calcInDataSetX.addFields(new Field[]{new Field("batchgroupId", (DataType)DataType.IntegerType)}, new Object[]{0});
        calcInDataSetX = calcInDataSetX.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX rowx) {
                int batchGroupId = new SecureRandom().nextInt(32);
                rowx.set(this.sourceRowMeta.getFieldIndex("batchgroupId"), (Object)batchGroupId);
                return rowx;
            }
        });
        calcInDataSetX = calcInDataSetX.groupBy(new String[]{"batchgroupId"}).reduceGroup((GroupReduceFunction)new ActCalcInvResultSaveFunction(calcResultMap));
        calcInDataSetX = calcInDataSetX.select(new String[]{"carrytype", "srcEntryId", "subElementId", "outsourcetype", "cost"});
        logger.info("\u5b8c\u5de5\u5165\u5e93\u5355\u5206\u6279\u4fdd\u5b58\u5f00\u59cb");
        DataSetOutput resultSet = new DataSetOutput(calcInDataSetX.getRowMeta());
        calcInDataSetX.output((Output)resultSet);
        session.commit(2, TimeUnit.HOURS);
        DataSet calcInDataSetCopy = session.readDataSet(resultSet.getId());
        logger.info("\u5b8c\u5de5\u5165\u5e93\u5355\u5206\u6279\u4fdd\u5b58\u7ed3\u675f");
        return datainputFactory.buildCalcInCostParamNoSave(args, calcInDataSetCopy, calcResultMap, hasUpdateFactedEntryIds);
    }

    private void addFactedZeroCalcResultRow(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, List<Object[]> addResultEntryIds) {
        String insertSql = "insert into t_aca_calcresultinventry(fid,fentryid,fsourcebillid,fsourcebillentryid,finvcostobjectid,finvproducttype,finventorysubeleid,finventoryqty,finventoryamount,fcarrytype) values(?,?,?,?,?,?,?,?,?,?)";
        HashSet calcobjectSet = Sets.newHashSetWithExpectedSize((int)10);
        for (Object[] resultEntry : addResultEntryIds) {
            calcobjectSet.add((Long)resultEntry[4]);
        }
        ArrayList<Object[]> saveResultEntrys = new ArrayList<Object[]>(addResultEntryIds.size());
        Map<Long, Long> costobjectResultIdMap = datainputFactory.buildCostobjectResultIdMap(args, calcobjectSet);
        for (Object[] resultEntry : addResultEntryIds) {
            Long costobjectId = (Long)resultEntry[4];
            Long resultId = costobjectResultIdMap.get(costobjectId);
            if (resultId == null) continue;
            saveResultEntrys.add(resultEntry);
            resultEntry[0] = resultId;
        }
        ActCalcHelper.doExecuteBatch(saveResultEntrys, new DBRoute("cal"), insertSql);
    }

    private static DataSetX getMfgAllocDataSetX(ActCostCalcArgs args, Set<Long> calcCostObjectSet, JobSession session, DataSet mfgAllocDataSet, Set<Long> calcMainJoinSideCostObjectSet, Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap, ActCostCalcDataInputFactory datainputFactory) {
        DataSet mfgAllocDataABSet;
        DataSetX mfgAllocDataSetX = session.fromInput((Input)new DataSetInput(mfgAllocDataSet));
        Set<Object> calcCostObjectABSet = Sets.newHashSetWithExpectedSize((int)16);
        calcCostObjectABSet.addAll(calcMainJoinSideCostObjectSet);
        calcCostObjectABSet.removeAll(calcCostObjectSet);
        HashMap joinByMainMap = Maps.newHashMapWithExpectedSize((int)16);
        calcCostobjectFinalResultMap.forEach((mainCostObjectId, obj) -> obj.forEach((joinBy, obje) -> {
            if (!"C".equals(obje.getProductType())) {
                joinByMainMap.put(joinBy, mainCostObjectId);
            }
        }));
        if (!(CadEmptyUtils.isEmpty((Map)joinByMainMap) || CadEmptyUtils.isEmpty((Set)calcCostObjectABSet) || (mfgAllocDataABSet = datainputFactory.buildMfgJoinByFeeAllocDataSet(args, calcCostObjectABSet = joinByMainMap.keySet(), joinByMainMap)) == null || mfgAllocDataABSet.isEmpty())) {
            DataSetX mfgAllocDataABSetX = session.fromInput((Input)new DataSetInput(mfgAllocDataABSet));
            mfgAllocDataSetX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(mfgAllocDataSetX, mfgAllocDataABSetX);
        }
        return mfgAllocDataSetX;
    }

    private DataSetX collectCalbyCostElementInfo(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, JobSession session, Set<Long> calcCostObjectSet, Set<Long> nestCalcResultIds, DataSetX detailDataSetX, int i, DebugInfoMsgHandler msgHander) {
        OrmInput materialSubDs = datainputFactory.buildMaterialAllocSubDataSet(args, calcCostObjectSet);
        OrmInput adjustSubCalcResultDs = datainputFactory.buildAdjustSubCalcResultDataSet(args, calcCostObjectSet);
        DataSet preCalcResultDs = datainputFactory.buildDetailPreSubCalcResultDataSet(args, calcCostObjectSet, nestCalcResultIds);
        DataSetX adjustSubCalcResultDsX = session.fromInput((Input)adjustSubCalcResultDs);
        DataSetX subItemResultDsX = adjustSubCalcResultDsX.groupBy(new String[]{"costObjectId", "relaCostObjectId"}).reduceGroup((GroupReduceFunction)new ActCalcAdjuctSubDataDealFunction());
        DataSetX materialSubDsX = session.fromInput((Input)materialSubDs);
        DataSetX preCalcResultDsX = session.fromInput((Input)new DataSetInput(preCalcResultDs));
        subItemResultDsX = DataSetXHelper.unionIfRowDiff(subItemResultDsX, materialSubDsX);
        subItemResultDsX = DataSetXHelper.unionIfRowDiff(subItemResultDsX, preCalcResultDsX);
        subItemResultDsX = AcaDataSetXLogUtil.logDataSetX(subItemResultDsX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u5206\u9879\u6570\u636e-\u5408\u8ba1\u524d\uff1a", (String)"ActCalcAction_264", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), i), msgHander);
        subItemResultDsX = subItemResultDsX.groupBy(new String[]{"costObjectId", "relaCostObjectId", "subelement", "subMatId", "subMatVerId", "subMatAuxId", "calckeycol", "selement", "ssubelement"}).sum("spdstartamt").sum("spdstartadjamt").sum("spdcurramt").sum("spdcomamt").sum("spdendamt").sum("spdendadjamt").sum("spdyearsumamt").sum("spdsumamt").sum("spdyearcomamt").sum("spdsumcomamt");
        subItemResultDsX = AcaDataSetXLogUtil.logDataSetX(subItemResultDsX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u5206\u9879\u6570\u636e-\u5408\u8ba1\u540e\uff1a", (String)"ActCalcAction_265", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), i), msgHander);
        DataSetX subItemResultRelaDsX = subItemResultDsX.groupBy(new String[]{"costObjectId", "relaCostObjectId", "subelement", "subMatId", "subMatVerId", "subMatAuxId", "calckeycol"}).reduceGroup((GroupReduceFunction)new ActCalcSubItemToJsonDealFunction());
        subItemResultRelaDsX = AcaDataSetXLogUtil.logDataSetX(subItemResultRelaDsX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u5206\u9879\u6570\u636e-\u8f6cjson\uff1a", (String)"ActCalcAction_266", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), i), msgHander);
        detailDataSetX = detailDataSetX.leftJoin(subItemResultRelaDsX).on("mainCostObjectId", "costObjectId").on("costObjectId", "relaCostObjectId").on("subElementId", "subelement").on("subMatId", "subMatId").on("subMatVerId", "subMatVerId").on("subMatAuxId", "subMatAuxId").on("calckeycol", "calckeycol").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"subjson"});
        detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u8ba1\u7b97\u660e\u7ec6\u5173\u8054json\u6570\u636e\uff1a", (String)"ActCalcAction_267", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), i), msgHander);
        detailDataSetX = detailDataSetX.groupBy(new String[]{"mainCostObjectId", "subElementId", "subMatId", "subMatVerId", "subMatAuxId", "calckeycol"}).reduceGroup((GroupReduceFunction)new ActCalcSubItemReviseDataFunction(args, msgHander));
        detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u4fee\u6b63\u5206\u9879\u6570\u636e\uff1a", (String)"ActCalcAction_268", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), i), msgHander);
        return detailDataSetX;
    }

    private DataSetX unionAddAssemblyCostDs(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, DataSet mainJoinCostobjectCopyDs, JobSession session, DataSetX detailDataSetX, int i, DebugInfoMsgHandler msgHander) {
        DataSet assemblyDataSet;
        boolean isAddStockField = true;
        if (!args.getAssemblyCostCenterSet().isEmpty() && (assemblyDataSet = datainputFactory.buildAssemblyDataSet(args, mainJoinCostobjectCopyDs)) != null) {
            isAddStockField = false;
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                AcaDataSetXLogUtil.logDataSet(assemblyDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u7ec4\u4ef6\u6e05\u5355\u6570\u636e\uff1a", (String)"ActCalcAction_205", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), i), msgHander);
            }
            DataSetX assemblyDataSetX = session.fromInput((Input)new DataSetInput(assemblyDataSet));
            detailDataSetX = detailDataSetX.leftJoin(assemblyDataSetX).on("costObjectId", "costObjectId").on("subMatId", "subMaterialId").on("subMatAuxId", "subauxpty").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"stockqty", "useqty"});
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u7ec4\u4ef6\u6e05\u5355\u6570\u636e\uff1a", (String)"ActCalcAction_205", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), i), msgHander);
            }
        }
        if (isAddStockField) {
            detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("stockqty", (DataType)DataType.BigDecimalType), new Field("useqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        }
        return detailDataSetX;
    }

    private DataSetX unionAddBomCostDs(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, DataSet bomMainJoinCostObjectDs, JobSession session, DataSetX detailDataSetX, int i, DebugInfoMsgHandler msgHander) {
        DataSet bomDataSet;
        boolean addBomField = true;
        if (!args.getBomCostCenterSet().isEmpty() && (bomDataSet = datainputFactory.buildBomSettingDataSet(args, bomMainJoinCostObjectDs)) != null && !bomDataSet.isEmpty()) {
            addBomField = false;
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                AcaDataSetXLogUtil.logDataSet(bomDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:Bom\u8bbe\u7f6e\u6570\u636e\uff1a", (String)"ActCalcAction_254", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), i), msgHander);
            }
            DataSetX bomDataSetX = session.fromInput((Input)new DataSetInput(bomDataSet));
            detailDataSetX = detailDataSetX.leftJoin(bomDataSetX).on("costObjectId", "costObjectId").on("subMatId", "subMaterialId").on("subMatAuxId", "subauxpty").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"unitQty"});
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:Bom\u8bbe\u7f6e\u6570\u636e\uff1a", (String)"ActCalcAction_254", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), i), msgHander);
            }
        }
        if (addBomField) {
            detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("unitQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        }
        return detailDataSetX;
    }

    private void getFactProductInfo(ActCostCalcArgs args, DataSet tmpFactnedDataSet, Set<Long> sideProductIds, Set<Long> productGroupIds, Set<Long> gradeGroupIds, Set<Long> factnedMainJoinEntryIds, int i) {
        for (Row row : tmpFactnedDataSet) {
            String productType = row.getString("productType");
            Long matId = row.getLong("matId");
            if (MATCONDITIONTYPE_B.equals(productType)) {
                sideProductIds.add(matId);
            }
            factnedMainJoinEntryIds.add(row.getLong("srcEntryId"));
            productGroupIds.add(row.getLong("groupId"));
            Long gradeProdGroup = row.getLong("gradeprodgroup");
            if (CadEmptyUtils.isEmpty((Long)gradeProdGroup)) continue;
            gradeGroupIds.add(gradeProdGroup);
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u526f\u4ea7\u54c1ID\u5408\u8ba1:", (String)"ActCalcAction_196", (String)"macc-aca-algox", (Object[])new Object[0]), i), sideProductIds);
            LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u4ea7\u54c1\u7ec4ID\u5408\u8ba1:", (String)"ActCalcAction_197", (String)"macc-aca-algox", (Object[])new Object[0]), i), productGroupIds);
            LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5c42\u7b49\u7ea7\u54c1\u4ea7\u54c1\u7ec4ID\u5408\u8ba1:", (String)"ActCalcAction_243", (String)"macc-aca-algox", (Object[])new Object[0]), i), gradeGroupIds);
        }
    }

    private void printDebugCostObjectInfo(ActCostCalcArgs args, Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap, DebugInfoMsgHandler msgHander) {
        if (StringUtils.isNotEmpty((String)args.getDebugColVal()) && ("costObjectId".equals(args.getDebugColName()) || "mainCostObjectId".equals(args.getDebugColName()))) {
            try {
                Long costobjectId = Long.valueOf(args.getDebugColVal());
                Map<Long, AcaResultFinalResultVO> detailsMap = calcCostobjectFinalResultMap.get(costobjectId);
                if (detailsMap != null && msgHander != null) {
                    msgHander.dealInfoMsg("\r\nAcaResultFinalResult-" + detailsMap);
                }
            }
            catch (Exception ex) {
                logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97-long\u7c7b\u578b\u8f6c\u6362\u95ee\u9898\uff0c\u4e0d\u9700\u8981\u5173\u6ce8", (Object)ex);
            }
        }
    }

    private void factedZeroCostRecordUpdateService(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, int index, Set<Long> factnedMainJoinEntryIds, Set<Long> hasUpdateFactedEntryIds, List<Map<String, Object>> calcParamList, List<Object[]> addResultEntryIds) {
        ActCalcAction.setDefaultElementId(args);
        if (args.getDefaultSubElementId() == 0L) {
            return;
        }
        factnedMainJoinEntryIds.removeAll(hasUpdateFactedEntryIds);
        if (factnedMainJoinEntryIds.isEmpty()) {
            return;
        }
        DataSet factedDs = datainputFactory.buildFactnedoutputInEntryIdDs(args, factnedMainJoinEntryIds);
        DataSet sideFactedDs = factedDs.copy().filter("productType='B'").groupBy(new String[]{"costObjectId"}).sum("proFinQty").finish().filter("proFinQty<>0");
        if (!sideFactedDs.isEmpty()) {
            HashSet errCostObjectIds = Sets.newHashSetWithExpectedSize((int)16);
            for (Object row : sideFactedDs) {
                errCostObjectIds.add(row.getLong("costObjectId"));
            }
            Map<Long, Set<String>> costcenterCostobjectMap = datainputFactory.buildCostObjectNumberSet(errCostObjectIds);
            if (!costcenterCostobjectMap.isEmpty()) {
                for (Map.Entry entry : costcenterCostobjectMap.entrySet()) {
                    ArrayList<String> errorInfos = new ArrayList<String>(10);
                    for (String costobjectNum : (Set)entry.getValue()) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u526f\u4ea7\u54c1\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a%s\uff0c\u6709\u5b8c\u5de5\u5165\u5e93\u5355\uff0c\u65e0\u6295\u5165\u8d39\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u5165\u5e93\u6210\u672c\u66f4\u65b0\u3002", (String)"ActCalcAction_258", (String)"macc-aca-algox", (Object[])new Object[0]), costobjectNum);
                        errorInfos.add(errorMsg);
                    }
                    ActCalcFunctionHelper.insertCalcErrorInfo(args.getLevelEntryId(), (Long)entry.getKey(), errorInfos, "2");
                }
            }
            factedDs.close();
            return;
        }
        String msgFormat = ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61\u201c%s\u201d\uff0c\u672a\u8fdb\u884c\u5165\u5e93\u6210\u672c\u66f4\u65b0\uff0c\u8fdb\u884c\u96f6\u6210\u672c\u5165\u5e93\u3002", (String)"ActCalcAction_259", (String)"macc-aca-algox", (Object[])new Object[0]);
        factedDs = factedDs.filter("productType<>'B'");
        HashMap listMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap errorInfos = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : factedDs) {
            Long entryId = row.getLong("srcEntryId");
            Long costObjectId = row.getLong("costObjectId");
            Long costcenter = row.getLong("costcenter");
            String costOjbectName = row.getString("costObjectName");
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("outsourcetype", "");
            map.put("costsubelement", args.getDefaultSubElementId());
            map.put("cost", BigDecimal.ZERO);
            ArrayList list = Lists.newArrayList();
            list.add(map);
            listMap.put(entryId, list);
            addResultEntryIds.add(new Object[]{0L, ID.genLongId(), row.getLong("srcBillId"), entryId, costObjectId, row.getString("productType"), args.getDefaultSubElementId(), row.getBigDecimal("proFinQty"), BigDecimal.ZERO, MATCONDITIONTYPE_A});
            if (args.isCalbyCostElement()) {
                addResultEntryIds.add(new Object[]{0L, ID.genLongId(), row.getLong("srcBillId"), entryId, costObjectId, row.getString("productType"), args.getDefaultSubElementId(), row.getBigDecimal("proFinQty"), BigDecimal.ZERO, MATCONDITIONTYPE_B});
            }
            Set errorInfo = errorInfos.computeIfAbsent(costcenter, t -> Sets.newHashSetWithExpectedSize((int)5));
            errorInfo.add(String.format(msgFormat, costOjbectName));
        }
        for (Map.Entry mapEntry : listMap.entrySet()) {
            Long srcEntryId = (Long)mapEntry.getKey();
            List list = (List)mapEntry.getValue();
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("costaccount", args.getCostAccountId());
            map.put("bizbillentryid", srcEntryId);
            map.put("costinfo", list);
            calcParamList.add(map);
        }
        for (Map.Entry entry : errorInfos.entrySet()) {
            ActCalcFunctionHelper.insertCalcErrorInfo(args.getLevelEntryId(), (Long)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()), "1");
        }
    }

    public static void setDefaultElementId(ActCostCalcArgs args) {
        if (CadEmptyUtils.isEmpty((Long)args.getDefaultSubElementId())) {
            QFilter eleFilter = new QFilter("type", "=", (Object)"001");
            eleFilter.and("defaultvalue", "=", (Object)Boolean.TRUE);
            DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"cad_subelement", (String)"id", (QFilter[])eleFilter.toArray());
            if (dyo != null && dyo.length > 0) {
                args.setDefaultSubElementId(dyo[0].getLong("id"));
            }
        }
    }

    private boolean negUnitPriceDeal(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, DataSet calcInDataSet, DebugInfoMsgHandler msgHander) {
        Map<Long, Set<String>> tipInfoMap;
        DataSet calcZeroCostDataSet = calcInDataSet.filter("cost=0 and groupcategoryid=0");
        calcInDataSet = calcInDataSet.filter("unitPrice<0");
        Map<Long, Set<String>> errorInfoMap = this.buildCalcFactTip(args, datainputFactory, calcInDataSet, ResManager.loadKDString((String)"\u5165\u5e93\u6210\u672c\u4e3a\u8d1f\u5355\u4ef7\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u6570\u636e\u3002", (String)"ActCalcAction_133", (String)"macc-aca-algox", (Object[])new Object[0]));
        if (!calcZeroCostDataSet.isEmpty() && !CadEmptyUtils.isEmpty(tipInfoMap = this.buildCalcFactTip(args, datainputFactory, calcZeroCostDataSet, ResManager.loadKDString((String)"\u5165\u5e93\u6210\u672c\u4e3a\u96f6\u6210\u672c\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u6570\u636e\u3002", (String)"ActCalcAction_134", (String)"macc-aca-algox", (Object[])new Object[0])))) {
            for (Map.Entry<Long, Set<String>> entry : tipInfoMap.entrySet()) {
                ActCalcFunctionHelper.insertCalcErrorInfo(args.getLevelEntryId(), entry.getKey(), new ArrayList<String>((Collection)entry.getValue()), "1");
            }
        }
        if (!CadEmptyUtils.isEmpty(errorInfoMap)) {
            for (Map.Entry<Long, Set<String>> entry : errorInfoMap.entrySet()) {
                ActCalcFunctionHelper.insertCalcErrorInfo(args.getLevelEntryId(), entry.getKey(), new ArrayList<String>((Collection)entry.getValue()));
            }
            return true;
        }
        return false;
    }

    private Map<Long, Set<String>> buildCalcFactTip(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, DataSet ds, String tip) {
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet srcEntryIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap costobjectEntryIdMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap costobjectCenterMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : ds) {
            Long costObjectId = row.getLong("costObjectId");
            Long costCenterId = row.getLong("costCenterId");
            costobjectIds.add(costObjectId);
            srcEntryIds.add(row.getLong("srcEntryId"));
            costobjectEntryIdMap.computeIfAbsent(costObjectId, t -> new HashSet(16)).add(row.getLong("srcEntryId"));
            costobjectCenterMap.put(costObjectId, costCenterId);
        }
        Map<Long, String> costobjectNumberMap = datainputFactory.buildCostObjectNameMap(costobjectIds);
        Map<Long, String> entryNumberMap = datainputFactory.buildFactEntryNumberMap(args, srcEntryIds);
        HashMap errorInfoMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry entry : costobjectEntryIdMap.entrySet()) {
            Set entryIdSet = (Set)entry.getValue();
            StringBuilder factSb = new StringBuilder();
            for (Long srcEntryId : entryIdSet) {
                factSb.append("\u3010").append(entryNumberMap.get(srcEntryId)).append("\u3011").append(",");
            }
            Long costcenterId = (Long)costobjectCenterMap.get(entry.getKey());
            if (costcenterId == null) {
                costcenterId = 0L;
            }
            Set errorInfos = errorInfoMap.computeIfAbsent(costcenterId, t -> Sets.newHashSetWithExpectedSize((int)10));
            errorInfos.add(tip + String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a%1$s\uff0c\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u53f7\uff1a%2$s;", (String)"ActCalcAction_211", (String)"macc-aca-algox", (Object[])new Object[0]), costobjectNumberMap.get(entry.getKey()), factSb.length() == 0 ? "" : factSb.toString().substring(0, factSb.length() - 1)));
        }
        return errorInfoMap;
    }

    private void actCalcNotDetailDeal(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, String logUniqueKey, int i, Set<Long> matIdSet, Set<Long> calcCostObjectSet, DataSet costObjectResultDataSet, DebugInfoMsgHandler msgHander) {
        HashSet hasDetailCostObjectId = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : costObjectResultDataSet) {
            hasDetailCostObjectId.add(row.getLong("costObjectId"));
        }
        HashSet calcNoDetailCostObjectIds = Sets.newHashSetWithExpectedSize((int)128);
        calcNoDetailCostObjectIds.addAll(calcCostObjectSet);
        calcNoDetailCostObjectIds.removeAll(hasDetailCostObjectId);
        if (!calcNoDetailCostObjectIds.isEmpty()) {
            DataSet mainJoinSideCostobjectDs = datainputFactory.getMainJoinSideCostobjDsFromMainId(args.getOrgId(), calcNoDetailCostObjectIds, new String[]{"C", MATCONDITIONTYPE_A, MATCONDITIONTYPE_B});
            Set<Long> calcMainJoinSideCostObjectSet = datainputFactory.getLongIdSetFromDs(mainJoinSideCostobjectDs, "costObjectId", true);
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3011-\u65e0\u8ba1\u7b97\u660e\u7ec6-\u5f00\u59cb", (String)"ActCalcAction_212", (String)"macc-aca-algox", (Object[])new Object[0]), i));
            long start = System.currentTimeMillis();
            DataSet factnedDataSet = datainputFactory.buildFactnedoutputDataSet(args, calcMainJoinSideCostObjectSet, null);
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3011-\u65e0\u8ba1\u7b97\u660e\u7ec6-\u7ed3\u675f%2$s", (String)"ActCalcAction_213", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
            DataSet factnedCopyDataSet = factnedDataSet.copy().groupBy(new String[]{"costObjectId"}).sum("proFinQty").finish();
            if (!factnedCopyDataSet.isEmpty()) {
                HashSet errCostObjectIds = Sets.newHashSetWithExpectedSize((int)16);
                for (Object row : factnedCopyDataSet) {
                    errCostObjectIds.add(row.getLong("costObjectId"));
                }
                Map<Long, Set<String>> costcenterCostobjectMap = datainputFactory.buildCostObjectNumberSet(errCostObjectIds);
                if (!costcenterCostobjectMap.isEmpty()) {
                    for (Map.Entry entry : costcenterCostobjectMap.entrySet()) {
                        ArrayList<String> errorInfos = new ArrayList<String>(10);
                        for (String costobjectNum : (Set)entry.getValue()) {
                            String errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a%s\uff0c\u6709\u8ba1\u5212\uff0c\u6709\u5b8c\u5de5\uff0c\u65e0\u8d39\u7528\u6295\u5165\u3002", (String)"ActCalcAction_260", (String)"macc-aca-algox", (Object[])new Object[0]), costobjectNum);
                            errorInfos.add(errorMsg);
                        }
                        ActCalcFunctionHelper.insertCalcErrorInfo(args.getLevelEntryId(), (Long)entry.getKey(), errorInfos, "1");
                    }
                }
            }
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011-\u65e0\u8ba1\u7b97\u660e\u7ec6-\u5f00\u59cb", (String)"ActCalcAction_214", (String)"macc-aca-algox", (Object[])new Object[0]), i));
            start = System.currentTimeMillis();
            DataSet plannedDataSet = datainputFactory.buildPlannedoutputDataSet(args, calcMainJoinSideCostObjectSet);
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011-\u65e0\u8ba1\u7b97\u660e\u7ec6-\u7ed3\u675f%2$s", (String)"ActCalcAction_215", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
            Set<Long> nestCalcResultIds = datainputFactory.buildNestCalcResultIds(args, calcNoDetailCostObjectIds);
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355-\u6700\u7ec8\u7ed3\u679c\u9879\u3011-\u65e0\u8ba1\u7b97\u660e\u7ec6-\u5f00\u59cb", (String)"ActCalcAction_216", (String)"macc-aca-algox", (Object[])new Object[0]), i));
            start = System.currentTimeMillis();
            DataSet preFinalDataSet = datainputFactory.buildFinalPreCalcResultDataSet(args, calcNoDetailCostObjectIds, nestCalcResultIds);
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355-\u6700\u7ec8\u7ed3\u679c\u9879\u3011-\u65e0\u8ba1\u7b97\u660e\u7ec6-\u7ed3\u675f%2$s", (String)"ActCalcAction_217", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
            preFinalDataSet = preFinalDataSet.select("costobjectId,pdStartQty,pdStartAmt,pdSumQty,pdSumAmt,sumComQty,sumComAmt,yearSumInputQty,yearSumInputAmt,yearSumFinishQty,yearSumFinishAmt");
            DataSet dataSet = datainputFactory.buildAdjustDataSet(args, calcNoDetailCostObjectIds);
            DataSet wipCostCheckAdjDs = datainputFactory.buildWipCostCheckDataDs(args, calcNoDetailCostObjectIds);
            DataSet closeStatusDs = datainputFactory.buildCloseStatus(args, calcNoDetailCostObjectIds);
            mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(plannedDataSet).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"proPlanQty"}).finish();
            DataSet factnedCostobjectDs = factnedDataSet.groupBy(new String[]{"costObjectId"}).sum("proFinQty").finish();
            mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(factnedCostobjectDs).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"proFinQty"}).finish();
            mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(preFinalDataSet).on("costObjectId", "costobjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"pdStartQty", "pdStartAmt", "pdSumQty", "pdSumAmt", "sumComQty", "sumComAmt", "yearSumInputQty", "yearSumInputAmt", "yearSumFinishQty", "yearSumFinishAmt"}).finish();
            mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(dataSet).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"startadjqty", "endadjqty"}).finish();
            mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(wipCostCheckAdjDs).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"pdEndCheckQty", "finAdjustQty"}).finish();
            mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(closeStatusDs).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"closestatus"}).finish();
            JobSession session = AlgoX.createSession((String)"ActCalcAction-NoDetailResultSave");
            DataSetX mainJoinSideCostobjectDsX = session.fromInput((Input)new DataSetInput(mainJoinSideCostobjectDs));
            mainJoinSideCostobjectDsX = mainJoinSideCostobjectDsX.filter(new FilterFunction(){
                private static final long serialVersionUID = 1L;

                public boolean test(RowX row) {
                    BigDecimal pdStartQty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("pdStartQty"));
                    if (pdStartQty != null && pdStartQty.compareTo(BigDecimal.ZERO) != 0) {
                        return true;
                    }
                    BigDecimal pdStartAmt = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("pdStartAmt"));
                    if (pdStartAmt != null && pdStartAmt.compareTo(BigDecimal.ZERO) != 0) {
                        return true;
                    }
                    BigDecimal proPlanQty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("proPlanQty"));
                    if (proPlanQty != null && proPlanQty.compareTo(BigDecimal.ZERO) != 0) {
                        return true;
                    }
                    BigDecimal startadjqty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("startadjqty"));
                    if (startadjqty != null && startadjqty.compareTo(BigDecimal.ZERO) != 0) {
                        return true;
                    }
                    BigDecimal endadjqty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("endadjqty"));
                    if (endadjqty != null && endadjqty.compareTo(BigDecimal.ZERO) != 0) {
                        return true;
                    }
                    BigDecimal proFinQty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("proFinQty"));
                    return proFinQty != null && proFinQty.compareTo(BigDecimal.ZERO) != 0;
                }
            });
            mainJoinSideCostobjectDsX = mainJoinSideCostobjectDsX.groupBy(new String[]{"mainCostObjectId"}).reduceGroup((GroupReduceFunction)new ActNoDetailResultSaveFunction(mainJoinSideCostobjectDsX.getRowMeta(), args));
            mainJoinSideCostobjectDsX.output((Output)new IgnoreOutput());
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u671f\u672b\u6210\u672c\u8ba1\u7b97-\u65e0\u8ba1\u7b97\u660e\u7ec6\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355-algox\u3011\u5f00\u59cb", (String)"ActCalcAction_218", (String)"macc-aca-algox", (Object[])new Object[0]), i));
            start = System.currentTimeMillis();
            session.commit(10, TimeUnit.HOURS);
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u671f\u672b\u6210\u672c\u8ba1\u7b97-\u65e0\u8ba1\u7b97\u660e\u7ec6\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355-algox\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%2$s", (String)"ActCalcAction_219", (String)"macc-aca-algox", (Object[])new Object[0]), i, System.currentTimeMillis() - start));
        }
    }

    private DataSetX gradeProductProcess(ActCostCalcArgs args, ActCostCalcDataInputFactory dataInputFactory, Set<Long> gradeGroupIds, DataSetX calcDataSetX, DataSetX factnedDataSetX, DebugInfoMsgHandler msgHander) {
        HashMap<Long, String> matGroFieMap = new HashMap<Long, String>(10);
        HashMap<String, String> srcFieldMap = new HashMap<String, String>(5);
        HashMap<String, BigDecimal> matCateMap = new HashMap<String, BigDecimal>(16);
        dataInputFactory.buildGradeProductByGroupIds(gradeGroupIds, matGroFieMap, matCateMap, srcFieldMap);
        calcDataSetX = calcDataSetX.groupBy(new String[]{"mainCostObjectId", "costObjectId", "matId", "elementId", "subElementId", "outsourcetype", "carrytype"}).reduceGroup((GroupReduceFunction)new ActCalcGradeFunction(args, matGroFieMap, matCateMap, srcFieldMap, msgHander));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcDataSetX = AcaDataSetXLogUtil.logDataSetX(calcDataSetX, args.getDebugColName(), args.getDebugColVal(), args.getGetLogUniqueKey() + ":gradeProductProcess-two\uff1a", msgHander);
        }
        return calcDataSetX;
    }

    private DataSetX conversionSubDetailProcess(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, JobSession session, DataSetX calcDataSetX, DataSetX calcDetailDataSetX, DebugInfoMsgHandler msgHander) {
        DataSetX calcDataSetCopyX = calcDataSetX.filter("carrytype='A'");
        JoinDataSetX convSubDetailDataSetX = calcDataSetCopyX.leftJoin(calcDetailDataSetX).on("mainCostObjectId", "mainCostObjectId").on("costObjectId", "costObjectId").on("elementId", "elementId").on("subElementId", "subElementId").on("outsourcetype", "outsourcetype").select(new String[]{"srcBillId", "srcEntryId", "costCenterId", "mainCostObjectId", "costObjectId", "productType", "elementId", "subElementId", "outsourcetype", "proFinQty", "cost", "groupfield", "groupcategoryid"}, new String[]{"subMatId", "subMatVerId", "subMatAuxId", "subMatUnitPrecision", "finQty", "finAmt"});
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            convSubDetailDataSetX = AcaDataSetXLogUtil.logDataSetX((DataSetX)convSubDetailDataSetX, args.getDebugColName(), args.getDebugColVal(), args.getGetLogUniqueKey() + ":conversionSubDetailProcess-two\uff1a", msgHander);
        }
        DataSet subElementTypeDs = datainputFactory.buildSubElementTypeDataSet();
        DataSetX subElementTypeDsX = session.fromInput((Input)new DataSetInput(subElementTypeDs));
        convSubDetailDataSetX = convSubDetailDataSetX.leftJoin(subElementTypeDsX).on("subElementId", "id").select(convSubDetailDataSetX.getRowMeta().getFieldNames(), new String[]{"subElementType"});
        convSubDetailDataSetX = convSubDetailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "elementId", "subElementId", "outsourcetype"}).reduceGroup((GroupReduceFunction)new ActCalcJoinSideDetailFunction(args));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            convSubDetailDataSetX = AcaDataSetXLogUtil.logDataSetX((DataSetX)convSubDetailDataSetX, args.getDebugColName(), args.getDebugColVal(), args.getGetLogUniqueKey() + ":conversionSubDetailProcess-three\uff1a", msgHander);
        }
        return convSubDetailDataSetX;
    }

    private void calculatCostRecordCostUpdateService(List<Map<String, Object>> calcParamList, int index) {
        try {
            if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(calcParamList)) {
                LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u5f00\u59cb", (String)"ActCalcAction_220", (String)"macc-aca-algox", (Object[])new Object[0]), index));
                long start = System.currentTimeMillis();
                HashMap result = (HashMap)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CostRecordCostUpdateService", (String)"updateCostByCostSubElement", (Object[])new Object[]{calcParamList});
                if (result != null && result.size() > 0) {
                    logger.error(this.getContext().getInputArgs().getGetLogUniqueKey() + ",index" + index + "\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u8fd4\u56de\u5931\u8d25\u7ed3\u679c\u3002", (Throwable)new KDBizException(((Object)result).toString()));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u8fd4\u56de\u5931\u8d25\u7ed3\u679c\uff1a%s", (String)"ActCalcAction_221", (String)"macc-aca-algox", (Object[])new Object[0]), ((Object)result).toString()));
                }
                LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%2$s", (String)"ActCalcAction_222", (String)"macc-aca-algox", (Object[])new Object[0]), index, System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            logger.error(this.getContext().getInputArgs().getGetLogUniqueKey() + ",index" + index + "\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u5931\u8d25\u3002", (Throwable)e);
            throw e;
        }
    }

    private void updateCostFromCostPriceService(ActCostCalcArgs args, Set<Long> matIdSet, int index) {
        LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u8fd4\u5de5\u7269\u6599\u66f4\u65b0\u4ef7\u683cupdateCostFromCostPrice\u3011\u5f00\u59cb", (String)"ActCalcAction_223", (String)"macc-aca-algox", (Object[])new Object[0]), index));
        long start = System.currentTimeMillis();
        HashMap<Long, Set<Long>> bizParam = new HashMap<Long, Set<Long>>();
        bizParam.put(args.getCostAccountId(), matIdSet);
        HashMap<String, String> commonParam = new HashMap<String, String>();
        commonParam.put("priceobject", "K");
        commonParam.put("entityobject", "cal_out_calculate");
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CostPrice4CostRecordService", (String)"updateCostFromCostPrice", (Object[])new Object[]{bizParam, commonParam});
        LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index %1$s\u3010\u8fd4\u5de5\u7269\u6599\u66f4\u65b0\u4ef7\u683cupdateCostFromCostPrice\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%2$s", (String)"ActCalcAction_224", (String)"macc-aca-algox", (Object[])new Object[0]), index, System.currentTimeMillis() - start));
        LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index %1$s\u3010\u8fd4\u5de5\u7269\u6599\u66f4\u65b0\u4ef7\u683cupdateCostFromCostPrice\u3011\u7ed3\u675f\uff0c\u8fd4\u56de\u503c\uff1a%2$s", (String)"ActCalcAction_225", (String)"macc-aca-algox", (Object[])new Object[0]), index, result));
        if (result != null && result.get("success") != null && "0".equals(result.get("success").toString())) {
            String tipMsg = ResManager.loadKDString((String)"\u8fd4\u5de5\u7269\u6599\u66f4\u65b0\u4ef7\u683c\u5931\u8d25\uff1a%s", (String)"ActCalcAction_77", (String)"macc-aca-algox", (Object[])new Object[0]);
            tipMsg = String.format(tipMsg, result.get("msg"));
            String warnLevel = this.getContext().getCalcCheckWarnLevelMap().get("CALC-TERMINALCALC-B-01");
            String checkStatus = "2";
            if (warnLevel != null && "1".equals(warnLevel)) {
                checkStatus = "1";
            }
            ActCalcFunctionHelper.insertCalcErrorInfo(args.getLevelEntryId(), (Long)0L, tipMsg, checkStatus);
            LogUtils.logError(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, tipMsg);
        }
    }

    private void calculatOutService(ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory, Set<Long> matIdSet, int index, String matConditionType, boolean isConcurrencyMode) {
        long start;
        try {
            Map failMatInfosMap;
            LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u51fa\u5e93\u6838\u7b97calculateOut\u3011\u5f00\u59cb", (String)"ActCalcAction_226", (String)"macc-aca-algox", (Object[])new Object[0]), index));
            start = System.currentTimeMillis();
            List<Map<String, Object>> bizParamList = datainputFactory.buildCalcOutCostParam(args, matIdSet);
            Map result = null;
            try (TXHandle h = TX.notSupported();){
                result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"CalculateOutService", (String)"calculateOutForResult", (Object[])new Object[]{datainputFactory.buildCalcOutCostCommonParam(matConditionType, isConcurrencyMode), bizParamList});
            }
            LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index %1$s\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u51fa\u5e93\u6838\u7b97calculateOutForResult\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%2$s", (String)"ActCalcAction_227", (String)"macc-aca-algox", (Object[])new Object[0]), index, System.currentTimeMillis() - start));
            LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index %1$s\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u51fa\u5e93\u6838\u7b97calculateOutForResult\u3011\u7ed3\u675f\uff0c\u8fd4\u56de\u503c\uff1a%2$s", (String)"ActCalcAction_228", (String)"macc-aca-algox", (Object[])new Object[0]), index, result.toString()));
            if (result != null && result.get("failMatInfos") != null && (failMatInfosMap = (Map)result.get("failMatInfos")).size() > 0) {
                Date startTime = (Date)result.get("startTime");
                Date endTime = (Date)result.get("endTime");
                throw new ActCalcCallCalOutException("", failMatInfosMap, startTime, endTime);
            }
        }
        catch (Exception e) {
            logger.error(this.getContext().getInputArgs().getGetLogUniqueKey() + ",index" + index + "\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u51fa\u5e93\u6838\u7b97calculateOut\u3011\u5931\u8d25\u3002", (Throwable)e);
            throw e;
        }
        if (MATCONDITIONTYPE_A.equals(matConditionType)) {
            LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index%s\u3010\u81ea\u52a8\u6750\u6599\u5206\u914d\u3011\u5f00\u59cb", (String)"ActCalcAction_229", (String)"macc-aca-algox", (Object[])new Object[0]), index));
            start = System.currentTimeMillis();
            ActCalcHelper.autoMatAllocPre(args, matIdSet, null);
            ActCalcHelper.autoMatAllocNew(args, matIdSet, null);
            LogUtils.logInfo(this.getContext().getInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"index%1$s\u3010\u81ea\u52a8\u6750\u6599\u5206\u914d\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%2$s", (String)"ActCalcAction_230", (String)"macc-aca-algox", (Object[])new Object[0]), index, System.currentTimeMillis() - start));
        }
    }

    private int getCostObjectBatSize() {
        int batchSize = CadBgParamUtils.getCadParamForInt((String)DBPARAM_ACA_CALC_COSTOBJSIZE, (int)10000);
        if (batchSize < 100) {
            batchSize = 100;
        }
        return batchSize;
    }
}

