/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.common.TaskConfigConstant;
import kd.macc.aca.algox.costcalc.ActTaskRecorder;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.check.AbstractCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;

public class ActCheckAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(ActCheckAction.class);
    private static final String BIZ_TYPE_RO = "RO";
    private ActTaskRecorder taskRecorder;

    @Override
    protected void doExecute() {
        LogUtils.logInfo(this.getContext().getInputArgs().getCalcReportId(), logger, ResManager.loadKDString((String)"\u6570\u636e\u68c0\u67e5\uff1a\u5f00\u59cb", (String)"ActCheckAction_0", (String)"macc-aca-algox", (Object[])new Object[0]));
        this.taskRecorder = this.getResultManager().getTaskRecorder();
        List<Long> checkCostObjectRange = this.getCheckCostObjectRange();
        Long checkResultId = this.initCheckReuslt(checkCostObjectRange);
        this.getContext().getInputArgs().setCheckResultId(checkResultId);
        this.taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_CHECK, "2");
        this.doCheck(checkResultId, checkCostObjectRange);
        this.getContext().getInputArgs().setCheckResultId(checkResultId);
        if (this.getContext().getCheckNoPassCount() > 0) {
            this.getContext().getInputArgs().setCalc(false);
        } else {
            this.getContext().getInputArgs().setCalc(true);
        }
        if (this.getContext().getInputArgs().getCheckWay() == 1) {
            this.taskRecorder.upateTaskRecord(10, "2");
            String checkSattus = "4";
            if (this.getContext().getCheckNoPassCount() > 0) {
                checkSattus = "3";
            } else if (this.getContext().getCheckRemaindCount() > 0) {
                checkSattus = "7";
            }
            this.taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_CHECK, checkSattus);
        }
        this.taskRecorder.upateTaskRecordHander(this.getContext().getInputArgs().getCheckResultId(), this.getContext());
        LogUtils.logInfo(this.getContext().getInputArgs().getCalcReportId(), logger, String.format(ResManager.loadKDString((String)"\u6570\u636e\u68c0\u67e5\uff1a\u7ed3\u675f\u3002 checkResultId: %s", (String)"ActCheckAction_1", (String)"macc-aca-algox", (Object[])new Object[0]), checkResultId));
    }

    private List<Long> getCheckCostObjectRange() {
        if (ActCheckAction.isCostObjectRuleAllRoType(this.getContext().getInputArgs().getOrgId()) && "1".equals(CadBgParamUtils.getCadBgParamForString((String)"collectCheckObj", (String)"1"))) {
            return new ArrayList<Long>(this.getContext().getCacheCostObjectFilterIds());
        }
        return null;
    }

    private static boolean isCostObjectRuleAllRoType(long orgId) {
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        QFilter billStatusQf = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection costObjRule = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"biztype", (QFilter[])new QFilter[]{orgQf, billStatusQf});
        for (DynamicObject rule : costObjRule) {
            String bizType = rule.getString("biztype");
            if (BIZ_TYPE_RO.equals(bizType)) continue;
            return false;
        }
        return true;
    }

    protected Long getCheckConfigId() {
        Long checkConfigId = this.getContext().getInputArgs().getCheckConfigId();
        if (checkConfigId != null && Long.compare(0L, checkConfigId) != 0) {
            return checkConfigId;
        }
        QFilter qfType = new QFilter("type", "=", (Object)"3");
        DynamicObject checkConfig = QueryServiceHelper.queryOne((String)"sca_checkconfig", (String)"id checkConfigId,taskconfig.id taskconfigId", (QFilter[])new QFilter[]{qfType});
        if (checkConfig == null) {
            return null;
        }
        checkConfigId = checkConfig.getLong("checkConfigId");
        this.getContext().getInputArgs().setCheckConfigId(checkConfigId);
        return checkConfigId;
    }

    private void doCheck(Long checkResultId, List<Long> checkCostObjectRange) {
        ActCostCalcArgs inputArgs = this.getContext().getInputArgs();
        List<Long> checkItemList = this.getContext().getInputArgs().getCheckItemList();
        String checkparamstr = ActCostCalcArgs.toJSONString(this.getContext().getInputArgs());
        JSONObject checkparam = JSONObject.fromObject((Object)checkparamstr);
        checkparam.put((Object)"costobjects", checkCostObjectRange);
        String calType = "aca_terminalcalwizards";
        CalcCheckContext calcCheckContext = new CalcCheckContext();
        calcCheckContext.setCheckParamJs(checkparam);
        calcCheckContext.setCheckResultId(inputArgs.getCheckResultId());
        calcCheckContext.setTaskId(this.getContext().getInputArgs().getTaskRecordId());
        calcCheckContext.setTaskType(calType);
        calcCheckContext.setOrgId(inputArgs.getOrgId());
        calcCheckContext.setCostAccountId(inputArgs.getCostAccountId());
        calcCheckContext.setPeriodId(inputArgs.getPeriodId());
        calcCheckContext.setAppNum("aca");
        calcCheckContext.setPeriodStartDate(inputArgs.getStartDate());
        calcCheckContext.setPeriodEndDate(inputArgs.getEndDate());
        calcCheckContext.getParams().put("MatLvlList", this.getContext().getMatLvlList());
        calcCheckContext.getParams().put("CacheMatallocDataSet", this.getContext().getCacheMatallocDataSet());
        calcCheckContext.getParams().put("Nestmatcheck", this.getContext().getInputArgs().getNestmatcheck());
        List<AbstractCalcCheckAction> checkActions = this.createCheckActions(calcCheckContext, checkItemList);
        for (AbstractCalcCheckAction action : checkActions) {
            action.execute();
        }
        if (!CadEmptyUtils.isEmpty(checkActions)) {
            this.getContext().setCheckNoPassCount(Integer.parseInt(String.valueOf(checkActions.get(0).getContext().getFailCount())));
            this.getContext().setCheckRemaindCount(Integer.parseInt(String.valueOf(checkActions.get(0).getContext().getRemindCount())));
        }
    }

    private List<AbstractCalcCheckAction> createCheckActions(CalcCheckContext calcCheckContext, List<Long> checkItemList) {
        List<AbstractCalcCheckAction> actions = new ArrayList<AbstractCalcCheckAction>(10);
        switch (this.getContext().getTaskType()) {
            case PeriodEndCalcCheck: {
                actions = this.createPeriodEndCalcCheckActions(calcCheckContext, checkItemList);
                break;
            }
            case PeriodEndCalc: {
                actions = this.createPeriodEndCalcCheckActions(calcCheckContext, checkItemList);
                break;
            }
        }
        return actions;
    }

    protected List<AbstractCalcCheckAction> createPeriodEndCalcCheckActions(CalcCheckContext calcCheckContext, List<Long> checkItemList) {
        String calType = calcCheckContext.getTaskType();
        return CalcCheckHelper.getCheckActionList((CalcCheckContext)calcCheckContext, checkItemList, (String)calType, (String)"aca");
    }

    private Long initCheckReuslt(List<Long> checkCostObjectRange) {
        DynamicObject checkresultInfo = BusinessDataServiceHelper.newDynamicObject((String)"aca_calcreport");
        Long checkresultId = DBServiceHelper.genGlobalLongId();
        checkresultInfo.set("id", (Object)checkresultId);
        checkresultInfo.set("org", (Object)this.getContext().getInputArgs().getOrgId());
        checkresultInfo.set("costaccount", (Object)this.getContext().getInputArgs().getCostAccountId());
        checkresultInfo.set("period", (Object)this.getContext().getInputArgs().getPeriodId());
        checkresultInfo.set("executor", (Object)RequestContext.get().getCurrUserId());
        checkresultInfo.set("calcdate", (Object)TimeServiceHelper.now());
        checkresultInfo.set("billtype", (Object)"1");
        checkresultInfo.set("progress", (Object)0);
        checkresultInfo.set("usetime", (Object)0L);
        checkresultInfo.set("type", (Object)"0");
        if (!CadEmptyUtils.isEmpty(checkCostObjectRange)) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"checkCostObjectRange", checkCostObjectRange);
            checkresultInfo.set("nextpagepara_tag", (Object)obj.toString());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkresultInfo});
        return checkresultId;
    }
}

