/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCalcReportHeader;

public class ActCreateCalcReportHeaderAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(ActCreateCalcReportHeaderAction.class);

    @Override
    protected void doExecute() {
        IDataEntityType rptHeadType = ActCalcReportHeader.getDataEntityType();
        Long id = this.getContext().getInputArgs().getCalcReportId();
        logger.info(String.format("\u3010\u521b\u5efa\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u3011\uff1a\u5f00\u59cb, \u5df2\u4f20\u5165actCalcReportId: %s", id));
        if (id == null || Long.compare(0L, id) == 0) {
            id = DBServiceHelper.genGlobalLongId();
        } else {
            Object[] rptObjs = BusinessDataServiceHelper.load((Object[])new Object[]{id}, (IDataEntityType)rptHeadType);
            if (rptObjs != null && rptObjs.length > 0) {
                ActCalcReportHeader calcRpt = (ActCalcReportHeader)rptObjs[0];
                this.getResultManager().setCalcReport(calcRpt);
                logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u5df2\u5b58\u5728\uff0c\u4e0d\u9700\u521b\u5efa\uff0c\u9000\u51fa");
                return;
            }
        }
        ActCalcReportHeader reportHeader = new ActCalcReportHeader();
        reportHeader.setId(id);
        reportHeader.setBilltype(this.getContext().getTaskType().getValue() + "");
        reportHeader.setOrg(this.getContext().getInputArgs().getOrgId());
        reportHeader.setCostAccount(this.getContext().getInputArgs().getCostAccountId());
        reportHeader.setCalScheme(this.getContext().getInputArgs().getCalSchemeId());
        reportHeader.setPeriod(this.getContext().getInputArgs().getPeriodId());
        reportHeader.setExecutor(RequestContext.get().getCurrUserId());
        reportHeader.setCalcdate(TimeServiceHelper.now());
        reportHeader.setBillstatus("C");
        reportHeader.setProgress(0);
        reportHeader.setUsetime(0L);
        reportHeader.setType("1");
        reportHeader.setInstanceid(Instance.getInstanceId());
        String[] numberArr = CodeRuleServiceHelper.getBatchNumber((String)"aca_calcreport", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"aca_calcreport"), (String)"", (int)1);
        if (numberArr.length > 0) {
            reportHeader.setBillno(numberArr[0]);
        }
        SaveServiceHelper.save((IDataEntityType)rptHeadType, (Object[])new Object[]{reportHeader});
        this.getContext().getInputArgs().setCalcReportId(id);
        this.getResultManager().setCalcReport(reportHeader);
        logger.info(String.format("\u3010\u521b\u5efa\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u3011\uff1a\u7ed3\u675f\u3002 actCalcReportId: %s", reportHeader.getId()));
    }
}

