/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.common.TaskConfigConstant;
import kd.macc.aca.algox.costcalc.ActCostCalcContext;
import kd.macc.aca.algox.costcalc.ActCostCalcDataInputFactory;
import kd.macc.aca.algox.costcalc.ActTaskRecorder;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.action.ActCalcAction;
import kd.macc.aca.algox.costcalc.action.DebugInfoMsgHandler;
import kd.macc.aca.algox.costcalc.common.ActCalcHelper;
import kd.macc.aca.algox.costcalc.common.ActCalcMaterial;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.AcaAlgoxMaterialLevelHelper;
import kd.macc.aca.algox.utils.AcaDataSetXLogUtil;
import kd.macc.aca.algox.utils.DataSetHelper;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.aca.algox.utils.PeriodHelper;

public class ActMaterialLvlCalcAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(ActCalcAction.class);
    private static final String ALGOKEY = "ActMaterialLvlCalcAction";

    @Override
    protected void doExecute() {
        ActCostCalcArgs args = this.getContext().getInputArgs();
        ActTaskRecorder taskRecorder = this.getResultManager().getTaskRecorder();
        String logUniqueKey = this.getContext().getInputArgs().getGetLogUniqueKey();
        ActCostCalcDataInputFactory datainputFactory = new ActCostCalcDataInputFactory();
        taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_MATLEVEL, "2");
        long start = System.currentTimeMillis();
        DataSet cacheMatallocDataSet = this.buildMatAllocDataSet(args);
        Set<Long> needDealSideMaterialIds = this.dealSideMainUse(cacheMatallocDataSet.copy(), args, datainputFactory);
        if (!needDealSideMaterialIds.isEmpty()) {
            cacheMatallocDataSet = this.dealSideMaterialFilter(cacheMatallocDataSet, needDealSideMaterialIds);
            Set<String> curCalMatNumbers = datainputFactory.buildMaterialNumberSetByMaterialIdSet(needDealSideMaterialIds);
            DebugInfoMsgHandler msgHander = new DebugInfoMsgHandler(args.getTaskRecordId(), 1);
            String logInfo = String.format(ResManager.loadKDString((String)"\u5373\u662f\u4e3b\u53c8\u662f\u526f\u7684\u7269\u6599\uff0c\u9632\u6b62\u4f4e\u9636\u7801\u5d4c\u5957\uff0c\u653e\u5165\u7b2c2\u5c42\uff1a%s", (String)"ActMaterialLvlCalcAction_14", (String)"macc-aca-algox", (Object[])new Object[0]), curCalMatNumbers);
            msgHander.dealInfoMsg(logInfo);
            LogUtils.logInfo(logUniqueKey, logger, String.format("%s,time\uff1a%s", logInfo, System.currentTimeMillis() - start));
        }
        cacheMatallocDataSet = this.dealMainJoinDataSet(cacheMatallocDataSet, args, datainputFactory);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(cacheMatallocDataSet.getRowMeta().getFieldNames()));
        fieldNames.remove("subauxpty");
        fieldNames.remove("submatversion");
        fieldNames.remove("auxpty");
        fieldNames.remove("matversion");
        fieldNames.add("0L as subauxpty");
        fieldNames.add("0L as submatversion");
        fieldNames.add("0L as auxpty");
        fieldNames.add("0L as matversion");
        cacheMatallocDataSet = cacheMatallocDataSet.select(fieldNames.toArray(new String[0]));
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u4f4e\u9636\u7801-\u67e5\u8be2\u6750\u6599\u8017\u7528\u5206\u914d\u6570\u636e\u8017\u65f6\uff1a%s ms", (String)"ActMaterialLvlCalcAction_0", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        this.getContext().setCacheMatallocDataSet(cacheMatallocDataSet);
        List<Set<ActCalcMaterial>> matList = AcaAlgoxMaterialLevelHelper.getMatLevelList(args, cacheMatallocDataSet.copy());
        if (CollectionUtils.isEmpty(matList)) {
            matList = new ArrayList<Set<ActCalcMaterial>>();
            matList.add(Sets.newHashSetWithExpectedSize((int)16));
        }
        long rangestart = System.currentTimeMillis();
        this.setCalcCostObjectRange(this.getContext());
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u4f4e\u9636\u7801-\u8bbe\u7f6e\u8ba1\u7b97\u8303\u56f4\uff1a%s ms", (String)"ActMaterialLvlCalcAction_1", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - rangestart));
        this.setCostObjectNotMatUseToMatLvl(this.getContext(), matList);
        this.getContext().setMatLvlList(matList);
        this.setMaterialHasFactSet(this.getContext());
        if (!needDealSideMaterialIds.isEmpty()) {
            this.setSideMaterialToTwoLevel(needDealSideMaterialIds);
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            this.logMatLvlNo(logUniqueKey, matList);
        }
        if (matList.size() == 2 && matList.get(0).isEmpty() && matList.get(1).isEmpty()) {
            LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"ActMaterialLvlCalcAction \u5b9e\u9645\u6210\u672c\u8ba1\u7b97\uff1a\u9000\u51fa\uff0cmats.size()==0", (String)"ActMaterialLvlCalcAction_2", (String)"macc-aca-algox", (Object[])new Object[0]));
            taskRecorder.upateTaskRecord(10, "2");
            taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_MATLEVEL, "3");
            this.getContext().setMatLvlList(null);
            return;
        }
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u7269\u6599\u4f4e\u9636\u7801\u6392\u5e8f\u3011\u603b\u7ea7\u6b21:%1$s,\u8017\u65f6:%2$s", (String)"ActMaterialLvlCalcAction_11", (String)"macc-aca-algox", (Object[])new Object[0]), matList.size(), System.currentTimeMillis() - start));
        taskRecorder.upateTaskRecordDetail(TaskConfigConstant.PENIODEND_MATLEVEL, "4");
        taskRecorder.upateTaskRecord(10, "2");
    }

    private void setSideMaterialToTwoLevel(Set<Long> needDealSideMaterialIds) {
        Set<ActCalcMaterial> twoMaterials = this.getContext().getMatLvlList().get(1);
        for (ActCalcMaterial material : twoMaterials) {
            if (!needDealSideMaterialIds.contains(material.getMaterialId())) continue;
            needDealSideMaterialIds.remove(material.getMaterialId());
        }
        for (Long subSideMaterialId : needDealSideMaterialIds) {
            ActCalcMaterial material = new ActCalcMaterial();
            material.setMaterialId(subSideMaterialId);
            material.setMaterialNumber("");
            material.setLevel(0);
            material.setMaterialAuxPropId(0L);
            material.setMaterialVer(0L);
            material.setCostObjectId(0L);
            twoMaterials.add(material);
        }
    }

    private DataSet dealSideMaterialFilter(DataSet cacheMatallocDataSet, Set<Long> needDealSideMaterialIds) {
        StringBuilder sb = new StringBuilder();
        for (Long costcenter : needDealSideMaterialIds) {
            sb.append(costcenter).append(",");
        }
        String filterStr = "material not in(" + sb.toString().substring(0, sb.length() - 1) + ")";
        return cacheMatallocDataSet.filter(filterStr);
    }

    private Set<Long> dealSideMainUse(DataSet materialAllocCopyDs, ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory) {
        if (materialAllocCopyDs.isEmpty()) {
            return Sets.newHashSetWithExpectedSize((int)10);
        }
        materialAllocCopyDs = materialAllocCopyDs.groupBy(new String[]{"submaterial", "costobject", "material"}).finish();
        HashSet submaterialIds = Sets.newHashSetWithExpectedSize((int)10);
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)10);
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Row row : materialAllocCopyDs) {
            submaterialIds.add(row.getLong("submaterial"));
            costobjectIds.add(row.getLong("costobject"));
            materialIds.add(row.getLong("material"));
        }
        DataSet relaCostobjectDs = datainputFactory.getMainJoinSideCostobjDsFromMainId(args.getOrgId(), costobjectIds, new String[]{"B"});
        HashSet sideMaterialIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Row row : relaCostobjectDs) {
            sideMaterialIds.add(row.getLong("material"));
        }
        if (sideMaterialIds.isEmpty()) {
            return sideMaterialIds;
        }
        sideMaterialIds.retainAll(materialIds);
        if (sideMaterialIds.isEmpty()) {
            return sideMaterialIds;
        }
        HashSet needDealSideMaterialIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Long sideMaterialId : sideMaterialIds) {
            if (!submaterialIds.contains(sideMaterialId)) continue;
            needDealSideMaterialIds.add(sideMaterialId);
        }
        return needDealSideMaterialIds;
    }

    public List<Set<Long>> costRecGetMatLvlV1(ActCostCalcArgs args) {
        DataSet cacheMatallocDataSet = this.buildMatAllocDataSet(args);
        ActCostCalcDataInputFactory datainputFactory = new ActCostCalcDataInputFactory();
        cacheMatallocDataSet = this.dealMainJoinDataSet(cacheMatallocDataSet, args, datainputFactory);
        List<Set<ActCalcMaterial>> materlvl = AcaAlgoxMaterialLevelHelper.getMatLevelList(args, cacheMatallocDataSet);
        Set<Long> prodIds = this.buildCurrentFactMatSet(args);
        Set<Long> preProdIds = this.buildPreProductList(args);
        prodIds.addAll(preProdIds);
        ArrayList<Set<Long>> lvlMatList = new ArrayList<Set<Long>>(10);
        if (materlvl == null) {
            materlvl = new ArrayList<Set<ActCalcMaterial>>(10);
        }
        for (Set<ActCalcMaterial> curCalcMat : materlvl) {
            if (curCalcMat.isEmpty()) continue;
            HashSet curCalcMatIdSet = Sets.newHashSetWithExpectedSize((int)curCalcMat.size());
            for (ActCalcMaterial actCalcMaterial : curCalcMat) {
                curCalcMatIdSet.add(actCalcMaterial.getMaterialId());
            }
            if (curCalcMatIdSet.isEmpty()) continue;
            lvlMatList.add(curCalcMatIdSet);
            prodIds.removeAll(curCalcMatIdSet);
        }
        if (!prodIds.isEmpty()) {
            if (lvlMatList.isEmpty()) {
                lvlMatList.add(prodIds);
            } else {
                ((Set)lvlMatList.get(lvlMatList.size() - 1)).addAll(prodIds);
            }
        }
        return lvlMatList;
    }

    private void setMaterialHasFactSet(ActCostCalcContext context) {
        HashSet twoLevelCalcOutServiceMat = Sets.newHashSetWithExpectedSize((int)16);
        Set<Long> curFactMatSet = this.buildCurrentFactMatSet(this.getContext().getInputArgs());
        Set<ActCalcMaterial> oneCalcMatMaterialSet = context.getMatLvlList().get(0);
        for (ActCalcMaterial actCalcMaterial : oneCalcMatMaterialSet) {
            if (!curFactMatSet.contains(actCalcMaterial.getMaterialId())) continue;
            twoLevelCalcOutServiceMat.add(actCalcMaterial.getMaterialId());
        }
        Set<ActCalcMaterial> twoCalcMatMaterialSet = context.getMatLvlList().get(1);
        HashSet twoMaterials = Sets.newHashSetWithExpectedSize((int)16);
        for (ActCalcMaterial material : twoCalcMatMaterialSet) {
            twoMaterials.add(material.getMaterialId());
        }
        if (!twoMaterials.isEmpty()) {
            HashSet productMaterials = Sets.newHashSetWithExpectedSize((int)16);
            for (int i = 2; i < context.getMatLvlList().size(); ++i) {
                Set<ActCalcMaterial> calcMatMaterialSet = context.getMatLvlList().get(i);
                for (ActCalcMaterial material : calcMatMaterialSet) {
                    productMaterials.add(material.getMaterialId());
                }
            }
            twoMaterials.removeAll(productMaterials);
        }
        if (!twoMaterials.isEmpty()) {
            logger.info("\u975e\u7b2c2\u5c42\u6709\u5b8c\u5de5\u5165\u5e93\uff0c\u52a0\u5165\u5230\u7b2c2\u5c42\u51fa\u5e93\u6838\u7b97\uff1a{}", (Object)twoMaterials);
            twoLevelCalcOutServiceMat.addAll(twoMaterials);
        }
        context.setTwoLevelOutStMats(twoLevelCalcOutServiceMat);
    }

    private void setCalcCostObjectRange(ActCostCalcContext context) {
        ActCostCalcArgs args = this.getContext().getInputArgs();
        this.buildProMatToCostObjectSet(context.getInputArgs());
        HashSet notRoCostObjectIds = Sets.newHashSetWithExpectedSize((int)16);
        Set<Long> costObjectFilterIds = this.buildPlanCostObject(args, notRoCostObjectIds);
        LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u627e\u5230\u7684\u5bf9\u5e94\u6210\u672c\u6838\u7b97\u5bf9\u8c61id", (String)"ActMaterialLvlCalcAction_5", (String)"macc-aca-algox", (Object[])new Object[0]), costObjectFilterIds);
        Set<Long> preCostObjectFilterIds = this.buildLastCalcResultCostObject(args);
        LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u4e0a\u671f\u7684\u8ba1\u7b97\u7ed3\u679c\u5355\u7684\u6210\u672c\u5bf9\u8c61\u96c6\u5408", (String)"ActMaterialLvlCalcAction_6", (String)"macc-aca-algox", (Object[])new Object[0]), preCostObjectFilterIds);
        costObjectFilterIds.addAll(preCostObjectFilterIds);
        Set<Long> adjCostObjectFilterIds = this.buildAdjustCostobject(args);
        LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u672c\u671f\u7684\u6210\u672c\u8c03\u6574\u5355\u7684\u6210\u672c\u5bf9\u8c61\u96c6\u5408", (String)"ActMaterialLvlCalcAction_4", (String)"macc-aca-algox", (Object[])new Object[0]), adjCostObjectFilterIds);
        costObjectFilterIds.addAll(adjCostObjectFilterIds);
        context.setCacheCostObjectFilterIds(costObjectFilterIds);
        Set<Long> matUseCostObjectIds = this.buildMatAllocCostObject(args);
        matUseCostObjectIds.addAll(context.getInputArgs().getResultCostObjectIds());
        Set<Long> mftCostObjectIds = this.buildMfgFeeAllocCostObject(args);
        HashSet hasPutCostObjectIds = Sets.newHashSetWithExpectedSize((int)1024);
        hasPutCostObjectIds.addAll(matUseCostObjectIds);
        hasPutCostObjectIds.addAll(mftCostObjectIds);
        hasPutCostObjectIds.removeAll(preCostObjectFilterIds);
        notRoCostObjectIds.removeAll(preCostObjectFilterIds);
        hasPutCostObjectIds.addAll(notRoCostObjectIds);
        adjCostObjectFilterIds.removeAll(preCostObjectFilterIds);
        hasPutCostObjectIds.addAll(adjCostObjectFilterIds);
        args.setCacheNestCalResultCostObjects(hasPutCostObjectIds);
        HashSet cacheCostObjects = Sets.newHashSetWithExpectedSize((int)128);
        cacheCostObjects.addAll(context.getCacheCostObjectFilterIds());
        cacheCostObjects.removeAll(context.getInputArgs().getResultCostObjectIds());
        matUseCostObjectIds.removeAll(context.getInputArgs().getResultCostObjectIds());
        cacheCostObjects.addAll(matUseCostObjectIds);
        mftCostObjectIds.removeAll(context.getInputArgs().getResultCostObjectIds());
        cacheCostObjects.addAll(mftCostObjectIds);
        args.setCacheNotMatUseCostObjects(cacheCostObjects);
    }

    private void setCostObjectNotMatUseToMatLvl(ActCostCalcContext context, List<Set<ActCalcMaterial>> matList) {
        Set<Long> cacheNotMatUseCostObject = context.getInputArgs().getCacheNotMatUseCostObjects();
        HashSet<ActCalcMaterial> calcMatSet = new HashSet<ActCalcMaterial>(16);
        ArrayList<ActCalcMaterial> reworkMatSet = new ArrayList<ActCalcMaterial>();
        HashSet<Long> reworkCostObject = new HashSet<Long>();
        if (!CollectionUtils.isEmpty(cacheNotMatUseCostObject)) {
            QFilter filter = new QFilter("id", "in", cacheNotMatUseCostObject);
            filter.and("producttype", "=", (Object)"C");
            String selectFields = "id,costcenter, material,material.number AS materialnumber,material.isuseauxpty AS isuseauxpty,auxpty,material.isenablematerialversion AS isversion,bomversion AS matversion,isrework";
            DataSet costObjectResult = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_costobject", (String)selectFields, (QFilter[])filter.toArray(), null);
            cacheNotMatUseCostObject.clear();
            for (Row row : costObjectResult) {
                ActCalcMaterial material = new ActCalcMaterial();
                Long curMatId = row.getLong("material");
                Long costobjectId = row.getLong("id");
                context.getInputArgs().getResultCostCenterIds().add(row.getLong("costcenter"));
                material.setMaterialId(curMatId);
                material.setMaterialNumber(row.getString("materialnumber"));
                material.setLevel(0);
                material.setMaterialAuxPropId(row.getLong("auxpty"));
                material.setMaterialVer(row.getLong("matversion"));
                material.setCostObjectId(costobjectId);
                Boolean isrework = row.getBoolean("isrework");
                if (isrework == null || !isrework.booleanValue()) {
                    cacheNotMatUseCostObject.add(costobjectId);
                    calcMatSet.add(material);
                    continue;
                }
                reworkMatSet.add(material);
                reworkCostObject.add(costobjectId);
            }
            if (!CollectionUtils.isEmpty(reworkMatSet)) {
                QFilter matfilter = new QFilter("org", "=", (Object)context.getInputArgs().getOrgId());
                matfilter.and(new QFilter("allocstatus", "=", (Object)"2"));
                matfilter.and(new QFilter("appnum", "=", (Object)"aca"));
                matfilter.and(new QFilter("costaccount", "=", (Object)context.getInputArgs().getCostAccountId()));
                matfilter.and(new QFilter("period", "=", (Object)context.getInputArgs().getPeriodId()));
                if (context.getInputArgs().getManuOrgId() != null && context.getInputArgs().getManuOrgId() > 0L) {
                    matfilter.and(new QFilter("manuorg", "=", (Object)context.getInputArgs().getManuOrgId()));
                }
                matfilter.and(new QFilter("entryentity.costobejctentry", "in", reworkCostObject));
                String matSelectFields = "entryentity.costobejctentry AS costobject";
                DataSet matDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_matalloc", (String)matSelectFields, (QFilter[])new QFilter[]{matfilter}, null);
                reworkCostObject.clear();
                for (Row row : matDataSet) {
                    reworkCostObject.add(row.getLong("costobject"));
                }
                for (ActCalcMaterial material : reworkMatSet) {
                    if (reworkCostObject.contains(material.getCostObjectId()) && context.getInputArgs().getMatCostobjectListMap().containsKey(material.getMaterialId())) {
                        context.getInputArgs().getMatCostobjectListMap().get(material.getMaterialId()).add(material.getCostObjectId());
                        continue;
                    }
                    cacheNotMatUseCostObject.add(material.getCostObjectId());
                    calcMatSet.add(material);
                }
            }
        }
        matList.add(1, calcMatSet);
    }

    private DataSet dealMainJoinDataSet(DataSet mainMatAlloc, ActCostCalcArgs args, ActCostCalcDataInputFactory datainputFactory) {
        DataSet joinMatAlloc = mainMatAlloc.copy().filter("productgroup > 0");
        if (joinMatAlloc.isEmpty()) {
            return mainMatAlloc;
        }
        DataSet probillIdDs = joinMatAlloc.copy().select("costobject").distinct();
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : probillIdDs) {
            costobjectIds.add(row.getLong("costobject"));
        }
        DebugInfoMsgHandler msgHander = null;
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            msgHander = new DebugInfoMsgHandler(args.getTaskRecordId(), 1);
        }
        if (!CollectionUtils.isEmpty((Collection)costobjectIds)) {
            LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u6709\u4e3b\u8054\u526f\u7684\u5de5\u5355\u96c6\u5408", (String)"ActMaterialLvlCalcAction_7", (String)"macc-aca-algox", (Object[])new Object[0]), costobjectIds);
            DataSet relaCostobjectDs = datainputFactory.getMainJoinSideCostobjDsFromMainId(args.getOrgId(), costobjectIds, new String[]{"A"});
            joinMatAlloc = joinMatAlloc.join(relaCostobjectDs).on("costobject", "mainCostObjectId").select(new String[]{"costcenter", "submaterial", "submaterialnumber", "subauxpty", "submatversion", "material as mainmaterial", "materialnumber mainmaterialnumber", "auxpty as mainAuxpty", "matversion as mainMatversion"}, new String[]{"costObjectId costobject", "material", "materialnumber", "auxpty", "matversion", "productgroup", "srcbillnumber"}).finish();
            DataSet joinMatAllocMain = joinMatAlloc.copy().select(new String[]{"material", "materialnumber", "auxpty", "matversion", "mainMaterial", "mainmaterialnumber", "mainAuxpty", "mainMatversion"}).filter("material!=mainMaterial").distinct();
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                AcaDataSetXLogUtil.logDataSet(joinMatAllocMain.copy(), ResManager.loadKDString((String)"\u8054\u4ea7\u54c1\u5bf9\u5e94\u7684\u4e3b\u4ea7\u54c1\u5217\u8868", (String)"ActMaterialLvlCalcAction_9", (String)"macc-aca-algox", (Object[])new Object[0]), msgHander);
            }
            mainMatAlloc = DataSetHelper.union(mainMatAlloc, joinMatAlloc.removeFields(new String[]{"mainAuxpty", "mainMatversion"}));
            DataSet joinToMainDs = mainMatAlloc.copy().join(joinMatAllocMain).on("submaterial", "material").select(new String[]{"costcenter", "costobject", "material", "materialnumber", "auxpty", "matversion", "productgroup", "srcbillnumber"}, new String[]{"mainMaterial as submaterial", "mainmaterialnumber as submaterialnumber", "mainAuxpty as subauxpty", "mainMatversion as submatversion", "material as mainmaterial", "materialnumber as mainmaterialnumber"}).finish();
            if (!joinToMainDs.isEmpty()) {
                mainMatAlloc = DataSetHelper.union(mainMatAlloc, joinToMainDs);
            }
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(mainMatAlloc, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s\u3010\u4f4e\u9636\u7801-\u9886\u6599\u6570\u636e\u3011", (String)"ActMaterialLvlCalcAction_12", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey()), msgHander);
        }
        return mainMatAlloc;
    }

    private DataSet buildMatAllocDataSet(ActCostCalcArgs args) {
        QFilter filter = new QFilter("allocstatus", "=", (Object)"2");
        filter.and("appnum", "=", (Object)"aca");
        filter.and("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("isreturnitem", "=", (Object)false);
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("costcenter").append(",material.id AS submaterial,material.number AS submaterialnumber").append(",auxpty AS subauxpty");
        selectFields.append(",matversion AS submatversion");
        selectFields.append(",entryentity.costobejctentry AS costobject");
        selectFields.append(",entryentity.costobejctentry.material AS material");
        selectFields.append(",entryentity.costobejctentry.material.number AS materialnumber");
        selectFields.append(",entryentity.costobejctentry.auxpty AS auxpty");
        selectFields.append(",entryentity.costobejctentry.bomversion AS matversion");
        selectFields.append(",entryentity.costobejctentry.productgroup AS productgroup");
        selectFields.append(",entryentity.costobejctentry.srcbillnumber AS srcbillnumber");
        selectFields.append(",0L AS mainmaterial");
        selectFields.append(",' ' AS mainmaterialnumber");
        DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_matalloc", (String)selectFields.toString(), (QFilter[])filter.toArray(), null);
        tmpDataSet = tmpDataSet.distinct();
        return tmpDataSet;
    }

    private DataSet buildCalcResultDataSet(ActCostCalcArgs args) {
        QFilter filter = new QFilter("period", "=", (Object)args.getPeriodId());
        filter.and("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(args.getManuOrgId())) {
            filter.and("costobject.manuorg.id", "=", (Object)args.getManuOrgId());
        }
        filter.and("entryentity.submaterial", ">", (Object)0L);
        filter.and("entryentity.relacostobject.producttype", "!=", (Object)"B");
        DataSet calcResult = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_calcresult", (String)"costcenter,entryentity.relacostobject costobject,entryentity.relacostobject.material AS material,entryentity.relacostobject.material.number AS materialnumber,entryentity.relacostobject.auxpty AS auxpty,entryentity.relacostobject.bomversion AS matversion,entryentity.submaterial AS submaterial,entryentity.submaterial.number AS submaterialnumber,entryentity.subauxpty AS subauxpty,entryentity.submatversion AS submatversion,entryentity.currcomqty as pdFinQty,entryentity.currcomamount as pdFinAmt", (QFilter[])filter.toArray(), null);
        return calcResult.filter("pdFinQty!=0 or pdFinAmt!=0").filter("material!=submaterial").removeFields(new String[]{"pdFinQty", "pdFinAmt"});
    }

    private Set<Long> buildPreProductList(ActCostCalcArgs args) {
        QFilter prdStructureFilter = new QFilter("org", "=", (Object)args.getOrgId());
        prdStructureFilter.and("costaccount", "=", (Object)args.getCostAccountId());
        prdStructureFilter.and("period", "=", (Object)args.getPeriodId());
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(args.getManuOrgId())) {
            prdStructureFilter.and("prdorg", "=", (Object)args.getManuOrgId());
        }
        prdStructureFilter.and("billstatus", "=", (Object)"C");
        DataSet prdStructure = QueryServiceHelper.queryDataSet((String)"ActMaterialLvlCalcAction4", (String)"sca_halfprdstructure", (String)"material.id as material", (QFilter[])prdStructureFilter.toArray(), null);
        return ActCalcHelper.getLongIdSetFromDs(prdStructure, "material", false);
    }

    public Set<Long> buildPlanCostObject(ActCostCalcArgs args, Set<Long> notRoCostObjectIds) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"aca");
        QFilter qfStartDate = new QFilter("bizdate", ">=", (Object)args.getStartDate());
        QFilter qfEndDate = new QFilter("bizdate", "<=", (Object)args.getEndDate());
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter accountorg = new QFilter("accountorg", "=", (Object)args.getOrgId());
        QFilter productType = new QFilter("costobject.producttype", "=", (Object)"C");
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            accountorg.and(new QFilter("manuorg", "=", (Object)args.getManuOrgId()));
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_plannedoutputbill", (String)"costobject,costobject.biztype biztype", (QFilter[])new QFilter[]{accountorg, qfStartDate, qfEndDate, qfBillStatus, qfAppNum, productType}, null);
        HashSet<Long> costObjectFilterIds = new HashSet<Long>(16);
        for (Row row : ds) {
            if (!"RO".equals(row.getString("biztype"))) {
                notRoCostObjectIds.add(row.getLong("costobject"));
            }
            costObjectFilterIds.add(row.getLong("costobject"));
        }
        return costObjectFilterIds;
    }

    public Set<Long> buildLastCalcResultCostObject(ActCostCalcArgs args) {
        QFilter preFilter = new QFilter("period", "=", (Object)PeriodHelper.getPrePeriodId(args.getPeriodId()));
        preFilter.and("org", "=", (Object)args.getOrgId());
        preFilter.and("costaccount", "=", (Object)args.getCostAccountId());
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            preFilter.and("costobject.manuorg.id", "=", (Object)args.getManuOrgId());
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_calcresult", (String)"costobject", (QFilter[])preFilter.toArray(), null);
        return ActMaterialLvlCalcAction.getCostObjectIds(ds);
    }

    public Set<Long> buildAdjustCostobject(ActCostCalcArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        String selectFields = "costobject";
        DataSet adjDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_wipadjustbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        return ActMaterialLvlCalcAction.getCostObjectIds(adjDataSet);
    }

    public Set<Long> buildMfgFeeAllocCostObject(ActCostCalcArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("allocstatus", "=", (Object)"2");
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_mfgfeeallocco", (String)"entryentity.costobject as costobject", (QFilter[])filter.toArray(), null);
        return ActMaterialLvlCalcAction.getCostObjectIds(ds);
    }

    public Set<Long> buildMatAllocCostObject(ActCostCalcArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("allocstatus", "=", (Object)"2");
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        filter.and("isreturnitem", "=", (Object)true);
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_matalloc", (String)"entryentity.costobejctentry as costobject", (QFilter[])filter.toArray(), null);
        return ActMaterialLvlCalcAction.getCostObjectIds(ds);
    }

    public Set<Long> buildCurrentFactMatSet(ActCostCalcArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "entryentity.costobject.material material";
        DataSet factned = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        HashSet currentFactMatSet = Sets.newHashSetWithExpectedSize((int)32);
        for (Row row : factned) {
            currentFactMatSet.add(row.getLong("material"));
        }
        return currentFactMatSet;
    }

    public void buildProMatToCostObjectSet(ActCostCalcArgs args) {
        QFilter filter = new QFilter("id", "in", args.getResultCostObjectIds());
        filter.and("producttype", "=", (Object)"C");
        String selectFields = "id costobject, material promat";
        DataSet costObjectResult = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_costobject", (String)selectFields, (QFilter[])filter.toArray(), null);
        for (Row row : costObjectResult) {
            args.getMatCostobjectListMap().computeIfAbsent(row.getLong("promat"), t -> new HashSet(16)).add(row.getLong("costobject"));
        }
    }

    private static Set<Long> getCostObjectIds(DataSet costObjectDataSet) {
        HashSet<Long> costObjectFilterIds = new HashSet<Long>(16);
        for (Row row : costObjectDataSet) {
            costObjectFilterIds.add(row.getLong("costobject"));
        }
        return costObjectFilterIds;
    }

    private void logMatLvlNo(String logUniqueKey, List<Set<ActCalcMaterial>> matList) {
        int level = 0;
        for (Set<ActCalcMaterial> set : matList) {
            StringBuilder sb = new StringBuilder(2000);
            sb.append("level:").append(level).append(",");
            int index = 0;
            for (ActCalcMaterial mat : set) {
                sb.append(",").append(mat.getMaterialNumber());
                if (++index <= 100) continue;
                LogUtils.logInfo(logUniqueKey, logger, sb.toString());
                index = 0;
                sb.setLength(0);
                sb.append("level:").append(level).append(",");
            }
            LogUtils.logInfo(logUniqueKey, logger, sb.toString());
            ++level;
        }
    }
}

