/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.utils.AcaAlgoxCostAccountHelper;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ActUpPlanOutBizdateAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(ActUpPlanOutBizdateAction.class);
    private static String ALGOKEY = "ActUpPlanOutBizdateAction";

    @Override
    protected void doExecute() {
        logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u7684\u4e1a\u52a1\u65e5\u671f\u53ef\u81ea\u52a8\u4fee\u6539\uff1a\u5f00\u59cb!");
        ActCostCalcArgs args = this.getContext().getInputArgs();
        Long orgId = args.getOrgId();
        DynamicObjectCollection costAccounts = AcaAlgoxCostAccountHelper.getEnableCostAccountCollection(orgId);
        if (costAccounts.size() == 1) {
            Set<Long> preCostObjectIds = this.buildLastCalcResultCostObject(args);
            this.buildPlanCostObject(args, preCostObjectIds);
        }
        logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u7684\u4e1a\u52a1\u65e5\u671f\u53ef\u81ea\u52a8\u4fee\u6539\uff1a\u7ed3\u675f!");
    }

    public void buildPlanCostObject(ActCostCalcArgs args, Set<Long> preCostObjectIds) {
        Long periodId = args.getPeriodId();
        Date preBeginDate = PeriodHelper.getPeriodBeginDate(periodId);
        Set<Long> allPlanIds = this.getAllPlanBillIds(args, preCostObjectIds);
        if (allPlanIds.isEmpty()) {
            return;
        }
        QFilter qfPlanId = new QFilter("id", "in", allPlanIds);
        DataSet allDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_plannedoutputbill", (String)"id,costobject,costobject.productType productType,costobject.productgroup productgroup,costobject.srcbillnumber srcbillnumber", (QFilter[])new QFilter[]{qfPlanId}, null);
        DataSet mainPGDataSet = allDataSet.filter("productType = 'C'").filter("productgroup > 0");
        DataSet mainDataSet = allDataSet.filter("productType = 'C'").filter("productgroup = 0");
        DataSet unClacDataSet = allDataSet.join(mainPGDataSet).on("productgroup", "productgroup").on("srcbillnumber", "srcbillnumber").select(new String[]{"id"}, new String[0]).finish().union(mainDataSet.select("id"));
        HashSet planIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : unClacDataSet) {
            planIds.add(row.getLong("id"));
        }
        if (!planIds.isEmpty()) {
            DynamicObject[] planOutputBills;
            QFilter qfId = new QFilter("id", "in", (Object)planIds);
            for (DynamicObject bill : planOutputBills = BusinessDataServiceHelper.load((String)"cad_plannedoutputbill", (String)"id,bizdate,ismodifybizdate", (QFilter[])new QFilter[]{qfId})) {
                bill.set("bizdate", (Object)preBeginDate);
                bill.set("ismodifybizdate", (Object)Boolean.TRUE);
            }
            LogUtils.logInfoIdColl(args.getCalcReportId(), logger, ResManager.loadKDString((String)"\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u5f52\u96c6\u81ea\u52a8\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u96c6\u5408", (String)"ActUpPlanOutBizdateAction_0", (String)"macc-aca-algox", (Object[])new Object[0]), planIds);
            SaveServiceHelper.update((DynamicObject[])planOutputBills);
        }
    }

    private Set<Long> getAllPlanBillIds(ActCostCalcArgs args, Set<Long> preCostObjectIds) {
        Long prePeriod = args.getPrePeriodId();
        if (CadEmptyUtils.isEmpty((Long)prePeriod)) {
            return Sets.newHashSetWithExpectedSize((int)8);
        }
        Map<String, Date> dateMap = PeriodHelper.getPeriodBeginDateAndEndDate(PeriodHelper.getPeriod(prePeriod));
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"aca");
        QFilter qfStartDate = new QFilter("bizdate", ">=", (Object)dateMap.get("begindate"));
        QFilter qfEndDate = new QFilter("bizdate", "<=", (Object)dateMap.get("enddate"));
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter accountorg = new QFilter("accountorg", "=", (Object)args.getOrgId());
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            accountorg.and(new QFilter("manuorg", "=", (Object)args.getManuOrgId()));
        }
        QFilter qfBiztype = new QFilter("costobject.biztype", "=", (Object)"RO");
        DataSet allDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_plannedoutputbill", (String)"id,costobject", (QFilter[])new QFilter[]{accountorg, qfStartDate, qfEndDate, qfBillStatus, qfAppNum, qfBiztype}, null);
        HashSet planIds = Sets.newHashSetWithExpectedSize((int)1024);
        for (Row row : allDataSet) {
            Long costObjectId = row.getLong("costobject");
            if (preCostObjectIds.contains(costObjectId)) continue;
            planIds.add(row.getLong("id"));
        }
        return planIds;
    }

    public Set<Long> buildLastCalcResultCostObject(ActCostCalcArgs args) {
        QFilter preFilter = new QFilter("period", "=", (Object)args.getPrePeriodId());
        preFilter.and("org", "=", (Object)args.getOrgId());
        preFilter.and("costaccount", "=", (Object)args.getCostAccountId());
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            preFilter.and("costobject.manuorg.id", "=", (Object)args.getManuOrgId());
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_calcresult", (String)"costobject", (QFilter[])preFilter.toArray(), null);
        return ActUpPlanOutBizdateAction.getCostObjectIds(ds);
    }

    private static Set<Long> getCostObjectIds(DataSet costObjectDataSet) {
        HashSet<Long> costObjectFilterIds = new HashSet<Long>(16);
        for (Row row : costObjectDataSet) {
            costObjectFilterIds.add(row.getLong("costobject"));
        }
        return costObjectFilterIds;
    }
}

