/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CoProductCostCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        filter.and("bookdate", ">=", (Object)context.getPeriodStartDate());
        filter.and("bookdate", "<=", (Object)context.getPeriodEndDate());
        filter.and("entryentity.costobject.productgroup", ">", (Object)0L);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.costobject.producttype", "=", (Object)"B");
        if (context.getManuOrgId() != null && context.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)context.getManuOrgId());
        }
        String selectFields = "entryentity.costobject.srcbillnumber as mftOrderNo,costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity.costobject.producttype as productType,entryentity.costobject.productgroup.id as groupId,material as matId,version as matVerId,auxpty as matAuxId,material.number as matNumber,material.name as matName";
        DataSet factned = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        HashMap checkMap = Maps.newHashMap();
        for (Row row : factned) {
            HashMap tmp = Maps.newHashMap();
            tmp.put("costCenterId", row.getString("costCenterId"));
            tmp.put("mftOrderNo", row.get("mftOrderNo"));
            tmp.put("matStr", row.getString("matNumber") + "/" + row.getString("matName"));
            checkMap.put(row.getLong("matId"), tmp);
        }
        if (checkMap.size() == 0) {
            return;
        }
        filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("startdate", "<", (Object)context.getPeriodEndDate());
        filter.and("enddate", ">", (Object)context.getPeriodEndDate());
        filter.and("material.id", "in", checkMap.keySet());
        DataSet proextraPriceDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"aca_proextraprice", (String)"material.id as matId,matversion as matVerId,auxpty.id as matAuxId", (QFilter[])filter.toArray(), null);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        for (Row row : proextraPriceDataSet) {
            materialIds.add(row.getLong("matId"));
        }
        String detailDesc1 = ResManager.loadKDString((String)"\u5de5\u5355\u201c%1$s\u201d\u7684\u7269\u6599\u201c%2$s\u201d\u4e3a\u526f\u4ea7\u54c1\uff0c\u672a\u7ef4\u62a4\u5b9a\u989d\u6210\u672c\uff0c\u8bf7\u5728\u201c\u7269\u6599\u5b9a\u989d\u6210\u672c\u4ef7\u76ee\u8868\u201d\u4e2d\u7ef4\u62a4\u3002", (String)"CoProductCostCheckAction_3", (String)"macc-aca-algox", (Object[])new Object[0]);
        String detailDesc2 = ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u4e3a\u526f\u4ea7\u54c1\uff0c\u672a\u7ef4\u62a4\u5b9a\u989d\u6210\u672c\uff0c\u8bf7\u5728\u201c\u7269\u6599\u5b9a\u989d\u6210\u672c\u4ef7\u76ee\u8868\u201d\u4e2d\u7ef4\u62a4\u3002", (String)"CoProductCostCheckAction_1", (String)"macc-aca-algox", (Object[])new Object[0]);
        String checkDesc = ResManager.loadKDString((String)"\u5b58\u5728\u7269\u6599\u672a\u7ef4\u62a4\u5b9a\u989d\u6210\u672c\u3002", (String)"CoProductCostCheckAction_2", (String)"macc-aca-algox", (Object[])new Object[0]);
        for (Map.Entry entrySet : checkMap.entrySet()) {
            if (materialIds.contains(entrySet.getKey())) continue;
            Map tmpMap = (Map)entrySet.getValue();
            String costCenterId = (String)tmpMap.get("costCenterId");
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(Long.valueOf(Long.parseLong(costCenterId)));
            String billNo = String.valueOf(tmpMap.get("mftOrderNo"));
            if (CadEmptyUtils.isEmpty((String)billNo)) {
                info.setCheckDetailResult(String.format(detailDesc2, tmpMap.get("matStr")));
            } else {
                info.setCheckDetailResult(String.format(detailDesc1, tmpMap.get("mftOrderNo"), tmpMap.get("matStr")));
            }
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }
}

