/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostObjNoInButFeeAction
extends AbstractSingleCalcCheckAction {
    private Log logger = LogFactory.getLog(CostObjNoInButFeeAction.class);

    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        Long manuOrgId = context.getManuOrgId();
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"aca");
        QFilter qfOrg = new QFilter("org", "=", (Object)context.getOrgId());
        QFilter qfAccountOrg = new QFilter("accountorg", "=", (Object)context.getOrgId());
        QFilter qfStartDate = new QFilter("bizdate", ">=", (Object)context.getPeriodStartDate());
        QFilter qfEndDate = new QFilter("bizdate", "<=", (Object)context.getPeriodEndDate());
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter qfManuOrg = null;
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(manuOrgId)) {
            qfManuOrg = new QFilter("manuorg", "=", (Object)manuOrgId);
        }
        QFilter mainProductType = new QFilter("costobject.producttype", "=", (Object)Character.valueOf('C'));
        QFilter notOutSourcing = new QFilter("costobject.isoutsource", "=", (Object)false);
        String selectFields = "costcenter,costobject.id AS costobject,costobject.billno AS costobjectbillno,costobject.name AS costobjectname";
        DataSet plan = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_plannedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{qfAccountOrg, qfStartDate, qfEndDate, qfBillStatus, qfAppNum, mainProductType, qfManuOrg, notOutSourcing}, null);
        HashMap costObjMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : plan) {
            costObjMap.put(row.getLong("costobject"), row.getString("costobjectbillno") + "/" + this.getStringVal(row.getString("costobjectname")) + "@" + row.getString("costcenter"));
        }
        QFilter adjustFilter = new QFilter("adjusttype", "=", (Object)"START");
        adjustFilter.and("org", "=", (Object)context.getOrgId());
        adjustFilter.and("costaccount", "=", (Object)context.getCostAccountId());
        adjustFilter.and("period", "=", (Object)context.getPeriodId());
        adjustFilter.and("adjustqty", "!=", (Object)0);
        adjustFilter.and(qfBillStatus);
        adjustFilter.and(notOutSourcing);
        DataSet adjustDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"aca_wipadjustbill", (String)(selectFields + ",wipqty+adjustqty adjustqty"), (QFilter[])adjustFilter.toArray(), null);
        adjustDs = adjustDs.filter("adjustqty>0");
        for (Row row : adjustDs) {
            costObjMap.put(row.getLong("costobject"), row.getString("costobjectbillno") + "/" + this.getStringVal(row.getString("costobjectname")) + "@" + row.getString("costcenter"));
        }
        QFilter filter = new QFilter("period", "=", (Object)PeriodHelper.getPrePeriodId(context.getPeriodId()));
        filter.and("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(manuOrgId)) {
            filter.and("costobject.manuorg", "=", (Object)manuOrgId);
        }
        filter.and("costobject.isoutsource", "=", (Object)false);
        filter.and("entryentity.type", "=", (Object)"finalResult");
        DataSet calcResultDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"aca_calcresult", (String)(selectFields + ",entryentity.pdendqty+entryentity.endadjqty endadjqty"), (QFilter[])filter.toArray(), null);
        calcResultDataSet = calcResultDataSet.filter("endadjqty>0");
        for (Row calcRow : calcResultDataSet) {
            costObjMap.put(calcRow.getLong("costobject"), calcRow.getString("costobjectbillno") + "/" + this.getStringVal(calcRow.getString("costobjectname")) + "@" + calcRow.getString("costcenter"));
        }
        Map costObjDescMap = Maps.newHashMapWithExpectedSize((int)16);
        QFilter qfAllocStatus = new QFilter("allocstatus", "=", (Object)"2");
        QFilter qfNoOutSourcing = new QFilter("entryentity.costobejctentry.isoutsource", "=", (Object)false);
        QFilter qfCostAccount = new QFilter("costaccount", "=", (Object)context.getCostAccountId());
        QFilter qfPeriod = new QFilter("period", "=", (Object)context.getPeriodId());
        DataSet matAlloc = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"sca_matalloc", (String)"entryentity.costobejctentry.id as costobject,entryentity.costobejctentry.billno AS costobjectbillno,entryentity.costobejctentry.name AS costobjectname,costcenter", (QFilter[])new QFilter[]{qfNoOutSourcing, qfOrg, qfCostAccount, qfPeriod, qfAppNum, qfAllocStatus, qfManuOrg}, null).distinct();
        for (Row row : matAlloc) {
            costObjDescMap.put(row.getLong("costobject"), row.getString("costobjectbillno").concat("/").concat(this.getStringVal(row.getString("costobjectname")).concat("@").concat(row.getString("costcenter"))));
        }
        QFilter qfMfgAllocStatus = new QFilter("allocstatus", "=", (Object)"2");
        qfNoOutSourcing = new QFilter("entryentity.costobject.isoutsource", "=", (Object)false);
        QFilter qfAllocAmt = new QFilter("entryentity.allocamt", ">", (Object)0);
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(manuOrgId)) {
            qfManuOrg = new QFilter("entryentity.costobject.manuorg", "=", (Object)manuOrgId);
        }
        DataSet mfgAlloc = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_mfgfeeallocco", (String)"entryentity.costobject.id AS costobject,entryentity.costobject.billno AS costobjectbillno,entryentity.costobject.name AS costobjectname,benefcostcenter AS costcenter", (QFilter[])new QFilter[]{qfNoOutSourcing, qfOrg, qfCostAccount, qfPeriod, qfMfgAllocStatus, qfAllocAmt, qfManuOrg, qfAppNum}, null).distinct();
        for (Object row : mfgAlloc) {
            costObjDescMap.put(row.getLong("costobject"), row.getString("costobjectbillno").concat("/").concat(this.getStringVal(row.getString("costobjectname")).concat("@").concat(row.getString("costcenter"))));
        }
        if (!costObjDescMap.isEmpty()) {
            MapDifference difference = Maps.difference((Map)costObjDescMap, (Map)costObjMap);
            costObjDescMap = difference.entriesOnlyOnLeft();
        }
        if (costObjDescMap.isEmpty()) {
            return;
        }
        String detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%s\u201d\u65e0\u671f\u521d\u5728\u4ea7\u54c1\u6570\u91cf\u53ca\u672c\u671f\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\uff0c\u4f46\u6709\u8d39\u7528\u53d1\u751f\u3002", (String)"CostObjNoInButFeeAction_0", (String)"macc-aca-algox", (Object[])new Object[0]);
        for (Map.Entry entry : costObjDescMap.entrySet()) {
            String[] values = ((String)entry.getValue()).split("@");
            if (values.length != 2) continue;
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(Long.valueOf(Long.parseLong(values[1])));
            info.setCheckDetailResult(String.format(detailDesc, values[0]));
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        String checkDesc = String.format(ResManager.loadKDString((String)"%s\u4e2a\u201c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201d\u65e0\u671f\u521d\u5728\u4ea7\u54c1\u6570\u91cf\u53ca\u672c\u671f\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\uff0c\u4f46\u6709\u8d39\u7528\u53d1\u751f\u3002", (String)"CostObjNoInButFeeAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), this.getSingleCheckContext().getCheckDetailResult().size());
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private String getStringVal(String val) {
        if (val == null) {
            return "";
        }
        return val;
    }
}

