/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class InproallocNotHasValCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        Map<Long, Set<Long>> customCostcenters = this.queryProAllocStd(this.getContext().getOrgId(), this.getContext().getCostAccountId());
        if (customCostcenters.isEmpty()) {
            return;
        }
        Map<String, BigDecimal> costdriverValueMap = this.getInProdAllocStdValMap();
        HashSet costdriverSet = Sets.newHashSetWithExpectedSize((int)10);
        HashSet costcenterSet = Sets.newHashSetWithExpectedSize((int)10);
        HashSet notHasAllocVals = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry<Long, Set<Long>> entry : customCostcenters.entrySet()) {
            Long costcenter = entry.getKey();
            Set<Long> costdrivers = entry.getValue();
            for (Long costdriver : costdrivers) {
                String key = String.format("%s@%s", costdriver, costcenter);
                if (costdriverValueMap.containsKey(key)) continue;
                costdriverSet.add(costdriver);
                costcenterSet.add(costcenter);
                notHasAllocVals.add(key);
            }
        }
        if (!notHasAllocVals.isEmpty()) {
            Map<Long, String> costdriverMap = this.getCostdriverInfo(costdriverSet);
            for (String allocs : notHasAllocVals) {
                Long costdriver;
                String[] allocArr = allocs.split("@");
                if (allocArr.length < 2) continue;
                Long costcenter = Long.valueOf(allocArr[1]);
                costdriver = Long.valueOf(allocArr[0]);
                String costdriverName = costdriverMap.get(costdriver);
                String tip = ResManager.loadKDString((String)"\u6210\u672c\u52a8\u56e0\u201c%s\u201d\u4e0d\u5305\u542b\u6b64\u6210\u672c\u4e2d\u5fc3\u7684\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"InproallocNotHasValCheckAction_0", (String)"macc-aca-algox", (Object[])new Object[0]);
                CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                info.setCostCenter(costcenter);
                info.setCheckDetailResult(String.format(tip, costdriverName));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (!this.getSingleCheckContext().getCheckDetailResult().isEmpty()) {
            this.getSingleCheckContext().setPass(false);
            this.getSingleCheckContext().setCheckResult(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u4e3a\u81ea\u5b9a\u4e49\u65f6\uff0c\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u7684\u6210\u672c\u52a8\u56e0\u9700\u8981\u6709\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"InproallocNotHasValCheckAction_1", (String)"macc-aca-algox", (Object[])new Object[0]));
        }
    }

    private Map<Long, String> getCostdriverInfo(Set<Long> costdriverSet) {
        HashMap costdriverMap = Maps.newHashMapWithExpectedSize((int)10);
        QFilter filter = new QFilter("id", "in", costdriverSet);
        DataSet costCenterDriverDs = QueryServiceHelper.queryDataSet((String)"costdriver", (String)"cad_costdriver", (String)"id,number,name", (QFilter[])filter.toArray(), null);
        for (Row row : costCenterDriverDs) {
            costdriverMap.put(row.getLong("id"), String.format("%s/%s", row.getString("number"), row.getString("name")));
        }
        return costdriverMap;
    }

    private Map<String, BigDecimal> getInProdAllocStdValMap() {
        QFilter filter = new QFilter("org", "=", (Object)this.getContext().getOrgId());
        filter.and("costaccount", "=", (Object)this.getContext().getCostAccountId());
        filter.and("period", "=", (Object)this.getContext().getPeriodId());
        DataSet completionDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_inproallocstdval", (String)"costdriver,costcenter,allocvalue", (QFilter[])filter.toArray(), null);
        completionDs = completionDs.groupBy(new String[]{"costdriver", "costcenter"}).sum("allocvalue").finish();
        HashMap costdriverValueMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : completionDs) {
            Long costagent = this.getDefaultLongVal(row.getLong("costdriver"));
            Long costcenter = this.getDefaultLongVal(row.getLong("costcenter"));
            BigDecimal allocvalue = BigDecimalUtil.getOrZero(row.getBigDecimal("allocvalue"));
            String key = String.format("%s@%s", costagent, costcenter);
            costdriverValueMap.put(key, allocvalue);
        }
        return costdriverValueMap;
    }

    public Long getDefaultLongVal(Long val) {
        if (val == null) {
            return 0L;
        }
        return val;
    }

    private Map<Long, Set<Long>> queryProAllocStd(Long orgId, Long costAccountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costAccountId);
        filter.and("effectstatus", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"proallocstd", (String)"aca_proallocstd", (String)"costaccount,allocentry.costcenter costcenter,allocentry.costdriver costdriver,allocentry.costagent costagent,allocentry.productsubentry.costdriverdetail costdriverdetail,allocentry.productsubentry.costagentdetail costagentdetail", (QFilter[])filter.toArray(), null);
        HashSet hasStdCostcenters = Sets.newHashSetWithExpectedSize((int)10);
        HashMap customCostcenters = Maps.newHashMapWithExpectedSize((int)10);
        Long zero = 0L;
        for (Row row : ds) {
            Long costagentdetail;
            Long costagent;
            Long costcenter = row.getLong("costcenter");
            if (costcenter == null) {
                costcenter = zero;
            }
            if (!CadEmptyUtils.isEmpty((Long)costcenter)) {
                hasStdCostcenters.add(costcenter);
            }
            String costdriver = row.getString("costdriver");
            String costdriverdetail = row.getString("costdriverdetail");
            if ("6".equals(costdriver) && !CadEmptyUtils.isEmpty((Long)(costagent = row.getLong("costagent")))) {
                customCostcenters.computeIfAbsent(costcenter, t -> new HashSet()).add(costagent);
            }
            if (!"6".equals(costdriverdetail) || CadEmptyUtils.isEmpty((Long)(costagentdetail = row.getLong("costagentdetail")))) continue;
            customCostcenters.computeIfAbsent(costcenter, t -> new HashSet()).add(costagentdetail);
        }
        if (customCostcenters.containsKey(zero)) {
            List costCenterIds = CostCenterHelper.getCostCenterByOrg((Long)orgId, (Long[])new Long[]{4L});
            Set costValue = (Set)customCostcenters.remove(zero);
            costCenterIds.removeAll(hasStdCostcenters);
            for (Long costcenter : costCenterIds) {
                customCostcenters.put(costcenter, costValue);
            }
        }
        return customCostcenters;
    }
}

