/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class SideInButMainProdutNotInCheckAction
extends AbstractSingleCalcCheckAction {
    private static final Log logger = LogFactory.getLog(SideInButMainProdutNotInCheckAction.class);

    protected void doCheck() {
        CalcCheckDetailResultInfo info;
        Map<String, String> errorMap;
        CalcCheckContext context = this.getContext();
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)context.getPeriodStartDate());
        filter.and("bookdate", "<=", (Object)context.getPeriodEndDate());
        filter.and("billstatus", "=", (Object)"C");
        if (context.getManuOrgId() != null && context.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)context.getManuOrgId());
        }
        ArrayList typeList = Lists.newArrayList((Object[])new String[]{"B", "A"});
        QFilter sideFilter = new QFilter("entryentity.costobject.producttype", "in", (Object)typeList);
        String selectFields = "entryentity.costobject.srcbillnumber as mftOrderNo,material.number as matNumber,costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity.costobject.producttype as productType,entryentity.costobject.productgroup.id as groupId";
        DataSet factnedDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{filter, sideFilter}, null);
        HashMap productTypeMap = Maps.newHashMapWithExpectedSize((int)2);
        productTypeMap.put("A", ResManager.loadKDString((String)"\u8054\u4ea7\u54c1", (String)"SideInButMainProdutNotInCheckAction_3", (String)"macc-aca-algox", (Object[])new Object[0]));
        productTypeMap.put("B", ResManager.loadKDString((String)"\u526f\u4ea7\u54c1", (String)"SideInButMainProdutNotInCheckAction_4", (String)"macc-aca-algox", (Object[])new Object[0]));
        HashMap orderNoToMatList = Maps.newHashMap();
        HashMap groupToMatList = Maps.newHashMap();
        ArrayList mftOrderNoList = Lists.newArrayList();
        ArrayList roGroupIdList = Lists.newArrayList();
        ArrayList flGroupIdList = Lists.newArrayList();
        for (Row row : factnedDataSet) {
            Long groupId = row.getLong("groupId");
            String mftOrderNo = row.getString("mftOrderNo");
            String matNumber = row.getString("matNumber");
            String productType = row.getString("productType");
            String productTypeDesc = (String)productTypeMap.get(productType);
            if (StringUtils.isBlank((CharSequence)mftOrderNo)) {
                if (CadEmptyUtils.isEmpty((Long)groupId)) continue;
                flGroupIdList.add(groupId);
                groupToMatList.computeIfAbsent(String.valueOf(groupId), val -> new ArrayList(2)).add(productTypeDesc.concat(":").concat(matNumber));
                continue;
            }
            try {
                orderNoToMatList.computeIfAbsent(mftOrderNo.concat("_").concat(String.valueOf(groupId)), val -> new HashSet(2)).add(productTypeDesc.concat(":").concat(matNumber));
            }
            catch (Exception ex) {
                logger.error("\u671f\u672b\u6210\u672c\u8ba1\u7b97-\u65e5\u5fd7\u8ddf\u8e2a\uff1a" + String.format("groupId=%s,mftOrderNo=%s,matNumber=%s,productType=%s,productTypeDesc=%s", groupId, mftOrderNo, matNumber, productType, productTypeDesc));
                throw ex;
            }
            mftOrderNoList.add(mftOrderNo);
            roGroupIdList.add(groupId);
        }
        if (!CollectionUtils.isEmpty((Collection)roGroupIdList)) {
            errorMap = this.dealROCheck(orderNoToMatList, filter, roGroupIdList, mftOrderNoList);
            for (Map.Entry<String, String> mEntry : errorMap.entrySet()) {
                info = new CalcCheckDetailResultInfo();
                info.setCheckDetailResult(mEntry.getValue());
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)flGroupIdList)) {
            errorMap = this.dealFLCheck(groupToMatList, filter, flGroupIdList);
            for (Map.Entry<String, String> mEntry : errorMap.entrySet()) {
                info = new CalcCheckDetailResultInfo();
                info.setCheckDetailResult(mEntry.getValue());
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        String checkDesc = String.format(ResManager.loadKDString((String)"\u5f53\u671f\u5b58\u5728\u5b8c\u5de5\u5165\u5e93\u7684\u8054/\u526f\u4ea7\u54c1\uff0c\u6ca1\u6709\u5b8c\u5de5\u5165\u5e93\u7684\u4e3b\u4ea7\u54c1\uff0c\u4f1a\u5bfc\u81f4\u4ea7\u54c1\u5165\u5e93\u6210\u672c\u8ba1\u7b97\u9519\u8bef\u3002", (String)"SideInButMainProdutNotInCheckAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), this.getSingleCheckContext().getCheckDetailResult().size());
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private Map<String, String> dealFLCheck(Map<String, List<String>> groupToMatList, QFilter filter, List<Long> groupIdList) {
        String classTip = ResManager.loadKDString((String)"\u5f53\u671f%1$s\u5b58\u5728\u5b8c\u5de5\u5165\u5e93,\u6ca1\u6709\u4e3b\u4ea7\u54c1%2$s\u7684\u5b8c\u5de5\u5165\u5e93\uff0c\u4f1a\u5bfc\u81f4\u4ea7\u54c1\u5165\u5e93\u6210\u672c\u8ba1\u7b97\u9519\u8bef\u3002", (String)"SideInButMainProdutNotInCheckAction_7", (String)"macc-aca-algox", (Object[])new Object[0]);
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)16);
        QFilter groupFilter = new QFilter("id", "in", groupIdList);
        groupFilter.and("entryentity.producttype", "=", (Object)"C");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doGroup"), (String)"cad_productintogroup", (String)"id as groupId,entryentity.material.number as matNumber", (QFilter[])groupFilter.toArray(), null);
        for (Row row : dataSet) {
            String groupId = row.getString("groupId");
            List<String> matList = groupToMatList.get(groupId);
            if (CollectionUtils.isEmpty(matList)) continue;
            String matNumber = StringUtils.join(matList, (String)",");
            errorMap.put(groupId, String.format(classTip, matNumber, row.getString("matNumber")));
        }
        QFilter mainFilter = new QFilter("producttype", "=", (Object)"C");
        QFilter groupIdFilter = new QFilter("entryentity.costobject.productgroup.id", "in", groupIdList);
        String selectFields = "entryentity.costobject.productgroup.id as groupId";
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{filter, mainFilter, groupIdFilter}, null);
        for (Row row : mainDataSet) {
            String groupId = row.getString("groupId");
            errorMap.remove(groupId);
        }
        return errorMap;
    }

    private Map<String, String> dealROCheck(Map<String, Set<String>> orderNoToMatList, QFilter filter, List<Long> groupIdList, List<String> mftOrderNoList) {
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)16);
        String tip = ResManager.loadKDString((String)"\u5f53\u671f\u5b58\u5728\u5de5\u5355:%1$s \u5b58\u5728\u5b8c\u5de5\u5165\u5e93\u7684%2$s ,\u6ca1\u6709\u5b8c\u5de5\u5165\u5e93\u7684\u4e3b\u4ea7\u54c1\uff0c\u4f1a\u5bfc\u81f4\u4ea7\u54c1\u5165\u5e93\u6210\u672c\u8ba1\u7b97\u9519\u8bef\u3002", (String)"SideInButMainProdutNotInCheckAction_8", (String)"macc-aca-algox", (Object[])new Object[0]);
        for (Map.Entry<String, Set<String>> orderNoToMatListEntry : orderNoToMatList.entrySet()) {
            String key = orderNoToMatListEntry.getKey();
            Set<String> matNumberList = orderNoToMatList.get(key);
            String mftOrderNo = StringUtils.split((String)key, (String)"_")[0];
            String groupId = StringUtils.split((String)key, (String)"_")[1];
            String matNumber = StringUtils.join(matNumberList, (String)",");
            String error = String.format(tip, mftOrderNo, matNumber);
            errorMap.put(mftOrderNo.concat(String.valueOf(groupId)), error);
        }
        if (errorMap.size() > 0) {
            QFilter mftOrderNoFilter = new QFilter("entryentity.costobject.srcbillnumber", "in", mftOrderNoList);
            QFilter mainFilter = new QFilter("producttype", "=", (Object)"C");
            QFilter groupIdFilter = new QFilter("entryentity.costobject.productgroup.id", "in", groupIdList);
            String selectFields = "entryentity.costobject.srcbillnumber as mftOrderNo,entryentity.costobject.producttype as productType,entryentity.costobject.productgroup.id as groupId";
            DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{filter, mftOrderNoFilter, mainFilter, groupIdFilter}, null);
            for (Row row : mainDataSet) {
                Long groupId = row.getLong("groupId");
                String mftOrderNo = row.getString("mftOrderNo");
                errorMap.remove(mftOrderNo.concat(String.valueOf(groupId)));
            }
        }
        return errorMap;
    }
}

