/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.alloc.AcaMatAllocHelper;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.function.MatAutoAllocAmtFunction;
import kd.macc.aca.algox.enums.ScaAllocEnum;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ActCalcHelper {
    private static final Log logger = LogFactory.getLog(ActCalcHelper.class);

    public static boolean dealLevelCalcError(ActCostCalcArgs args, long entryId, String curItem) {
        if (!ActCalcHelper.isNeedGenerateBill(entryId)) {
            return false;
        }
        ActCalcHelper.createCalcCheckDetail(args, entryId, curItem);
        QFilter idFilter = new QFilter("id", "=", (Object)entryId);
        DataSet checkDetailDs = QueryServiceHelper.queryDataSet((String)"checkDetail", (String)"aca_calcreportdetail", (String)"id,entryentity.id entryId,entryentity.status status", (QFilter[])idFilter.toArray(), null);
        boolean isHasError = false;
        for (Row row : checkDetailDs) {
            if (!"2".equals(row.getString("status"))) continue;
            isHasError = true;
        }
        if (isHasError) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b\u4e2d\u5b58\u5728\u9519\u8bef\u9879\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u3002", (String)"ActCalcHelper_0", (String)"macc-aca-algox", (Object[])new Object[0]));
        }
        return true;
    }

    private static void createCalcCheckDetail(ActCostCalcArgs args, long entryId, String itemName) {
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"aca_calcreportdetail");
        checkDetail.set("id", (Object)entryId);
        checkDetail.set("org", (Object)args.getOrgId());
        checkDetail.set("costaccount", (Object)args.getCostAccountId());
        checkDetail.set("period", (Object)args.getPeriodId());
        checkDetail.set("currency", (Object)args.getCurrencyId());
        checkDetail.set("checkitemdesc", (Object)String.format(ResManager.loadKDString((String)"%s-\u6210\u672c\u8ba1\u7b97\u8fc7\u7a0b\u4e2d\u5b58\u5728\u7684\u9519\u8bef\u9879", (String)"ActCalcHelper_1", (String)"macc-aca-algox", (Object[])new Object[0]), itemName));
        checkDetail.set("calcdate", (Object)TimeServiceHelper.now());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"aca_calcreportdetail");
        SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{checkDetail});
    }

    private static boolean isNeedGenerateBill(long taskDetailId) {
        int size = 0;
        String strSql = "SELECT count(1) value FROM t_aca_calcdetailentry WHERE FId = " + taskDetailId;
        try (DataSet batSizeData = DB.queryDataSet((String)"TaskRecordGetEntrySize", (DBRoute)new DBRoute("cal"), (String)strSql);){
            if (batSizeData.hasNext()) {
                Row row = batSizeData.next();
                size = Integer.parseInt(row.get("value").toString());
            }
        }
        return size > 0;
    }

    public static void autoMatAllocPre(ActCostCalcArgs args, Set<Long> matIdSet, Boolean isRework) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("material", "in", matIdSet);
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        filter.and("costobject", "=", (Object)0L);
        filter.and("allocstatus", "!=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        filter.and("alloctype", "!=", (Object)ScaAllocEnum.ALLOCTYPE_MANUAL.getValue());
        if (isRework != null) {
            filter.and("isreturnitem", "=", (Object)isRework);
        }
        String selectFields = "id";
        long start = System.currentTimeMillis();
        DataSet matAlloc = QueryServiceHelper.queryDataSet((String)"matAlloc", (String)"aca_matalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011matAlloc\uff0c\u8017\u65f6:%1$s \u6761\u4ef6:%2$s", (String)"ActCalcHelper_2", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start, filter.toString()));
        HashSet matAllIds = Sets.newHashSet();
        for (Row row : matAlloc) {
            matAllIds.add(row.getLong("id"));
        }
        if (matAllIds.isEmpty()) {
            return;
        }
        AcaMatAllocHelper.doAlloc(matAllIds);
    }

    public static void autoMatAllocNew(ActCostCalcArgs args, Set<Long> matIdSet, Boolean isRework) {
        DataSet allocDs = ActCalcHelper.getMatAllocDs(args, matIdSet, isRework);
        Set<Long> matAllocIds = ActCalcHelper.getLongIdSetFromDs(allocDs, "matcollect", false);
        if (CadEmptyUtils.isEmpty(matAllocIds)) {
            return;
        }
        int batchSize = CadBgParamUtils.getCadParamForInt((String)"acaCalcAutoMatBatch", (int)5000);
        List partArrIds = Lists.partition(new ArrayList<Long>(matAllocIds), (int)batchSize);
        if (partArrIds.size() < 4) {
            logger.info("\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011\u5206\u914d\u5355\u6570\u91cf\u4e3a\uff1a{}\uff0c\u5206\u6279\u6570\uff1a{}", (Object)matAllocIds.size(), (Object)partArrIds.size());
            int batch = 0;
            for (List matColIds : partArrIds) {
                ActCalcHelper.batchDealMatAlloc(args, matColIds, ++batch, partArrIds.size());
            }
        } else {
            RowMeta rm = new RowMeta(new String[]{"id", "groupId"}, new DataType[]{DataType.LongType, DataType.IntegerType});
            ArrayList dataList = Lists.newArrayListWithExpectedSize((int)1024);
            int groupId = 0;
            for (List partArrId : partArrIds) {
                ++groupId;
                for (Long id : partArrId) {
                    Object[] obj = new Object[]{id, groupId};
                    dataList.add(obj);
                }
            }
            DataSet ds = Algo.create((String)"AcaCalc.matSource").createDataSet((Collection)dataList, rm);
            JobSession session = AlgoX.createSession((String)"AcaCalc.autoMatAllocNew");
            DataSetX dsx = session.fromInput((Input)new DataSetInput(ds));
            dsx = dsx.groupBy(new String[]{"groupId"}).reduceGroup((GroupReduceFunction)new MatAutoAllocAmtFunction(args, partArrIds.size()));
            dsx.output((Output)new IgnoreOutput());
            try {
                logger.info("\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011algox\u5f00\u59cb,\u603b\u6570{},batchSize{}", (Object)matAllocIds.size(), (Object)batchSize);
                long algoXStart = System.currentTimeMillis();
                session.commit(2, TimeUnit.HOURS);
                logger.info("\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011algox\u7ed3\u675f,\u8017\u65f6{}", (Object)(System.currentTimeMillis() - algoXStart));
            }
            catch (Exception e) {
                logger.error("\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011\u66f4\u65b0\u65f6\u62a5\u9519", (Throwable)e);
                throw e;
            }
        }
    }

    public static void batchDealMatAlloc(ActCostCalcArgs args, List<Long> matColIds, int batch, int totalBatch) {
        long start = System.currentTimeMillis();
        DataSet matCollectDataSet = ActCalcHelper.getMatCollectDs(matColIds);
        DataSet matCollectDataSetCopy = matCollectDataSet.copy();
        HashSet sourceBillEntryIds = Sets.newHashSetWithExpectedSize((int)128);
        HashSet matUseCollectEntryIdSet = Sets.newHashSetWithExpectedSize((int)128);
        for (Row row : matCollectDataSetCopy) {
            sourceBillEntryIds.add(row.getLong("srcEntryId"));
            matUseCollectEntryIdSet.add(row.getLong("entryId"));
        }
        DataSet costRecordDs = ActCalcHelper.getCalCostRecordDs(args, sourceBillEntryIds);
        DataSet allocDataSet = matCollectDataSet.leftJoin(costRecordDs).on("srcBillId", "srcBillId").on("srcEntryId", "srcEntryId").select(matCollectDataSet.getRowMeta().getFieldNames(), new String[]{"actCost", "unitActCost", "elementId", "subElementId", "subUnitActCost", "subActCost"}).finish();
        HashMap actCostMap = Maps.newHashMap();
        HashMap actSubItemMap = Maps.newHashMap();
        for (Object row : allocDataSet) {
            String string = String.format("%s@%s", row.getString("entryId"), row.getString("matId"));
            actCostMap.put(string, new BigDecimal[]{BigDecimalUtil.getOrZero(row.getBigDecimal("unitActCost")), BigDecimalUtil.getOrZero(row.getBigDecimal("actCost"))});
            if (!args.isCalbyCostElement()) continue;
            Long elementId = row.getLong("elementId");
            Long subElementId = row.getLong("subElementId");
            if (CadEmptyUtils.isEmpty((Long)subElementId)) continue;
            actSubItemMap.computeIfAbsent(string, t -> new ArrayList()).add(new Object[]{elementId, subElementId, BigDecimalUtil.getOrZero(row.getBigDecimal("subUnitActCost")), BigDecimalUtil.getOrZero(row.getBigDecimal("subActCost")), BigDecimal.ZERO});
        }
        DynamicObject[] allocDynArr = ActCalcHelper.getMatAllocDsByCollectId(args, matUseCollectEntryIdSet, args.isCalbyCostElement());
        if (args.isCalbyCostElement()) {
            ActCalcHelper.deleteMatAllocSubItem(allocDynArr);
            for (Map.Entry entry : actSubItemMap.entrySet()) {
                List objArr = (List)entry.getValue();
                if (objArr.size() == 1) {
                    ((Object[])objArr.get((int)0))[4] = BigDecimal.ONE;
                    continue;
                }
                BigDecimal totalSubAmt = BigDecimal.ZERO;
                for (Object[] obj : objArr) {
                    totalSubAmt = totalSubAmt.add((BigDecimal)obj[3]);
                }
                if (totalSubAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                for (Object[] obj : objArr) {
                    obj[4] = ((BigDecimal)obj[3]).divide(totalSubAmt, 10, RoundingMode.HALF_UP);
                }
            }
        }
        ArrayList<Object[]> updateHeadList = new ArrayList<Object[]>();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ArrayList<Object[]> insertSubEntryList = new ArrayList<Object[]>();
        HashSet updateEntryIds = Sets.newHashSetWithExpectedSize((int)10);
        for (DynamicObject dyo : allocDynArr) {
            String key = String.format("%s@%s", dyo.getLong("matcollect"), dyo.getLong("material.id"));
            BigDecimal[] actCostArr = (BigDecimal[])actCostMap.get(key);
            if (actCostArr == null) continue;
            Long headId = dyo.getLong("id");
            BigDecimal actCost = actCostArr[1].setScale(args.getAmtScale(), RoundingMode.HALF_UP);
            BigDecimal unitActCost = actCostArr[0].setScale(args.getPriceScale(), RoundingMode.HALF_UP);
            DynamicObjectCollection entryColl = dyo.getDynamicObjectCollection("entryentity");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryColl)) continue;
            BigDecimal oldActCost = BigDecimalUtil.getOrZero(dyo.getBigDecimal("useamount"));
            if (oldActCost.compareTo(actCost) != 0) {
                updateHeadList.add(new Object[]{actCost, headId});
            }
            updateEntryIds.clear();
            if (entryColl.size() == 1) {
                DynamicObject entry = (DynamicObject)entryColl.get(0);
                if (BigDecimalUtil.getOrZero(entry.getBigDecimal("amount")).compareTo(actCost) != 0) {
                    entry.set("amount", (Object)actCost);
                    updateEntryIds.add(entry.getLong("id"));
                }
            } else {
                BigDecimal totalAllocVal = BigDecimal.ZERO;
                for (DynamicObject entry : entryColl) {
                    totalAllocVal = totalAllocVal.add(BigDecimalUtil.getOrZero(entry.getBigDecimal("allocvalue")));
                }
                BigDecimal diff = actCost;
                BigDecimal tmpQty = null;
                DynamicObject diffEntry = null;
                if (totalAllocVal.compareTo(BigDecimal.ZERO) == 0) {
                    BigDecimal useQty = BigDecimalUtil.getOrZero(dyo.getBigDecimal("useqty"));
                    if (BigDecimal.ZERO.compareTo(useQty) == 0) continue;
                    for (DynamicObject entry : entryColl) {
                        BigDecimal qty = BigDecimalUtil.getOrZero(entry.getBigDecimal("qty"));
                        BigDecimal amt = qty.divide(useQty, 10, RoundingMode.HALF_UP).multiply(actCost).setScale(args.getAmtScale(), RoundingMode.HALF_UP);
                        if (tmpQty == null || qty.compareTo(tmpQty) > 0) {
                            tmpQty = qty;
                            diffEntry = entry;
                        }
                        if (BigDecimalUtil.getOrZero(entry.getBigDecimal("amount")).compareTo(amt) != 0) {
                            entry.set("amount", (Object)amt);
                            updateEntryIds.add(entry.getLong("id"));
                        }
                        diff = diff.subtract(amt);
                    }
                } else {
                    for (DynamicObject entry : entryColl) {
                        BigDecimal allocvalue = BigDecimalUtil.getOrZero(entry.getBigDecimal("allocvalue"));
                        BigDecimal amt = allocvalue.divide(totalAllocVal, 10, RoundingMode.HALF_UP).multiply(actCost).setScale(args.getAmtScale(), RoundingMode.HALF_UP);
                        if (tmpQty == null || allocvalue.compareTo(tmpQty) > 0) {
                            tmpQty = allocvalue;
                            diffEntry = entry;
                        }
                        if (BigDecimalUtil.getOrZero(entry.getBigDecimal("amount")).compareTo(amt) != 0) {
                            entry.set("amount", (Object)amt);
                            updateEntryIds.add(entry.getLong("id"));
                        }
                        diff = diff.subtract(amt);
                    }
                }
                if (diff.compareTo(BigDecimal.ZERO) != 0 && diffEntry != null) {
                    diffEntry.set("amount", (Object)diffEntry.getBigDecimal("amount").add(diff));
                    updateEntryIds.add(diffEntry.getLong("id"));
                }
            }
            for (DynamicObject entry : entryColl) {
                BigDecimal allocAmt = BigDecimalUtil.getOrZero(entry.getBigDecimal("amount"));
                Long entryId = entry.getLong("id");
                if (updateEntryIds.contains(entryId)) {
                    arrayList.add(new Object[]{allocAmt, unitActCost, entryId});
                }
                List subitemCostArrs = (List)actSubItemMap.get(key);
                if (!args.isCalbyCostElement() || CadEmptyUtils.isEmpty((List)subitemCostArrs)) continue;
                BigDecimal subdiff = allocAmt;
                Object[] maxSubitemArr = null;
                for (Object[] subitemCostArr : subitemCostArrs) {
                    BigDecimal subitemCost = ((BigDecimal)subitemCostArr[4]).multiply(allocAmt).setScale(args.getAmtScale(), RoundingMode.HALF_UP);
                    Object[] subitemArr = new Object[]{ID.genLongId(), entryId, subitemCostArr[0], subitemCostArr[1], subitemCostArr[2], subitemCost};
                    subdiff = subdiff.subtract(subitemCost);
                    if (maxSubitemArr == null || ((BigDecimal)maxSubitemArr[5]).compareTo(subitemCost) < 0) {
                        maxSubitemArr = subitemArr;
                    }
                    insertSubEntryList.add(subitemArr);
                }
                if (maxSubitemArr == null || subdiff.compareTo(BigDecimal.ZERO) == 0) continue;
                maxSubitemArr[5] = ((BigDecimal)maxSubitemArr[5]).add(subdiff).setScale(args.getAmtScale(), RoundingMode.HALF_UP);
            }
        }
        logger.info("\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011\u83b7\u53d6\u66f4\u65b0\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        DBRoute route = new DBRoute("cal");
        String updateHeadSql = "update t_sca_matalloc set fuseamount=?  where fid= ? ";
        String updateEntrySql = "update t_sca_matallocentry set famount=?,fprice=? where fentryid = ?";
        String insertSubEntrySql = "insert into t_sca_matallocsubentry(fdetailid,fentryid,felementid,fsubelementid,fstandardcost,fstandardamt) values(?,?,?,?,?,?)";
        if (!updateHeadList.isEmpty()) {
            ActCalcHelper.doExecuteBatch(updateHeadList, route, updateHeadSql);
        }
        if (!arrayList.isEmpty()) {
            ActCalcHelper.doExecuteBatch(arrayList, route, updateEntrySql);
        }
        if (!insertSubEntryList.isEmpty()) {
            ActCalcHelper.doExecuteBatch(insertSubEntryList, route, insertSubEntrySql);
        }
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011\u66f4\u65b0 \u5355\u636e\u5934\uff1a%1$s\u6761 \uff0c\u5206\u5f55:%2$s\u6761\uff0c\u5b50\u5206\u5f55:%3$s\u6761\uff0c\u8017\u65f6:%4$s", (String)"ActCalcHelper_3", (String)"macc-aca-algox", (Object[])new Object[0]), updateHeadList.size(), arrayList.size(), insertSubEntryList.size(), System.currentTimeMillis() - start));
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011\u66f4\u65b0 \u6279\u6b21%1$s/\u603b\u6279\u6b21%2$s\uff0c\u8017\u65f6:%3$s", (String)"ActCalcHelper_4", (String)"macc-aca-algox", (Object[])new Object[0]), batch, totalBatch, System.currentTimeMillis() - start));
    }

    private static DataSet getCalCostRecordDs(ActCostCalcArgs args, Set<Long> sourceBillEntryIds) {
        DataSet calCostRecord = ActCalcHelper.getCalCostRecord(args, sourceBillEntryIds);
        DataSet costAdjust = ActCalcHelper.getCostAdjust(args, sourceBillEntryIds, calCostRecord);
        return calCostRecord.union(costAdjust);
    }

    private static DataSet getCostAdjust(ActCostCalcArgs args, Set<Long> sourceBillEntryIds, DataSet calCostRecord) {
        QFilter adjustFilter = new QFilter("costaccount", "=", (Object)args.getCostAccountId());
        adjustFilter.and("entryentity.id", "in", sourceBillEntryIds);
        if (args.isCalbyCostElement()) {
            adjustFilter.and("entryentity.subentryentity.sub_adjustamt", "!=", (Object)0);
        }
        String selectAdjustFields = "costaccount as costAccountId,calorg as orgId,id as srcBillId,entryentity.id as srcEntryId,entryentity.material.masterid as matId,entryentity.mversion as matVerId,entryentity.assist as matAuxId,entryentity.adjustamt as actCost,0 as unitActCost";
        selectAdjustFields = args.isCalbyCostElement() ? selectAdjustFields + ",entryentity.subentryentity.costelement as elementId,entryentity.subentryentity.costsubelement as subElementId,0 as subUnitActCost,entryentity.subentryentity.sub_adjustamt as subActCost" : selectAdjustFields + ",0L as elementId,0L as subElementId,0 as subUnitActCost,0 as subActCost";
        return QueryServiceHelper.queryDataSet((String)"calCostAdjust", (String)"cal_costadjust_subentity", (String)selectAdjustFields, (QFilter[])adjustFilter.toArray(), null);
    }

    private static DataSet getCalCostRecord(ActCostCalcArgs args, Set<Long> sourceBillEntryIds) {
        QFilter filter = new QFilter("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("entry.bizbillentryid", "in", sourceBillEntryIds);
        if (args.isCalbyCostElement()) {
            filter.and("entry.subentrycostelement.sub_actualcost", "!=", (Object)0);
        }
        String selectFields = "costaccount as costAccountId,calorg as orgId,bizbillid as srcBillId,entry.bizbillentryid as srcEntryId,entry.material.masterid as matId,entry.mversion as matVerId,entry.assist as matAuxId,entry.actualcost as actCost,entry.unitactualcost as unitActCost";
        selectFields = args.isCalbyCostElement() ? selectFields + ",entry.subentrycostelement.costelement as elementId,entry.subentrycostelement.costsubelement as subElementId,entry.subentrycostelement.sub_unitactualcost as subUnitActCost,entry.subentrycostelement.sub_actualcost as subActCost" : selectFields + ",0L as elementId,0L as subElementId,0 as subUnitActCost,0 as subActCost";
        return QueryServiceHelper.queryDataSet((String)"calCostRecord", (String)"cal_costrecord_subentity", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    public static DataSet getMatCollectDs(List<Long> matColIds) {
        QFilter filter = new QFilter("entryentity.id", "in", matColIds);
        return QueryServiceHelper.queryDataSet((String)"matUseCollect", (String)"aca_matusecollect", (String)"sourcebillid as srcBillId,entryentity.sourcebillentryid as srcEntryId,entryentity.id as entryId,entryentity.material.id as matId", (QFilter[])filter.toArray(), null);
    }

    private static void deleteMatAllocSubItem(DynamicObject[] allocDynArr) {
        ArrayList<Long> entryIds = new ArrayList<Long>();
        for (DynamicObject dyn : allocDynArr) {
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
            if (entryentity == null || entryentity.isEmpty()) continue;
            for (DynamicObject entrydyn : entryentity) {
                DynamicObjectCollection subentryentity = entrydyn.getDynamicObjectCollection("subentryentity");
                if (subentryentity == null || subentryentity.isEmpty()) continue;
                for (DynamicObject subentrydyn : subentryentity) {
                    entryIds.add(subentrydyn.getLong("id"));
                }
            }
        }
        if (entryIds.isEmpty()) {
            return;
        }
        List splitLists = Lists.partition(entryIds, (int)2000);
        for (List spids : splitLists) {
            String sql = String.format("delete from t_sca_matallocsubentry where fdetailid in (%s)", ActCalcHelper.getUpdateInSql(spids));
            ActCalcHelper.executeBatch(sql);
        }
    }

    private static DynamicObject[] getMatAllocDsByCollectId(ActCostCalcArgs args, Set<Long> matUseCollectEntryIdSet, boolean isCalbyCostElement) {
        QFilter filter = new QFilter("matcollect", "in", matUseCollectEntryIdSet);
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        String selectField = "id,matcollect,material.id,useamount,useqty,entryentity.id,entryentity.qty,entryentity.allocvalue,entryentity.amount";
        if (isCalbyCostElement) {
            selectField = selectField + ",entryentity.subentryentity.id";
        }
        return BusinessDataServiceHelper.load((String)"aca_matalloc", (String)selectField, (QFilter[])filter.toArray());
    }

    private static DataSet getMatAllocDs(ActCostCalcArgs args, Set<Long> matIdSet, Boolean isRework) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("material", "in", matIdSet);
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        if (isRework != null) {
            filter.and("isreturnitem", "=", (Object)isRework);
        }
        String selectFields = "id,matcollect";
        return QueryServiceHelper.queryDataSet((String)"matAlloc", (String)"aca_matalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    @Deprecated
    public static void autoMatAlloc(ActCostCalcArgs args, Set<Long> matIdSet, Boolean isRework) {
        HashSet matAllocIds = Sets.newHashSetWithExpectedSize((int)128);
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("material", "in", matIdSet);
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        if (isRework != null) {
            filter.and("isreturnitem", "=", (Object)isRework);
        }
        String selectFields = "id,matcollect";
        long start = System.currentTimeMillis();
        DataSet matAlloc = QueryServiceHelper.queryDataSet((String)"matAlloc", (String)"aca_matalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011matAlloc\uff0c\u8017\u65f6:%1$s \u6761\u4ef6:%2$s", (String)"ActCalcHelper_5", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start, filter.toString()));
        HashSet allMatColIds = Sets.newHashSet();
        for (Row row : matAlloc) {
            allMatColIds.add(row.getLong("matcollect"));
            matAllocIds.add(row.getLong("id"));
        }
        if (allMatColIds.size() == 0) {
            return;
        }
        List partArrIds = Lists.partition(new ArrayList(allMatColIds), (int)50000);
        long batch = 0L;
        for (List matColIds : partArrIds) {
            ++batch;
            long time = System.currentTimeMillis();
            filter = new QFilter("entryentity.id", "in", (Object)matColIds);
            filter.and("appnum", "=", (Object)"aca");
            if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
                filter.and("manuorg", "=", (Object)args.getManuOrgId());
            }
            selectFields = "sourcebillid as srcBillId,entryentity.sourcebillentryid as srcEntryId,entryentity.id as entryId,entryentity.material.id as matId";
            start = System.currentTimeMillis();
            DataSet matCollectDataSet = QueryServiceHelper.queryDataSet((String)"matUseCollect", (String)"aca_matusecollect", (String)selectFields, (QFilter[])filter.toArray(), null);
            LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011matCollectDataSet\uff0c\u8017\u65f6:%1$s \u6761\u4ef6:%2$s", (String)"ActCalcHelper_6", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start, filter.toString()));
            Iterator it = matCollectDataSet.copy().iterator();
            HashSet sourceBillIds = Sets.newHashSet();
            HashSet sourceBillEntryIds = Sets.newHashSet();
            HashSet matUseCollectEntryIdSet = Sets.newHashSet();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                sourceBillIds.add(row.getLong("srcBillId"));
                sourceBillEntryIds.add(row.getLong("srcEntryId"));
                matUseCollectEntryIdSet.add(row.getLong("entryId"));
            }
            if (sourceBillIds.size() == 0) {
                return;
            }
            filter = new QFilter("bizbillid", "in", (Object)sourceBillIds);
            filter.and("costaccount", "=", (Object)args.getCostAccountId());
            filter.and("entry.bizbillentryid", "in", (Object)sourceBillEntryIds);
            selectFields = "costaccount as costAccountId,calorg as orgId,bizbillid as srcBillId,entry.bizbillentryid as srcEntryId,entry.material.masterid as matId,entry.mversion as matVerId,entry.assist as matAuxId,entry.actualcost as actCost,entry.unitactualcost as unitActCost";
            start = System.currentTimeMillis();
            DataSet costRecord = QueryServiceHelper.queryDataSet((String)"calCostRecord", (String)"cal_costrecord_subentity", (String)selectFields, (QFilter[])filter.toArray(), null);
            LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011costRecord\uff0c\u8017\u65f6:%1$s \u6761\u4ef6:%2$s", (String)"ActCalcHelper_7", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start, filter.toString()));
            DataSet allocDataSet = matCollectDataSet.leftJoin(costRecord).on("srcBillId", "srcBillId").on("srcEntryId", "srcEntryId").select(matCollectDataSet.getRowMeta().getFieldNames(), new String[]{"actCost", "unitActCost"}).finish();
            HashMap actCostMap = Maps.newHashMap();
            HashMap unitActCostMap = Maps.newHashMap();
            for (Row row : allocDataSet) {
                actCostMap.put(row.getString("entryId") + row.getString("matId"), row.getBigDecimal("actCost"));
                unitActCostMap.put(row.getString("entryId") + row.getString("matId"), row.getBigDecimal("unitActCost"));
            }
            filter = new QFilter("matcollect", "in", (Object)matUseCollectEntryIdSet);
            filter.and(new QFilter("costaccount", "=", (Object)args.getCostAccountId()));
            start = System.currentTimeMillis();
            DynamicObject[] matAllocDataArr = BusinessDataServiceHelper.load((String)"aca_matalloc", (String)"id,matcollect,material.id,useamount,useqty,entryentity.id,entryentity.qty,entryentity.allocvalue,entryentity.amount", (QFilter[])filter.toArray());
            LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011matAllocDataArr\uff0c\u8017\u65f6:%1$s \u6761\u4ef6:%2$s", (String)"ActCalcHelper_8", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start, filter.toString()));
            LinkedList<Object[]> updateHeadList = new LinkedList<Object[]>();
            LinkedList<Object[]> updateEntryList = new LinkedList<Object[]>();
            for (DynamicObject dyo : matAllocDataArr) {
                Long matcollect = dyo.getLong("matcollect");
                Long matId = dyo.getLong("material.id");
                String key = matcollect + "" + matId;
                if (actCostMap.get(key) == null) continue;
                Long headId = dyo.getLong("id");
                BigDecimal actCost = ((BigDecimal)actCostMap.get(key)).setScale(args.getAmtScale(), RoundingMode.HALF_UP);
                BigDecimal unitActCost = ((BigDecimal)unitActCostMap.get(key)).setScale(args.getPriceScale(), RoundingMode.HALF_UP);
                BigDecimal totalAllocVal = BigDecimal.ZERO;
                DynamicObjectCollection entryColl = dyo.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryColl) {
                    totalAllocVal = totalAllocVal.add(BigDecimalUtil.getOrZero(entry.getBigDecimal("allocvalue")));
                }
                updateHeadList.add(new Object[]{actCost, headId});
                BigDecimal diff = actCost;
                BigDecimal tmpQty = null;
                DynamicObject diffEntry = null;
                if (totalAllocVal.compareTo(BigDecimal.ZERO) == 0) {
                    BigDecimal useQty = BigDecimalUtil.getOrZero(dyo.getBigDecimal("useqty"));
                    if (BigDecimal.ZERO.compareTo(useQty) == 0) continue;
                    for (DynamicObject entry : entryColl) {
                        BigDecimal qty = BigDecimalUtil.getOrZero(entry.getBigDecimal("qty"));
                        BigDecimal amt = qty.divide(useQty, 10, RoundingMode.HALF_UP).multiply(actCost).setScale(args.getAmtScale(), RoundingMode.HALF_UP);
                        if (tmpQty == null || qty.compareTo(tmpQty) > 0) {
                            tmpQty = qty;
                            diffEntry = entry;
                        }
                        entry.set("amount", (Object)amt);
                        diff = diff.subtract(amt);
                    }
                } else {
                    for (DynamicObject entry : entryColl) {
                        BigDecimal allocvalue = BigDecimalUtil.getOrZero(entry.getBigDecimal("allocvalue"));
                        BigDecimal amt = allocvalue.divide(totalAllocVal, 10, RoundingMode.HALF_UP).multiply(actCost).setScale(args.getAmtScale(), RoundingMode.HALF_UP);
                        if (tmpQty == null || allocvalue.compareTo(tmpQty) > 0) {
                            tmpQty = allocvalue;
                            diffEntry = entry;
                        }
                        entry.set("amount", (Object)amt);
                        diff = diff.subtract(amt);
                    }
                }
                if (diff.compareTo(BigDecimal.ZERO) != 0 && diffEntry != null) {
                    diffEntry.set("amount", (Object)diffEntry.getBigDecimal("amount").add(diff));
                }
                for (DynamicObject entry : entryColl) {
                    updateEntryList.add(new Object[]{entry.getBigDecimal("amount"), unitActCost, entry.getLong("id")});
                }
            }
            DBRoute route = new DBRoute("cal");
            String updateHeadSql = "update t_sca_matalloc set fuseamount=?  where fid= ? ";
            String updateEntrySql = "update t_sca_matallocentry set famount=?,fprice=? where fentryid = ?";
            start = System.currentTimeMillis();
            if (updateHeadList.size() > 0) {
                ActCalcHelper.doExecuteBatch(updateHeadList, route, updateHeadSql);
            }
            if (updateEntryList.size() > 0) {
                ActCalcHelper.doExecuteBatch(updateEntryList, route, updateEntrySql);
            }
            LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011\u66f4\u65b0 \u5355\u636e\u5934\uff1a%1$s\u6761 \uff0c\u5206\u5f55:%2$s\u6761\uff0c\u8017\u65f6:%3$s", (String)"ActCalcHelper_9", (String)"macc-aca-algox", (Object[])new Object[0]), updateHeadList.size(), updateEntryList.size(), System.currentTimeMillis() - start));
            LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011\u66f4\u65b0 \u5355\u636e\u5934\uff1a%1$s\u6761 \uff0c\u5206\u5f55:%2$s\u6761\uff0c\u8017\u65f6:%3$s", (String)"ActCalcHelper_9", (String)"macc-aca-algox", (Object[])new Object[0]), updateHeadList.size(), updateEntryList.size(), System.currentTimeMillis() - start));
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u6279\u6b21\uff1a{}\u5f15\u5165\u65f6\u5bf9\u5171\u8017\u6750\u6599\u8fdb\u884c\u81ea\u52a8\u5206\u914d\u548c\u786e\u8ba4,\u8017\u65f6\uff1a{}ms", (Object)batch, (Object)(System.currentTimeMillis() - time));
            LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u81ea\u52a8\u5206\u914d\u3011\u66f4\u65b0 \u6279\u6b21%1$s/\u603b\u6279\u6b21%2$s\uff0c\u8017\u65f6:%3$s", (String)"ActCalcHelper_4", (String)"macc-aca-algox", (Object[])new Object[0]), batch, partArrIds.size(), System.currentTimeMillis() - start));
        }
    }

    public static void doExecuteBatch(List<Object[]> updateHeadList, DBRoute route, String updateHeadSql) {
        List parParamObjs = Lists.partition(updateHeadList, (int)1000);
        for (List parParamObj : parParamObjs) {
            TXHandle handler = TX.requiresNew();
            Throwable throwable = null;
            try {
                ActCalcHelper.executeBatchSql(route, updateHeadSql, parParamObj);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (handler == null) continue;
                if (throwable != null) {
                    try {
                        handler.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                handler.close();
            }
        }
    }

    private static void executeBatchSql(DBRoute route, String updateHeadSql, List<Object[]> parParamObj) {
        DB.executeBatch((DBRoute)route, (String)updateHeadSql, parParamObj);
    }

    private static void executeBatch(String sql) {
        try (TXHandle handle = TX.requiresNew();){
            DB.execute((DBRoute)new DBRoute("cal"), (String)sql);
        }
    }

    public static Set<Long> getLongIdSetFromDs(DataSet ds, String colField, boolean isCopy) {
        DataSet result = ds;
        if (isCopy) {
            result = ds.copy();
        }
        HashSet longIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : result) {
            longIdSet.add(row.getLong(colField));
        }
        return longIdSet;
    }

    private static String getUpdateInSql(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        for (Long costcenter : ids) {
            sb.append(",").append(costcenter);
        }
        return sb.substring(1);
    }
}

