/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.aca.algox.costcalc.action.DebugInfoMsgHandler;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.function.ActCalcFunctionHelper;
import kd.macc.aca.algox.utils.AcaDataSetXLogUtil;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;

public class ActCalcGradeFunction
extends GroupReduceFunction {
    private static final Log logger = LogFactory.getLog(ActCalcGradeFunction.class);
    private ActCostCalcArgs args;
    Map<Long, String> matGroFieMap;
    Map<String, BigDecimal> matCateMap;
    Map<String, String> srcFieldMap;
    private DebugInfoMsgHandler msgHander = null;

    public ActCalcGradeFunction(ActCostCalcArgs args, Map<Long, String> matGroFieMap, Map<String, BigDecimal> matCateMap, Map<String, String> srcFieldMap, DebugInfoMsgHandler msgHander) {
        this.args = args;
        this.matGroFieMap = matGroFieMap;
        this.matCateMap = matCateMap;
        this.srcFieldMap = srcFieldMap;
        this.msgHander = msgHander;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Long costObjectId;
        List<RowX> rowXList = AcaDataSetXLogUtil.getListFromIterable(iterable);
        StringBuilder debugMsg = null;
        boolean isCostobjectDebug = false;
        if (this.sourceRowMeta.getFieldIndex("costObjectId", false) >= 0 && (isCostobjectDebug = ActCalcFunctionHelper.isCostobjectDebug(this.args, costObjectId = rowXList.get(0).getLong(this.sourceRowMeta.getFieldIndex("costObjectId"))))) {
            debugMsg = new StringBuilder();
            debugMsg.append(ResManager.loadKDString((String)"\u7b49\u7ea7\u54c1\u8ba1\u7b97\uff1a\n", (String)"ActCalcGradeFunction_8", (String)"macc-aca-algox", (Object[])new Object[0]));
        }
        if (rowXList.size() > 1) {
            logger.info("\u7b49\u7ea7\u54c1\u8ba1\u7b97\u5f00\u59cb");
            HashSet<Long> groupType = new HashSet<Long>(16);
            BigDecimal totalAmt = BigDecimal.ZERO;
            BigDecimal denominatorAmt = BigDecimal.ZERO;
            BigDecimal maxDenominatorAmt = BigDecimal.ZERO;
            boolean isCalc = true;
            Long matId = rowXList.get(0).getLong(this.sourceRowMeta.getFieldIndex("matId"));
            String groupField = this.matGroFieMap.get(matId);
            if (groupField == null) {
                isCalc = false;
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("The grouping field corresponding to the product is not found: ").append(matId).append("\n");
                }
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u672a\u6839\u636e\u5f53\u524d\u4ea7\u54c1==>{}\u627e\u5230\u5bf9\u5e94\u7684\u5206\u7ec4\u5b57\u6bb5 %s", (String)"ActCalcGradeFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]), matId));
            } else if (this.srcFieldMap.get(groupField) == null) {
                isCalc = false;
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("The source field corresponding to the grouping field is not found:").append(groupField).append("\n");
                }
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1==>{}\u672a\u627e\u5230\u5bf9\u5e94\u5206\u7ec4\u5b57\u6bb5\u7684\u6e90\u5355\u5b57\u6bb5 %s", (String)"ActCalcGradeFunction_9", (String)"macc-aca-algox", (Object[])new Object[0]), matId));
            }
            if (isCalc) {
                for (RowX rowX : rowXList) {
                    String srcField;
                    Long srcGroupType = rowX.getLong(this.sourceRowMeta.getFieldIndex(srcField = this.srcFieldMap.get(groupField)));
                    if (srcGroupType == null || srcGroupType <= 0L) {
                        isCalc = false;
                        break;
                    }
                    groupType.add(srcGroupType);
                    totalAmt = totalAmt.add(BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost"))));
                    String weightKey = matId + "@" + srcGroupType;
                    BigDecimal weight = this.matCateMap.get(weightKey);
                    if (weight == null) {
                        if (isCostobjectDebug && debugMsg != null) {
                            debugMsg.append("Not Find Weight Value:").append(weightKey).append("\n");
                        }
                        LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u672a\u6839\u636e\u5f53\u524d\u4ea7\u54c1==>%1$s\u914d\u7f6e\u7684\u5206\u7ec4\u7c7b\u578b\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6743\u91cd\u4fe1\u606f==>%2$s", (String)"ActCalcGradeFunction_6", (String)"macc-aca-algox", (Object[])new Object[0]), matId, weight));
                        isCalc = false;
                        break;
                    }
                    BigDecimal linWeight = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("proFinQty"))).multiply(weight).setScale(10, RoundingMode.HALF_UP);
                    denominatorAmt = denominatorAmt.add(linWeight);
                    if (maxDenominatorAmt.compareTo(linWeight.abs()) >= 0) continue;
                    maxDenominatorAmt = linWeight.abs();
                }
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("Total Weight\uff1a").append(denominatorAmt).append("\uff0cMax Weight\uff1a").append(maxDenominatorAmt).append("\n");
                }
                if (denominatorAmt.compareTo(BigDecimal.ZERO) == 0) {
                    if (isCostobjectDebug && debugMsg != null) {
                        debugMsg.append("Total weight is zero:").append(denominatorAmt).append("\n");
                    }
                    LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1==>%s\u9000\u5e93\u5165\u5e93\u76f8\u7b49", (String)"ActCalcGradeFunction_2", (String)"macc-aca-algox", (Object[])new Object[0]), matId));
                    denominatorAmt = maxDenominatorAmt;
                    if (denominatorAmt.compareTo(BigDecimal.ZERO) == 0) {
                        isCalc = false;
                        if (isCostobjectDebug && debugMsg != null) {
                            debugMsg.append("Max weight is zero:").append(maxDenominatorAmt).append("\n");
                        }
                        LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u7b49\u7ea7\u54c1\u6210\u672c\u8ba1\u7b97\u5206\u6bcd\u4e3a0,\u9000\u51fa\u5f53\u524d\u8ba1\u7b97\uff0c\u5f53\u524d\u4ea7\u54c1%s", (String)"ActCalcGradeFunction_3", (String)"macc-aca-algox", (Object[])new Object[0]), matId));
                    }
                }
            }
            if (groupType.size() == 1) {
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("Only on Group Type:").append(matId).append(",grouptype:").append(groupType).append("\n");
                }
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u7b49\u7ea7\u54c1\u6210\u672c\u8ba1\u7b97\u5206\u7ec4\u7c7b\u578b\u4e00\u81f4\uff0c\u5f53\u524d\u4ea7\u54c1%s", (String)"ActCalcGradeFunction_5", (String)"macc-aca-algox", (Object[])new Object[0]), matId));
                isCalc = false;
            }
            if (isCalc) {
                RowX maxRow = null;
                BigDecimal amtDiff = totalAmt;
                for (RowX rowX : rowXList) {
                    String srcField = this.srcFieldMap.get(groupField);
                    Long srcGroupType = rowX.getLong(this.sourceRowMeta.getFieldIndex(srcField));
                    rowX.set(this.sourceRowMeta.getFieldIndex("groupfield"), (Object)groupField);
                    rowX.set(this.sourceRowMeta.getFieldIndex("groupcategoryid"), (Object)srcGroupType);
                    String weightKey = matId + "@" + srcGroupType;
                    BigDecimal weight = this.matCateMap.get(weightKey);
                    BigDecimal ratio = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("proFinQty")).multiply(weight)).divide(denominatorAmt, 10, RoundingMode.HALF_UP);
                    BigDecimal amount = ratio.multiply(totalAmt).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
                    if (isCostobjectDebug && debugMsg != null) {
                        debugMsg.append("ratio:").append(ratio).append(",amount:").append(amount).append("\n");
                    }
                    amtDiff = amtDiff.subtract(amount);
                    rowX.set(this.sourceRowMeta.getFieldIndex("cost"), (Object)amount);
                    if (maxRow != null && maxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost")).compareTo(amount) >= 0) continue;
                    maxRow = rowX;
                }
                if (maxRow != null && amtDiff.compareTo(BigDecimal.ZERO) != 0) {
                    maxRow.set(this.sourceRowMeta.getFieldIndex("cost"), (Object)maxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost")).add(amtDiff));
                }
            }
        }
        if (isCostobjectDebug && this.msgHander != null && debugMsg != null) {
            this.msgHander.dealInfoMsg(debugMsg.toString());
        }
        for (RowX rowx : rowXList) {
            collector.collect(rowx);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }
}

