/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.TaskRecordExceptionHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;

public class ActCalcJointSideFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 2232400386910032900L;
    private static final Log logger = LogFactory.getLog(ActCalcJointSideFunction.class);
    private RowMeta srcMeta;
    private ActCostCalcArgs args;
    private Map<String, DynamicObject> proextraPriceMap;
    private Map<String, String> allocTypeMap;
    private Map<String, BigDecimal> weightMap;

    public ActCalcJointSideFunction(RowMeta srcMeta, ActCostCalcArgs args, Map<String, DynamicObject> proextraPriceMap, Map<String, String> allocTypeMap, Map<String, BigDecimal> weightMap) {
        this.srcMeta = srcMeta;
        this.args = args;
        this.proextraPriceMap = proextraPriceMap;
        this.allocTypeMap = allocTypeMap;
        this.weightMap = weightMap;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashMap subEleMainRowXMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList jointList = Lists.newArrayList();
        ArrayList sideList = Lists.newArrayList();
        ArrayList mainList = Lists.newArrayList();
        HashSet existsMainSrcEntryId = Sets.newHashSetWithExpectedSize((int)16);
        HashSet existsSideKey = Sets.newHashSetWithExpectedSize((int)16);
        HashSet existsJointKey = Sets.newHashSetWithExpectedSize((int)16);
        Long mainCostObejctId = 0L;
        HashMap subEleMapElemetMap = Maps.newHashMapWithExpectedSize((int)16);
        boolean isOutSource = false;
        for (RowX row : iterable) {
            String productType = row.getString(this.srcMeta.getFieldIndex("productType"));
            String key = null;
            if ("A".equals(productType) || "B".equals(productType)) {
                key = row.getLong(this.srcMeta.getFieldIndex("srcEntryId")) + "@" + row.getLong(this.srcMeta.getFieldIndex("matId")) + "@" + row.getLong(this.srcMeta.getFieldIndex("matVerId")) + "@" + row.getLong(this.srcMeta.getFieldIndex("matAuxId"));
            }
            Long subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
            String outsourcetype = row.getString(this.srcMeta.getFieldIndex("outsourcetype"));
            if (!StringUtils.isBlank((CharSequence)outsourcetype)) {
                isOutSource = true;
            }
            Long elementId = row.getLong(this.srcMeta.getFieldIndex("elementId"));
            if (mainCostObejctId == 0L) {
                mainCostObejctId = row.getLong(this.srcMeta.getFieldIndex("mainCostObjectId"));
            }
            if (subEleMapElemetMap.get(subElementId) == null) {
                subEleMapElemetMap.put(subElementId, elementId);
            }
            String subElementOsKey = String.format("%s@%s", subElementId, outsourcetype);
            switch (productType) {
                case "C": {
                    Map mainRowXMap = (Map)subEleMainRowXMap.get(subElementOsKey);
                    if (mainRowXMap == null) {
                        mainRowXMap = Maps.newHashMapWithExpectedSize((int)16);
                        subEleMainRowXMap.put(subElementOsKey, mainRowXMap);
                    }
                    Long srcEntryId = row.getLong(this.srcMeta.getFieldIndex("srcEntryId"));
                    mainRowXMap.put(srcEntryId, row);
                    String mainSrcEntryIdKey = String.format("%s@%s@%s", srcEntryId, subElementId, outsourcetype);
                    if (!existsMainSrcEntryId.add(mainSrcEntryIdKey)) break;
                    mainList.add(row);
                    break;
                }
                case "A": {
                    if (!existsJointKey.add(key)) break;
                    jointList.add(row);
                    break;
                }
                case "B": {
                    if (!existsSideKey.add(key)) break;
                    sideList.add(row);
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(mainCostObejctId))) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup1:values %s", (String)"ActCalcJointSideFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]), Arrays.toString(this.srcMeta.getFieldNames())));
            for (RowX row : mainList) {
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup1:values %s", (String)"ActCalcJointSideFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]), row));
            }
            for (RowX row : jointList) {
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup2:values %s", (String)"ActCalcJointSideFunction_1", (String)"macc-aca-algox", (Object[])new Object[0]), row));
            }
            for (RowX row : sideList) {
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup3:values %s", (String)"ActCalcJointSideFunction_2", (String)"macc-aca-algox", (Object[])new Object[0]), row));
            }
        }
        if (jointList.size() > 0 || sideList.size() > 0) {
            this.jointSideProcess(collector, mainList, jointList, sideList, subEleMainRowXMap, subEleMapElemetMap, isOutSource);
        } else {
            for (RowX rowX : mainList) {
                collector.collect(rowX);
            }
        }
    }

    private void jointSideProcess(Collector collector, List<RowX> mainList, List<RowX> jointList, List<RowX> sideList, Map<String, Map<Long, RowX>> subEleMainRowXMap, Map<Long, Long> subEleMapElemetMap, boolean isOutSource) {
        String errStr;
        RowX tmpMainRowX = null;
        BigDecimal totalCost = BigDecimal.ZERO;
        HashMap subEleCostMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, Map<Long, RowX>> subEntry : subEleMainRowXMap.entrySet()) {
            Map<Long, RowX> srcEntryRowX = subEntry.getValue();
            BigDecimal subCost = BigDecimal.ZERO;
            for (Map.Entry<Long, RowX> subSubEntry : srcEntryRowX.entrySet()) {
                RowX row = subSubEntry.getValue();
                if (tmpMainRowX == null) {
                    tmpMainRowX = row;
                }
                BigDecimal cost = row.getBigDecimal(this.srcMeta.getFieldIndex("cost"));
                totalCost = totalCost.add(cost);
                subCost = subCost.add(cost);
            }
            subEleCostMap.put(subEntry.getKey(), subCost);
        }
        if (tmpMainRowX == null) {
            if (jointList.size() > 0) {
                for (int i = 0; i < jointList.size(); ++i) {
                    BigDecimal subEleCost;
                    RowX rowx = jointList.get(i);
                    BigDecimal cost = rowx.getBigDecimal(this.srcMeta.getFieldIndex("cost"));
                    Long subElementId = rowx.getLong(this.srcMeta.getFieldIndex("subElementId"));
                    String outsourcetype = rowx.getString(this.srcMeta.getFieldIndex("outsourcetype"));
                    totalCost = totalCost.add(cost);
                    String subElementOsKey = String.format("%s@%s", subElementId, outsourcetype);
                    if (i == 0) {
                        tmpMainRowX = rowx;
                    }
                    if ((subEleCost = (BigDecimal)subEleCostMap.get(subElementOsKey)) == null) {
                        subEleCost = BigDecimal.ZERO;
                    }
                    subEleCost = subEleCost.add(rowx.getBigDecimal(this.srcMeta.getFieldIndex("cost")));
                    subEleCostMap.put(subElementOsKey, subEleCost);
                }
            } else {
                errStr = ResManager.loadKDString((String)"\u3010\u4e3b\u8054\u526f\u8ba1\u7b97\u3011\u6ca1\u6709\u4e3b\u4ea7\u54c1,\u6ca1\u6709\u8054\u4ea7\u54c1", (String)"ActCalcJointSideFunction_3", (String)"macc-aca-algox", (Object[])new Object[0]);
                LogUtils.logError(this.args.getGetLogUniqueKey(), logger, errStr);
                throw new KDBizException(errStr);
            }
        }
        if (tmpMainRowX == null) {
            errStr = ResManager.loadKDString((String)"\u3010\u4e3b\u8054\u526f\u8ba1\u7b97\u3011\u6ca1\u6709\u4e3b\u8054\u4ea7\u54c1 ", (String)"ActCalcJointSideFunction_4", (String)"macc-aca-algox", (Object[])new Object[0]);
            LogUtils.logError(this.args.getGetLogUniqueKey(), logger, errStr);
            throw new KDBizException(errStr);
        }
        String mftOrderNo = tmpMainRowX.getString(this.srcMeta.getFieldIndex("mftOrderNo"));
        Long mainCostObjectId = tmpMainRowX.getLong(this.srcMeta.getFieldIndex("mainCostObjectId"));
        Long groupId = tmpMainRowX.getLong(this.srcMeta.getFieldIndex("groupId"));
        if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(mainCostObjectId))) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup4:groupId %1$s,totalCost %2$s,mftOrderNo %3$s,subEleCostMap", (String)"ActCalcJointSideFunction_19", (String)"macc-aca-algox", (Object[])new Object[0]), groupId, totalCost, mftOrderNo, subEleCostMap));
        }
        BigDecimal totalSideCost = BigDecimal.ZERO;
        ArrayList newSideList = Lists.newArrayList();
        if (sideList.size() > 0) {
            for (RowX row : sideList) {
                Long sideMatId = row.getLong(this.srcMeta.getFieldIndex("matId"));
                String sideMatver = row.getString(this.srcMeta.getFieldIndex("matVerId"));
                String auxptyId = row.getString(this.srcMeta.getFieldIndex("matAuxId"));
                String key = sideMatId + "@" + sideMatver + "@" + auxptyId;
                String costCenterId = row.getString(this.srcMeta.getFieldIndex("costCenterId"));
                String manuorgId = row.getString(this.srcMeta.getFieldIndex("manuorgId"));
                BigDecimal qty = row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty"));
                DynamicObject sidePriceDyo = this.getsidePriceDyo(key, costCenterId, manuorgId);
                if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(mainCostObjectId))) {
                    LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f-\u526f\u4ea7\u54c1\u8ba1\u7b97 setup1:sideMatId %1$s,key %2$s,qty %3$s,sidePriceDyo %4$s", (String)"ActCalcJointSideFunction_20", (String)"macc-aca-algox", (Object[])new Object[0]), sideMatId, key, qty, sidePriceDyo));
                }
                for (DynamicObject tmpEntry : sidePriceDyo.getDynamicObjectCollection("entryentity")) {
                    BigDecimal sidePrice = tmpEntry.getBigDecimal("price") == null ? BigDecimal.ZERO : tmpEntry.getBigDecimal("price");
                    Long elementId = tmpEntry.getLong("element.id");
                    Long subElementId = tmpEntry.getLong("subelement.id");
                    String subElementType = tmpEntry.getString("subelement.type");
                    if (subEleMapElemetMap.get(subElementId) == null) {
                        subEleMapElemetMap.put(subElementId, elementId);
                    }
                    BigDecimal cost = sidePrice.multiply(qty).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
                    RowX newRow = row.copy();
                    newRow.set(this.srcMeta.getFieldIndex("elementId"), (Object)elementId);
                    newRow.set(this.srcMeta.getFieldIndex("subElementId"), (Object)subElementId);
                    newRow.set(this.srcMeta.getFieldIndex("cost"), (Object)cost);
                    newSideList.add(newRow);
                    totalSideCost = totalSideCost.add(cost);
                    String subElementOsKey = String.format("%s@%s", subElementId, "A");
                    if (subEleCostMap.containsKey(subElementOsKey)) {
                        newRow.set(this.srcMeta.getFieldIndex("outsourcetype"), (Object)"A");
                    } else {
                        subElementOsKey = null;
                        for (Map.Entry entry : subEleCostMap.entrySet()) {
                            if (!((String)entry.getKey()).contains(subElementId + "@")) continue;
                            subElementOsKey = (String)entry.getKey();
                            String[] keys = subElementOsKey.split("@");
                            newRow.set(this.srcMeta.getFieldIndex("outsourcetype"), (Object)(keys.length > 1 ? keys[1] : ""));
                            break;
                        }
                        if (StringUtils.isEmpty((CharSequence)subElementOsKey)) {
                            if (isOutSource) {
                                if ("001".equals(subElementType) || "002".equals(subElementType)) {
                                    subElementOsKey = String.format("%s@%s", subElementId, "D");
                                    newRow.set(this.srcMeta.getFieldIndex("outsourcetype"), (Object)"D");
                                } else {
                                    subElementOsKey = String.format("%s@%s", subElementId, "A");
                                    newRow.set(this.srcMeta.getFieldIndex("outsourcetype"), (Object)"A");
                                }
                            } else {
                                subElementOsKey = String.format("%s@%s", subElementId, "");
                                newRow.set(this.srcMeta.getFieldIndex("outsourcetype"), (Object)"");
                            }
                        }
                    }
                    if (subEleCostMap.get(subElementOsKey) == null) {
                        subEleCostMap.put(subElementOsKey, BigDecimal.ZERO);
                    }
                    BigDecimal subEleCost = (BigDecimal)subEleCostMap.get(subElementOsKey);
                    subEleCost = subEleCost.subtract(cost);
                    subEleCostMap.put(subElementOsKey, subEleCost);
                    if (!StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) || !this.args.getDebugColVal().equals(String.valueOf(mainCostObjectId))) continue;
                    LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f-\u526f\u4ea7\u54c1\u8ba1\u7b97 setup2:subElementId %1$s,sidePrice %2$s,cost %3$s,subEleCost %4$s,newRow %5$s", (String)"ActCalcJointSideFunction_21", (String)"macc-aca-algox", (Object[])new Object[0]), subElementId, sidePrice, cost, subEleCost, newRow));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(mainCostObjectId))) {
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup5:totalCost %1$s,totalSideCost %2$s", (String)"ActCalcJointSideFunction_22", (String)"macc-aca-algox", (Object[])new Object[0]), totalCost, totalSideCost));
            }
            if (totalSideCost.abs().compareTo(totalCost.abs()) >= 0) {
                DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingle((Object)mainCostObjectId, (String)"cad_costobject", (String)"name");
                String errStr2 = String.format(ResManager.loadKDString((String)"\u526f\u4ea7\u54c1\u7684\u5b9a\u989d\u6210\u672c\u4e4b\u548c>=\u5b8c\u5de5\u4ea7\u54c1\u6210\u672c,\u5de5\u5355\u7f16\u53f7:%1$s ,\u4e3b\u4ea7\u54c1\u6210\u672c\u5bf9\u8c61:%2$s ,\u5dee\u989d\u4e3a%3$s", (String)"ActCalcJointSideFunction_23", (String)"macc-aca-algox", (Object[])new Object[0]), mftOrderNo, costObjectDyo.getString("name"), BigDecimalUtil.toString(totalSideCost.abs().subtract(totalCost.abs())));
                LogUtils.logError(this.args.getGetLogUniqueKey(), logger, errStr2);
                TaskRecordExceptionHelper.saveErroToTaskRecord(this.args.getTaskRecordId(), errStr2, this.args);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\uff0c%s", (String)"ActCalcJointSideFunction_24", (String)"macc-aca-algox", (Object[])new Object[0]), errStr2));
            }
        }
        HashSet existsMainSrcEntryId = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList mainEntryList = Lists.newArrayList();
        for (RowX row : mainList) {
            Long srcEntryId = row.getLong(this.srcMeta.getFieldIndex("srcEntryId"));
            if (!existsMainSrcEntryId.add(srcEntryId)) continue;
            mainEntryList.add(row);
        }
        ArrayList newJointList = Lists.newArrayList();
        ArrayList newMainList = Lists.newArrayList();
        for (Map.Entry mapEntry : subEleCostMap.entrySet()) {
            RowX newRow;
            BigDecimal jointMulti;
            BigDecimal weight;
            BigDecimal qty;
            BigDecimal subEleCost;
            String[] subElementOsKeys = ((String)mapEntry.getKey()).split("@");
            Long subElementId = Long.valueOf(subElementOsKeys[0]);
            BigDecimal diff = subEleCost = (BigDecimal)mapEntry.getValue();
            RowX tmpRow = null;
            BigDecimal tmpCompare = BigDecimal.ZERO;
            diff = diff.subtract(tmpCompare);
            if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(mainCostObjectId))) {
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup7  \u5b50\u8981\u7d20\u7684\u4e3b\u8054\u603b\u6210\u672c:subElementId %1$s,subEleCost %2$s", (String)"ActCalcJointSideFunction_25", (String)"macc-aca-algox", (Object[])new Object[0]), subElementId, subEleCost));
            }
            BigDecimal totalMuilt = this.getMainJoinTotalMuilt(mainEntryList, jointList, subElementId);
            if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(mainCostObjectId))) {
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup6:totalMuilt %s", (String)"ActCalcJointSideFunction_12", (String)"macc-aca-algox", (Object[])new Object[0]), totalMuilt));
            }
            if (totalMuilt.compareTo(BigDecimal.ZERO) == 0) {
                String errStr3 = String.format(ResManager.loadKDString((String)"\u3010\u2211\u4e3b\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd+\u2211\u8054\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd=0\u3011\u5de5\u5355\u7f16\u53f7:%1$s,\u4ea7\u54c1\u7ec4id:%2$s,\u5b50\u8981\u7d20id:%3$s", (String)"ActCalcJointSideFunction_26", (String)"macc-aca-algox", (Object[])new Object[0]), mftOrderNo, groupId, subElementId);
                LogUtils.logError(this.args.getGetLogUniqueKey(), logger, errStr3);
                throw new KDBizException(errStr3);
            }
            for (RowX row : mainEntryList) {
                qty = row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty"));
                weight = this.getAllocWeight(row, subElementId.toString());
                jointMulti = qty.multiply(weight);
                BigDecimal mainCost = jointMulti.divide(totalMuilt, 10, RoundingMode.HALF_UP).multiply(subEleCost).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
                newRow = row.copy();
                newRow.set(this.srcMeta.getFieldIndex("elementId"), (Object)subEleMapElemetMap.get(subElementId));
                newRow.set(this.srcMeta.getFieldIndex("subElementId"), (Object)subElementId);
                newRow.set(this.srcMeta.getFieldIndex("cost"), (Object)mainCost);
                newRow.set(this.srcMeta.getFieldIndex("outsourcetype"), (Object)(subElementOsKeys.length > 1 ? subElementOsKeys[1] : ""));
                newMainList.add(newRow);
                if (tmpCompare.compareTo(BigDecimal.ZERO) == 0 || mainCost.compareTo(tmpCompare) > 0) {
                    tmpCompare = mainCost;
                    tmpRow = newRow;
                }
                diff = diff.subtract(mainCost);
                if (!StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) || !this.args.getDebugColVal().equals(String.valueOf(mainCostObjectId))) continue;
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup8  \u4e3b\u4ea7\u54c1\u6210\u672c:subElementId %1$s,qty %2$s,weight %3$s jointMulti %4$s,mainCost %5$s,newRow %6$s", (String)"ActCalcJointSideFunction_27", (String)"macc-aca-algox", (Object[])new Object[0]), subElementId, qty, weight, jointMulti, mainCost, newRow));
            }
            for (RowX row : jointList) {
                qty = row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty"));
                weight = this.getAllocWeight(row, subElementId.toString());
                jointMulti = qty.multiply(weight);
                BigDecimal jointCost = jointMulti.divide(totalMuilt, 10, RoundingMode.HALF_UP).multiply(subEleCost).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
                newRow = row.copy();
                newRow.set(this.srcMeta.getFieldIndex("elementId"), (Object)subEleMapElemetMap.get(subElementId));
                newRow.set(this.srcMeta.getFieldIndex("subElementId"), (Object)subElementId);
                newRow.set(this.srcMeta.getFieldIndex("cost"), (Object)jointCost);
                newRow.set(this.srcMeta.getFieldIndex("outsourcetype"), (Object)(subElementOsKeys.length > 1 ? subElementOsKeys[1] : ""));
                newJointList.add(newRow);
                BigDecimal cost = jointCost;
                if (tmpCompare.compareTo(BigDecimal.ZERO) == 0 || cost.compareTo(tmpCompare) > 0) {
                    tmpCompare = cost;
                    tmpRow = newRow;
                }
                diff = diff.subtract(cost);
                if (!StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) || !this.args.getDebugColVal().equals(String.valueOf(mainCostObjectId))) continue;
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup8  \u8054\u6210\u672c:subElementId %1$s,qty %2$s,weight %3$s jointMulti %4$s,mainCost %5$s,newRow %6$s", (String)"ActCalcJointSideFunction_28", (String)"macc-aca-algox", (Object[])new Object[0]), subElementId, qty, weight, jointMulti, jointCost, newRow));
            }
            if (diff.compareTo(BigDecimal.ZERO) == 0 || tmpRow == null) continue;
            tmpRow.set(this.srcMeta.getFieldIndex("cost"), (Object)tmpRow.getBigDecimal(this.srcMeta.getFieldIndex("cost")).add(diff));
            if (!StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) || !this.args.getDebugColVal().equals(String.valueOf(mainCostObjectId))) continue;
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f setup8  \u8054\u526f\u5c3e\u5dee:subElementId %1$s,diff %2$s,tmpRow %3$s", (String)"ActCalcJointSideFunction_29", (String)"macc-aca-algox", (Object[])new Object[0]), subElementId, diff, tmpRow));
        }
        for (RowX rowX : newMainList) {
            collector.collect(rowX);
        }
        for (RowX rowX : newSideList) {
            collector.collect(rowX);
        }
        for (RowX rowX : newJointList) {
            collector.collect(rowX);
        }
    }

    private DynamicObject getsidePriceDyo(String key, String costCenterId, String manuorgId) {
        manuorgId = manuorgId == null ? "0" : manuorgId;
        costCenterId = costCenterId == null ? "0" : costCenterId;
        String manuorgKey = key + "@" + manuorgId;
        DynamicObject priceDyo = this.proextraPriceMap.get(manuorgKey + "@" + costCenterId);
        if (priceDyo != null) {
            return priceDyo;
        }
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(costCenterId) && (priceDyo = this.proextraPriceMap.get(manuorgKey + "@0")) != null) {
            return priceDyo;
        }
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(manuorgId)) {
            manuorgKey = key + "@0";
            priceDyo = this.proextraPriceMap.get(manuorgKey + "@" + costCenterId);
            if (priceDyo != null) {
                return priceDyo;
            }
            if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(costCenterId) && (priceDyo = this.proextraPriceMap.get(manuorgKey + "@0")) != null) {
                return priceDyo;
            }
        }
        String errStr = String.format(ResManager.loadKDString((String)"%1$s@%2$s@%3$s\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7269\u6599\u6210\u672c\u4ef7\u76ee\u8868\u6570\u636e,\u8bf7\u68c0\u67e5", (String)"ActCalcJointSideFunction_30", (String)"macc-aca-algox", (Object[])new Object[0]), key, manuorgId, costCenterId);
        Long materialId = Long.valueOf(key.substring(0, key.indexOf("@")));
        DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(costCenterId), (String)"bos_costcenter", (String)"name");
        DynamicObject materialDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"name");
        String errMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3:%1$s\uff0c\u7269\u6599:%2$s\uff0c\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7269\u6599\u6210\u672c\u4ef7\u76ee\u8868\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ActCalcJointSideFunction_31", (String)"macc-aca-algox", (Object[])new Object[0]), costCenterDyo == null ? " " : costCenterDyo.getString("name"), materialDyo == null ? " " : materialDyo.getString("name"));
        LogUtils.logError(this.args.getGetLogUniqueKey(), logger, errStr);
        throw new KDBizException(errMsg);
    }

    private BigDecimal getMainJoinTotalMuilt(List<RowX> mainList, List<RowX> jointList, Long subElementId) {
        BigDecimal multi;
        BigDecimal weight;
        BigDecimal qty;
        BigDecimal totalMuilt = BigDecimal.ZERO;
        BigDecimal maxMuilt = null;
        for (RowX row : mainList) {
            qty = row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty"));
            weight = this.getAllocWeight(row, subElementId.toString());
            multi = qty.multiply(weight);
            totalMuilt = totalMuilt.add(multi);
            if (maxMuilt != null && maxMuilt.compareTo(multi.abs()) >= 0) continue;
            maxMuilt = multi.abs();
        }
        for (RowX row : jointList) {
            qty = row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty"));
            weight = this.getAllocWeight(row, subElementId.toString());
            multi = qty.multiply(weight);
            totalMuilt = totalMuilt.add(multi);
            if (maxMuilt != null && maxMuilt.compareTo(multi.abs()) >= 0) continue;
            maxMuilt = multi.abs();
        }
        if (totalMuilt.compareTo(BigDecimal.ZERO) == 0 && maxMuilt != null) {
            totalMuilt = maxMuilt;
        }
        return totalMuilt;
    }

    private BigDecimal getAllocWeight(RowX row, String subElementId) {
        BigDecimal weight = BigDecimal.ZERO;
        String key = row.getString(this.srcMeta.getFieldIndex("groupId")) + "@" + row.getString(this.srcMeta.getFieldIndex("matId")) + "@" + row.getString(this.srcMeta.getFieldIndex("matVerId")) + "@" + row.getString(this.srcMeta.getFieldIndex("matAuxId"));
        String allocType = this.allocTypeMap.get(key);
        if ("1".equals(allocType)) {
            BigDecimal bigDecimal = weight = row.getBigDecimal(this.srcMeta.getFieldIndex("costObjectWeight")) == null ? BigDecimal.ZERO : row.getBigDecimal(this.srcMeta.getFieldIndex("costObjectWeight"));
            if (weight == null) {
                weight = BigDecimal.ONE;
            }
        } else if ("2".equals(allocType)) {
            String subElementKey = key + "@" + subElementId;
            weight = this.weightMap.get(subElementKey);
            if (weight == null) {
                weight = this.weightMap.get(key);
            }
            if (weight == null) {
                weight = BigDecimal.ZERO;
            }
        }
        return weight;
    }
}

