/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.alibaba.fastjson.JSON;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.aca.algox.costcalc.common.ActSubItemRow;
import org.apache.commons.lang3.StringUtils;

public class ActCalcSubItemElementFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = new RowMeta(new Field[]{new Field("costCenterId", (DataType)DataType.LongType), new Field("mainCostObjectId", (DataType)DataType.LongType), new Field("costObjectId", (DataType)DataType.LongType), new Field("productType", (DataType)DataType.StringType), new Field("groupId", (DataType)DataType.LongType), new Field("mftOrderNo", (DataType)DataType.StringType), new Field("matId", (DataType)DataType.LongType), new Field("matVerId", (DataType)DataType.LongType), new Field("matAuxId", (DataType)DataType.LongType), new Field("outsourcetype", (DataType)DataType.StringType), new Field("carrytype", (DataType)DataType.StringType), new Field("elementId", (DataType)DataType.LongType), new Field("subElementId", (DataType)DataType.LongType), new Field("finAmt", (DataType)DataType.BigDecimalType), new Field("calcAmt", (DataType)DataType.BigDecimalType)});
    private int amtpricise = 2;

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public ActCalcSubItemElementFunction(int amtpricise) {
        this.amtpricise = amtpricise;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> colRows = new ArrayList<RowX>(10);
        for (RowX row : iterable) {
            RowX baseRow = this.getBaseRow(row);
            String subjson = row.getString(this.sourceRowMeta.getFieldIndex("subjson"));
            if (StringUtils.isEmpty((CharSequence)subjson)) {
                colRows.add(baseRow);
                continue;
            }
            List subItemRows = JSON.parseArray((String)subjson, ActSubItemRow.class);
            if (subItemRows.isEmpty()) {
                colRows.add(baseRow);
                continue;
            }
            for (ActSubItemRow subitemRow : subItemRows) {
                RowX addRow = baseRow.copy();
                addRow.set(this.rowMeta.getFieldIndex("elementId"), (Object)subitemRow.getSelement());
                addRow.set(this.rowMeta.getFieldIndex("subElementId"), (Object)subitemRow.getSsubelement());
                addRow.set(this.rowMeta.getFieldIndex("finAmt"), (Object)subitemRow.getSpdcomamt());
                addRow.set(this.rowMeta.getFieldIndex("calcAmt"), (Object)subitemRow.getSpdstartamt().add(subitemRow.getSpdstartadjamt()).add(subitemRow.getSpdcurramt()).setScale(this.amtpricise, RoundingMode.HALF_UP));
                colRows.add(addRow);
            }
        }
        for (RowX row : colRows) {
            collector.collect(row);
        }
    }

    private RowX getBaseRow(RowX row) {
        RowX baseRow = new RowX(this.rowMeta.getFieldCount());
        baseRow.set(this.rowMeta.getFieldIndex("costCenterId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("costCenterId")));
        baseRow.set(this.rowMeta.getFieldIndex("mainCostObjectId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("mainCostObjectId")));
        baseRow.set(this.rowMeta.getFieldIndex("costObjectId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("costObjectId")));
        baseRow.set(this.rowMeta.getFieldIndex("productType"), (Object)row.getString(this.sourceRowMeta.getFieldIndex("productType")));
        baseRow.set(this.rowMeta.getFieldIndex("groupId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("groupId")));
        baseRow.set(this.rowMeta.getFieldIndex("mftOrderNo"), (Object)row.getString(this.sourceRowMeta.getFieldIndex("mftOrderNo")));
        baseRow.set(this.rowMeta.getFieldIndex("matId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("matId")));
        baseRow.set(this.rowMeta.getFieldIndex("matVerId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("matVerId")));
        baseRow.set(this.rowMeta.getFieldIndex("matAuxId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("matAuxId")));
        baseRow.set(this.rowMeta.getFieldIndex("outsourcetype"), (Object)row.getString(this.sourceRowMeta.getFieldIndex("outsourcetype")));
        baseRow.set(this.rowMeta.getFieldIndex("elementId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("elementId")));
        baseRow.set(this.rowMeta.getFieldIndex("subElementId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("subElementId")));
        baseRow.set(this.rowMeta.getFieldIndex("finAmt"), (Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
        baseRow.set(this.rowMeta.getFieldIndex("calcAmt"), (Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex("calcAmt")));
        baseRow.set(this.rowMeta.getFieldIndex("carrytype"), (Object)"B");
        return baseRow;
    }
}

